/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.installshield.util.FileUtils;
import com.installshield.util.StringResolverException;
import com.installshield.util.StringResolverMethod;
import com.installshield.wizard.Wizard;
import java.io.File;

public class KitFileResolverMethod
extends StringResolverMethod {
    private Wizard wizard = null;

    public KitFileResolverMethod() {
        throw new Error("This string resolver method cannot be added at buildtime. It must be added at runtime by the wizard.");
    }

    public KitFileResolverMethod(Wizard wiz) {
        this.wizard = wiz;
    }

    public String getName() {
        return "KITFILE";
    }

    public String invoke(String[] args) {
        try {
            return this.invokeWithValidation(args);
        }
        catch (StringResolverException ex) {
            return "";
        }
    }

    public String invokeWithValidation(String[] args) throws StringResolverException {
        if (args.length != 1) {
            throw new StringResolverException("ERROR: expected 1 argument for '" + this.getName() + "' method");
        }
        String fileName = args[0];
        String kitDir = null;
        if (!new File(fileName).isAbsolute()) {
            String absFileName = null;
            try {
                String kitAltDir = (String)this.wizard.getServices().getValue("InstallerAltDirectory");
                if (kitAltDir != null && kitAltDir.trim().length() > 0 && !new File(absFileName = FileUtils.createFileName(kitAltDir, fileName)).exists()) {
                    absFileName = null;
                }
            }
            catch (Exception e) {
                absFileName = null;
            }
            if (absFileName != null && absFileName.trim().length() > 0) {
                return absFileName;
            }
            try {
                kitDir = (String)this.wizard.getServices().getValue("InstallerDirectory");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (kitDir == null || kitDir.trim().length() == 0) {
                throw new StringResolverException("ERROR: Cannot resolve global variable 'InstallerDirectory' for '" + this.getName() + "' method");
            }
        }
        return FileUtils.createFileName(kitDir, fileName);
    }
}

