/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareVersion;
import com.installshield.product.service.registry.RegistryService;
import com.installshield.util.FileUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import java.util.StringTokenizer;

public class MultipleInstancesSoftwareObjectUtils {
    private WizardServices wizardServices = ICAInstGlobals.getServices();

    public SoftwareObject[] getSoftwareObjects(String uid) throws ServiceException {
        RegistryService registryService = this.getRegistryService();
        SoftwareObject[] sos = registryService.getSoftwareObjects(uid);
        return sos;
    }

    public SoftwareObject getSoftwareObject(String uid, String installLocation) throws ServiceException {
        RegistryService registryService = this.getRegistryService();
        SoftwareObject so = registryService.getSoftwareObject(uid, installLocation);
        return so;
    }

    public SoftwareVersion getSoftwareObjectVersion(SoftwareObject so) {
        if (so == null) {
            return null;
        }
        return so.getKey().getVersion();
    }

    public String versionToString(SoftwareVersion version, int depthLevel) {
        String vers = "";
        if (depthLevel < 1) {
            depthLevel = 1;
        }
        if (depthLevel > 4) {
            depthLevel = 4;
        }
        if (version == null) {
            return vers;
        }
        switch (depthLevel) {
            case 1: {
                vers = version.getMajor();
                break;
            }
            case 2: {
                vers = String.valueOf(version.getMajor()) + "." + version.getMinor();
                break;
            }
            case 3: {
                vers = String.valueOf(version.getMajor()) + "." + version.getMinor() + "." + version.getMaintenance();
                break;
            }
            case 4: {
                vers = String.valueOf(version.getMajor()) + "." + version.getMinor() + "." + version.getMaintenance() + "." + version.getUpdate();
            }
        }
        return vers;
    }

    public String getSoftwareObjectInstallLocation(SoftwareObject so) {
        if (so == null) {
            return null;
        }
        return so.getInstallLocation();
    }

    public String getSoftwareObjectDisplayName(SoftwareObject so) {
        if (so == null) {
            return null;
        }
        return so.getDisplayName();
    }

    private RegistryService getRegistryService() throws ServiceException {
        return (RegistryService)this.wizardServices.getService("registryService");
    }

    public String getUninstallerPath(String productKey, String installLocation) throws ServiceException {
        String uninstaller;
        String uninstallPath = null;
        SoftwareObject soUninst = this.getRegistryService().getSoftwareObject(productKey, installLocation);
        if (soUninst != null && (uninstaller = soUninst.getUninstaller()) != null) {
            StringTokenizer token = new StringTokenizer(uninstaller, " ");
            String _uninst = ICAStringUtils.unquote(((String)token.nextElement()).trim());
            String uninstallJar = ICAStringUtils.unquote(((String)token.nextElement()).trim());
            uninstallPath = FileUtils.createFileName(installLocation, _uninst);
            uninstallPath = FileUtils.createFileName(uninstallPath, uninstallJar);
        }
        return uninstallPath;
    }

    public boolean isProductInstalled(String productKey, String installLocation) throws ServiceException {
        SoftwareObject so = this.getSoftwareObject(productKey, installLocation);
        return so != null;
    }
}

