/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ProcUtl;
import com.ibm.itcins.ica2.ShowMessage;
import java.io.IOException;
import java.util.StringTokenizer;

public class PortUtils {
    public static final int NO_ERROR = 0;
    public static final int ERROR_INVALID_PORT_NUMBER = 1;
    public static final int ERROR_DUPLICATED_PORT = 2;
    public static final int ERROR_PORT_IN_USE = 3;
    public static final int MINIMUM_PORT_NUMBER = 1;
    public static final int MAXIMUM_PORT_NUMBER = 65535;

    public int[] a2i(String[] array) throws NumberFormatException {
        if (array == null) {
            return null;
        }
        int ln = array.length;
        int[] intArray = new int[ln];
        int idx = 0;
        while (idx < ln) {
            intArray[idx] = Integer.parseInt(array[idx]);
            ++idx;
        }
        return intArray;
    }

    public String[] i2a(int[] array) {
        if (array == null) {
            return null;
        }
        int ln = array.length;
        String[] stringArray = new String[ln];
        int idx = 0;
        while (idx < ln) {
            stringArray[idx] = Integer.toString(array[idx]);
            ++idx;
        }
        return stringArray;
    }

    public String getList(String[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuffer list = new StringBuffer();
        String listSeparator = ", ";
        int i = 0;
        while (i < array.length) {
            list.append(listSeparator).append(array[i]);
            ++i;
        }
        list.substring(listSeparator.length());
        return list.toString();
    }

    public static boolean isPortValid(int port) {
        return port >= 1 && port <= 65535;
    }

    public static boolean isValidPort(String port) {
        try {
            int portValue = Integer.parseInt(port);
            if (portValue >= 1 && portValue <= 65535) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public int firstDuplicatedPort(int[] ports) {
        if (ports == null) {
            return -1;
        }
        int k = 0;
        int noPorts = ports.length;
        while (k < noPorts) {
            int i = k + 1;
            while (i < noPorts) {
                if (ports[k] == ports[i]) {
                    return k;
                }
                ++i;
            }
            ++k;
        }
        return -1;
    }

    public boolean existDuplicatedPorts(int[] ports) {
        return this.firstDuplicatedPort(ports) == -1;
    }

    public String getWasPortsInUse(int[] wasPorts) {
        if (wasPorts == null || wasPorts.length == 0) {
            return "";
        }
        String portsInUse = PortUtils.getPortsInUse();
        if (portsInUse == null || portsInUse.length() == 0) {
            return "";
        }
        String wasPortsUsed = "";
        int i = 0;
        while (i < wasPorts.length) {
            if (portsInUse.indexOf(":" + wasPorts[i] + "\n") >= 0) {
                wasPortsUsed = String.valueOf(wasPortsUsed) + (wasPortsUsed.length() > 0 ? ", " : "") + wasPorts[i];
            }
            ++i;
        }
        return wasPortsUsed;
    }

    private static String getPortsInUse() {
        StringBuffer sb;
        block14: {
            StringTokenizer token;
            block15: {
                block13: {
                    ProcUtl proc = new ProcUtl();
                    Object[] setupCmd = null;
                    if (System.getProperty("os.name", "").toUpperCase().startsWith("WINDOWS")) {
                        setupCmd = new String[]{"netstat", "-a", "-n"};
                    } else if (System.getProperty("os.name", "").toUpperCase().equals("LINUX")) {
                        setupCmd = new String[]{"netstat", "-a", "-t", "-u", "-n"};
                    } else if (System.getProperty("os.name", "").toUpperCase().equals("AIX")) {
                        setupCmd = new String[]{"netstat", "-an", "|", "awk '{printf \"%s %s \\n\",$4,$6}'"};
                    }
                    int rc = -1;
                    sb = new StringBuffer();
                    try {
                        if (System.getProperty("os.name", "").toUpperCase().equals("AIX")) {
                            String aixCmd = ICAStringUtils.arrayToString(setupCmd, " ");
                            rc = proc.system(aixCmd, true, null, sb, sb);
                        } else {
                            rc = proc.execcmd((String[])setupCmd, true, null, (Object)sb, (Object)sb);
                        }
                        if (rc != 0) {
                            return "";
                        }
                    }
                    catch (IOException ioe) {
                        ShowMessage.writeLogOutput("err", ioe.getLocalizedMessage());
                    }
                    String out = sb.toString().trim();
                    token = new StringTokenizer(out, "\n");
                    sb.setLength(0);
                    if (!System.getProperty("os.name", "").toUpperCase().startsWith("WINDOWS")) break block13;
                    while (token.hasMoreElements()) {
                        String sbLine = (String)token.nextElement();
                        int p = sbLine.indexOf(":");
                        if (p < 0) continue;
                        sb.append(String.valueOf(sbLine.substring(p, p + 10).trim()) + "\n");
                    }
                    break block14;
                }
                if (!System.getProperty("os.name", "").toUpperCase().equals("LINUX")) break block15;
                String a1 = "ESTABLISHED";
                String a2 = "LISTEN";
                while (token.hasMoreElements()) {
                    String sbLine = (String)token.nextElement();
                    int p = sbLine.indexOf(":");
                    if (p < 0 || sbLine.indexOf(a1) < 0 && sbLine.indexOf(a2) < 0) continue;
                    sb.append(String.valueOf(sbLine.substring(p, sbLine.indexOf(32, p + 1))) + "\n");
                }
                break block14;
            }
            if (!System.getProperty("os.name", "").toUpperCase().equals("AIX")) break block14;
            String a1 = "ESTABLISHED";
            String a2 = "LISTEN";
            while (token.hasMoreElements()) {
                String ipAddressAndPort;
                int p;
                String sbLine = (String)token.nextElement();
                if (sbLine.indexOf(a1) < 0 && sbLine.indexOf(a2) < 0 || (p = (ipAddressAndPort = new StringTokenizer(sbLine, " ").nextToken().trim()).lastIndexOf(46)) <= 0) continue;
                sb.append(":" + ipAddressAndPort.substring(p + 1) + "\n");
            }
        }
        return sb.toString();
    }

    public String[] concatenateArrays(String[] a, String[] b) {
        int ln_b;
        int ln_a = a == null ? 0 : a.length;
        int ln_c = ln_a + (ln_b = b == null ? 0 : b.length);
        if (ln_c == 0) {
            return null;
        }
        String[] c = new String[ln_c];
        int i = 0;
        while (i < ln_c) {
            c[i] = i < ln_a ? a[i] : b[i - ln_a];
            ++i;
        }
        return c;
    }

    public String[] generatePortsRange(int basePort, int noPorts) {
        if (noPorts <= 0) {
            return null;
        }
        String[] range = new String[noPorts];
        int i = 0;
        while (i < noPorts) {
            range[i] = new String(Integer.toString(basePort + i));
            ++i;
        }
        return range;
    }

    public int getNextAvailablePortValue(int port) {
        while (true) {
            String portInUse;
            if (!PortUtils.isPortValid(port)) {
                port = 1;
            }
            if ((portInUse = this.getWasPortsInUse(new int[]{port++})).trim().length() == 0) break;
        }
        int availablePortValue = port;
        return availablePortValue;
    }
}

