/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.ActionTimeBasedPercentEstimator;
import com.installshield.product.ProductActionSupport;
import com.installshield.wizard.service.MutableOperationState;
import com.installshield.wizard.service.OperationState;

public class ProductActionTimeBasedPercentEstimator
implements ActionTimeBasedPercentEstimator {
    private ProductActionSupport support = null;
    private long operationStartTime = 0L;
    private int estimatedTimeTenths = 0;
    private double estimatedTimeMillisFloat = 0.0;
    private long operationUpdatedQuota = 0L;
    private long operationTotalQuota = 0L;
    private long sleepInterval = 200L;

    public ProductActionTimeBasedPercentEstimator(ProductActionSupport support, int estimatedTimeTenths, int alreadyElapsedTimeTenths, boolean suspended) {
        this.support = support;
        this.operationStartTime = System.currentTimeMillis() - (long)(alreadyElapsedTimeTenths * 100);
        if (this.operationStartTime <= 0L) {
            this.operationStartTime = 1L;
        }
        if (estimatedTimeTenths > 0) {
            this.estimatedTimeTenths = estimatedTimeTenths;
            this.estimatedTimeMillisFloat = (double)estimatedTimeTenths * 100.0;
            int intervalTenths = estimatedTimeTenths / 16;
            if (intervalTenths < 2) {
                intervalTenths = 2;
            } else if (intervalTenths > 20) {
                intervalTenths = 20;
            }
            this.sleepInterval = (long)intervalTenths * 100L;
            long quota = estimatedTimeTenths * 4 / intervalTenths;
            if (quota < 4L) {
                quota = 4L;
            }
            this.operationTotalQuota = quota;
        }
        if (suspended) {
            this.suspendEstimation();
        }
    }

    public ProductActionTimeBasedPercentEstimator(ProductActionSupport support, int estimatedTimeTenths) {
        this(support, estimatedTimeTenths, 0, false);
    }

    public synchronized void updateOperationState(boolean completed) {
        if (this.estimatedTimeTenths > 0 && this.operationTotalQuota > 0L && this.operationStartTime > 0L) {
            long estimatedQuota = 0L;
            if (completed) {
                estimatedQuota = this.operationTotalQuota;
            } else {
                double t1;
                double proc = 0.0;
                double t = System.currentTimeMillis() - this.operationStartTime;
                proc = t <= (t1 = this.estimatedTimeMillisFloat * 0.667) ? t / t1 * 67.0 : (t <= t1 * 2.0 ? t / t1 * 22.0 + 45.0 : t / t1 * 11.0 + 67.0);
                estimatedQuota = (long)(proc * (double)this.operationTotalQuota / 100.0);
                if (estimatedQuota < 0L) {
                    estimatedQuota = 0L;
                }
                if (estimatedQuota > this.operationTotalQuota) {
                    estimatedQuota = this.operationTotalQuota;
                }
            }
            if (estimatedQuota > this.operationUpdatedQuota) {
                MutableOperationState state;
                long increment = estimatedQuota - this.operationUpdatedQuota;
                if (this.support != null && (state = this.support.getOperationState()) != null && this.checkOperationState(state)) {
                    state.updatePercentComplete(this.estimatedTimeTenths, increment, this.operationTotalQuota);
                    this.operationUpdatedQuota = estimatedQuota;
                }
            }
        }
    }

    public void updateOperationState() {
        this.updateOperationState(false);
    }

    public void completeOperationState() {
        this.updateOperationState(true);
    }

    public synchronized void suspendEstimation() {
        long tmp = 0L;
        if (this.operationStartTime > 0L) {
            tmp = this.operationStartTime - System.currentTimeMillis();
            this.operationStartTime = tmp < 0L ? tmp : 0L;
        }
    }

    public synchronized void resumeEstimation() {
        if (this.operationStartTime <= 0L) {
            this.operationStartTime = System.currentTimeMillis() + this.operationStartTime;
        }
    }

    public long getReccomendedSleepInterval() {
        return this.sleepInterval;
    }

    public void sleep(long sleepTime) {
        if (this.operationStartTime > 0L && sleepTime > 0L) {
            long t1 = System.currentTimeMillis();
            long t2 = 0L;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                t2 = System.currentTimeMillis() - t1;
            }
            if (t2 > 0L && t2 < sleepTime) {
                try {
                    Thread.sleep(sleepTime - t2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void sleep() {
        this.sleep(this.sleepInterval);
    }

    public boolean isSuspended() {
        return this.operationStartTime <= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkOperationState(OperationState operationstate) {
        boolean rez;
        if (operationstate.isSuspended()) {
            this.suspendEstimation();
            while (operationstate.isSuspended()) {
                OperationState operationState = operationstate;
                synchronized (operationState) {
                    try {
                        operationstate.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        boolean bl = rez = !operationstate.isCanceled();
        if (!rez) {
            this.suspendEstimation();
        } else if (this.isSuspended()) {
            this.resumeEstimation();
        }
        return rez;
    }
}

