/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.CimomActions;
import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ProcUtl;
import com.ibm.itcins.ica2.ProcessesUtl;
import com.ibm.itcins.ica2.SLPActions;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.WASUtl;
import com.ibm.itcins.ica2.WizardActionTimeBasedPercentEstimator;
import com.installshield.wizard.service.ServiceException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SVCProcsUtils {
    public static String[][] getRunningProcesses(String[] servicesNamesToCheck, String[] wasServicesNamesToCheck, String wasInstallLocation, boolean isDebug) {
        ProcessesUtl procsUtl = ProcessesUtl.instantiate(ICAInstGlobals.getWizard());
        Vector<String[]> runningServices = new Vector<String[]>();
        isDebug = true;
        if (isDebug) {
            ShowMessage.writeLogOutput("getRunningProcesses(): services to be checked = ");
        }
        int i = 0;
        while (i < servicesNamesToCheck.length) {
            block31: {
                String txt;
                String serviceName;
                block30: {
                    StringTokenizer tok = new StringTokenizer(servicesNamesToCheck[i], ":");
                    serviceName = ICAInstGlobals.getServices().resolveString(tok.nextToken());
                    String serviceDisplayName = ICAInstGlobals.getServices().resolveString(tok.nextToken());
                    servicesNamesToCheck[i] = String.valueOf(serviceName) + ":" + serviceDisplayName;
                    if (isDebug) {
                        ShowMessage.writeLogOutput(String.valueOf(servicesNamesToCheck[i]) + "\n");
                    }
                    try {
                        if (!serviceName.equals("slpd") || SLPActions.instantiate().isSLPInstalledByProduct(ICAInstGlobals.getServices().resolveString("$P(product.key.UID)"))) break block30;
                        if (isDebug) {
                            ShowMessage.writeLogOutput("slpd not installed by current application");
                        }
                        break block31;
                    }
                    catch (ServiceException e) {
                        txt = ShowMessage.gi(null).resolve("Install.ServiceExceptionOccured", new String[]{e.toString()}, null);
                        ShowMessage.writeLogOutput("wrn", txt);
                    }
                    catch (IOException e) {
                        txt = ShowMessage.gi(null).resolve("Install.IOExceptionOccured", new String[]{e.toString()}, null);
                        ShowMessage.writeLogOutput("wrn", txt);
                    }
                }
                try {
                    if (procsUtl.isServiceInstalled(serviceName) && procsUtl.isServiceRunning(serviceName)) {
                        String[] stringArray = new String[7];
                        stringArray[0] = serviceName;
                        stringArray[1] = "-install";
                        stringArray[3] = serviceName;
                        stringArray[4] = procsUtl.getServiceDescription(serviceName);
                        stringArray[6] = "false";
                        runningServices.addElement(stringArray);
                    }
                }
                catch (ServiceException e) {
                    txt = ShowMessage.gi(null).resolve("Install.ServiceExceptionOccured", new String[]{e.toString()}, null);
                    ShowMessage.writeLogOutput("wrn", txt);
                }
            }
            ++i;
        }
        if (isDebug) {
            ShowMessage.writeLogOutput("getRunningProcesses(): WAS services to be checked = ");
        }
        WASUtl wasUtl = WASUtl.instantiate(ICAInstGlobals.getWizard());
        int i2 = 0;
        while (i2 < wasServicesNamesToCheck.length) {
            String txt;
            StringTokenizer tok = new StringTokenizer(wasServicesNamesToCheck[i2], ":");
            String serviceName = ICAInstGlobals.getServices().resolveString(tok.nextToken());
            String serverName = ICAInstGlobals.getServices().resolveString(tok.nextToken());
            String serviceDisplayName = ICAInstGlobals.getServices().resolveString(tok.nextToken());
            try {
                serviceName = wasUtl.getWASServiceControlingServer(serviceName, serverName, ICAInstGlobals.getServices().resolveString(wasInstallLocation));
            }
            catch (ServiceException e3) {
                txt = ShowMessage.gi(null).resolve("Install.ServiceExceptionOccured", new String[]{e3.toString()}, null);
                ShowMessage.writeLogOutput("wrn", txt);
            }
            if (serviceName != null && serviceName.length() != 0) {
                String txt2;
                wasServicesNamesToCheck[i2] = String.valueOf(serviceName) + ":" + serverName + ":" + serviceDisplayName;
                if (isDebug) {
                    ShowMessage.writeLogOutput(String.valueOf(wasServicesNamesToCheck[i2]) + "\n");
                }
                int wasState = 4;
                try {
                    wasState = wasUtl.getWASServerStatus(ICAInstGlobals.getServices().resolveString(wasInstallLocation), serverName, serviceName, null, null, null, 1);
                }
                catch (ServiceException e2) {
                    txt2 = ShowMessage.gi(null).resolve("Install.ServiceExceptionOccured", new String[]{e2.toString()}, null);
                    ShowMessage.writeLogOutput("wrn", txt2);
                }
                catch (IOException e2) {
                    txt2 = ShowMessage.gi(null).resolve("Install.IOExceptionOccured", new String[]{e2.toString()}, null);
                    ShowMessage.writeLogOutput("wrn", txt2);
                }
                switch (wasState) {
                    case 0: {
                        txt = ShowMessage.gi(null).resolve("Install.WASServerStopped", new String[]{serverName}, null);
                        ShowMessage.writeLogOutput(txt);
                        break;
                    }
                    case 1: {
                        ShowMessage.writeLogOutput(ShowMessage.gi(null).resolve("Install.WASServerStarted", new String[]{serverName}, null));
                        try {
                            String[] stringArray = new String[7];
                            stringArray[0] = serviceName;
                            stringArray[1] = "-add";
                            stringArray[3] = serviceName;
                            stringArray[4] = ICAStringUtils.isWindows() ? procsUtl.getServiceDescription(serviceName) : serviceDisplayName;
                            stringArray[5] = serverName;
                            stringArray[6] = "true";
                            runningServices.addElement(stringArray);
                        }
                        catch (ServiceException e1) {
                            txt = ShowMessage.gi(null).resolve("Install.ServiceExceptionOccured", new String[]{e1.toString()}, null);
                            ShowMessage.writeLogOutput("wrn", txt);
                        }
                        break;
                    }
                    case 3: {
                        ShowMessage.writeLogOutput(ShowMessage.gi(null).resolve("Install.WASServerBadCredential", new String[]{serverName}, null));
                        try {
                            String[] stringArray = new String[7];
                            stringArray[0] = serviceName;
                            stringArray[1] = "-add";
                            stringArray[3] = serviceName;
                            stringArray[4] = ICAStringUtils.isWindows() ? procsUtl.getServiceDescription(serviceName) : serviceDisplayName;
                            stringArray[5] = serverName;
                            stringArray[6] = "true";
                            runningServices.addElement(stringArray);
                        }
                        catch (ServiceException e) {
                            txt = ShowMessage.gi(null).resolve("Install.ServiceExceptionOccured", new String[]{e.toString()}, null);
                            ShowMessage.writeLogOutput("wrn", txt);
                        }
                        break;
                    }
                    default: {
                        ShowMessage.writeLogOutput(ShowMessage.gi(null).resolve("Install.WASServerUknownState", new String[]{serverName}, null));
                    }
                }
            }
            ++i2;
        }
        String[][] runProc = null;
        if (!runningServices.isEmpty()) {
            runProc = new String[runningServices.size()][];
            Enumeration enumeration = runningServices.elements();
            int i3 = 0;
            while (enumeration.hasMoreElements()) {
                runProc[i3++] = (String[])enumeration.nextElement();
            }
        }
        return runProc;
    }

    public static String stopRunningProcesses(String[] servicesNames, String[] wasServicesAndServersPairs, String wasInstallLocation) {
        String[][] processesRunning = SVCProcsUtils.getRunningProcesses(servicesNames, wasServicesAndServersPairs, wasInstallLocation, false);
        String servicesNotStopped = "";
        if (processesRunning != null && processesRunning.length > 0) {
            ProcessesUtl procsUtl = ProcessesUtl.instantiate(ICAInstGlobals.getWizard());
            WASUtl wasUtl = WASUtl.instantiate(ICAInstGlobals.getWizard());
            int j = 0;
            while (j < processesRunning.length) {
                block19: {
                    if (Boolean.getBoolean(processesRunning[j][processesRunning[j].length - 1])) {
                        String txt;
                        String txt2;
                        int wasState = 4;
                        try {
                            txt2 = ShowMessage.gi(null).resolve("Install.StoppingWASServer", new String[]{processesRunning[j][processesRunning[j].length - 2]}, null);
                            ShowMessage.writeLogOutput(txt2);
                            wasState = wasUtl.stopWASServer(wasInstallLocation, processesRunning[j][processesRunning[j].length - 2], processesRunning[j][0], null, null, null, 1, true);
                        }
                        catch (ServiceException e) {
                            txt = ShowMessage.gi(null).resolve("Install.ServiceExceptionOccured", new String[]{e.toString()}, null);
                            ShowMessage.writeLogOutput("wrn", txt);
                        }
                        catch (IOException e) {
                            txt = ShowMessage.gi(null).resolve("Install.IOExceptionOccured", new String[]{e.toString()}, null);
                            ShowMessage.writeLogOutput("wrn", txt);
                        }
                        switch (wasState) {
                            case 0: {
                                txt2 = ShowMessage.gi(null).resolve("Install.WASServerStopped", new String[]{processesRunning[j][4]}, null);
                                ShowMessage.writeLogOutput(txt2);
                                break;
                            }
                            default: {
                                servicesNotStopped = String.valueOf(servicesNotStopped) + "<br>";
                                servicesNotStopped = String.valueOf(servicesNotStopped) + processesRunning[j][4];
                                break;
                            }
                        }
                    } else {
                        try {
                            if (!procsUtl.isServiceInstalled(processesRunning[j][0]) || !procsUtl.isServiceRunning(processesRunning[j][0])) break block19;
                            String txt = ShowMessage.gi(null).resolve("Install.StoppingService", new String[]{processesRunning[j][4]}, null);
                            ShowMessage.writeLogOutput(txt);
                            boolean stopped = false;
                            try {
                                stopped = procsUtl.stopService(processesRunning[j][0]);
                            }
                            catch (ServiceException e) {
                                txt = ShowMessage.gi(null).resolve("Install.ServiceExceptionOccured", new String[]{e.toString()}, null);
                                ShowMessage.writeLogOutput("wrn", txt);
                            }
                            if (!stopped) {
                                txt = ShowMessage.gi(null).resolve("Install.StoppingServiceFailed", new String[]{processesRunning[j][4]}, null);
                                ShowMessage.writeLogOutput(txt);
                                servicesNotStopped = String.valueOf(servicesNotStopped) + "<br>";
                                servicesNotStopped = String.valueOf(servicesNotStopped) + processesRunning[j][4];
                            } else {
                                txt = ShowMessage.gi(null).resolve("Install.ServiceStopped", new String[]{processesRunning[j][4]}, null);
                                ShowMessage.writeLogOutput(txt);
                            }
                        }
                        catch (ServiceException e) {
                            String txt = ShowMessage.gi(null).resolve("Install.ServiceExceptionOccured", new String[]{e.toString()}, null);
                            ShowMessage.writeLogOutput("wrn", txt);
                        }
                    }
                }
                ++j;
            }
            if (!servicesNotStopped.equals("")) {
                servicesNotStopped = String.valueOf(servicesNotStopped) + "<br>";
                return servicesNotStopped;
            }
            try {
                Thread.sleep(7000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return "";
    }

    public static String stopCIMOMByScript(CimomActions actions, String CimServiceName, String stopCimserverScript, WizardActionTimeBasedPercentEstimator estimator) {
        String msg = "";
        if (actions.isServiceRunning(CimServiceName)) {
            ProcUtl utl = new ProcUtl();
            StringBuffer stdout = new StringBuffer();
            StringBuffer stderr = new StringBuffer();
            Object[] comd = new String[1];
            int ii = 0;
            comd[ii++] = ICAStringUtils.quote(stopCimserverScript);
            if (new File(stopCimserverScript).exists()) {
                String exeCmdMsg = ShowMessage.gi(null).resolve("Install.CmdToBeExecuted", new String[]{ICAStringUtils.arrayToString(comd)}, null);
                ShowMessage.writeLogOutput("Stopping Pegasus CIMOM by script...");
                ShowMessage.writeLogOutput(exeCmdMsg);
                try {
                    int rcCmd = utl.execcmd((String[])comd, false, null, (Object)stdout, (Object)stderr);
                    if (estimator != null) {
                        while (utl.isProcessRunning()) {
                            estimator.updateOperationState();
                            estimator.sleep();
                        }
                        estimator.updateOperationState();
                    }
                    utl.waitForProcess();
                    if (rcCmd != 0) {
                        msg = ShowMessage.gi("ICAIns").resolve("ICAInstall.StopCIMServiceError", null, null);
                        ShowMessage.writeLogOutput("Stop Pegasus CIMOM by script failed");
                        ShowMessage.writeLogOutput(stderr.toString());
                        return msg;
                    }
                    ShowMessage.writeLogOutput("Stop Pegasus CIMOM by script successfully");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ShowMessage.writeLogOutput(stderr.toString());
                }
            } else {
                msg = ShowMessage.gi("ICAIns").resolve("ICAInstall.NoCIMServiceStopScript", null, null);
                ShowMessage.writeLogOutput(msg);
                return msg;
            }
        }
        return msg;
    }
}

