/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.ConstResourceBundle;
import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICASoftwareObjectUtils;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.Utilities;
import com.ibm.itcins.ica2.VersionConvertor;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.service.registry.RegistryService;
import com.installshield.util.OperationRejectedException;
import com.installshield.wizard.service.ServiceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class SoftwareVersionUtils {
    public static String componentKey = null;

    public static String getStringComponentVersionInstalled(String componentKey) throws ServiceException {
        RegistryService regService = null;
        SoftwareObject so = null;
        SoftwareObjectKey instSok = null;
        String retValue = null;
        regService = (RegistryService)ICAInstGlobals.getService("registryService");
        regService.initializeRegistry();
        so = regService.getNewestSoftwareObject(componentKey);
        if (so == null) {
            retValue = null;
        } else {
            instSok = so.getKey();
            retValue = String.valueOf(instSok.getVersion().getMajor()) + "." + instSok.getVersion().getMinor() + "." + instSok.getVersion().getMaintenance();
        }
        return retValue;
    }

    public static int checkComponentVersionInstalled(String componentKey, String[] versionToCompareWith) throws ServiceException, OperationRejectedException {
        RegistryService regService = null;
        SoftwareObject so = null;
        SoftwareObjectKey instSok = null;
        SoftwareObjectKey reqSok = null;
        int retValue = 1;
        regService = (RegistryService)ICAInstGlobals.getService("registryService");
        regService.initializeRegistry();
        so = regService.getNewestSoftwareObject(componentKey);
        if (so == null) {
            retValue = -2;
        } else if (versionToCompareWith == null || versionToCompareWith.length == 0) {
            retValue = 0;
        } else {
            VersionConvertor formater = new VersionConvertor(new String[]{"V.R", "M", "F"});
            instSok = so.getKey();
            int cmpVers = instSok.compareTo(reqSok = Utilities.createSoftwareObjectKey(componentKey, formater.formatVRMF(versionToCompareWith), null, instSok.getInstance()));
            retValue = cmpVers > 0 ? 1 : (cmpVers < 0 ? -1 : 0);
        }
        return retValue;
    }

    public static boolean isNewComponentInstallAllowed(String componentKeyID, String componentName, Hashtable productVersions, int verbose) {
        return true;
    }

    public static Hashtable readVersionsFromFile(int verbose, boolean all) {
        boolean error = false;
        ConstResourceBundle bundle = (ConstResourceBundle)ICAInstGlobals.getValue("ResourceBundleReference");
        String[][] mapIntKeysToExtKeys = (String[][])bundle.getObject("Maps.InternalVersionKeysToExternalVerionKeys");
        Properties propVersions = new Properties();
        int compVersionMissing = 0;
        StringBuffer text = new StringBuffer();
        Hashtable<String, Object[]> hashVersions = new Hashtable<String, Object[]>();
        String propFileName = ICAStringUtils.getSearchedFilePath(bundle.getString("Files.productversions"));
        if (propFileName == null || !new File(propFileName).exists()) {
            propFileName = null;
        }
        if (propFileName != null) {
            if (verbose >= 2) {
                text.append(ShowMessage.gi("ICAIns").resolve("ICAInstall.FileFoundOnSearchedDirs", new String[]{propFileName}, null));
                text.append("\n");
            }
            try {
                propVersions.load(new FileInputStream(propFileName));
                int ii = 0;
                while (ii < mapIntKeysToExtKeys.length) {
                    String version = propVersions.getProperty(mapIntKeysToExtKeys[ii][1]);
                    if (version != null) {
                        Object[] splittedVersion = VersionConvertor.getStringVersion(new String[]{version}, true);
                        if (splittedVersion == null) {
                            splittedVersion = VersionConvertor.getStringVersion(new String[]{version}, false);
                            if (verbose >= 1) {
                                text.append(ShowMessage.gi("ICAIns").resolve("ICAInstall.ComponentVersionFoundOnFileWrongFormat", new String[]{mapIntKeysToExtKeys[ii][1], version, ICAStringUtils.arrayToString(splittedVersion, "."), propFileName}, null));
                                text.append("\n");
                            }
                        } else if (verbose >= 2) {
                            text.append(ShowMessage.gi("ICAIns").resolve("ICAInstall.ComponentVersionFoundOnFile", new String[]{mapIntKeysToExtKeys[ii][1], version, ICAStringUtils.arrayToString(splittedVersion, "."), propFileName}, null));
                            text.append("\n");
                        }
                        hashVersions.put(mapIntKeysToExtKeys[ii][0], splittedVersion);
                    } else {
                        if (verbose >= 0 && all) {
                            text.append(ShowMessage.gi("ICAIns").resolve("ICAInstall.ErrorReadingComponentVersionFromFile", new String[]{mapIntKeysToExtKeys[ii][1], propFileName}, null));
                            text.append("\n");
                        }
                        ++compVersionMissing;
                    }
                    ++ii;
                }
            }
            catch (IOException ioE) {
                if (verbose >= 0) {
                    text.append(ShowMessage.gi("ICAIns").resolve("ICAInstall.IOExceptionOccured", new String[]{ioE.toString()}, null));
                    text.append("\n");
                }
                error = true;
            }
        } else {
            if (verbose >= 0) {
                text.append(ShowMessage.gi("ICAIns").resolve("ICAInstall.FileNotFoundOnSearchedDirs", new String[]{bundle.getString("Files.productversions"), ICAStringUtils.arrayToString(ICAStringUtils.getSearchDirectories(), ", ")}, null));
                text.append("\n");
            }
            error = true;
        }
        if (text.toString().trim().length() > 0) {
            ShowMessage.gi("ICAIns");
            ShowMessage.writeLogOutput(text.toString().trim());
        }
        if (compVersionMissing > 0 && all || compVersionMissing == mapIntKeysToExtKeys.length || error) {
            return null;
        }
        return hashVersions;
    }

    public static int possibleUpgradeAction(String[] componentKeyIDs, String[] componentNames, String productKeyID, String productName, int whatToCheck, int verbose) {
        int action;
        boolean preserveConfig = true;
        boolean upgrade = true;
        int ii = 0;
        Hashtable productVersions = SoftwareVersionUtils.readVersionsFromFile(0, false);
        while (ii < componentKeyIDs.length) {
            action = SoftwareVersionUtils.possibleComponentUpgradeAction(componentKeyIDs[ii], componentNames[ii], productVersions, whatToCheck, verbose);
            switch (action) {
                case -1: {
                    if (SoftwareVersionUtils.isNewComponentInstallAllowed(componentKeyIDs[ii], componentNames[ii], productVersions, 0)) break;
                    upgrade = false;
                    preserveConfig = false;
                    break;
                }
                case 0: {
                    upgrade = false;
                }
                case 1: {
                    if (whatToCheck != 1) break;
                    preserveConfig = false;
                }
            }
            ++ii;
        }
        if (upgrade) {
            if (preserveConfig) {
                action = SoftwareVersionUtils.possibleComponentUpgradeAction(productKeyID, productName, productVersions, whatToCheck, verbose);
            } else {
                action = SoftwareVersionUtils.possibleComponentUpgradeAction(productKeyID, productName, productVersions, 0, verbose);
                if (action > 0) {
                    String versionInstalled = "";
                    try {
                        versionInstalled = SoftwareVersionUtils.getStringComponentVersionInstalled(componentKey);
                    }
                    catch (ServiceException serviceException) {
                        // empty catch block
                    }
                    String text = ShowMessage.gi("ICAIns").resolve("ICAInstall.PreserveConfigurationFromVersionImposible", new String[]{productName, versionInstalled}, null);
                    if (verbose >= 0) {
                        ShowMessage.writeLogOutput(text);
                    }
                }
            }
        } else {
            String text = ShowMessage.gi("ICAIns").resolve("ICAInstall.UpgradeFromVersionImposible", new String[]{productName}, null);
            if (verbose >= 0) {
                ShowMessage.writeLogOutput(text);
            }
            action = 0;
        }
        return action;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int possibleComponentUpgradeAction(String componentKeyID, String componentName, Hashtable productVersions, int whatToCheck, int verbose) {
        ConstResourceBundle bundle = (ConstResourceBundle)ICAInstGlobals.getValue("ResourceBundleReference");
        Object[] componentOldestUpgradableVers = null;
        Object[] componentOldestConfigPreservableVers = null;
        String[] componentKeys = bundle.getStringArray(componentKeyID);
        String productUID = "";
        try {
            productUID = ICASoftwareObjectUtils.getInstallingProductUID();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        int i = 0;
        while (i < componentKeys.length) {
            String currentKey = ICAInstGlobals.getServices().resolveString(componentKeys[i]);
            if (!currentKey.startsWith(productUID) || !currentKey.equals(productUID)) {
                currentKey = String.valueOf(productUID) + "." + currentKey;
            }
            componentKeys[i] = currentKey;
            ++i;
        }
        if (productVersions == null) {
            componentOldestUpgradableVers = new String[]{"0", "0", "0", "0"};
            componentOldestConfigPreservableVers = new String[]{"0", "0", "0", "0"};
        } else {
            componentOldestUpgradableVers = (String[])productVersions.get(String.valueOf(componentKeyID) + "_OldestUpgradable");
            if (componentOldestUpgradableVers == null) {
                componentOldestUpgradableVers = new String[]{"0", "0", "0", "0"};
            }
            if ((componentOldestConfigPreservableVers = (String[])productVersions.get(String.valueOf(componentKeyID) + "_OldestConfigPreservable")) == null) {
                componentOldestConfigPreservableVers = new String[]{"0", "0", "0", "0"};
            }
        }
        try {
            String text;
            int upgrade = -2;
            int ii = 0;
            while (ii < componentKeys.length) {
                upgrade = SoftwareVersionUtils.checkComponentVersionInstalled(componentKeys[ii], (String[])componentOldestUpgradableVers);
                if (upgrade != -2) {
                    componentKey = componentKeys[ii];
                    break;
                }
                ++ii;
            }
            int configure = upgrade != -2 ? SoftwareVersionUtils.checkComponentVersionInstalled(componentKey, (String[])componentOldestConfigPreservableVers) : -2;
            if (upgrade < 0) {
                if (upgrade == -2) {
                    if (verbose < 0) return -1;
                    String text2 = ShowMessage.gi("ICAIns").resolve("ICAInstall.ComponentNotInstalled", new String[]{componentName}, null);
                    ShowMessage.writeLogOutput(text2);
                    return -1;
                }
                if (upgrade != -1) return -2;
                if (verbose < 0) return 0;
                String text3 = ShowMessage.gi("ICAIns").resolve("ICAInstall.UpgradeComponentFromVersionImposible", new String[]{componentName, SoftwareVersionUtils.getStringComponentVersionInstalled(componentKey), ICAStringUtils.arrayToString(componentOldestUpgradableVers, ".")}, null);
                ShowMessage.writeLogOutput(text3);
                return 0;
            }
            if (verbose >= 2) {
                text = ShowMessage.gi("ICAIns").resolve("ICAInstall.UpgradeComponentFromVersionPossible", new String[]{componentName, SoftwareVersionUtils.getStringComponentVersionInstalled(componentKey)}, null);
                ShowMessage.writeLogOutput(text);
            }
            if (whatToCheck == 0) {
                return 1;
            }
            if (configure < 0) {
                if (verbose < 0) return 1;
                text = ShowMessage.gi("ICAIns").resolve("ICAInstall.PreserveComponentConfigurationFromVersionImposible", new String[]{componentName, SoftwareVersionUtils.getStringComponentVersionInstalled(componentKey), ICAStringUtils.arrayToString(componentOldestConfigPreservableVers, ".")}, null);
                ShowMessage.writeLogOutput(text);
                return 1;
            }
            if (verbose < 2) return 2;
            text = ShowMessage.gi("ICAIns").resolve("ICAInstall.PreserveComponentConfigurationFromVersionPossible", new String[]{componentName, SoftwareVersionUtils.getStringComponentVersionInstalled(componentKey)}, null);
            ShowMessage.writeLogOutput(text);
            return 2;
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.ServiceExceptionOccured", new String[]{serviceException.toString()}, null));
            return 0;
        }
        catch (OperationRejectedException opRejEx) {
            ShowMessage.writeLogOutput(opRejEx.toString());
            return 0;
        }
    }
}

