/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.CheckExtFile;
import com.ibm.itcins.ica2.CimomActions;
import com.ibm.itcins.ica2.ICAInstConst;
import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICAResume;
import com.ibm.itcins.ica2.ICASoftwareObjectUtils;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ProcUtl;
import com.ibm.itcins.ica2.ProcessesUtl;
import com.ibm.itcins.ica2.SLPActions;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.Utilities;
import com.ibm.itcins.ica2.Utl;
import com.ibm.itcins.ica2.W32RegistryUtils;
import com.ibm.itcins.ica2.W32ServiceUtils;
import com.ibm.itcins.ica2.W32Utl;
import com.ibm.itcins.ica2.WizardActionTimeBasedPercentEstimator;
import com.ibm.itcins.ica2.exceptions.CmdException;
import com.installshield.product.ProductException;
import com.installshield.product.SoftwareObject;
import com.installshield.product.service.registry.RegistryService;
import com.installshield.util.FileUtils;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.platform.win32.Win32Service;
import com.installshield.wizard.platform.win32.win32service.NTServiceConfig;
import com.installshield.wizard.platform.win32.win32service.NTServiceStatus;
import com.installshield.wizard.platform.win32.win32service.Win2kServiceStatusProcess;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class W32CimomActions
extends CimomActions {
    private ICAInstConst bundle = null;
    private String puttyVersion = "0.0";
    static /* synthetic */ Class class$0;

    public W32CimomActions() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.itcins.ica2.ICAInstConst");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.bundle = (ICAInstConst)Utilities.instantiate(clazz.getName());
    }

    public boolean isServiceInstalled(String serviceName) {
        try {
            Win32Service win32Service = (Win32Service)this.wizardServices.getService("win32Service");
            if (win32Service.serviceExists(serviceName)) {
                return true;
            }
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.ServiceExceptionOccured", new String[]{serviceException.toString()}, null));
        }
        return false;
    }

    public boolean isServiceRunning(String serviceName) {
        try {
            Win32Service win32Service;
            Win2kServiceStatusProcess process;
            if (this.isServiceInstalled(serviceName) && 4 == (process = (win32Service = (Win32Service)this.wizardServices.getService("win32Service")).queryWin2kServiceStatusProcess(serviceName)).getCurrentState()) {
                return true;
            }
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.ServiceExceptionOccured", new String[]{serviceException.toString()}, null));
        }
        return false;
    }

    public boolean isDiffSlpInstalled() {
        return this.isServiceInstalled("slpd") && !this.isSLPInVPD();
    }

    public String[][] areProcessRunning(String installLocation) {
        int j;
        String[][] runProc = null;
        Vector<String[]> runningServices = new Vector<String[]>();
        String bobcatSrvName = this.getWAS5SuffixedServiceName();
        String cimomSrvName = this.getCIMAgentSrvName();
        if (this.isServiceInstalled(cimomSrvName) && this.isServiceRunning(cimomSrvName)) {
            String[] stringArray = new String[5];
            stringArray[0] = cimomSrvName;
            stringArray[1] = "-install";
            stringArray[3] = cimomSrvName;
            stringArray[4] = this.getServiceDescription(cimomSrvName);
            runningServices.addElement(stringArray);
        }
        if (this.isServiceInstalled("slpd") && this.isSlpdInstalledByCurrentApp() && this.isServiceRunning("slpd") && this.mustStopSlp()) {
            String[] stringArray = new String[5];
            stringArray[0] = "slpd";
            stringArray[1] = "-install";
            stringArray[3] = "slpd";
            stringArray[4] = this.getServiceDescription("slpd");
            runningServices.addElement(stringArray);
        }
        if (this.isConsoleInstalled() && ((j = this.isBobcatRunning()) == 1 || j == 3)) {
            String[] stringArray = new String[5];
            stringArray[0] = bobcatSrvName;
            stringArray[1] = "-add";
            stringArray[3] = bobcatSrvName;
            stringArray[4] = this.getServiceDescription(bobcatSrvName);
            runningServices.addElement(stringArray);
        }
        if (!runningServices.isEmpty()) {
            runProc = new String[runningServices.size()][];
            Enumeration enumeration = runningServices.elements();
            int i = 0;
            while (enumeration.hasMoreElements()) {
                runProc[i++] = (String[])enumeration.nextElement();
            }
        }
        return runProc;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean stopService(String serviceName) {
        block59: {
            NTServiceStatus serviceStatus = null;
            NTServiceStatus initialServiceStatus = null;
            Win32Service win32Service = null;
            int waitToStop = 24;
            int waitToStart = 24;
            try {
                win32Service = (Win32Service)this.wizardServices.getService("win32Service");
                if (!win32Service.serviceExists(serviceName)) break block59;
                initialServiceStatus = win32Service.queryNTServiceStatus(serviceName);
                if (initialServiceStatus != null) {
                    int firstState = initialServiceStatus.getCurrentState();
                    if (firstState == 1) {
                        return true;
                    }
                    if (firstState == 3) {
                        for (int j = 0; j <= 24; ++j) {
                            if (j == 24) {
                                return false;
                            }
                            initialServiceStatus = win32Service.queryNTServiceStatus(serviceName);
                            int interState = initialServiceStatus.getCurrentState();
                            if (interState != 1) {
                                try {
                                    Thread.sleep(5000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                continue;
                            }
                            return true;
                        }
                        break block59;
                    }
                    if (firstState == 2) {
                        int j = 0;
                        while (j <= 24) {
                            int interState;
                            if (j == 24 || (interState = (initialServiceStatus = win32Service.queryNTServiceStatus(serviceName)).getCurrentState()) == 4) break;
                            if (interState == 1) {
                                return true;
                            }
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ++j;
                        }
                        try {
                            serviceStatus = win32Service.controlNTService(serviceName, 1);
                        }
                        catch (ServiceException srvException) {
                            boolean stopped = false;
                            String errormsg = srvException.toString();
                            int i = 0;
                            int stay2 = 6;
                            do {
                                try {
                                    serviceStatus = win32Service.queryNTServiceStatus(serviceName);
                                    if (serviceStatus != null) {
                                        if (serviceStatus.getCurrentState() != 1) {
                                            try {
                                                Thread.sleep(20000L);
                                            }
                                            catch (InterruptedException interruptedException) {}
                                        } else {
                                            stopped = true;
                                        }
                                    }
                                }
                                catch (ServiceException srvEx) {
                                    try {
                                        Thread.sleep(20000L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                                if (!stopped) continue;
                                return true;
                            } while (++i < stay2);
                            ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.ServiceExceptionOccured", new String[]{errormsg}, null));
                            return false;
                        }
                        for (int k = 0; k <= 24; ++k) {
                            if (k == 24) {
                                return false;
                            }
                            initialServiceStatus = win32Service.queryNTServiceStatus(serviceName);
                            int interState = initialServiceStatus.getCurrentState();
                            if (interState != 1) {
                                try {
                                    Thread.sleep(5000L);
                                }
                                catch (InterruptedException errormsg) {
                                    // empty catch block
                                }
                                continue;
                            }
                            return true;
                        }
                        break block59;
                    }
                    if (firstState != 4) break block59;
                    try {
                        serviceStatus = win32Service.controlNTService(serviceName, 1);
                    }
                    catch (ServiceException srvException) {
                        boolean stopped = false;
                        String errormsg = srvException.toString();
                        int i = 0;
                        int stay = 6;
                        do {
                            try {
                                serviceStatus = win32Service.queryNTServiceStatus(serviceName);
                                if (serviceStatus != null) {
                                    if (serviceStatus.getCurrentState() != 1) {
                                        try {
                                            Thread.sleep(20000L);
                                        }
                                        catch (InterruptedException stay2) {}
                                    } else {
                                        stopped = true;
                                    }
                                }
                            }
                            catch (ServiceException srvEx) {
                                try {
                                    Thread.sleep(20000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            if (!stopped) continue;
                            return true;
                        } while (++i < stay);
                        ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.ServiceExceptionOccured", new String[]{errormsg}, null));
                        return false;
                    }
                    for (int k = 0; k <= 24; ++k) {
                        if (k == 24) {
                            return false;
                        }
                        initialServiceStatus = win32Service.queryNTServiceStatus(serviceName);
                        int interState = initialServiceStatus.getCurrentState();
                        if (interState != 1) {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException errormsg) {
                                // empty catch block
                            }
                            continue;
                        }
                        return true;
                    }
                    break block59;
                }
                return false;
            }
            catch (ServiceException serviceException) {
                boolean stopped = false;
                String errormsg = serviceException.toString();
                int i = 0;
                int stay = 6;
                do {
                    try {
                        serviceStatus = win32Service.queryNTServiceStatus(serviceName);
                        if (serviceStatus != null) {
                            if (serviceStatus.getCurrentState() != 1) {
                                try {
                                    Thread.sleep(20000L);
                                }
                                catch (InterruptedException srvEx) {}
                            } else {
                                stopped = true;
                            }
                        }
                    }
                    catch (ServiceException srvEx) {
                        try {
                            Thread.sleep(20000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (!stopped) continue;
                    return true;
                } while (++i < stay);
                ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.ServiceExceptionOccured", new String[]{errormsg}, null));
                return false;
            }
        }
        return true;
    }

    public void stopServices(String[] services) {
        int i = 0;
        while (i < services.length) {
            if (services[i].equals(this.getWAS5SuffixedServiceName())) {
                this.stopBobcatServer();
            } else {
                this.stopService(services[i]);
            }
            ++i;
        }
    }

    public boolean installService(String serviceName, String serviceLocation, String args) throws ProductException {
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        boolean retVal = false;
        String slpCommand = "\"" + this.wizardServices.getValue(serviceLocation) + "\\" + serviceName + "\"" + " -install" + " " + args;
        ProcUtl proc = new ProcUtl();
        try {
            if (!this.isServiceInstalled(serviceName)) {
                int rc = proc.execcmd(slpCommand, true, null, (Object)stdout, (Object)stderr);
                if (rc < 0) {
                    throw new CmdException(rc, slpCommand, new String[]{stderr == null ? null : stderr.toString()});
                }
                if (!this.isServiceInstalled(serviceName)) {
                    throw new ProductException(601, ShowMessage.gi("ICAIns").resolve("ICAInstall.SrvInstallationError", null, null));
                }
                ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.SrvSuccInstalled", new String[]{this.getServiceDescription(serviceName)}, null));
                retVal = true;
            }
        }
        catch (CmdException cmdException) {
            throw new ProductException(601, cmdException.toString());
        }
        catch (IOException ioException) {
            throw new ProductException(601, ioException.toString());
        }
        return retVal;
    }

    public boolean installSlpService() throws ProductException {
        boolean srvInstalled = this.installService("slpd", "SLPDIR", "");
        if (srvInstalled) {
            try {
                W32ServiceUtils.setNTServiceStartupType("slpd", 2);
            }
            catch (ServiceException serviceException) {
                ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.ServiceExceptionOccured", new String[]{serviceException.toString()}, null));
            }
        }
        return srvInstalled;
    }

    public boolean installCimService() throws ProductException {
        String cimomSrvName = this.getCIMAgentSrvName();
        boolean state = this.installService(cimomSrvName, "CIMOM", "auto dep");
        return state;
    }

    public void uninstallService(String serviceName) throws ProductException {
        block14: {
            String srvDispName = this.getServiceDescription(serviceName);
            boolean isInstalling = ICAInstGlobals.getBoolean("isInstalling");
            try {
                Win32Service win32Service = (Win32Service)this.wizardServices.getService("win32Service");
                if (!win32Service.serviceExists(serviceName)) break block14;
                if (this.isServiceRunning(serviceName)) {
                    this.stopService(serviceName);
                }
                win32Service.deleteNTService(serviceName);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!win32Service.serviceExists(serviceName)) {
                    ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.SrvSuccRemoved", new String[]{srvDispName}, null));
                } else {
                    String msg = ShowMessage.gi("ICAIns").resolve("ICAInstall.FailToUninstSrv", new String[]{srvDispName}, null);
                    NTServiceConfig srvConfig = win32Service.queryNTServiceConfig(serviceName);
                    if (srvConfig != null) {
                        if (srvConfig.getStartType() == 4) {
                            String txt = ShowMessage.gi("ICAIns").resolve("ICAInstall.NTSrvDisabled", new String[]{srvDispName}, null);
                            ShowMessage.writeLogOutput(txt);
                            if (!isInstalling) {
                                SystemUtilService sus = (SystemUtilService)this.wizardServices.getService("systemUtilService");
                                sus.setRebootRequired(true);
                            }
                        } else {
                            ShowMessage.writeLogOutput(String.valueOf(ShowMessage.gi("ICAIns").resolve("ICAInstall.NTSrvsStartTypeNotDisable", new String[]{srvDispName, new Integer(srvConfig.getStartType()).toString()}, null)) + " \n " + msg);
                        }
                    } else {
                        ShowMessage.writeLogOutput(String.valueOf(ShowMessage.gi("ICAIns").resolve("ICAInstall.UnableToDetNTSrvsConfig", new String[]{srvDispName}, null)) + " \n " + msg);
                    }
                }
            }
            catch (ServiceException serviceException) {
                String msg = ShowMessage.gi("ICAIns").resolve("ICAInstall.FailToUninstSrv", new String[]{srvDispName}, null);
                ShowMessage.writeLogOutput(msg);
                if (isInstalling) break block14;
                try {
                    SystemUtilService sus = (SystemUtilService)this.wizardServices.getService("systemUtilService");
                    sus.setRebootRequired(true);
                }
                catch (ServiceException serviceException2) {
                    // empty catch block
                }
            }
        }
    }

    public void uninstallSlpService() throws ProductException {
        if (this.isSlpdInstalledByCurrentApp() && (!ICAInstGlobals.getBoolean("isInstalling") || this.mustReinstallSlpSrv())) {
            this.uninstallService("slpd");
        }
    }

    public void uninstallCimService() throws ProductException {
        if (!ICAInstGlobals.getBoolean("isInstalling") || this.mustReinstallCimomSrv()) {
            this.uninstallService(this.getCIMAgentSrvName());
        }
    }

    public int cleanCimomPreviousInstallation() {
        ProcUtl proc = new ProcUtl();
        String[] uninstallCmd = null;
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        String jarPath = null;
        String java_command = null;
        String retLastInstall = null;
        int rc = 0;
        if (ICAResume.exists()) {
            ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.ProductIncompleteInstallation", new String[]{ShowMessage.gi("ICAIns").resolve("ICAInstall.folder", null, null)}, null));
            return this.clean();
        }
        String productUID = "";
        try {
            productUID = ICASoftwareObjectUtils.getInstallingProductUID();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        retLastInstall = this.getLastInstallPath(productUID);
        if (retLastInstall.equals("")) {
            return 700;
        }
        java_command = String.valueOf(retLastInstall) + this.bundle.getString("_jvm");
        jarPath = Utilities.concatenateDirFile(retLastInstall, this.getUninstallJar());
        if (!new File(jarPath).exists()) {
            String text = ShowMessage.gi("ICAInstall").resolve("ICAInstall.CantFindFile", new String[]{jarPath}, null);
            ShowMessage.writeLogOutput(text);
            return this.clean();
        }
        uninstallCmd = new String[]{Utilities.quote(java_command), "-jar", Utilities.quote(jarPath), "-silent"};
        StringBuffer cmdString = new StringBuffer();
        cmdString.append(uninstallCmd[0]);
        cmdString.append(uninstallCmd[1]);
        cmdString.append(uninstallCmd[2]);
        cmdString.append(uninstallCmd[3]);
        ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.CmdToBeExecuted", new String[]{cmdString.toString()}, null));
        try {
            rc = proc.execcmd(uninstallCmd, true, null, (Object)stdout, (Object)stderr);
        }
        catch (IOException ioException) {
            ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.IOExceptionOccured", new String[]{ioException.toString()}, null));
            return this.clean();
        }
        if (rc != 0 && rc != 600) {
            return this.clean();
        }
        return rc;
    }

    public int clean() {
        try {
            this.uninstallCimService();
            this.uninstallSlpService();
            this.unregister();
            String installLocation = String.valueOf(this.wizardServices.resolveString("$P(installLocation)")) + "\\";
            Utilities.cleanFiles(installLocation, ICAStringUtils.getSearchedFilePath("cimom_clean.txt"));
            String message = String.valueOf(ShowMessage.gi("ICAIns").resolve("ICAInstall.folder", null, null)) + ShowMessage.gi("ICAIns").resolve("ICAInstall.filesRemoved", null, null);
            ShowMessage.writeLogOutput(message);
            String folder = ShowMessage.gi("ICAIns").resolve("ICAInstall.folder", null, null);
            W32Utl utl = (W32Utl)Utl.instantiate(ICAInstGlobals.getWizard());
            String name = String.valueOf(utl.programsMenuContext()) + folder;
            FileService sfs = (FileService)this.wizardServices.getService("fileService");
            if (sfs.fileExists(name)) {
                sfs.deleteDirectory(name, false, true);
            }
            if (sfs.fileExists(name = String.valueOf(utl.desktop()) + ShowMessage.gi("ICAIns").resolve("ICAInstall.cimom_upd_conf", null, null) + ".lnk")) {
                sfs.deleteFile(name);
            }
            if (sfs.fileExists(name = String.valueOf(utl.desktop()) + ShowMessage.gi("ICAIns").resolve("ICAInstall.upd_conf_folder", null, null) + ".lnk")) {
                sfs.deleteFile(name);
            }
            this.cleanVPD();
            ICAResume.deleteFile();
        }
        catch (Exception e) {
            ShowMessage.gi("ICAIns").dispMessage0(this, null, ShowMessage.gi("ICAIns").resolve("ICAInstall.CleanFailed", null, null));
            return 700;
        }
        return 0;
    }

    public int unregister() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.itcins.ica2.ICAInstConst");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICAInstConst bundle = (ICAInstConst)Utilities.instantiate(clazz.getName());
        try {
            Win32RegistryService winService = (Win32RegistryService)this.wizardServices.getService("win32RegistryService");
            String rootIBMKey = bundle.getString("rootIBMKey");
            String productKey = this.wizardServices.resolveString("$GLOBAL(Product_ShortDisplayName)");
            StringBuffer productBuffer = new StringBuffer();
            productBuffer.append(rootIBMKey);
            productBuffer.append("\\");
            productBuffer.append(productKey);
            String key1 = productBuffer.toString();
            if (winService.keyExists(4, key1)) {
                winService.deleteKey(4, rootIBMKey, productKey, false);
                ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.w2kRegistryKeyRemoved", null, null));
            }
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput(serviceException.toString());
            return 1;
        }
        return 0;
    }

    public String getServiceDescription(String serviceName) {
        if (serviceName == null) {
            return "";
        }
        String retVal = serviceName.toUpperCase();
        try {
            String name;
            Win32Service win32Service = (Win32Service)this.wizardServices.getService("win32Service");
            if (win32Service.serviceExists(serviceName) && (name = win32Service.getNTServiceDisplayName(serviceName)) != null && name.length() > 0) {
                retVal = name;
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return retVal;
    }

    public void updateEnv(String name) {
        SystemUtilService systemService = null;
        String installVar = null;
        String path = null;
        try {
            systemService = (SystemUtilService)this.wizardServices.getService("systemUtilService");
            installVar = this.getESSCliInstallLocation();
            if (installVar == null || installVar.trim().length() == 0) {
                installVar = systemService.getRawEnvironmentVariable(name, 1);
            }
            path = systemService.getRawEnvironmentVariable("PATH", 1);
            if (installVar != null) {
                if (path.indexOf(installVar) == -1) {
                    systemService.appendEnvironmentVariable("PATH", installVar, File.pathSeparator, 1);
                    ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.PathEnvVarUpdate", null, null));
                }
                this.wizardServices.setValue("ESSCLI", installVar);
            } else {
                ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.PathEnvVarUpdateFailed", null, null));
                this.wizardServices.setValue("ESSCLI", "");
            }
        }
        catch (ServiceException srvEx) {
            ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.ServiceExceptionOccured", new String[]{srvEx.toString()}, null));
            this.wizardServices.setValue("ESSCLI", "");
        }
    }

    public String checkSystem() {
        StringBuffer exitMsg = new StringBuffer();
        String prereq = (String)this.wizardServices.getValue("checkPrerequisite");
        boolean checkPrereq = prereq != null && prereq.toUpperCase().startsWith("Y");
        boolean isW2003 = ICAStringUtils.isWindows2003();
        boolean isW2008 = ICAStringUtils.isWindows2K8();
        if (!checkPrereq) {
            if (ICAStringUtils.isWindows()) {
                return "";
            }
            return ShowMessage.gi("ICAIns").resolve("ICAInstall.UnsupportedOS", null, null);
        }
        if (!isW2003 && !isW2008) {
            String osFounded = System.getProperty("os.name").toUpperCase();
            exitMsg.append(ShowMessage.gi("ICAIns").resolve("ICAInstall.WrongOSLevel", null, null));
            exitMsg.append("\n");
            exitMsg.append(ShowMessage.gi("ICAIns").resolve("ICAInstall.OSLevel", new String[]{ShowMessage.gi("ICAIns").resolve("ICAInstall.ReqOSName", null, null), osFounded}, null));
            return exitMsg.toString();
        }
        String osMain = ICAInstGlobals.getServices().resolveString("$D(os_main)");
        String systemRoot = Utilities.getEnvironmentVariable("SystemRoot");
        if (systemRoot == "") {
            systemRoot = Utilities.getEnvironmentVariable("WINDIR");
        }
        if (osMain != null && systemRoot != "") {
            osMain = ICAStringUtils.removeLastSlash(ICAStringUtils.goodSlashes(ICAStringUtils.unquote(osMain.trim())));
            systemRoot = ICAStringUtils.removeLastSlash(ICAStringUtils.goodSlashes(ICAStringUtils.unquote(systemRoot.trim())));
        }
        return exitMsg.toString();
    }

    public int startNTService(String serviceName) {
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        ProcUtl proc = new ProcUtl();
        String serviceStartCmd = "net start " + serviceName;
        try {
            ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.CmdToBeExecuted", new String[]{serviceStartCmd}, null));
            int rc = proc.system(serviceStartCmd, true, null, stdout, stderr);
            if (rc != 0) {
                throw new CmdException(rc, serviceStartCmd, new String[]{stderr == null ? null : stderr.toString().trim()});
            }
            return 0;
        }
        catch (CmdException cmdException) {
            ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.ErrExecutingCmd", new String[]{cmdException.getCommand(), cmdException.getMessage().trim()}, null));
        }
        catch (IOException ioException) {
            ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.IOExceptionOccured", new String[]{ioException.toString().trim()}, null));
        }
        return 1;
    }

    public int startSlp() {
        return this.startNTService("slpd");
    }

    public int startCimom() {
        return this.startNTService(this.getCIMAgentSrvName());
    }

    public ArrayList startServices() {
        Vector<String> srvsStarted = new Vector<String>();
        Vector<String> srvsNotStarted = new Vector<String>();
        ArrayList<Vector<String>> result = new ArrayList<Vector<String>>();
        String slpdDisplayName = this.getServiceDescription("slpd");
        String cimomDisplayName = this.getServiceDescription(this.getCIMAgentSrvName());
        String wasSrvsInternalName = this.getWAS5SuffixedServiceName();
        String wasDisplayName = this.getServiceDescription(wasSrvsInternalName);
        if (this.successInstall()) {
            boolean isMySlp = this.isSlpdInstalledByCurrentApp();
            if (this.startCimom() != 0) {
                if (isMySlp) {
                    if (this.isServiceInstalled("slpd") && this.isServiceRunning("slpd")) {
                        srvsStarted.add(slpdDisplayName);
                    } else {
                        srvsNotStarted.add(slpdDisplayName);
                    }
                }
                srvsNotStarted.add(cimomDisplayName);
            } else {
                if (isMySlp) {
                    srvsStarted.add(slpdDisplayName);
                }
                srvsStarted.add(cimomDisplayName);
            }
            if (this.isConsoleInstalled()) {
                if (this.startBobcatService() != 0) {
                    srvsNotStarted.add(wasDisplayName);
                } else {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.isServiceRunning(wasSrvsInternalName)) {
                        srvsStarted.add(wasDisplayName);
                    } else {
                        srvsNotStarted.add(wasDisplayName);
                    }
                }
            }
        } else {
            srvsNotStarted.add(slpdDisplayName);
            srvsNotStarted.add(cimomDisplayName);
            if (this.isConsoleInstalled()) {
                srvsNotStarted.add(wasDisplayName);
            }
        }
        result.add(srvsNotStarted);
        result.add(srvsStarted);
        return result;
    }

    public String checkLockedFiles() {
        W32Utl utl = (W32Utl)Utl.instantiate(ICAInstGlobals.getWizard());
        StringBuffer message = new StringBuffer("");
        String productUID = "";
        try {
            productUID = ICASoftwareObjectUtils.getInstallingProductUID();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        String[] dirsToCheck = new String[]{this.getLastInstallPath(productUID)};
        String[] fileExtensions = new String[]{"exe", "dll", "jar", "zip", "class", "noextension"};
        String[] dirsToExclude = new String[]{"_jvm", "_uninst", "_uninst1", "_uninst2", "_uninst3", "_uninst4", "_uninst5", "_uninst6", "_uninst7", "_uninst8", "_uninst9"};
        String[] extraDirsToExclude = new String[]{this.bundle.getString("slpLocation")};
        String[] targetDirsToExclude = new String[]{this.bundle.getString("slpLocation")};
        if (ICAInstGlobals.getBoolean("isInstalling")) {
            int i = 0;
            while (i < extraDirsToExclude.length) {
                String dirName = ICAStringUtils.getSearchedFilePath(extraDirsToExclude[i]);
                if (dirName != null) {
                    File slpSrcDir = new File(dirName);
                    if (!slpSrcDir.exists()) {
                        dirsToExclude = Utilities.addStringToStringArray(dirsToExclude, targetDirsToExclude[i]);
                    } else {
                        String[] files = slpSrcDir.list();
                        if (files == null || files.length == 0) {
                            dirsToExclude = Utilities.addStringToStringArray(dirsToExclude, targetDirsToExclude[i]);
                        }
                    }
                }
                ++i;
            }
        }
        int ii = 0;
        String[] filesLocked = utl.getFilesInUse(dirsToCheck, dirsToExclude, fileExtensions);
        ii = 0;
        while (ii < filesLocked.length) {
            message.append(String.valueOf(filesLocked[ii]) + "\n");
            ++ii;
        }
        return message.toString().trim();
    }

    public String getServiceDisplayName(String serviceName) {
        Win32Service win32service = null;
        String srvDispName = null;
        try {
            win32service = (Win32Service)this.wizardServices.getService("win32Service");
            if (this.isServiceInstalled(serviceName)) {
                srvDispName = win32service.getNTServiceDisplayName(serviceName);
            }
        }
        catch (ServiceException serviceException) {
            srvDispName = "";
        }
        return srvDispName;
    }

    public boolean installBobcatService(String serviceName, String serverName) throws ProductException {
        return this.installBobcatService(serviceName, serverName, null, null, null, null, null, null, true);
    }

    public boolean installBobcatService(String serviceName, String serverName, String wasHome, String configRoot, String startArgs, String userID, String password, String logFile, boolean restart) throws ProductException {
        StringBuffer installCommand = new StringBuffer();
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        ProcUtl proc = new ProcUtl();
        File bobcatServiceFile = null;
        String wasInternalName = null;
        wasInternalName = this.bundle.getString("WASBobcatInternalServiceName");
        String bobcatSrvName = String.valueOf(wasInternalName) + serviceName;
        String bobcatInstPath = ICAInstGlobals.getString("WASROOT");
        if (this.isServiceInstalled(bobcatSrvName)) {
            return false;
        }
        if (bobcatInstPath == null) {
            throw new ProductException(601, ShowMessage.gi("ICAIns").resolve("NullGlobalVariable", new String[]{"WASROOT"}, null));
        }
        bobcatServiceFile = new File(Utilities.concatenateDirFile(new String[]{bobcatInstPath, "bin", "WASService.exe"}));
        if (!bobcatServiceFile.exists()) {
            String msg = ShowMessage.gi("ICAIns").resolve("ICAInstall.NTServiceInstFailed", new String[]{bobcatSrvName}, null);
            ShowMessage.writeLogOutput(msg);
            throw new ProductException(601, ShowMessage.gi("ICAIns").resolve("ICAInstall.CantFindFile", new String[]{bobcatServiceFile.getAbsolutePath()}, null));
        }
        installCommand.append(String.valueOf(ICAStringUtils.quoteOrUnquote(bobcatServiceFile.getAbsolutePath())) + " ");
        if (serviceName != null) {
            installCommand.append(" -add ");
            installCommand.append(serviceName);
        }
        if (serverName == null) {
            serverName = this.bundle.getString("WASBobcatServerID");
        }
        installCommand.append(" -serverName ");
        installCommand.append(serverName);
        if (wasHome != null) {
            installCommand.append(" -wasHome ");
            installCommand.append(wasHome);
        }
        if (configRoot != null && configRoot.length() != 0) {
            installCommand.append(" -configRoot ");
            installCommand.append(configRoot);
        }
        if (startArgs != null) {
            installCommand.append(" -startArgs ");
            installCommand.append(startArgs);
        }
        if (userID != null && password != null) {
            installCommand.append(" -userid ");
            installCommand.append(userID);
            installCommand.append(" -password ");
            installCommand.append(password);
        }
        if (logFile != null) {
            installCommand.append(" -logFile ");
            installCommand.append(logFile);
        }
        installCommand.append(" -restart ");
        installCommand.append(new Boolean(restart).toString());
        try {
            ShowMessage.writeLogOutput("dbg", ShowMessage.gi("ICAIns").resolve("ICAInstall.CmdToBeExecuted", new String[]{installCommand.toString().trim()}, null));
            int rc = proc.execcmd(installCommand.toString().trim(), true, null, (Object)stdout, (Object)stderr);
            if (rc != 0) {
                throw new CmdException(rc, installCommand.toString().trim(), new String[]{stderr == null ? null : stderr.toString()});
            }
            ShowMessage.writeLogOutput(ShowMessage.gi("ICA1").resolve("ICAInstall.WASBobcatServiceInstalled", new String[]{this.getServiceDescription(bobcatSrvName)}, null));
        }
        catch (IOException ioException) {
            throw new ProductException(601, ioException.toString());
        }
        this.changeBobcatSrvCfg();
        return true;
    }

    public void changeBobcatSrvCfg() {
        Win32Service win32Service = null;
        NTServiceConfig bobcatCurrentNTSrvConf = null;
        String bobcatName = this.getWAS5SuffixedServiceName();
        try {
            win32Service = (Win32Service)this.wizardServices.getService("win32Service");
            if (win32Service.serviceExists(bobcatName) && (bobcatCurrentNTSrvConf = win32Service.queryNTServiceConfig(bobcatName)) != null) {
                bobcatCurrentNTSrvConf.setStartType(2);
                win32Service.changeNTServiceConfig(bobcatName, bobcatCurrentNTSrvConf);
            }
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.ServiceExceptionOccured", new String[]{serviceException.toString()}, null));
        }
    }

    public int startBobcatService() {
        return this.startNTService(Utilities.quote(this.getWAS5SuffixedServiceName()));
    }

    public void uninstallBobcatService() throws ProductException {
        if (!ICAInstGlobals.getBoolean("isInstalling") || this.mustReinstallWasSrv()) {
            this.uninstallService(this.getWAS5SuffixedServiceName());
        }
    }

    public void createW2KIBMRootRegistryKey(String parentKey, String keyName) throws ProductException {
        this.createW2KRegistryKey(parentKey, keyName, null, null, false);
    }

    public void createW2KRegistryKey(String parentKey, String keyName, String[] vrmf, String installLocation, boolean deleteOldKeyIfExists) throws ProductException {
        Win32RegistryService winService = null;
        String currentKey = null;
        String currentVersionString = null;
        String installLocationEntry = null;
        String currentVersionKey = null;
        String[] currentVRMFEntries = null;
        try {
            winService = (Win32RegistryService)this.wizardServices.getService("win32RegistryService");
            if (!winService.keyExists(4, parentKey)) {
                throw new ProductException(601, ShowMessage.gi("ICAIns").resolve("W32ICARegistryUpdate.parentKeyDoesNotExists", new String[]{parentKey, keyName}, null));
            }
            currentKey = String.valueOf(parentKey) + "\\" + keyName;
            if (deleteOldKeyIfExists && winService.keyExists(4, currentKey)) {
                winService.deleteKey(4, parentKey, keyName, false);
            }
            winService.createKey(4, parentKey, keyName);
            if (vrmf != null) {
                currentVersionString = "CurrentVersion";
                currentVersionKey = String.valueOf(currentKey) + "\\" + currentVersionString;
                if (winService.keyExists(4, currentVersionKey)) {
                    winService.deleteKey(4, currentKey, currentVersionString, false);
                }
                winService.createKey(4, currentKey, currentVersionString);
                currentVRMFEntries = new String[]{"Version", "Release", "Modification", "Service Level"};
                if (winService.keyExists(4, currentVersionKey)) {
                    int i = 0;
                    while (i < currentVRMFEntries.length) {
                        winService.setStringValue(4, currentVersionKey, currentVRMFEntries[i], false, vrmf[i]);
                        ++i;
                    }
                }
            }
            if (installLocation != null) {
                installLocationEntry = "InstallLocation";
                if (winService.keyExists(4, currentKey)) {
                    winService.setStringValue(4, currentKey, installLocationEntry, false, installLocation);
                }
            }
        }
        catch (ServiceException serviceException) {
            throw new ProductException(601, serviceException.toString());
        }
    }

    public int getOSServiceLevel() {
        int returnLevel = -1;
        SystemUtilService sus = null;
        String serviceLevel = "";
        StringTokenizer token = null;
        try {
            sus = (SystemUtilService)this.wizardServices.getService("systemUtilService");
            serviceLevel = sus.getOSServiceLevel();
            if (serviceLevel != null && serviceLevel.length() > 0) {
                token = new StringTokenizer(serviceLevel, " ");
                while (token.hasMoreElements()) {
                    String nextToken = (String)token.nextElement();
                    try {
                        int i;
                        returnLevel = i = Integer.parseInt(nextToken);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            } else {
                returnLevel = 0;
            }
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.UnableToDetermineOSSystemLevel", null, null));
            ShowMessage.gi("ICAIns").fatalError0(this, "ICAInstall.ServiceExceptionOccured", new String[]{serviceException.getMessage()});
        }
        return returnLevel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String checkPuttyInstallation() {
        String retVal = "";
        SoftwareObject puttySO = null;
        RegistryService regServ = null;
        String puttyFeatureKey = "ibmcimagentsvc.sshclientfeature";
        if (!this.isKeyInVPD(puttyFeatureKey)) return this.checkPuttyUninstallRegKey();
        try {
            regServ = (RegistryService)this.wizardServices.getService("registryService");
            puttySO = regServ.getNewestSoftwareObject(puttyFeatureKey);
            if (puttySO == null) return retVal;
            String puttyInstallLocation = puttySO.getInstallLocation();
            if (puttyInstallLocation == null) return retVal;
            if (puttyInstallLocation.length() <= 0) return retVal;
            return ICAStringUtils.quoteOrUnquote(Utilities.concatenateDirFile(puttyInstallLocation, "SSHClient"));
        }
        catch (ServiceException serviceException) {
            ShowMessage.gi("ICAIns").fatalError1(this, "ICAInstall.ServiceExceptionOccured", serviceException.toString(), null);
            return null;
        }
    }

    public String checkPuttyUninstallRegKey() {
        String w2kUninstallKey = null;
        String puttyKeyName = null;
        Win32RegistryService win32RegSrv = null;
        String puttyInstallationPath = "";
        w2kUninstallKey = this.bundle.getString("cimmomUninstallerRegistryKey");
        puttyKeyName = this.bundle.getString("puttyKey");
        try {
            win32RegSrv = (Win32RegistryService)this.wizardServices.getService("win32RegistryService");
            if (win32RegSrv.keyExists(4, w2kUninstallKey)) {
                String[] subkeyNames = null;
                subkeyNames = win32RegSrv.getSubkeyNames(4, w2kUninstallKey);
                int i = 0;
                while (i < subkeyNames.length) {
                    int pos = subkeyNames[i].toUpperCase().indexOf(puttyKeyName);
                    if (pos == 0) {
                        String appPathValue = null;
                        String uninstValue = null;
                        String currentSubkey = String.valueOf(w2kUninstallKey) + "\\" + subkeyNames[i];
                        String appPath = this.bundle.getString("puttyAppPath");
                        String puttyUninsString = this.bundle.getString("puttyUninst");
                        if (win32RegSrv.keyExists(4, currentSubkey)) {
                            int j;
                            if (win32RegSrv.valueExists(4, currentSubkey, appPath)) {
                                appPathValue = win32RegSrv.getStringValue(4, currentSubkey, appPath, false);
                                if (appPathValue != null && appPathValue.length() > 0 && win32RegSrv.valueExists(4, currentSubkey, this.bundle.getString("puttyVersion"))) {
                                    puttyInstallationPath = appPathValue;
                                    this.puttyVersion = win32RegSrv.getStringValue(4, currentSubkey, this.bundle.getString("puttyVersion"), false);
                                }
                            } else if (win32RegSrv.valueExists(4, currentSubkey, puttyUninsString) && (uninstValue = win32RegSrv.getStringValue(4, currentSubkey, puttyUninsString, false)) != null && uninstValue.length() > 0 && (j = uninstValue.lastIndexOf("\\")) != -1) {
                                puttyInstallationPath = ICAStringUtils.unquote(uninstValue).substring(0, j - 1);
                                if (win32RegSrv.valueExists(4, currentSubkey, this.bundle.getString("puttyVersion"))) {
                                    this.puttyVersion = win32RegSrv.getStringValue(4, currentSubkey, this.bundle.getString("puttyVersion"), false);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        catch (ServiceException serviceException) {
            ShowMessage.gi("ICAIns").fatalError1(this, "ICAInstall.ServiceExceptionOccured", serviceException.toString(), null);
            return null;
        }
        return puttyInstallationPath;
    }

    public boolean isOpenSSHInstalled() {
        String puttyInstPath = this.checkPuttyUninstallRegKey();
        boolean retVal = false;
        if (puttyInstPath != null && puttyInstPath.length() > 0) {
            ICAInstGlobals.setValue("SSHCLI", puttyInstPath);
            retVal = true;
        }
        return retVal;
    }

    public boolean openSSHGoodVersion() {
        double puttyVersionNumber = new Double(this.puttyVersion);
        return puttyVersionNumber >= 0.6;
    }

    public boolean checkSSHFileExistence() {
        String puttyInstPath = (String)ICAInstGlobals.getValue("SSHCLI");
        String plink = "plink.exe";
        String pscp = "pscp.exe";
        File plinkFile = new File(puttyInstPath, plink);
        File pscpFile = new File(puttyInstPath, pscp);
        return plinkFile.exists() && pscpFile.exists();
    }

    public String getSSHVersion() {
        return this.puttyVersion;
    }

    public boolean isWinServer() {
        try {
            Win32RegistryService win32Reg = (Win32RegistryService)this.wizardServices.getService("win32RegistryService");
            String valVer = win32Reg.getStringValue(4, "System\\CurrentControlSet\\Control\\ProductOptions", "ProductType", true);
            if (valVer != null && valVer.toUpperCase().equals("WINNT")) {
                return false;
            }
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.ServiceExceptionOccured", new String[]{serviceException.toString()}, null));
        }
        return true;
    }

    public String isServiceInstalledByApps(String srvName, String[] appsVpdKeys) {
        String retVal;
        block10: {
            String productUID = "";
            try {
                productUID = ICASoftwareObjectUtils.getInstallingProductUID();
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            retVal = "@02";
            try {
                Win32Service win32Service = (Win32Service)this.wizardServices.getService("win32Service");
                if (win32Service.serviceExists(srvName)) {
                    if (appsVpdKeys == null || appsVpdKeys.length <= 0) break block10;
                    int k = 0;
                    while (k < appsVpdKeys.length) {
                        String instPath = this.getLastInstallPath(appsVpdKeys[k]);
                        if (instPath != null && instPath.length() > 0) {
                            instPath = FileUtils.canonizePath(instPath);
                            NTServiceConfig ntSrvCfg = win32Service.queryNTServiceConfig(srvName);
                            if (ntSrvCfg != null) {
                                String srvExecPath = ntSrvCfg.getCommand();
                                if ((srvExecPath = FileUtils.canonizePath(srvExecPath)).toLowerCase().indexOf(instPath.toLowerCase()) >= 0) {
                                    retVal = appsVpdKeys[k];
                                    if (retVal.equals(productUID)) {
                                        retVal = "@04";
                                    }
                                    break block10;
                                }
                            }
                        }
                        ++k;
                    }
                    break block10;
                }
                retVal = "@01";
            }
            catch (ServiceException serviceException) {
                ShowMessage.gi("ICAIns").fatalError1((Object)this, "", "ICAInstall.ServiceExceptionOccured", (Object)serviceException.toString(), null);
                return "@03";
            }
        }
        return retVal;
    }

    public boolean isCurrentAppUid(String uid) {
        String productUID = "";
        try {
            productUID = ICASoftwareObjectUtils.getInstallingProductUID();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        String[] uids = new String[]{productUID, this.getCIMOMKey(), this.getCIMOMFeatureKey(), this.getSLPFeatureKey(), this.getConsoleFeatureKey(), this.getConsoleKey(), this.getLapComponentKey(), this.getSupportComponentKey()};
        int i = 0;
        while (i < uids.length) {
            if (uids[i].equals(uid)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getIBMCimAgentVpdKeys() {
        RegistryService regService = null;
        String[] returnedKeys = null;
        String[] allUids = null;
        Vector<String> validUids = new Vector<String>();
        try {
            regService = (RegistryService)this.wizardServices.getService("registryService");
            regService.initializeRegistry();
            allUids = regService.getAllSoftwareObjectUIDs();
            String productUID = ICASoftwareObjectUtils.getInstallingProductUID();
            if (allUids != null && allUids.length > 0) {
                int i = 0;
                while (i < allUids.length) {
                    boolean check = allUids[i].startsWith("ibmcimagent") || allUids[i].startsWith(productUID);
                    String uid = this.findParentUIDRecursively(allUids[i]);
                    if (check && !validUids.contains(uid)) {
                        validUids.add(uid);
                    }
                    ++i;
                }
            }
        }
        catch (ServiceException serviceException) {
            ShowMessage.gi("ICAIns").fatalError1(this, "ICAInstall.ServiceExceptionOccured", serviceException.toString(), null);
        }
        returnedKeys = new String[validUids.size()];
        returnedKeys = validUids.toArray(returnedKeys);
        return returnedKeys;
    }

    public String isServiceInstalledByApp(String srvName, String appVpdKey) {
        return this.isServiceInstalledByApps(srvName, new String[]{appVpdKey});
    }

    public boolean isSlpdInstalledByCurrentApp() {
        String srvName = "slpd";
        String productUID = "";
        try {
            productUID = ICASoftwareObjectUtils.getInstallingProductUID();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return this.isServiceInstalledByApp(srvName, productUID).equals("@04");
    }

    public boolean mustReinstallCimomSrv() {
        String srcFile = "";
        String destFile = "";
        String installLocation = null;
        String cimomSrvName = this.getCIMAgentSrvName();
        String extension = ".exe";
        boolean mustReinstall = false;
        srcFile = ICAStringUtils.getSearchedFilePath("cimom" + File.separator + cimomSrvName + extension);
        installLocation = ICAInstGlobals.getString("CIMOM");
        if (installLocation != null && installLocation.length() > 0) {
            destFile = Utilities.concatenateDirFile(new String[]{installLocation, String.valueOf(cimomSrvName) + extension});
        }
        try {
            mustReinstall = (CheckExtFile.checkFilesPresent(srcFile, destFile, true) & 0x22) != 0;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mustReinstall;
    }

    public boolean mustReinstallSlpSrv() {
        String srcFile = "";
        String destFile = "";
        String slpSrvName = "slpd";
        String slpInstPath = ICAInstGlobals.getString("SLPDIR");
        String extension = ".exe";
        boolean mustReinstall = false;
        srcFile = ICAStringUtils.getSearchedFilePath(String.valueOf(this.bundle.getString("slpLocation")) + File.separator + slpSrvName + extension);
        if (slpInstPath != null && slpInstPath.length() > 0) {
            destFile = Utilities.concatenateDirFile(new String[]{slpInstPath, String.valueOf(slpSrvName) + extension});
        }
        try {
            mustReinstall = (CheckExtFile.checkFilesPresent(srcFile, destFile, true) & 0x22) != 0;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mustReinstall;
    }

    public boolean mustReinstallWasSrv() {
        String srcFile = "";
        String destFile = "";
        String wasSrvName = "wasservice.exe";
        String wasInstPath = ICAInstGlobals.getString("SLPDIR");
        boolean mustReinstall = false;
        srcFile = ICAStringUtils.getSearchedFilePath(String.valueOf(this.bundle.getString("embeddedWAS")) + File.separator + "bin" + File.separator + wasSrvName);
        if (wasInstPath != null && wasInstPath.length() > 0) {
            destFile = Utilities.concatenateDirFile(new String[]{wasInstPath, "bin", wasSrvName});
        }
        try {
            mustReinstall = (CheckExtFile.checkFilesPresent(srcFile, destFile, true) & 0x22) != 0;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mustReinstall;
    }

    public boolean mustStopSlp() {
        String[] files;
        File slpSrcDir;
        boolean mustStop = false;
        if (!ICAInstGlobals.getBoolean("isInstalling")) {
            return true;
        }
        String dirName = ICAStringUtils.getSearchedFilePath(this.bundle.getString("slpLocation"));
        if (dirName != null && (slpSrcDir = new File(dirName)).exists() && slpSrcDir.isDirectory() && (files = slpSrcDir.list()) != null && files.length > 0) {
            mustStop = true;
        }
        return mustStop;
    }

    public String findESSCliInstallerDirectory() throws ServiceException {
        String installVar = "";
        if (this.isEssCliInstalled() && this.essGoodVersion()) {
            String path;
            SystemUtilService systemService = (SystemUtilService)this.wizardServices.getService("systemUtilService");
            installVar = this.getESSCliInstallLocation();
            if (installVar == null || installVar.trim().length() == 0) {
                installVar = systemService.getRawEnvironmentVariable("INSTALL", 1);
            }
            if (installVar != null && installVar.trim().length() > 0 && (path = systemService.getRawEnvironmentVariable("PATH", 1)).indexOf(installVar) < 0) {
                systemService.appendEnvironmentVariable("PATH", installVar, File.pathSeparator, 1);
            }
        }
        return installVar;
    }

    public boolean cleanPreviousInstallation(WizardActionTimeBasedPercentEstimator estimator) throws IOException, ServiceException {
        ProcessesUtl utl = ProcessesUtl.instantiate(this.wizardServices);
        if (estimator != null) {
            estimator.updateOperationState();
        }
        String[] services = new String[]{this.bundle.getString("cimServicePreviousName"), "slpd"};
        int i = 0;
        while (i < services.length) {
            block13: {
                int j;
                String serviceDescription;
                block12: {
                    serviceDescription = utl.getServiceDescription(services[i]);
                    if (!services[i].equalsIgnoreCase("slpd")) break block12;
                    String installLocation = ICASoftwareObjectUtils.getLastInstallPath(this.bundle.getString("icatPreviousKey"));
                    if (!SLPActions.instantiate().isSLPActiveAsService(installLocation, "slpd")) break block13;
                }
                String txt = ShowMessage.gi(null).resolve("Install.RemovingService", new String[]{serviceDescription}, null);
                ShowMessage.writeLogOutput(txt);
                if (estimator != null) {
                    estimator.updateOperationState();
                }
                if ((j = utl.uninstallService(this.wizardServices, services[i], false)) != 0) {
                    txt = ShowMessage.gi(null).resolve("Install.RemovingServiceFailed", new String[]{serviceDescription}, null);
                    ShowMessage.writeLogOutput("err", txt);
                    return false;
                }
                txt = ShowMessage.gi(null).resolve("Install.ServiceRemoved", new String[]{serviceDescription}, null);
                ShowMessage.writeLogOutput(txt);
            }
            ++i;
        }
        if (estimator != null) {
            estimator.updateOperationState();
        }
        String keyName = this.bundle.getString("prevCIMServerWinRegKeyName");
        W32RegistryUtils.deleteRegistryKey("SOFTWARE\\IBM", keyName);
        W32Utl win32utl = (W32Utl)Utl.instantiate(ICAInstGlobals.getWizard());
        String cimDestopItemsFolder = String.valueOf(win32utl.programsMenuContext()) + keyName;
        FileService sfs = (FileService)this.wizardServices.getService("fileService");
        if (sfs.fileExists(cimDestopItemsFolder)) {
            sfs.deleteDirectory(cimDestopItemsFolder, false, true);
        }
        cimDestopItemsFolder = String.valueOf(win32utl.getCurrentUserHome()) + keyName;
        sfs = (FileService)this.wizardServices.getService("fileService");
        if (sfs.fileExists(cimDestopItemsFolder)) {
            sfs.deleteDirectory(cimDestopItemsFolder, false, true);
        }
        if (sfs.fileExists(cimDestopItemsFolder = String.valueOf(win32utl.desktop()) + keyName)) {
            sfs.deleteDirectory(cimDestopItemsFolder, false, true);
        }
        if (estimator != null) {
            estimator.updateOperationState();
        }
        return super.cleanPreviousInstallation(estimator);
    }
}

