/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.ActionTimeBasedPercentEstimator;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ProcUtl;
import com.ibm.itcins.ica2.ProcessesUtl;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.W32ServiceUtils;
import com.ibm.itcins.ica2.exceptions.CmdException;
import com.installshield.util.FileUtils;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.platform.win32.Win32Service;
import com.installshield.wizard.platform.win32.win32service.NTServiceConfig;
import com.installshield.wizard.platform.win32.win32service.NTServiceStatus;
import com.installshield.wizard.platform.win32.win32service.Win2kServiceStatusProcess;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.IOException;
import java.util.Hashtable;

public class W32ProcessesUtl
extends ProcessesUtl {
    static /* synthetic */ Class class$0;

    public static String[] involvedClasses() {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.itcins.ica2.W32ServiceUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        return stringArray;
    }

    public boolean isServiceInstalled(String serviceName) throws ServiceException {
        Win32Service win32Service = (Win32Service)this.wizardServices.getService("win32Service");
        return win32Service.serviceExists(serviceName);
    }

    public boolean isServiceRunning(String serviceName) throws ServiceException {
        Win32Service win32Service;
        Win2kServiceStatusProcess process;
        return this.isServiceInstalled(serviceName) && 4 == (process = (win32Service = (Win32Service)this.wizardServices.getService("win32Service")).queryWin2kServiceStatusProcess(serviceName)).getCurrentState();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean stopService(String serviceName) throws ServiceException {
        block59: {
            NTServiceStatus serviceStatus = null;
            NTServiceStatus initialServiceStatus = null;
            Win32Service win32Service = null;
            int waitToStop = 24;
            int waitToStart = 24;
            try {
                win32Service = (Win32Service)this.wizardServices.getService("win32Service");
                if (!win32Service.serviceExists(serviceName)) break block59;
                initialServiceStatus = win32Service.queryNTServiceStatus(serviceName);
                if (initialServiceStatus != null) {
                    int firstState = initialServiceStatus.getCurrentState();
                    if (firstState == 1) {
                        return true;
                    }
                    if (firstState == 3) {
                        for (int j = 0; j <= 24; ++j) {
                            if (j == 24) {
                                return false;
                            }
                            initialServiceStatus = win32Service.queryNTServiceStatus(serviceName);
                            int interState = initialServiceStatus.getCurrentState();
                            if (interState != 1) {
                                try {
                                    Thread.sleep(5000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                continue;
                            }
                            return true;
                        }
                        break block59;
                    }
                    if (firstState == 2) {
                        int j = 0;
                        while (j <= 24) {
                            int interState;
                            if (j == 24 || (interState = (initialServiceStatus = win32Service.queryNTServiceStatus(serviceName)).getCurrentState()) == 4) break;
                            if (interState == 1) {
                                return true;
                            }
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ++j;
                        }
                        try {
                            serviceStatus = win32Service.controlNTService(serviceName, 1);
                        }
                        catch (ServiceException srvException) {
                            boolean stopped = false;
                            String errormsg = srvException.toString();
                            int errorcode = srvException.getErrorCode();
                            int i = 0;
                            int stay2 = 6;
                            do {
                                try {
                                    serviceStatus = win32Service.queryNTServiceStatus(serviceName);
                                    if (serviceStatus != null) {
                                        if (serviceStatus.getCurrentState() != 1) {
                                            try {
                                                Thread.sleep(20000L);
                                            }
                                            catch (InterruptedException interruptedException) {}
                                        } else {
                                            stopped = true;
                                        }
                                    }
                                }
                                catch (ServiceException srvEx) {
                                    try {
                                        Thread.sleep(20000L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                                if (!stopped) continue;
                                return true;
                            } while (++i < stay2);
                            throw new ServiceException(errorcode, errormsg);
                        }
                        for (int k = 0; k <= 24; ++k) {
                            if (k == 24) {
                                return false;
                            }
                            initialServiceStatus = win32Service.queryNTServiceStatus(serviceName);
                            int interState = initialServiceStatus.getCurrentState();
                            if (interState != 1) {
                                try {
                                    Thread.sleep(5000L);
                                }
                                catch (InterruptedException errormsg) {
                                    // empty catch block
                                }
                                continue;
                            }
                            return true;
                        }
                        break block59;
                    }
                    if (firstState != 4) break block59;
                    try {
                        serviceStatus = win32Service.controlNTService(serviceName, 1);
                    }
                    catch (ServiceException srvException) {
                        boolean stopped = false;
                        String errormsg = srvException.toString();
                        int errorcode = srvException.getErrorCode();
                        int i = 0;
                        int stay = 6;
                        do {
                            try {
                                serviceStatus = win32Service.queryNTServiceStatus(serviceName);
                                if (serviceStatus != null) {
                                    if (serviceStatus.getCurrentState() != 1) {
                                        try {
                                            Thread.sleep(20000L);
                                        }
                                        catch (InterruptedException stay2) {}
                                    } else {
                                        stopped = true;
                                    }
                                }
                            }
                            catch (ServiceException srvEx) {
                                try {
                                    Thread.sleep(20000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            if (!stopped) continue;
                            return true;
                        } while (++i < stay);
                        throw new ServiceException(errorcode, errormsg);
                    }
                    for (int k = 0; k <= 24; ++k) {
                        if (k == 24) {
                            return false;
                        }
                        initialServiceStatus = win32Service.queryNTServiceStatus(serviceName);
                        int interState = initialServiceStatus.getCurrentState();
                        if (interState != 1) {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException errormsg) {
                                // empty catch block
                            }
                            continue;
                        }
                        return true;
                    }
                    break block59;
                }
                return false;
            }
            catch (ServiceException serviceException) {
                boolean stopped = false;
                String errormsg = serviceException.toString();
                int errorcode = serviceException.getErrorCode();
                int i = 0;
                int stay = 6;
                do {
                    try {
                        serviceStatus = win32Service.queryNTServiceStatus(serviceName);
                        if (serviceStatus != null) {
                            if (serviceStatus.getCurrentState() != 1) {
                                try {
                                    Thread.sleep(20000L);
                                }
                                catch (InterruptedException srvEx) {}
                            } else {
                                stopped = true;
                            }
                        }
                    }
                    catch (ServiceException srvEx) {
                        try {
                            Thread.sleep(20000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (!stopped) continue;
                    return true;
                } while (++i < stay);
                throw new ServiceException(errorcode, errormsg);
            }
        }
        return true;
    }

    public String getServiceDescription(String serviceName) throws ServiceException {
        String name;
        if (serviceName == null) {
            return "";
        }
        String retVal = serviceName.toUpperCase();
        Win32Service win32Service = (Win32Service)this.wizardServices.getService("win32Service");
        if (win32Service.serviceExists(serviceName) && (name = win32Service.getNTServiceDisplayName(serviceName)) != null && name.length() > 0) {
            retVal = name;
        }
        return retVal;
    }

    public void changeNTSrvStartType(String srvName, int startType) throws ServiceException {
        NTServiceConfig currentNTSrvConf;
        Win32Service win32Service = (Win32Service)this.wizardServices.getService("win32Service");
        if (win32Service.serviceExists(srvName) && (currentNTSrvConf = win32Service.queryNTServiceConfig(srvName)) != null) {
            currentNTSrvConf.setStartType(startType);
            win32Service.changeNTServiceConfig(srvName, currentNTSrvConf);
        }
    }

    public int getNTSrvStartType(String srvName) throws ServiceException {
        NTServiceConfig currentNTSrvConf;
        Win32Service win32Service = (Win32Service)this.wizardServices.getService("win32Service");
        int retval = -123456;
        if (win32Service.serviceExists(srvName) && (currentNTSrvConf = win32Service.queryNTServiceConfig(srvName)) != null) {
            retval = currentNTSrvConf.getStartType();
        }
        return retval;
    }

    public String getNTSrvUser(String srvName) throws ServiceException {
        NTServiceConfig currentNTSrvConf;
        Win32Service win32Service = (Win32Service)this.wizardServices.getService("win32Service");
        String retval = null;
        if (win32Service.serviceExists(srvName) && (currentNTSrvConf = win32Service.queryNTServiceConfig(srvName)) != null) {
            retval = currentNTSrvConf.getUserName();
        }
        return retval;
    }

    public int installWASService(String serviceName, String serverName, String wasHome, String configRoot, String startArgs, String userID, String password, String logFile, boolean restart, boolean useDefaultConfiguration, int verbose) throws ServiceException, IOException {
        String logRoot;
        String logsDir;
        String servicePath = FileUtils.createFileName(wasHome, "bin/wasservice.exe");
        if (this.isServiceInstalled(serviceName)) {
            return 0;
        }
        if (verbose != 0) {
            verbose = 1;
        }
        StringBuffer installCommand = new StringBuffer();
        installCommand.append(String.valueOf(ICAStringUtils.quoteOrUnquote(servicePath)) + " ");
        if (serviceName != null) {
            installCommand.append(" -add ");
            installCommand.append(ICAStringUtils.quote(serviceName));
        }
        if (serverName == null) {
            serverName = "server1";
        }
        installCommand.append(" -serverName ");
        installCommand.append(serverName);
        if (startArgs != null && startArgs.length() > 0) {
            installCommand.append(" -startArgs ");
            installCommand.append(startArgs);
        }
        if (userID != null && password != null) {
            installCommand.append(" -userid ");
            installCommand.append(userID);
            installCommand.append(" -password ");
            installCommand.append(password);
        }
        if (!useDefaultConfiguration) {
            if (logFile != null && logFile.length() > 0) {
                installCommand.append(" -logFile ");
                logsDir = FileUtils.createFileName(W32ServiceUtils.getShortPath(wasHome), "logs");
                logFile = FileUtils.createFileName(logsDir, logFile);
                installCommand.append(ICAStringUtils.quoteOrUnquote(logFile));
            }
            installCommand.append(" -logRoot ");
            logsDir = FileUtils.createFileName(W32ServiceUtils.getShortPath(wasHome), "logs");
            logRoot = FileUtils.createFileName(logsDir, serverName);
            installCommand.append(ICAStringUtils.quoteOrUnquote(logRoot));
        } else {
            installCommand.append(" -logRoot ");
            logsDir = FileUtils.createFileName(wasHome, "logs");
            logRoot = FileUtils.createFileName(logsDir, serverName);
            installCommand.append(ICAStringUtils.quoteOrUnquote(logRoot));
        }
        if (restart) {
            installCommand.append(" -restart ");
            installCommand.append(new Boolean(restart).toString());
        }
        if (verbose == 1) {
            String msg = ShowMessage.gi("Ins").resolve("ICAInstall.ExecCmd", new String[]{installCommand.toString().trim()}, null);
            ShowMessage.writeLogOutput(msg);
        }
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        ProcUtl proc = new ProcUtl();
        int rc = 0;
        rc = proc.execcmd(installCommand.toString().trim(), true, null, (Object)stdout, (Object)stderr);
        if (rc != 0) {
            if (verbose == 1) {
                String msg = ShowMessage.gi("Ins").resolve("ICAInstall.CmdRc", new String[]{String.valueOf(rc)}, null);
                ShowMessage.writeLogOutput(msg);
            }
            throw new CmdException(rc, installCommand.toString().trim(), new String[]{stderr == null ? null : stderr.toString()});
        }
        if (verbose == 1) {
            String msg = ShowMessage.gi("Ins").resolve("ICAInstall.CmdRc", new String[]{String.valueOf(rc)}, null);
            ShowMessage.writeLogOutput(msg);
        }
        return rc;
    }

    public int installWASService(String serviceName, String serverName, String wasHome, String configRoot, String startArgs, String userID, String password, String logFile, boolean restart, int verbose) throws ServiceException, IOException {
        return this.installWASService(serviceName, serverName, wasHome, configRoot, startArgs, userID, password, logFile, restart, true, verbose);
    }

    public int installWAS6Service(String wasServicePath, String serviceName, String serverName, String profilePath, String wasHome, String configRoot, String startArgs, String stopArgs, String userID, String password, String logFile, String logRoot, boolean restart, String startupType, int verbose) throws ServiceException, IOException {
        if (verbose != 0) {
            verbose = 1;
        }
        StringBuffer installCommand = new StringBuffer();
        installCommand.append(String.valueOf(ICAStringUtils.quoteOrUnquote(wasServicePath)) + " ");
        if (serviceName != null) {
            installCommand.append(" -add ");
            installCommand.append(ICAStringUtils.quote(serviceName));
        }
        if (serverName == null) {
            serverName = "server1";
        }
        installCommand.append(" -serverName ");
        installCommand.append(serverName);
        installCommand.append(" -profilePath ");
        installCommand.append(ICAStringUtils.quoteOrUnquote(profilePath));
        if (wasHome != null && wasHome.trim().length() > 0) {
            installCommand.append("-wasHome");
            installCommand.append(wasHome);
        }
        if (startArgs != null && startArgs.trim().length() > 0) {
            installCommand.append(" -startArgs ");
            installCommand.append(startArgs);
        }
        if (stopArgs != null && stopArgs.trim().length() > 0) {
            installCommand.append(" -stopArgs ");
            installCommand.append(stopArgs);
        }
        if (userID != null && password != null) {
            installCommand.append(" -userid ");
            installCommand.append(userID);
            installCommand.append(" -password ");
            installCommand.append(password);
        }
        if (logFile != null && logFile.trim().length() > 0) {
            installCommand.append(" -logFile ");
            logFile = W32ServiceUtils.getShortPath(logFile);
            installCommand.append(ICAStringUtils.quoteOrUnquote(logFile));
        }
        if (logRoot != null && logRoot.trim().length() > 0) {
            installCommand.append(" -logRoot ");
            logRoot = W32ServiceUtils.getShortPath(logRoot);
            installCommand.append(ICAStringUtils.quoteOrUnquote(logRoot));
        }
        if (restart) {
            installCommand.append(" -restart ");
            installCommand.append(new Boolean(restart).toString());
        }
        if (startupType == null) {
            startupType = "automatic";
        }
        installCommand.append(" -startType ");
        installCommand.append(startupType);
        if (verbose == 1) {
            String msg = ShowMessage.gi("Ins").resolve("ICAInstall.ExecCmd", new String[]{installCommand.toString().trim()}, null);
            ShowMessage.writeLogOutput(msg);
        }
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        ProcUtl proc = new ProcUtl();
        int rc = 0;
        rc = proc.execcmd(installCommand.toString().trim(), true, null, (Object)stdout, (Object)stderr);
        if (rc != 0) {
            if (verbose == 1) {
                String msg = ShowMessage.gi("Ins").resolve("ICAInstall.CmdRc", new String[]{String.valueOf(rc)}, null);
                ShowMessage.writeLogOutput(msg);
            }
            throw new CmdException(rc, installCommand.toString().trim(), new String[]{stderr == null ? null : stderr.toString()});
        }
        if (verbose == 1) {
            String msg = ShowMessage.gi("Ins").resolve("ICAInstall.CmdRc", new String[]{String.valueOf(rc)}, null);
            ShowMessage.writeLogOutput(msg);
        }
        return rc;
    }

    public Hashtable getWASInstalledServices(String serverName) throws ServiceException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        String servicesKey = "SYSTEM\\CurrentControlSet\\Services";
        String wasStandardName = "IBMWAS5Service";
        int hive = 4;
        Win32RegistryService regService = (Win32RegistryService)this.wizardServices.getService("win32RegistryService");
        String[] serviceNames = null;
        if (regService.keyExists(hive, servicesKey) && (serviceNames = regService.getSubkeyNames(hive, servicesKey)) != null) {
            int i = 0;
            while (i < serviceNames.length) {
                String imagePath;
                String name;
                String parametersKey;
                if (serviceNames[i].startsWith(wasStandardName) && regService.keyExists(hive, parametersKey = String.valueOf(servicesKey) + "\\" + serviceNames[i] + "\\" + "Parameters") && (name = regService.getStringValue(hive, parametersKey, "ServerName", false)) != null && name.equals(serverName) && !table.contains(serviceNames[i]) && this.isServiceInstalled(serviceNames[i]) && (imagePath = regService.getStringValue(hive, String.valueOf(servicesKey) + "\\" + serviceNames[i], "ImagePath", false)) != null) {
                    table.put(serviceNames[i], imagePath);
                }
                ++i;
            }
        }
        return table;
    }

    public int uninstallService(WizardServices wizardServices, String serviceName, boolean askRebootIfUninstallFailed) throws ServiceException {
        Win32Service win32Service = (Win32Service)wizardServices.getService("win32Service");
        int rc = 0;
        if (win32Service.serviceExists(serviceName)) {
            if (this.isServiceRunning(serviceName)) {
                this.stopService(serviceName);
            }
            win32Service.deleteNTService(serviceName);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (win32Service.serviceExists(serviceName)) {
                NTServiceConfig srvConfig = win32Service.queryNTServiceConfig(serviceName);
                if (srvConfig != null && srvConfig.getStartType() == 4 && askRebootIfUninstallFailed) {
                    SystemUtilService sus = (SystemUtilService)wizardServices.getService("systemUtilService");
                    sus.setRebootRequired(true);
                }
                rc = 1;
            }
        }
        return rc;
    }

    public int startService(String serviceName, String startupScript, int verbose, ActionTimeBasedPercentEstimator estimator) throws CmdException, IOException, ServiceException {
        if (verbose > 0) {
            verbose = 1;
        }
        if (estimator != null) {
            estimator.updateOperationState();
        }
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        ProcUtl proc = new ProcUtl();
        String serviceStartCmd = "net start " + ICAStringUtils.quote(serviceName);
        if (verbose == 1) {
            String msg = ShowMessage.gi("Ins").resolve("ICAInstall.ExecCmd", new String[]{serviceStartCmd}, null);
            ShowMessage.writeLogOutput(msg);
        }
        int rc = proc.system(serviceStartCmd, false, null, stdout, stderr);
        if (estimator != null) {
            while (proc.isProcessRunning()) {
                estimator.updateOperationState();
                estimator.sleep();
            }
            estimator.updateOperationState();
        }
        if ((rc = proc.waitForProcess()) != 0) {
            throw new CmdException(rc, serviceStartCmd, stderr.toString().trim());
        }
        if (verbose == 1) {
            String msg = ShowMessage.gi("Ins").resolve("ICAInstall.CmdRc", new String[]{String.valueOf(rc)}, null);
            ShowMessage.writeLogOutput(msg);
        }
        if (estimator != null) {
            estimator.updateOperationState();
        }
        return rc;
    }

    public int startService(String servicename, int verbose, ActionTimeBasedPercentEstimator estimator) throws CmdException, IOException, ServiceException {
        return this.startService(servicename, null, verbose, estimator);
    }

    public String getServiceInstallCommand(String service) throws ServiceException {
        NTServiceConfig ntsrvcfg;
        String srvInstLoc = "";
        Win32Service win32Service = (Win32Service)this.wizardServices.getService("win32Service");
        if (win32Service.serviceExists(service) && (ntsrvcfg = win32Service.queryNTServiceConfig(service)) != null) {
            srvInstLoc = ntsrvcfg.getCommand();
        }
        return srvInstLoc;
    }

    public int installService(String exeAbsolutePath, String serviceName, String args, String[] env, int verbose, boolean ignoreRc) throws IOException, CmdException {
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        String cmd = null;
        cmd = args != null && args.length() > 0 ? String.valueOf(ICAStringUtils.quoteOrUnquote(exeAbsolutePath)) + " -install " + args : String.valueOf(ICAStringUtils.quoteOrUnquote(exeAbsolutePath)) + " -install";
        ProcUtl proc = new ProcUtl();
        if (verbose > 0) {
            String msg = ShowMessage.gi("Ins").resolve("ICAInstall.ExecCmd", new String[]{cmd}, null);
            ShowMessage.writeLogOutput(msg);
        }
        int rc = -1;
        rc = env == null || env.length == 0 ? proc.execcmd(cmd, true, null, (Object)stdout, (Object)stderr) : proc.execcmd(cmd, env, true, null, (Object)stdout, (Object)stderr);
        if (!ignoreRc && rc != 0) {
            throw new CmdException(rc, cmd, stderr == null ? null : stderr.toString());
        }
        return rc;
    }

    public int installService(String exeAbsolutePath, String serviceName, String args, int verbose, boolean ignoreRc) throws IOException, CmdException {
        return this.installService(exeAbsolutePath, serviceName, args, null, verbose, ignoreRc);
    }

    public int installService(String exeAbsolutePath, String serviceName, String args, int verbose) throws IOException, CmdException {
        return this.installService(exeAbsolutePath, serviceName, args, null, verbose, false);
    }
}

