/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.ConstResourceBundle;
import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ShowMessage;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.service.ServiceException;

public class W32RegistryUtils {
    public static void createW2KIBMRootRegistryKey(String parentKey, String keyName) {
        W32RegistryUtils.createW2KRegistryKey(parentKey, keyName, null, null, false);
    }

    public static void createRegistryKey(String parentKey, String keyName, String[] vrmf, String installLocation) {
        Win32RegistryService winService = null;
        try {
            winService = (Win32RegistryService)ICAInstGlobals.getService("win32RegistryService");
            if (!winService.keyExists(4, String.valueOf(parentKey) + "\\" + keyName)) {
                winService.createKey(4, parentKey, keyName);
            }
            String currentKey = String.valueOf(parentKey) + "\\" + keyName;
            String currentVersionKey = null;
            String[] currentVRMFEntries = null;
            if (vrmf != null) {
                currentVersionKey = "CurrentVersion";
                if (winService.keyExists(4, currentVersionKey)) {
                    winService.deleteKey(4, currentKey, currentVersionKey, false);
                }
                winService.createKey(4, currentKey, currentVersionKey);
                currentVRMFEntries = new String[]{"Version", "Release", "Modification", "Service Level"};
                if (winService.keyExists(4, String.valueOf(currentKey) + "\\" + currentVersionKey)) {
                    int i = 0;
                    while (i < currentVRMFEntries.length) {
                        winService.setStringValue(4, String.valueOf(currentKey) + "\\" + currentVersionKey, currentVRMFEntries[i], false, vrmf[i]);
                        ++i;
                    }
                }
            }
            if (installLocation != null) {
                String installLocationEntry = "InstallLocation";
                if (winService.keyExists(4, currentKey)) {
                    winService.setStringValue(4, currentKey, installLocationEntry, false, installLocation);
                }
            }
        }
        catch (ServiceException se) {
            ShowMessage.writeLogOutput(se.toString());
        }
    }

    public static boolean createW2KRegistryKey(String parentKey, String keyName, String[] vrmf, String installLocation, boolean deleteOldKeyIfExists) {
        Win32RegistryService winService = null;
        try {
            winService = (Win32RegistryService)ICAInstGlobals.getService("win32RegistryService");
            if (!winService.keyExists(4, parentKey)) {
                throw new ServiceException(2, ShowMessage.gi("ICAIns").resolve("W32ICARegistryUpdate.parentKeyDoesNotExists", new String[]{parentKey, keyName}, null));
            }
            String currentKey = String.valueOf(parentKey) + "\\" + keyName;
            if (deleteOldKeyIfExists && winService.keyExists(4, currentKey)) {
                W32RegistryUtils.deleteRegistryKey(parentKey, keyName);
            }
            W32RegistryUtils.createRegistryKey(parentKey, keyName, vrmf, installLocation);
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput("wrn", serviceException.toString());
            return false;
        }
        return true;
    }

    public static void deleteRegistryKey(String parentKey, String key, boolean ifEmpty) {
        try {
            Win32RegistryService winService = (Win32RegistryService)ICAInstGlobals.getService("win32RegistryService");
            if (winService.keyExists(4, String.valueOf(parentKey) + "\\" + key)) {
                if (ifEmpty) {
                    int i;
                    String[] subkeys = winService.getSubkeyNames(4, String.valueOf(parentKey) + "\\" + key);
                    if (subkeys != null && ((i = subkeys.length) == 0 || i == 1 && subkeys[0].equals("CurrentVersion"))) {
                        winService.deleteKey(4, parentKey, key, false);
                    }
                } else {
                    winService.deleteKey(4, parentKey, key, false);
                }
            }
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput(serviceException.toString());
        }
    }

    public static void deleteRegistryKey(String parentKey, String key) {
        W32RegistryUtils.deleteRegistryKey(parentKey, key, false);
    }

    public static boolean updateUninstallerRegistryKey(String prodKey, String uninstDisplayName) {
        ConstResourceBundle bundle = (ConstResourceBundle)ICAInstGlobals.getValue("ResourceBundleReference");
        String uninstRegKey = bundle.getString("uninstallerRegistryKey");
        if (!uninstRegKey.endsWith("\\")) {
            uninstRegKey = String.valueOf(uninstRegKey) + "\\";
        }
        try {
            Win32RegistryService winService = (Win32RegistryService)ICAInstGlobals.getService("win32RegistryService");
            if (!winService.keyExists(4, String.valueOf(uninstRegKey) + prodKey)) {
                winService.createKey(4, uninstRegKey, prodKey);
            }
            winService.setStringValue(4, String.valueOf(uninstRegKey) + prodKey, "DisplayName", false, uninstDisplayName);
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput("wrn", serviceException.toString());
            return false;
        }
        return true;
    }

    public static boolean updateProductValueName(String prodKey, String valueName, String parameter) {
        ConstResourceBundle bundle = (ConstResourceBundle)ICAInstGlobals.getValue("ResourceBundleReference");
        String uninstRegKey = bundle.getString("uninstallerRegistryKey");
        if (!uninstRegKey.endsWith("\\")) {
            uninstRegKey = String.valueOf(uninstRegKey) + "\\";
        }
        try {
            String valueData;
            Win32RegistryService winService = (Win32RegistryService)ICAInstGlobals.getService("win32RegistryService");
            if (winService.keyExists(4, String.valueOf(uninstRegKey) + prodKey) && winService.valueExists(4, String.valueOf(uninstRegKey) + prodKey, valueName) && (valueData = winService.getStringValue(4, String.valueOf(uninstRegKey) + prodKey, valueName, false)) != null && valueData.indexOf(parameter) == -1) {
                valueData = String.valueOf(valueData) + " ";
                valueData = String.valueOf(valueData) + parameter;
                winService.setStringValue(4, String.valueOf(uninstRegKey) + prodKey, valueName, false, valueData);
            }
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput("wrn", serviceException.toString());
            return false;
        }
        return true;
    }

    public static int checkW2KPatchInstallation(String patchID, String servicePackRequired) {
        int rc;
        block9: {
            rc = 1;
            String osID = "Windows 2000";
            if (ICAStringUtils.isWindowsXP()) {
                osID = "Windows XP";
            } else if (ICAStringUtils.isWindows2003()) {
                osID = "Windows 2003";
            }
            String updateKey = "SOFTWARE\\Microsoft\\Updates\\" + osID;
            try {
                Win32RegistryService winService = (Win32RegistryService)ICAInstGlobals.getService("win32RegistryService");
                if (servicePackRequired != null && servicePackRequired.length() > 0) {
                    if (winService.keyExists(4, updateKey = String.valueOf(updateKey) + "\\" + servicePackRequired) && winService.keyExists(4, updateKey = String.valueOf(updateKey) + "\\" + patchID)) {
                        rc = 0;
                    }
                    break block9;
                }
                if (!winService.keyExists(4, updateKey)) break block9;
                String[] subkeys = winService.getSubkeyNames(4, updateKey);
                int i = 0;
                while (i < subkeys.length) {
                    String currentKey = String.valueOf(updateKey) + "\\" + subkeys[i];
                    if (winService.keyExists(4, currentKey) && winService.keyExists(4, String.valueOf(currentKey) + "\\" + patchID)) {
                        rc = 0;
                        break;
                    }
                    ++i;
                }
            }
            catch (ServiceException serviceException) {
                ShowMessage.writeLogOutput("wrn", serviceException.toString());
                return -1;
            }
        }
        return rc;
    }

    public static boolean valueExists(int hive, String keyName, String valueName) throws ServiceException {
        Win32RegistryService winService;
        if (hive == -12344) {
            hive = 4;
        }
        return (winService = (Win32RegistryService)ICAInstGlobals.getService("win32RegistryService")).keyExists(hive, keyName) && winService.valueExists(hive, keyName, valueName);
    }

    public static boolean valueExists(String keyName, String valueName) throws ServiceException {
        return W32RegistryUtils.valueExists(-12344, keyName, valueName);
    }
}

