/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.ProcessesUtl;
import com.ibm.itcins.ica2.SLPActions;
import com.ibm.itcins.ica2.exceptions.CmdException;
import com.installshield.util.FileUtils;
import com.installshield.wizard.service.ServiceException;
import java.io.IOException;

public class W32SLPActions
extends SLPActions {
    public boolean isSLPInstalled(String serviceName) throws ServiceException {
        ProcessesUtl utl = ProcessesUtl.instantiate(this.wizardServices);
        if (serviceName == null || serviceName.trim().length() == 0) {
            serviceName = "slpd";
        }
        return utl.isServiceInstalled(serviceName);
    }

    public boolean isSLPInstalled() throws ServiceException {
        return this.isSLPInstalled(null);
    }

    public String getSLPInstallPath(String serviceName) throws ServiceException {
        String installPath = "";
        ProcessesUtl utl = ProcessesUtl.instantiate(this.wizardServices);
        if (serviceName == null || serviceName.trim().length() == 0) {
            serviceName = "slpd";
        }
        if (this.isSLPInstalled()) {
            installPath = utl.getServiceInstallCommand(serviceName);
        }
        return installPath;
    }

    public String getSLPInstallPath() throws ServiceException {
        return this.getSLPInstallPath(null);
    }

    public boolean installSLP(String serviceAbsolutePath, String serviceName, int serviceStartupType, String librariesDirectory, String confFileAbsolutePath, String regFileAbsolutePath, String serviceDisplayName) throws ServiceException, CmdException, IOException {
        ProcessesUtl utl = ProcessesUtl.instantiate(this.wizardServices);
        utl.installService(serviceAbsolutePath, serviceName, null, 1, true);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return utl.isServiceInstalled(serviceName);
    }

    public boolean uninstallSLP(String serviceName, String librariesDirectory, String confFileAbsolutePath, String regFileAbsolutePath, String serviceDisplayName, boolean stopService, String serviceAbsolutePath) throws CmdException, ServiceException, IOException {
        ProcessesUtl utl = ProcessesUtl.instantiate(this.wizardServices);
        if (utl.isServiceInstalled(serviceName)) {
            if (utl.isServiceRunning(serviceName)) {
                utl.stopService(serviceName);
            }
            utl.uninstallService(this.wizardServices, serviceName, true);
        }
        return true;
    }

    public boolean isSLPActiveAsService(String productinstallLocation, String serviceName) throws ServiceException {
        String serviceInstallationPath = this.getSLPInstallPath(serviceName);
        serviceInstallationPath = FileUtils.canonizePath(serviceInstallationPath);
        return (productinstallLocation = FileUtils.canonizePath(productinstallLocation)).regionMatches(true, 0, serviceInstallationPath, 0, serviceInstallationPath.length()) || serviceInstallationPath.regionMatches(true, 0, productinstallLocation, 0, productinstallLocation.length());
    }

    public boolean isSLPRunning(String serviceName) throws IOException, ServiceException {
        ProcessesUtl utl = ProcessesUtl.instantiate(this.wizardServices);
        if (serviceName == null || serviceName.trim().length() == 0) {
            serviceName = "slpd";
        }
        return utl.isServiceRunning(serviceName);
    }

    public boolean stopSLPService(String serviceName) throws IOException, ServiceException {
        ProcessesUtl utl = ProcessesUtl.instantiate(this.wizardServices);
        if (serviceName == null || serviceName.trim().length() == 0) {
            serviceName = "slpd";
        }
        return utl.stopService(serviceName);
    }
}

