/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica1.W32ICATNativeLib;
import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.Utl;
import com.ibm.itcins.ica2.exceptions.CmdException;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class W32Utl
extends Utl {
    public static long MAX_TIME_LOCKED_FILES = 10000L;
    private long initialTime = 0L;

    public boolean existUser(String user) throws IOException, CmdException {
        return false;
    }

    public String getSystemDrive() {
        String fs = System.getProperty("file.separator");
        String drive = ICAInstGlobals.getServices().resolveString("$D(os_main)");
        int poz = drive.indexOf(fs, 0);
        return drive.substring(0, poz);
    }

    public String getCurrentUserHome() {
        String home = String.valueOf(ICAInstGlobals.getServices().resolveString("$D(home)")) + "\\Start Menu\\Programs\\";
        return home;
    }

    public String programsMenuContext() {
        return String.valueOf(this.getSystemDrive()) + "\\Documents and Settings\\All Users\\Start Menu\\Programs\\";
    }

    public String desktop() {
        return String.valueOf(this.getSystemDrive()) + "\\Documents and Settings\\All Users\\Desktop\\";
    }

    public String getCommonFolder() {
        return ICAInstGlobals.getServices().resolveString("$D(common)");
    }

    public String[] getFilesInUse(String[] dirsToCheck, String[] dirsToExclude, String[] fileextensions) {
        String[] retValue;
        int ii = 0;
        Hashtable tmpHashRetValue = new Hashtable();
        Vector tmpVectorRetValue = new Vector();
        this.initialTime = System.currentTimeMillis();
        if (dirsToCheck == null || dirsToCheck.length == 0) {
            dirsToCheck = new String[]{};
        }
        if (dirsToExclude == null) {
            dirsToExclude = new String[]{};
        }
        if (fileextensions == null) {
            fileextensions = new String[]{};
        }
        ii = 0;
        while (ii < dirsToCheck.length) {
            if (dirsToCheck[ii] != null && dirsToCheck[ii].trim().length() != 0) {
                File d = new File(dirsToCheck[ii].trim());
                String tempDirName = d.getAbsolutePath();
                if ((d = new File(tempDirName)).exists()) {
                    this.getFilesInUseInDir(d.getPath(), dirsToExclude, fileextensions, tmpHashRetValue);
                }
            }
            ++ii;
        }
        if (fileextensions.length > 0) {
            ii = 0;
            while (ii < fileextensions.length) {
                if (tmpHashRetValue.get(fileextensions[ii]) != null) {
                    tmpVectorRetValue.addAll((Vector)tmpHashRetValue.get(fileextensions[ii]));
                }
                ++ii;
            }
        } else {
            if (tmpHashRetValue.get("exe") != null) {
                tmpVectorRetValue.addAll((Vector)tmpHashRetValue.get("exe"));
            }
            if (tmpHashRetValue.get("dll") != null) {
                tmpVectorRetValue.addAll((Vector)tmpHashRetValue.get("dll"));
            }
            if (tmpHashRetValue.get("jar") != null) {
                tmpVectorRetValue.addAll((Vector)tmpHashRetValue.get("jar"));
            }
            if (tmpHashRetValue.get("zip") != null) {
                tmpVectorRetValue.addAll((Vector)tmpHashRetValue.get("zip"));
            }
            if (tmpHashRetValue.get("class") != null) {
                tmpVectorRetValue.addAll((Vector)tmpHashRetValue.get("class"));
            }
            Enumeration extensions = tmpHashRetValue.keys();
            while (extensions.hasMoreElements()) {
                String extension = (String)extensions.nextElement();
                if (extension.equals("exe") || extension.equals("dll") || extension.equals("jar") || extension.equals("zip") || extension.equals("class") || tmpHashRetValue.get(extension) == null) continue;
                tmpVectorRetValue.addAll((Vector)tmpHashRetValue.get(extension));
            }
        }
        if (tmpVectorRetValue.size() == 0) {
            retValue = new String[]{};
        } else {
            retValue = new String[tmpVectorRetValue.size()];
            ii = 0;
            Enumeration elements = tmpVectorRetValue.elements();
            while (elements.hasMoreElements()) {
                retValue[ii] = (String)elements.nextElement();
                ++ii;
            }
        }
        return retValue;
    }

    private void getFilesInUseInDir(String dirOrFile, String[] dirsToExclude, String[] fileextensions, Hashtable filesInUse) {
        boolean rightextension = false;
        boolean excludedDir = false;
        W32ICATNativeLib ntl = new W32ICATNativeLib();
        long currentTime = 0L;
        long timeToWait = 0L;
        int ii = 0;
        int jj = 0;
        if (fileextensions == null) {
            fileextensions = new String[]{};
        }
        if (dirsToExclude == null) {
            dirsToExclude = new String[]{};
        }
        if (dirOrFile == null || dirOrFile.trim().length() == 0 || filesInUse == null) {
            return;
        }
        File d = new File(dirOrFile.trim());
        dirOrFile = d.getAbsolutePath();
        if (!(d = new File(dirOrFile)).exists()) {
            return;
        }
        if (!d.isDirectory()) {
            rightextension = fileextensions.length == 0;
            ii = 0;
            while (ii < fileextensions.length) {
                if (fileextensions[ii].equals("noextension")) {
                    if (W32Utl.getExtDotIndex(d.getName()) == -1) {
                        rightextension = true;
                        break;
                    }
                } else if (d.getName().endsWith("." + fileextensions[ii])) {
                    rightextension = true;
                    break;
                }
                ++ii;
            }
            if (rightextension && ntl.checkFileInUse(d.getPath()) && this.initialTime > 0L) {
                currentTime = System.currentTimeMillis();
                if (currentTime < this.initialTime + MAX_TIME_LOCKED_FILES) {
                    timeToWait = this.initialTime + MAX_TIME_LOCKED_FILES - currentTime;
                    if (timeToWait > MAX_TIME_LOCKED_FILES) {
                        timeToWait = MAX_TIME_LOCKED_FILES;
                    }
                    try {
                        Thread.sleep(timeToWait);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.initialTime = 0L;
            }
            if (rightextension && ntl.checkFileInUse(d.getPath())) {
                int extDotIndex = W32Utl.getExtDotIndex(d.getName());
                if (extDotIndex == -1) {
                    if (filesInUse.get("noextension") == null) {
                        filesInUse.put("noextension", new Vector());
                    }
                    ((Vector)filesInUse.get("noextension")).add(d.getPath());
                } else {
                    String extension = d.getName().substring(extDotIndex + 1, d.getName().length());
                    if (filesInUse.get(extension) == null) {
                        filesInUse.put(extension, new Vector());
                    }
                    ((Vector)filesInUse.get(extension)).add(d.getPath());
                }
            }
        } else {
            String[] subdirs = d.list();
            if (subdirs != null && subdirs.length > 0) {
                int dirIdx = 0;
                while (dirIdx < subdirs.length) {
                    File f = new File(d, subdirs[dirIdx]);
                    if (f.isDirectory()) {
                        excludedDir = false;
                        jj = 0;
                        while (jj < dirsToExclude.length) {
                            excludedDir = dirsToExclude[jj].trim().equals(subdirs[dirIdx]);
                            if (excludedDir) break;
                            ++jj;
                        }
                        if (!excludedDir) {
                            this.getFilesInUseInDir(f.getPath(), dirsToExclude, fileextensions, filesInUse);
                        }
                    } else {
                        rightextension = fileextensions.length == 0;
                        ii = 0;
                        while (ii < fileextensions.length) {
                            if (fileextensions[ii].equals("noextension")) {
                                if (W32Utl.getExtDotIndex(f.getName()) == -1) {
                                    rightextension = true;
                                    break;
                                }
                            } else if (f.getPath().endsWith("." + fileextensions[ii])) {
                                rightextension = true;
                                break;
                            }
                            ++ii;
                        }
                        if (rightextension && ntl.checkFileInUse(d.getPath()) && this.initialTime > 0L) {
                            currentTime = System.currentTimeMillis();
                            if (currentTime < this.initialTime + MAX_TIME_LOCKED_FILES) {
                                timeToWait = this.initialTime + MAX_TIME_LOCKED_FILES - currentTime;
                                if (timeToWait > MAX_TIME_LOCKED_FILES) {
                                    timeToWait = MAX_TIME_LOCKED_FILES;
                                }
                                try {
                                    Thread.sleep(timeToWait);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            this.initialTime = 0L;
                        }
                        if (rightextension && ntl.checkFileInUse(f.getPath())) {
                            int extDotIndex = W32Utl.getExtDotIndex(f.getName());
                            if (extDotIndex == -1) {
                                if (filesInUse.get("noextension") == null) {
                                    filesInUse.put("noextension", new Vector());
                                }
                                ((Vector)filesInUse.get("noextension")).add(f.getPath());
                            } else {
                                String extension = f.getName().substring(extDotIndex + 1, f.getName().length());
                                if (filesInUse.get(extension) == null) {
                                    filesInUse.put(extension, new Vector());
                                }
                                ((Vector)filesInUse.get(extension)).add(f.getPath());
                            }
                        }
                    }
                    ++dirIdx;
                }
            }
        }
    }

    public static int getExtDotIndex(String fileName) {
        int lastDotIndex = fileName.lastIndexOf(".");
        int extDotIndex = -1;
        if (lastDotIndex > 0) {
            if (lastDotIndex == fileName.length() - 1) {
                if ((lastDotIndex = fileName.lastIndexOf(".", lastDotIndex - 1)) > 0) {
                    extDotIndex = lastDotIndex;
                }
            } else {
                extDotIndex = lastDotIndex;
            }
        }
        return extDotIndex;
    }

    public String getUserHome(String userName) throws IOException {
        return "";
    }

    public static int getW2kServiceLevel() throws ServiceException {
        int returnLevel = -1;
        SystemUtilService sus = (SystemUtilService)ICAInstGlobals.getService("systemUtilService");
        String serviceLevel = sus.getOSServiceLevel();
        if (serviceLevel != null && serviceLevel.length() > 0) {
            StringTokenizer token = new StringTokenizer(serviceLevel, " ");
            while (token.hasMoreElements()) {
                String nextToken = (String)token.nextElement();
                try {
                    int i;
                    returnLevel = i = Integer.parseInt(nextToken);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        } else {
            returnLevel = 0;
        }
        return returnLevel;
    }
}

