/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.ActionTimeBasedPercentEstimator;
import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ProcessesUtl;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.WASUtl;
import com.ibm.itcins.ica2.exceptions.CmdException;
import com.installshield.util.FileUtils;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.platform.win32.Win32Service;
import com.installshield.wizard.platform.win32.win32service.NTServiceConfig;
import com.installshield.wizard.service.ServiceException;
import java.io.IOException;
import java.util.Vector;

public class W32WASUtl
extends WASUtl {
    public static final String wasprefixservicename = "IBMWAS5Service";
    public static final String CURRENTCONTROLSETKEY = "SYSTEM\\CurrentControlSet\\Services";

    public int getWASServerStatus(String wasInstallLocation, String server, String serviceName, String userName, String password, ActionTimeBasedPercentEstimator estimator, int verbose, int quotepassword) throws ServiceException, CmdException, IOException {
        int rc = -1;
        String srvName = W32WASUtl.getWASServiceName(serviceName);
        ProcessesUtl utl = ProcessesUtl.instantiate(this.wizardServices);
        if (serviceName != null && serviceName.length() > 0 && utl.srvExistsAndRuns(srvName)) {
            String msg = ShowMessage.gi(null).resolve("Install.ServiceAlreadyRunning", new String[]{srvName}, null);
            ShowMessage.writeLogOutput(msg);
            rc = 1;
        } else {
            rc = super.getWASServerStatus(wasInstallLocation, server, null, userName, password, estimator, verbose, quotepassword);
        }
        return rc;
    }

    public int getWASServerStatus(String wasInstallLocation, String server, String serviceName, String userName, String password, ActionTimeBasedPercentEstimator estimator, int verbose) throws ServiceException, CmdException, IOException {
        return this.getWASServerStatus(wasInstallLocation, server, serviceName, userName, password, estimator, verbose, 0);
    }

    public static String getWASServiceName(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (!name.startsWith(wasprefixservicename)) {
            name = "IBMWAS5Service - " + name;
        }
        return name;
    }

    public int startWASServer(String wasInstallationPath, String serverID, String serviceName, ActionTimeBasedPercentEstimator estimator, int verbose, boolean startServerIfServiceFailed) throws IOException, ServiceException {
        String srvName = W32WASUtl.getWASServiceName(serviceName);
        ProcessesUtl utl = ProcessesUtl.instantiate(this.wizardServices);
        if (serviceName != null && serviceName.length() > 0 && utl.isServiceInstalled(srvName)) {
            int started = 0;
            if (!utl.isServiceRunning(srvName)) {
                started = utl.startService(srvName, verbose, estimator);
            }
            if (started != 0 && startServerIfServiceFailed) {
                return super.startWASServer(wasInstallationPath, serverID, serviceName, estimator, verbose, false);
            }
            return started;
        }
        return super.startWASServer(wasInstallationPath, serverID, serviceName, estimator, verbose, false);
    }

    public int stopWASServer(String wasInstallationPath, String serverID, String serviceName, String userName, String password, ActionTimeBasedPercentEstimator estimator, int verbose, boolean stopServerIfServiceFailed, int quotepassword) throws ServiceException, IOException {
        int rc = -1;
        String srvName = W32WASUtl.getWASServiceName(serviceName);
        ProcessesUtl utl = ProcessesUtl.instantiate(this.wizardServices);
        if (serviceName != null && serviceName.length() > 0 && utl.srvExistsAndRuns(srvName)) {
            boolean stopped = utl.stopService(srvName);
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!stopped && stopServerIfServiceFailed) {
                int wasRc = super.stopWASServer(wasInstallationPath, serverID, serviceName, userName, password, estimator, verbose, stopServerIfServiceFailed, quotepassword);
                int k = 0;
                while (k < 5) {
                    if (serviceName == null || serviceName.length() <= 0 || !utl.srvExistsAndRuns(srvName)) break;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++k;
                }
                return wasRc;
            }
        }
        if ((rc = this.getWASServerStatus(wasInstallationPath, serverID, serviceName, userName, password, estimator, verbose, quotepassword)) != 0 && rc != 3) {
            rc = super.stopWASServer(wasInstallationPath, serverID, serviceName, userName, password, estimator, verbose, stopServerIfServiceFailed, quotepassword);
            int k = 0;
            while (k < 5) {
                if (serviceName == null || serviceName.length() <= 0 || !utl.srvExistsAndRuns(srvName)) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++k;
            }
        }
        return rc;
    }

    public int stopWASServer(String wasInstallationPath, String serverID, String serviceName, String userName, String password, ActionTimeBasedPercentEstimator estimator, int verbose, boolean stopServerIfServiceFailed) throws ServiceException, IOException {
        return this.stopWASServer(wasInstallationPath, serverID, serviceName, userName, password, estimator, verbose, stopServerIfServiceFailed, 0);
    }

    public static String[] getWASInstalledServices(String wasServicePrefixName, String wasRoot) throws ServiceException {
        boolean debug = true;
        Win32Service win32Service = (Win32Service)ICAInstGlobals.getService("win32Service");
        String[] allServ = win32Service.enumNTServiceKeys(48, 3);
        Vector<String> foundServices = new Vector<String>();
        wasRoot = FileUtils.createFileName(wasRoot, "bin/wasservice.exe");
        int i = 0;
        while (i < allServ.length) {
            NTServiceConfig ntSrvCfg;
            String srvName = allServ[i];
            if (win32Service.serviceExists(srvName) && srvName.startsWith(wasServicePrefixName) && (ntSrvCfg = win32Service.queryNTServiceConfig(srvName)) != null) {
                int idx;
                if (debug) {
                    ShowMessage.writeLogOutput("srvname = " + srvName);
                }
                String srvExecPath = ntSrvCfg.getCommand();
                if (debug) {
                    ShowMessage.writeLogOutput("srvexecpath1 = " + srvExecPath);
                }
                if ((idx = srvExecPath.indexOf(ICAStringUtils.quote(srvName))) > 0) {
                    srvExecPath = srvExecPath.substring(0, idx).trim();
                }
                srvExecPath = ICAStringUtils.unquote(srvExecPath);
                if (debug) {
                    ShowMessage.writeLogOutput("srvexecpath2 = " + srvExecPath);
                }
                if (srvExecPath != null && srvExecPath.length() > 0) {
                    srvExecPath = FileUtils.canonizePath(srvExecPath);
                    if (debug) {
                        ShowMessage.writeLogOutput("srvexecpath3 = " + srvExecPath);
                    }
                    String instPath = FileUtils.canonizePath(wasRoot);
                    if (debug) {
                        ShowMessage.writeLogOutput("instexecpath = " + instPath);
                    }
                    if (srvExecPath.toLowerCase().indexOf(instPath.toLowerCase()) >= 0 && !foundServices.contains(srvName)) {
                        foundServices.add(srvName);
                    }
                }
            }
            ++i;
        }
        String[] wasNTServices = new String[foundServices.size()];
        wasNTServices = foundServices.toArray(wasNTServices);
        return wasNTServices;
    }

    public String getWASServiceControlingServer(String wasServicePrefixName, String serverName, String wasRoot) throws ServiceException {
        if (serverName == null || wasRoot == null) {
            return null;
        }
        String[] ntServiceNames = W32WASUtl.getWASInstalledServices(wasServicePrefixName, wasRoot);
        if (ntServiceNames == null || ntServiceNames.length == 0) {
            return null;
        }
        int hive = 4;
        Win32RegistryService regService = (Win32RegistryService)ICAInstGlobals.getService("win32RegistryService");
        String serviceName = null;
        int i = 0;
        while (i < ntServiceNames.length) {
            String name;
            String parametersKey;
            String serviceKey = "SYSTEM\\CurrentControlSet\\Services\\" + ntServiceNames[i];
            if (regService.keyExists(hive, serviceKey) && regService.keyExists(hive, parametersKey = String.valueOf(serviceKey) + "\\" + "Parameters") && regService.valueExists(hive, parametersKey, "ServerName") && (name = regService.getStringValue(hive, parametersKey, "ServerName", false)) != null && name.length() > 0 && name.trim().equalsIgnoreCase(serverName)) {
                serviceName = ntServiceNames[i];
                break;
            }
            ++i;
        }
        return serviceName;
    }
}

