/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.ActionTimeBasedPercentEstimator;
import com.ibm.itcins.ica2.BldUtil;
import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICAProfileParser;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ProcUtl;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.Utilities;
import com.ibm.itcins.ica2.exceptions.CmdException;
import com.installshield.product.ProductActionSupport;
import com.installshield.util.FileUtils;
import com.installshield.wizard.service.MutableOperationState;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;

public class WASUtl {
    public static final int SERVER_STOPPED = 0;
    public static final int SERVER_STARTED = 1;
    public static final int SERVER_UNKNOWN = 2;
    public static final int SERVER_BAD_CREDENTIAL = 3;
    public static final int SERVER_UNKNOWN_STATE = 4;
    public static final int SERVER_FAILED_STARTING = 5;
    public static final int SERVER_ALREADY_RUNNING = 6;
    public static final int SERVER_STARTING = 7;
    public static final int SERVER_STOPPING = 8;
    protected WizardServices wizardServices = null;
    static /* synthetic */ Class class$0;

    public static WASUtl instantiate() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.itcins.ica2.WASUtl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WASUtl wasUtl = (WASUtl)BldUtil.instantiate(clazz.getName());
        wasUtl.wizardServices = ICAInstGlobals.getServices();
        return wasUtl;
    }

    public static WASUtl instantiate(Object obj) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.itcins.ica2.WASUtl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WASUtl wasUtl = (WASUtl)BldUtil.instantiate(clazz.getName());
        wasUtl.wizardServices = BldUtil.getServices(obj);
        return wasUtl;
    }

    public static String[] getWasExitCodes(String output) {
        int i;
        StringTokenizer token = null;
        Object[] returnCodes = null;
        Vector<String> bobcatCodes = new Vector<String>();
        if (output != null && output.toString().trim().length() > 0) {
            token = new StringTokenizer(output.toString().trim(), "\n");
            while (token.hasMoreElements()) {
                String code;
                String newElement = (String)token.nextElement();
                i = newElement.indexOf(":");
                if (i <= 0 || newElement.length() <= i + 1 || newElement.charAt(i + 1) != ' ' || (code = newElement.substring(0, i).trim()) == null || !code.toUpperCase().startsWith("ADM") || WASUtl.isInforWasCode(code)) continue;
                bobcatCodes.addElement(code);
            }
        }
        String genericErrorCode = "ADMU0002E";
        if (!bobcatCodes.isEmpty() && ((String)bobcatCodes.lastElement()).trim().equals(genericErrorCode)) {
            i = output.indexOf(genericErrorCode);
            int j = genericErrorCode.length();
            int k = output.length();
            if (i >= 0 && k > i + j) {
                String exceptionMsg = output.substring(i + j, k);
                StringTokenizer tokenizer = new StringTokenizer(exceptionMsg);
                while (tokenizer.hasMoreTokens()) {
                    String element = tokenizer.nextToken();
                    if (!(element = element.trim()).startsWith("ADM") || !element.endsWith("E:")) continue;
                    element = element.substring(0, element.indexOf(":"));
                    bobcatCodes.addElement(element);
                }
            }
        }
        if (bobcatCodes != null && !bobcatCodes.isEmpty()) {
            returnCodes = new String[bobcatCodes.size()];
            bobcatCodes.copyInto(returnCodes);
        }
        return returnCodes;
    }

    public static boolean isInforWasCode(String code) {
        String[] infWasCodes = new String[]{"ADMU0211I", "ADMU1211I"};
        int i = 0;
        while (i < infWasCodes.length) {
            if (infWasCodes[i].equalsIgnoreCase(code)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static int translateCode(String returnCode, boolean reportSpecificStartCode, String cmdoutput) {
        String serverStartedID = "ADMU0508I";
        String serverAlrdStoppedID = "ADMU0509I";
        String serverStoppedID = "ADMU4000I";
        String serverUnknownID = "ADMU0522E";
        int rc = 0;
        if (returnCode.equals(serverStartedID)) {
            String msg;
            int i;
            rc = 1;
            if (reportSpecificStartCode && cmdoutput != null && cmdoutput.length() > 0 && (i = cmdoutput.indexOf(serverStartedID)) >= 0 && (msg = cmdoutput.substring(i, cmdoutput.length())) != null && msg.length() > 0) {
                if (msg.indexOf("STARTED") >= 0) {
                    rc = 1;
                } else if (msg.indexOf("STARTING") >= 0) {
                    rc = 7;
                } else if (msg.indexOf("STOPPING") >= 0) {
                    rc = 8;
                }
            }
        } else {
            rc = WASUtl.isWASBadCredentialCode(returnCode) ? 3 : (returnCode.equals(serverAlrdStoppedID) || returnCode.equals(serverStoppedID) ? 0 : (returnCode.equals(serverUnknownID) ? 2 : 4));
        }
        return rc;
    }

    private static boolean isWASBadCredentialCode(String code) {
        Vector<String> codes = new Vector<String>(Arrays.asList("ADMN0022E", "ADMU4113E"));
        return codes.contains(code);
    }

    public int getWASServerStatus(String wasInstallLocation, String server, String serviceName, String userName, String password, ActionTimeBasedPercentEstimator estimator, int verbose, boolean returnStartSpecificCode, int quotepassword) throws ServiceException, CmdException, IOException {
        int code;
        if (verbose > 0) {
            verbose = 1;
        }
        if (estimator != null) {
            estimator.updateOperationState();
        }
        String serverStatus = FileUtils.createFileName(wasInstallLocation, "bin/serverStatus." + (ICAStringUtils.isUnix() ? "sh" : "bat"));
        Object[] comd = new String[20];
        int iii = 0;
        comd[iii++] = ICAStringUtils.quoteOrUnquoteOnlyOnW32(serverStatus);
        if (server == null) {
            server = "server1";
        }
        comd[iii++] = server;
        if (userName != null && userName.length() > 0 && password != null && password.length() > 0) {
            comd[iii++] = "-username";
            comd[iii++] = userName;
            comd[iii++] = "-password";
            if (quotepassword < 0 || quotepassword > 2) {
                quotepassword = 0;
            }
            switch (quotepassword) {
                case 1: {
                    if (!ICAStringUtils.isWindows()) break;
                    password = ICAStringUtils.quote(password);
                    break;
                }
                case 2: {
                    password = ICAStringUtils.quote(password);
                }
            }
            comd[iii++] = password;
        }
        Object[] tmpCmd = comd;
        comd = new String[iii];
        System.arraycopy(tmpCmd, 0, comd, 0, iii);
        tmpCmd = null;
        String msg = ICAStringUtils.arrayToString(comd, " ");
        int i = msg.indexOf("-password");
        if (i > 0) {
            msg = String.valueOf(msg.substring(0, i)) + "-password **********";
        }
        if (verbose > 0) {
            msg = ShowMessage.gi("Ins").resolve("ICAInstall.ExecCmd", new String[]{msg}, null);
            ShowMessage.writeLogOutput(msg);
        }
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        ProcUtl proc = new ProcUtl();
        int rc = proc.execcmd((String[])comd, false, null, (Object)stdout, (Object)stderr);
        if (estimator != null) {
            while (proc.isProcessRunning()) {
                estimator.updateOperationState();
                estimator.sleep();
            }
            estimator.updateOperationState();
        }
        rc = proc.waitForProcess();
        if (verbose > 0) {
            String msgrc = ShowMessage.gi("Ins").resolve("ICAInstall.CmdRc", new String[]{String.valueOf(rc)}, null);
            ShowMessage.writeLogOutput(msgrc);
        }
        String[] returnCodes = null;
        if (rc != 0) {
            returnCodes = WASUtl.getWasExitCodes(stdout.toString().trim());
            if (returnCodes == null) {
                throw new CmdException(rc, msg, new String[]{stderr == null ? null : stderr.toString()});
            }
        } else {
            returnCodes = WASUtl.getWasExitCodes(stdout.toString().trim());
            if (returnCodes == null || returnCodes.length == 0) {
                String errMsg = ShowMessage.gi("Ins").resolve("Install.WASServerUknownState", new String[]{server}, null);
                ShowMessage.writeLogOutput("wrn", errMsg);
                String cmdoutput = ShowMessage.gi("Ins").resolve("ICAInstall.CmdOut", new String[]{stdout.toString().trim()}, null);
                ShowMessage.writeLogOutput(cmdoutput);
                throw new CmdException(rc, msg, new String[]{stdout == null ? null : stdout.toString()});
            }
        }
        if (verbose > 0) {
            String msgrc = ShowMessage.gi("Ins").resolve("ICAInstall.WASRc", new String[]{returnCodes[returnCodes.length - 1]}, null);
            ShowMessage.writeLogOutput(msgrc);
        }
        if (estimator != null) {
            estimator.updateOperationState();
        }
        if ((code = WASUtl.translateCode(returnCodes[returnCodes.length - 1], returnStartSpecificCode, stdout.toString().trim())) == 4) {
            ShowMessage.writeLogOutput(ShowMessage.gi("Ins").resolve("ICAInstall.CmdOut", new String[]{stdout.toString()}, null));
        }
        return code;
    }

    public int getWASServerStatus(String wasInstallLocation, String server, String serviceName, String userName, String password, ActionTimeBasedPercentEstimator estimator, int verbose) throws ServiceException, CmdException, IOException {
        return this.getWASServerStatus(wasInstallLocation, server, serviceName, userName, password, estimator, verbose, false, 0);
    }

    public int getWASServerStatus(String wasInstallLocation, String server, String serviceName, String userName, String password, ActionTimeBasedPercentEstimator estimator, int verbose, int quotePassword) throws ServiceException, CmdException, IOException {
        return this.getWASServerStatus(wasInstallLocation, server, serviceName, userName, password, estimator, verbose, false, quotePassword);
    }

    public int startWASServer(String wasInstallationPath, String serverID, String serviceName, ActionTimeBasedPercentEstimator estimator, int verbose, boolean startServerIfServiceFailed) throws IOException, ServiceException {
        String[] codes;
        String startServer = null;
        String wasRoot = null;
        String wasLog = null;
        File wasLogFile = null;
        Object[] comd = new String[20];
        int iii = 0;
        StringBuffer stdout = new StringBuffer();
        ProcUtl proc = new ProcUtl();
        long timeBeforeStartingWAS = 0L;
        if (verbose != 0) {
            verbose = 1;
        }
        if ((wasRoot = wasInstallationPath) == null || wasRoot.trim().length() == 0) {
            return 1;
        }
        startServer = FileUtils.createFileName(wasRoot, "bin/startServer." + (ICAStringUtils.isUnix() ? "sh" : "bat"));
        wasLog = ICAStringUtils.quoteOrUnquote(FileUtils.createFileName(wasRoot, "logs/" + serverID + "/startServer.log"));
        wasLogFile = new File(wasLog);
        comd[iii++] = ICAStringUtils.quoteOrUnquoteOnlyOnW32(startServer);
        comd[iii++] = serverID;
        String srvAlrdRunning = "ADMU3027E";
        String errorStartingServer1 = "ADMU0111E";
        String errorStartingServer2 = "ADMU3011E";
        String srvSuccStarted = "ADMU3000I";
        timeBeforeStartingWAS = System.currentTimeMillis();
        Object[] tmpCmd = comd;
        comd = new String[iii];
        System.arraycopy(tmpCmd, 0, comd, 0, iii);
        tmpCmd = null;
        String msg = ICAStringUtils.arrayToString(comd, " ");
        if (verbose == 1) {
            msg = ShowMessage.gi("Ins").resolve("ICAInstall.ExecCmd", new String[]{msg}, null);
            ShowMessage.writeLogOutput(msg);
        }
        proc.execcmd((String[])comd, false, null, (Object)stdout, (Object)stdout);
        if (estimator != null) {
            while (proc.isProcessRunning()) {
                estimator.updateOperationState();
                estimator.sleep();
            }
            estimator.updateOperationState();
        }
        int rcCmd = proc.waitForProcess();
        if (verbose == 1) {
            String rcmsg = ShowMessage.gi("Ins").resolve("ICAInstall.CmdRc", new String[]{String.valueOf(rcCmd)}, null);
            ShowMessage.writeLogOutput(rcmsg);
        }
        if ((codes = WASUtl.getWasExitCodes(stdout.toString().trim())) == null || codes.length == 0) {
            String errMsg = ShowMessage.gi("Ins").resolve("Install.WASServerUknownState", new String[]{serverID}, null);
            ShowMessage.writeLogOutput("wrn", errMsg);
            String cmdoutput = ShowMessage.gi("Ins").resolve("ICAInstall.CmdOut", new String[]{stdout.toString().trim()}, null);
            ShowMessage.writeLogOutput(cmdoutput);
            throw new CmdException(rcCmd, ICAStringUtils.arrayToString(comd, " "), new String[]{stdout == null ? null : stdout.toString()});
        }
        if (wasLogFile.exists() && wasLogFile.lastModified() > timeBeforeStartingWAS) {
            wasLog = wasLogFile.getPath();
        } else {
            wasLog = null;
            String waslogmsg = ShowMessage.gi("Ins").resolve("ICAInstall.CmdOut", new String[]{stdout.toString()}, null);
            ShowMessage.writeLogOutput(waslogmsg);
        }
        int status = -1;
        int ii = 0;
        while (ii < codes.length) {
            if (codes[ii].trim().equals(srvSuccStarted)) {
                status = 0;
                break;
            }
            if (codes[ii].trim().equals(srvAlrdRunning)) {
                status = 1;
                break;
            }
            if (codes[ii].trim().equals(errorStartingServer1) || codes[ii].trim().equals(errorStartingServer2)) {
                status = 2;
                break;
            }
            ++ii;
        }
        if (rcCmd != 0 && status == -1) {
            status = 2;
        }
        if (estimator != null) {
            estimator.updateOperationState();
        }
        switch (status) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        return 2;
    }

    public int propFilePasswordEncoder(String wasInstallationPath, String propFileName, String password_properties_listORsas, int verbose) throws CmdException, IOException {
        String msg;
        int rc = -1;
        String exe = "bin/PropFilePasswordEncoder" + (ICAStringUtils.isUnix() ? ".sh" : ".bat");
        String[] cmd = new String[]{ICAStringUtils.quoteOrUnquote(FileUtils.createFileName(wasInstallationPath, exe)), ICAStringUtils.quoteOrUnquote(propFileName), password_properties_listORsas};
        ProcUtl proc = new ProcUtl();
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        if (verbose > 0) {
            msg = ShowMessage.gi("Ins").resolve("ICAInstall.ExecCmd", new String[]{String.valueOf(cmd[0]) + " " + cmd[1] + " " + cmd[2]}, null);
            ShowMessage.writeLogOutput(msg);
        }
        rc = proc.execcmd(cmd, true, null, (Object)stdout, (Object)stderr);
        if (verbose > 0) {
            msg = ShowMessage.gi("Ins").resolve("ICAInstall.CmdRc", new String[]{String.valueOf(rc)}, null);
            ShowMessage.writeLogOutput(msg);
        }
        if (rc != 0) {
            throw new CmdException(rc, cmd, (String)("".equals(stderr.toString().trim()) ? ("".equals(stdout.toString().trim()) ? null : stdout.toString().trim()) : stderr.toString().trim()));
        }
        return rc;
    }

    public int stopWASServer(String wasInstallationPath, String serverID, String serviceName, String userName, String password, ActionTimeBasedPercentEstimator estimator, int verbose, boolean stopServerIfServiceFailed, int quotepassword) throws ServiceException, IOException {
        if (verbose < 0) {
            verbose = 0;
        }
        if (verbose > 2) {
            verbose = 2;
        }
        if (estimator != null) {
            estimator.updateOperationState();
        }
        Object[] comd = new String[20];
        int iii = 0;
        String stopSrvPath = FileUtils.createFileName(wasInstallationPath, "bin/stopServer." + (ICAStringUtils.isUnix() ? "sh" : "bat"));
        comd[iii++] = ICAStringUtils.quoteOrUnquoteOnlyOnW32(stopSrvPath);
        if (serverID == null) {
            serverID = "server1";
        }
        comd[iii++] = serverID;
        if (userName != null && userName.length() > 0 && password != null && password.length() > 0) {
            comd[iii++] = "-username";
            comd[iii++] = userName;
            comd[iii++] = "-password";
            if (quotepassword < 0 || quotepassword > 2) {
                quotepassword = 0;
            }
            switch (quotepassword) {
                case 1: {
                    if (!ICAStringUtils.isWindows()) break;
                    password = ICAStringUtils.quote(password);
                    break;
                }
                case 2: {
                    password = ICAStringUtils.quote(password);
                }
            }
            comd[iii++] = password;
        }
        Object[] tmpCmd = comd;
        comd = new String[iii];
        System.arraycopy(tmpCmd, 0, comd, 0, iii);
        tmpCmd = null;
        String msg = ICAStringUtils.arrayToString(comd, " ");
        int i = msg.indexOf("-password");
        if (i > 0) {
            msg = String.valueOf(msg.substring(0, i)) + "-password **********";
        }
        if (verbose > 0) {
            msg = ShowMessage.gi("Ins").resolve("ICAInstall.ExecCmd", new String[]{msg}, null);
            ShowMessage.writeLogOutput(msg);
        }
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        ProcUtl proc = new ProcUtl();
        int rc = proc.execcmd((String[])comd, false, null, (Object)stdout, (Object)stderr);
        if (estimator != null) {
            while (proc.isProcessRunning()) {
                estimator.updateOperationState();
                estimator.sleep();
            }
            estimator.updateOperationState();
        }
        rc = proc.waitForProcess();
        if (verbose == 1) {
            String msgrc = ShowMessage.gi("Ins").resolve("ICAInstall.CmdRc", new String[]{String.valueOf(rc)}, null);
            ShowMessage.writeLogOutput(msgrc);
        }
        String[] codes = WASUtl.getWasExitCodes(stdout.toString().trim());
        if (estimator != null) {
            estimator.updateOperationState();
        }
        if (codes == null || codes.length == 0) {
            return 4;
        }
        String errCode = codes[codes.length - 1];
        int code = WASUtl.translateCode(errCode, false, null);
        if (verbose == 2 || code != 0) {
            String msgrc = ShowMessage.gi("Ins").resolve("ICAInstall.CmdOut", new String[]{stdout.toString()}, null);
            ShowMessage.writeLogOutput(msgrc);
        }
        return code;
    }

    public int stopWASServer(String wasInstallationPath, String serverID, String serviceName, String userName, String password, ActionTimeBasedPercentEstimator estimator, int verbose, boolean stopServerIfServiceFailed) throws ServiceException, IOException {
        return this.stopWASServer(wasInstallationPath, serverID, serviceName, userName, password, estimator, verbose, stopServerIfServiceFailed, 0);
    }

    public String getWasVersion(String wasInstallPath, String versionFile) {
        String version = "";
        String fileVersion = String.valueOf(ICAStringUtils.goodSlashes(wasInstallPath)) + File.separator + versionFile;
        String[] lines = null;
        String beginTag = "<version>";
        String endTag = "</version>";
        try {
            int poz1;
            lines = ICAProfileParser.readAsciiFile(fileVersion, true, null);
            if (lines == null || lines.length <= 0) {
                return version;
            }
            int poz = ICAStringUtils.locateString(beginTag, lines, 0, -1, true, false, false, 0);
            if (poz >= 0 && (poz1 = ICAStringUtils.locateString(endTag, lines, poz, -1, true, false, false, 0)) >= 0) {
                String ver = new String("");
                int i = poz;
                while (poz1 >= i) {
                    ver = String.valueOf(ver) + lines[i];
                    ++i;
                }
                version = ver.substring(ver.indexOf(beginTag) + beginTag.length(), ver.indexOf(endTag));
            }
        }
        catch (IOException ex) {
            ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.IOException", new String[]{ex.toString()}, null));
        }
        return version.trim();
    }

    public static int analyseWasConfigOutput(StringBuffer sb, int originalRetCode, String[] goodWords) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        if (goodWords == null) {
            goodWords = new String[]{};
        }
        String out = sb.toString().trim();
        int finalRetCode = originalRetCode;
        if (originalRetCode == 0) {
            int i = 0;
            while (i < goodWords.length) {
                if (goodWords[i] != null) {
                    if (out.indexOf(goodWords[i]) >= 0) {
                        finalRetCode = 0;
                        break;
                    }
                    finalRetCode = -1;
                }
                ++i;
            }
        }
        StringTokenizer token = null;
        sb.setLength(0);
        token = new StringTokenizer(out, "\n");
        while (token.hasMoreElements()) {
            String sbLine = (String)token.nextElement();
            int p = -1;
            if (sbLine.startsWith("WASConfig.")) {
                int q;
                Vector<String> wordsMessage = new Vector<String>();
                while ((q = sbLine.indexOf(",", p + 1)) > 0) {
                    String word = sbLine.substring(p + 1, p = q).trim();
                    if (word.equals("")) continue;
                    wordsMessage.addElement(word);
                }
                String last = sbLine.substring(p + 1, sbLine.length()).trim();
                if (!last.equals("")) {
                    wordsMessage.addElement(last);
                }
                String messKey = (String)wordsMessage.elementAt(0);
                Object[] messParam = null;
                int sizeMess = wordsMessage.size();
                if (sizeMess > 1) {
                    messParam = new String[sizeMess - 1];
                    int i = 1;
                    while (i < sizeMess) {
                        messParam[i - 1] = (String)wordsMessage.elementAt(i);
                        ++i;
                    }
                }
                String mess = new String("");
                if (messParam != null && messParam.length != 0) {
                    int i = 0;
                    while (i < messParam.length) {
                        mess = String.valueOf(mess) + (String)messParam[i] + " ,";
                        ++i;
                    }
                }
                String mes = ShowMessage.gi("ICAIns").resolve(messKey, messParam, messKey);
                sb.append(mes).append("\n");
                continue;
            }
            if (finalRetCode == 0) continue;
            sb.append(sbLine).append("\n");
        }
        return finalRetCode;
    }

    public static void execWasConfigWithEstimator(String[] comd, String waitMessage, ActionTimeBasedPercentEstimator estimator, ProductActionSupport support) throws IOException {
        int rcc;
        ProcUtl proc = new ProcUtl();
        StringBuffer sb = new StringBuffer();
        int rc = -1;
        MutableOperationState mos = support.getOperationState();
        if (estimator != null) {
            mos.setStatusDetail(waitMessage);
            rc = proc.execcmd(comd, false, null, (Object)sb, (Object)sb);
            while (proc.isProcessRunning()) {
                estimator.updateOperationState();
                estimator.sleep();
            }
            rc = proc.waitForProcess();
        } else {
            rc = proc.execcmd(comd, true, null, (Object)sb, (Object)sb);
        }
        if (sb == null || "".equals(sb.toString().trim())) {
            String cmd = ICAStringUtils.arrayToString(comd);
            ShowMessage.writeLogOutput("The output of following commnad \"" + cmd + "\" is empty.");
        }
        if ((rcc = WASUtl.analyseWasConfigOutput(sb, rc, new String[]{"WASConfig.ScriptEndSuccessN"})) != 0) {
            estimator = null;
            throw new CmdException(rc, comd[0], new String[]{comd[0]}, sb == null ? null : sb.toString());
        }
        ShowMessage.writeLogOutput(sb.toString());
        if (estimator != null) {
            estimator.completeOperationState();
            estimator = null;
        }
    }

    public static String[] getServersFromCurrentWASConfig(String wasroot) throws CmdException, IOException {
        String[] serverList = null;
        if (wasroot == null) {
            return null;
        }
        boolean DEBUG = false;
        String startTAG = "WASConfig.StartServersList";
        String endTAG = "WASConfig.EndServersList";
        String wsadmin = FileUtils.createFileName(wasroot, "bin");
        wsadmin = FileUtils.createFileName(wsadmin, Utilities.isWindows() ? "wsadmin.bat" : "wsadmin.sh");
        String listScript = FileUtils.createTempFile(ICAInstGlobals.getWizard().getResource("listWASServers.jacl"));
        String[] scriptCmd = new String[]{wsadmin, "-conntype", "NONE", "-f", listScript};
        int rc = -1;
        ProcUtl proc = new ProcUtl();
        StringBuffer sb = new StringBuffer();
        rc = proc.execcmd(scriptCmd, true, null, (Object)sb, (Object)sb);
        StringBuffer sbb = new StringBuffer(sb.toString());
        int rcc = WASUtl.analyseWasConfigOutput(sbb, rc, new String[]{"WASConfig.ScriptEndSuccessN"});
        if (DEBUG) {
            ShowMessage.writeLogOutput("command output = " + sb.toString());
        }
        if (rcc != 0) {
            throw new CmdException(rc, scriptCmd[0], new String[]{scriptCmd[0]}, sb == null ? null : sb.toString());
        }
        if (sb != null) {
            int startIdx = sb.toString().indexOf(startTAG);
            if (DEBUG) {
                ShowMessage.writeLogOutput("startIdx = " + startIdx);
            }
            int endIdx = sb.toString().indexOf(endTAG);
            if (DEBUG) {
                ShowMessage.writeLogOutput("endIdx = " + endIdx);
            }
            if (startIdx > 0 && endIdx > 0 && endIdx > startIdx) {
                String out = sb.toString().substring((startIdx += startTAG.length()) + 1, endIdx);
                if (DEBUG) {
                    ShowMessage.writeLogOutput("out " + out);
                }
                StringTokenizer token = new StringTokenizer(out.trim(), "\n");
                Vector<String> servers = new Vector<String>();
                while (token.hasMoreElements()) {
                    String currentServerName = (String)token.nextElement();
                    if (currentServerName.trim().length() <= 0 || servers.contains(currentServerName)) continue;
                    servers.add(currentServerName);
                }
                serverList = new String[servers.size()];
                serverList = servers.toArray(serverList);
            }
        }
        return serverList;
    }

    public String[][] getAllWASServersState(String wasRoot, String wasPrefixServiceName, boolean checkNTServicesState, String userName, String password) throws ServiceException, IOException, CmdException {
        if (wasRoot == null || wasRoot.length() == 0) {
            return null;
        }
        String[] servers = WASUtl.getServersFromCurrentWASConfig(wasRoot);
        return this.getWASServersState(servers, wasPrefixServiceName, wasRoot, checkNTServicesState, userName, password);
    }

    public String[][] getWASServersState(String[] servers, String wasPrefixServiceName, String wasRoot, boolean checkNTServicesState, String userName, String password, int quotePassword) throws ServiceException, IOException, CmdException {
        Vector<String[]> response = new Vector<String[]>();
        if (servers != null && servers.length > 0) {
            int[] states = new int[servers.length];
            int i = 0;
            while (i < servers.length) {
                String serviceName = null;
                if (ICAStringUtils.isWindows() && checkNTServicesState) {
                    serviceName = this.getWASServiceControlingServer(wasPrefixServiceName, servers[i], wasRoot);
                }
                String logMsg = ShowMessage.gi(null).resolve("Install.CheckWASServerState", new String[]{servers[i]}, null);
                ShowMessage.writeLogOutput(logMsg);
                states[i] = this.getWASServerStatus(wasRoot, servers[i], serviceName, userName, password, null, 2, quotePassword);
                switch (states[i]) {
                    case 0: {
                        logMsg = ShowMessage.gi(null).resolve("Install.WASServerStopped", new String[]{servers[i]}, null);
                        break;
                    }
                    case 1: {
                        logMsg = ShowMessage.gi(null).resolve("Install.WASServerStarted", new String[]{servers[i]}, null);
                        break;
                    }
                    case 2: {
                        logMsg = ShowMessage.gi(null).resolve("Install.WASServerUnknownServer", new String[]{servers[i]}, null);
                        break;
                    }
                    case 3: {
                        logMsg = ShowMessage.gi(null).resolve("Install.WASServerBadCredential", new String[]{servers[i]}, null);
                        break;
                    }
                    default: {
                        logMsg = ShowMessage.gi(null).resolve("Install.WASServerUknownState", new String[]{servers[i]}, null);
                    }
                }
                ShowMessage.writeLogOutput(logMsg);
                response.add(new String[]{servers[i], serviceName, String.valueOf(states[i])});
                ++i;
            }
        }
        String[][] resp = new String[response.size()][];
        resp = (String[][])response.toArray((T[])resp);
        return resp;
    }

    public String[][] getWASServersState(String[] servers, String wasPrefixServiceName, String wasRoot, boolean checkNTServicesState, String userName, String password) throws ServiceException, IOException, CmdException {
        return this.getWASServersState(servers, wasPrefixServiceName, wasRoot, checkNTServicesState, userName, password, 0);
    }

    public String getMQVersion(String mqInstallLocation) {
        return "";
    }

    public String getWASServiceControlingServer(String wasServicePrefixName, String serverName, String wasRoot) throws ServiceException {
        return null;
    }
}

