/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.ActionTimeBasedPercentEstimator;
import com.installshield.wizard.RunnableWizardBeanState;

public class WizardActionTimeBasedPercentEstimator
implements ActionTimeBasedPercentEstimator {
    private RunnableWizardBeanState state = null;
    private long operationStartTime = 0L;
    private int estimatedTimeTenths = 0;
    private double estimatedTimeMillisFloat = 0.0;
    private int initialPercentInt = 100;
    private int finalPercentInt = 100;
    private double initialPercentDouble = 0.0;
    private double finalPercentDouble = 100.0;
    private double updatedRelativePercent = 0.0;
    private double totalRelativePercent = 100.0;
    private long sleepInterval = 200L;

    public WizardActionTimeBasedPercentEstimator(RunnableWizardBeanState state, int estimatedTimeTenths, int initialPercent, int finalPercent, int alreadyElapsedTimeTenths, boolean suspended) {
        this.state = state;
        if (initialPercent < 0) {
            initialPercent = 0;
        }
        if (initialPercent > 100) {
            initialPercent = 100;
        }
        if (finalPercent < 0) {
            finalPercent = 0;
        }
        if (finalPercent > 100) {
            finalPercent = 100;
        }
        if (initialPercent > finalPercent) {
            initialPercent = finalPercent;
        }
        this.initialPercentInt = initialPercent;
        this.initialPercentDouble = initialPercent;
        this.finalPercentInt = finalPercent;
        this.finalPercentDouble = finalPercent;
        this.totalRelativePercent = this.finalPercentDouble - this.initialPercentDouble;
        this.updatedRelativePercent = 0.0;
        this.operationStartTime = System.currentTimeMillis() - (long)(alreadyElapsedTimeTenths * 100);
        if (this.operationStartTime <= 0L) {
            this.operationStartTime = 1L;
        }
        if (estimatedTimeTenths > 0) {
            this.estimatedTimeTenths = estimatedTimeTenths;
            this.estimatedTimeMillisFloat = (double)estimatedTimeTenths * 100.0;
            int intervalTenths = estimatedTimeTenths / 16;
            if (intervalTenths < 2) {
                intervalTenths = 2;
            } else if (intervalTenths > 20) {
                intervalTenths = 20;
            }
            this.sleepInterval = (long)intervalTenths * 100L;
        }
        if (suspended) {
            this.suspendEstimation();
        }
    }

    public WizardActionTimeBasedPercentEstimator(RunnableWizardBeanState state, int estimatedTimeTenths, int initialPercent, int finalPercent) {
        this(state, estimatedTimeTenths, initialPercent, finalPercent, 0, false);
    }

    public WizardActionTimeBasedPercentEstimator(RunnableWizardBeanState state, int estimatedTimeTenths) {
        this(state, estimatedTimeTenths, 0, 100);
    }

    public synchronized void updateOperationState(boolean completed) {
        if (this.estimatedTimeTenths > 0 && this.totalRelativePercent > 0.0 && this.operationStartTime > 0L) {
            double estimatedRelativePercent = 0.0;
            if (completed) {
                estimatedRelativePercent = this.totalRelativePercent;
            } else {
                double t1;
                double proc = 0.0;
                double t = System.currentTimeMillis() - this.operationStartTime;
                proc = t <= (t1 = this.estimatedTimeMillisFloat * 0.667) ? t / t1 * 67.0 : (t <= t1 * 2.0 ? t / t1 * 22.0 + 45.0 : t / t1 * 11.0 + 67.0);
                estimatedRelativePercent = proc * this.totalRelativePercent / 100.0;
                if (estimatedRelativePercent < 0.0) {
                    estimatedRelativePercent = 0.0;
                }
                if (estimatedRelativePercent > this.totalRelativePercent) {
                    estimatedRelativePercent = this.totalRelativePercent;
                }
            }
            if (estimatedRelativePercent > this.updatedRelativePercent) {
                this.updatedRelativePercent = estimatedRelativePercent;
            }
        }
        if (this.state != null) {
            try {
                int currentStatePercent = this.state.getPercentComplete();
                int updatedPercent = (int)(this.updatedRelativePercent + this.initialPercentDouble + 0.5);
                if (updatedPercent > this.finalPercentInt) {
                    updatedPercent = this.finalPercentInt;
                }
                if (updatedPercent >= this.finalPercentInt && !completed) {
                    updatedPercent = this.finalPercentInt - 1;
                }
                if (updatedPercent < this.initialPercentInt) {
                    updatedPercent = this.initialPercentInt;
                }
                if (updatedPercent != currentStatePercent) {
                    this.state.setPercentComplete(updatedPercent);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void updateOperationState() {
        this.updateOperationState(false);
    }

    public void completeOperationState() {
        this.updateOperationState(true);
    }

    public synchronized void suspendEstimation() {
        long tmp = 0L;
        if (this.operationStartTime > 0L) {
            tmp = this.operationStartTime - System.currentTimeMillis();
            this.operationStartTime = tmp < 0L ? tmp : 0L;
        }
    }

    public synchronized void resumeEstimation() {
        if (this.operationStartTime <= 0L) {
            this.operationStartTime = System.currentTimeMillis() + this.operationStartTime;
        }
    }

    public long getReccomendedSleepInterval() {
        return this.sleepInterval;
    }

    public void sleep(long sleepTime) {
        if (this.operationStartTime > 0L && sleepTime > 0L) {
            long t1 = System.currentTimeMillis();
            long t2 = 0L;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                t2 = System.currentTimeMillis() - t1;
            }
            if (t2 > 0L && t2 < sleepTime) {
                try {
                    Thread.sleep(sleepTime - t2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void sleep() {
        this.sleep(this.sleepInterval);
    }

    public boolean isSuspended() {
        return this.operationStartTime <= 0L;
    }
}

