/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.panels;

import com.ibm.itcins.ica2.CimomActions;
import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ProcUtl;
import com.ibm.itcins.ica2.SVCProcsUtils;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.Utilities;
import com.ibm.itcins.ica2.Utl;
import com.installshield.util.FileUtils;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardPanel;
import com.installshield.wizard.service.file.FileService;
import java.net.URL;

public class CIMAgentCheckUninstallPanel
extends WizardPanel {
    public static final int DISABLE_NEXT_BUTTON = 1;
    public static final int ENABLE_NEXT_BUTTON = 2;
    public static final int SET_WAIT_CURSOR = 1;
    public static final int SET_DEFAULT_CURSOR = 2;
    private static final String ECLIPSE_INFOCENTER_CLASS = "org.eclipse.help.standalone.Infocenter";
    private int nextButtonState = 2;
    private int waitCursorState = 2;
    public String message;
    public String initialNextLabel;
    private CimomActions actions = null;
    private String[][] processRunning = null;
    private int installationType;
    private String busyMessage = "";
    private boolean debug = false;
    private String[] servicesNames = new String[0];
    private String[] wasServicesAndServersPairs = new String[0];
    private String wasInstallLocation;
    private String javaPath;
    private String eclipseLocation;
    private String eclipseJarPath;

    public boolean queryEnter(WizardBeanEvent event) {
        this.setEntered(false);
        this.setBusyMessage(ShowMessage.gi("ICAIns").resolve("ICAInstall.VerifyRunServ", null, null));
        String s = this.resolveString(this.getBusyMessage());
        if (s != null && s.length() > 0) {
            event.getUserInterface().setBusy(s);
        }
        this.shutdownEclipse();
        if (!super.queryEnter(event)) {
            return false;
        }
        this.getWizard().getServices().setValue("isSilentMode", new Boolean(false));
        this.installationType = ICAInstGlobals.getInt("installationType");
        return this.formatMessage();
    }

    private void shutdownEclipse() {
        StringBuffer cmd = new StringBuffer(255);
        cmd.append(ICAStringUtils.quoteOrUnquote(this.resolveString(this.getJavaPath()))).append(" -classpath ").append(ICAStringUtils.quoteOrUnquote(this.resolveString(this.getEclipseJarPath()))).append(" ").append(ECLIPSE_INFOCENTER_CLASS).append(" -command shutdown ").append(" -eclipsehome ").append(ICAStringUtils.quoteOrUnquote(this.resolveString(this.getEclipseLocation())));
        String tempBatFile = null;
        try {
            String string = tempBatFile = ICAStringUtils.isWindows() ? FileUtils.createTempFile(new URL("file:///NUL"), "ShutdownEclipse.bat") : FileUtils.createTempFile();
            if (Utilities.isUnix()) {
                Utl utl = Utl.instantiate();
                utl.setExecutePermisions(tempBatFile);
            }
            FileService sfs = (FileService)this.getService("fileService");
            sfs.appendToAsciiFile(tempBatFile, new String[]{cmd.toString()});
        }
        catch (Throwable t) {
            ShowMessage.writeLogOutput("Shut down eclipse failed");
        }
        int exitProc = -1;
        ProcUtl proc = new ProcUtl();
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        try {
            exitProc = proc.execcmd(ICAStringUtils.quoteOrUnquote(ICAStringUtils.goodSlashes(tempBatFile)), false, null, (Object)stdout, (Object)stderr);
            if (exitProc != 0) {
                ShowMessage.writeLogOutput("Shut down eclipse failed");
                ShowMessage.writeLogOutput(stderr.toString());
            } else {
                ShowMessage.writeLogOutput("Shut down eclipse successfully");
                String returnmsg = stdout.toString().trim();
                ShowMessage.writeLogOutput(returnmsg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ShowMessage.writeLogOutput(stderr.toString());
        }
        exitProc = proc.waitForProcess();
        if (tempBatFile != null) {
            FileUtils.deleteTempFile(tempBatFile);
        }
    }

    public boolean entered(WizardBeanEvent event) {
        boolean rc = super.entered(event);
        ShowMessage.gi("ICAIns").setWizardTitle(this);
        Object label = this.getWizard().getServices().getValue("InitialNextLabel");
        if (label != null && label instanceof String) {
            this.setInitialNextLabel((String)label);
        }
        this.setEntered(true);
        this.setWaitCursorState(2);
        this.setNextButtonState(2);
        this.refreshNavStates();
        return rc;
    }

    public boolean queryExit(WizardBeanEvent event) {
        if (!this.isEntered()) {
            return false;
        }
        this.getWizard().getServices().setValue("stopProcessesResponse", "YES");
        this.setWaitCursorState(1);
        this.setNextButtonState(1);
        this.refreshNavStates();
        String txt = this.stopProcesses();
        if (!txt.equals("")) {
            this.setMessage(txt);
            this.setWaitCursorState(2);
            this.setNextButtonState(2);
            this.refreshNavStates();
            return false;
        }
        return true;
    }

    public void exited(WizardBeanEvent event) {
        super.exited(event);
        ShowMessage.gi("ICAIns").setWizardTitle(null);
    }

    public void execute(WizardBeanEvent event) {
        this.getWizard().getServices().setValue("isSilentMode", new Boolean(true));
        this.installationType = ICAInstGlobals.getInt("installationType");
        this.actions = CimomActions.instantiate(this, 'I');
        this.getWizard().getServices().setValue("stopProcessesResponse", "YES");
        String txt = this.stopProcesses();
        if (txt.equals("@01")) {
            StringBuffer processes = new StringBuffer();
            StringBuffer procsFromDir = new StringBuffer();
            if (this.processRunning != null && this.processRunning.length > 0) {
                int i = 0;
                while (i < this.processRunning.length) {
                    this.processRunning = this.actions.rmDuplicateProcesses(this.processRunning);
                    if (this.processRunning[i][4] != null) {
                        processes.append("\n" + this.processRunning[i][4]);
                    } else {
                        String pid = ShowMessage.gi("ICAIns").resolve("ICAInstall.htmlHeadPid", null, null);
                        String command = ShowMessage.gi("ICAIns").resolve("ICAInstall.htmlHeadCommand", null, null);
                        String args = ShowMessage.gi("ICAIns").resolve("ICAInstall.htmlHeadArgs", null, null);
                        procsFromDir.append("\n" + pid + ": " + this.processRunning[i][2]);
                        procsFromDir.append("\n" + command + ": " + this.processRunning[i][0]);
                        procsFromDir.append("\n" + args + ": " + this.processRunning[i][1]);
                    }
                    ++i;
                }
            }
            if (!procsFromDir.toString().trim().equals("")) {
                processes.append(procsFromDir.toString());
            }
            String msg = ICAStringUtils.isUnix() ? ShowMessage.gi("ICAIns").resolve("CIMAgentUninstallCheckingPanel.UNIX.UninstSetStopProcessesVar", new String[]{processes.toString()}, null) : ShowMessage.gi("ICAIns").resolve("CIMAgentUninstallCheckingPanel.UninstSetStopProcessesVar", new String[]{processes.toString()}, null);
            ShowMessage.writeLogOutput(msg);
            String wrnConsoleMsg = ShowMessage.gi("ICAIns").resolve("ICAInstall.Errors", new String[]{ICAStringUtils.goodSlashes(this.getWizard().getWizardLog().getLogOutput())}, null);
            if (!Utilities.getPrefix().toUpperCase().startsWith("AIX")) {
                this.getWizard().exit(2, wrnConsoleMsg);
            } else {
                System.err.println(wrnConsoleMsg);
                this.getWizard().exit(2);
            }
            return;
        }
        if (!txt.equals("")) {
            ShowMessage.gi("ICAIns").fatalError0(this, "", txt);
            return;
        }
        this.shutdownEclipse();
    }

    private boolean formatMessage() {
        this.actions = CimomActions.instantiate(this, 'I');
        StringBuffer procMessage = new StringBuffer("");
        this.processRunning = SVCProcsUtils.getRunningProcesses(this.getServicesNames(), this.getWasServicesAndServersPairs(), this.getWasInstallLocation(), this.isDebug());
        if (this.processRunning != null && this.processRunning.length > 0) {
            procMessage.append(this.actions.displayRunningProcesses(this.actions.rmDuplicateProcesses(this.processRunning), this.installationType, true));
            procMessage.append(ShowMessage.gi("ICAIns").resolve("ICAInstall.ClickNext", null, null));
        }
        if (procMessage.toString().length() <= 10) {
            return false;
        }
        this.setMessage(procMessage.toString().trim());
        return true;
    }

    private String stopProcesses() {
        String stopProcVar = (String)this.getServices().getValue("stopProcessesResponse");
        if (stopProcVar != null && stopProcVar.toUpperCase().startsWith("Y")) {
            String ret = SVCProcsUtils.stopRunningProcesses(this.getServicesNames(), this.getWasServicesAndServersPairs(), this.getWasInstallLocation());
            if (!ret.equals("")) {
                String txt = ShowMessage.gi("ICAIns").resolve("ICAInstall.StopServiceError", new String[]{ret}, null);
                return txt;
            }
        } else {
            return "@01";
        }
        return "";
    }

    void setMessage(String message) {
        this.message = message;
        this.propertyChanged("message");
    }

    String getMessage() {
        return this.message;
    }

    void setWaitCursorState(int waitCursorState) {
        this.waitCursorState = waitCursorState;
        this.propertyChanged("waitCursorState");
    }

    int getWaitCursorState() {
        return this.waitCursorState;
    }

    void setNextButtonState(int nextButtonState) {
        this.nextButtonState = nextButtonState;
    }

    int getNextButtonState() {
        return this.nextButtonState;
    }

    private void refreshNavStates() {
        if (this.getNextButtonState() == 1) {
            this.getWizard().getUI().setStopped(true);
        } else {
            this.getWizard().getUI().setStopped(false);
        }
    }

    void setInitialNextLabel(String initialNextLabel) {
        this.initialNextLabel = initialNextLabel;
        this.propertyChanged("initialNextLabel");
    }

    String getInitialNextLabel() {
        return this.initialNextLabel;
    }

    public void setBusyMessage(String busyMessage) {
        this.busyMessage = busyMessage;
    }

    public String getBusyMessage() {
        return this.busyMessage;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String[] getServicesNames() {
        return this.servicesNames;
    }

    public void setServicesNames(String[] servicesNames) {
        this.servicesNames = servicesNames;
    }

    public String getWasInstallLocation() {
        return this.wasInstallLocation;
    }

    public void setWasInstallLocation(String wasInstallLocation) {
        this.wasInstallLocation = wasInstallLocation;
    }

    public String[] getWasServicesAndServersPairs() {
        return this.wasServicesAndServersPairs;
    }

    public void setWasServicesAndServersPairs(String[] wasServicesAndServersPairs) {
        this.wasServicesAndServersPairs = wasServicesAndServersPairs;
    }

    public String getEclipseJarPath() {
        return this.eclipseJarPath;
    }

    public void setEclipseJarPath(String eclipseJarPath) {
        this.eclipseJarPath = eclipseJarPath;
    }

    public String getEclipseLocation() {
        return this.eclipseLocation;
    }

    public void setEclipseLocation(String eclipseLocation) {
        this.eclipseLocation = eclipseLocation;
    }

    public String getJavaPath() {
        return this.javaPath;
    }

    public void setJavaPath(String javaPath) {
        this.javaPath = javaPath;
    }
}

