/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.panels;

import com.ibm.itcins.ica2.ICAInstConst;
import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICASoftwareObjectUtils;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ProcUtl;
import com.ibm.itcins.ica2.ProcessesUtl;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.Utilities;
import com.installshield.product.service.product.ProductService;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.SystemUtilService;
import com.installshield.wizard.swing.SwingWizardUI;
import com.installshield.wizardx.panels.UserInputField;
import com.installshield.wizardx.panels.UserInputPanel;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;

public class CIMAgentInstallSummaryPanel
extends UserInputPanel {
    private static int INSTALLED = 0;
    private static int FAILED = 1;
    private int status = FAILED;
    private String readMePath;
    private static final String INSTSUCC = "INSTSUCC";
    private static final String INSTWRN = "INSTWRN";
    private static final String INSTFAILED = "INSTFAILED";
    private String inst_return_visual_code = "INSTFAILED";
    static /* synthetic */ Class class$0;

    public boolean queryEnter(WizardBeanEvent event) {
        this.setEntered(false);
        if (!super.queryEnter(event)) {
            return false;
        }
        Vector<UserInputField> fields = new Vector<UserInputField>();
        UserInputField productInstLabel = new UserInputField();
        productInstLabel.setType(1);
        productInstLabel.setName("productFinalInstallationStateLabel");
        String reportedMsg = this.getProductInstallationState();
        productInstLabel.setValue(String.valueOf(reportedMsg) + "\n\n");
        fields.add(productInstLabel);
        if (this.status != FAILED) {
            String wasServiceDisplayName = this.getServiceDisplayName(this.resolveString("$W(startWASServer.serviceName)"), "startWASServer");
            try {
                SystemUtilService sus = (SystemUtilService)ICAInstGlobals.getService("systemUtilService");
                if (sus.isRebootRequired()) {
                    ICAInstGlobals.setInt("WASServerState", -1);
                    Object[] args = new String[]{wasServiceDisplayName};
                    String rebootReqMsg = ShowMessage.gi("Ins").resolve("Install.RebootRequired.StartServers", args, null);
                    ShowMessage.writeLogOutput(rebootReqMsg);
                    UserInputField rebootReqLabel = new UserInputField();
                    rebootReqLabel.setType(1);
                    rebootReqLabel.setValue(rebootReqMsg);
                    fields.add(rebootReqLabel);
                } else {
                    int wasServerState = this.getWASServerState();
                    UserInputField startedServicesLabel = new UserInputField();
                    startedServicesLabel.setType(1);
                    UserInputField servicesFailedToStartLabel = new UserInputField();
                    servicesFailedToStartLabel.setType(1);
                    String servicesStartedMsg = ShowMessage.gi("Ins").resolve("CimAgentSummaryPanel.ServicesStartedMsg", null, null);
                    String servicesFailedToStartMsg = ShowMessage.gi("Ins").resolve("CimAgentSummaryPanel.ServicesFailedToStartMsg", null, null);
                    int i = 0;
                    int ii = 0;
                    if (wasServerState == 0) {
                        servicesStartedMsg = String.valueOf(servicesStartedMsg) + "\n" + wasServiceDisplayName;
                        ++i;
                    } else {
                        servicesFailedToStartMsg = String.valueOf(servicesFailedToStartMsg) + "\n" + wasServiceDisplayName;
                        ++ii;
                    }
                    if (i > 0) {
                        startedServicesLabel.setValue(servicesStartedMsg);
                        fields.add(startedServicesLabel);
                    }
                    if (ii > 0) {
                        servicesFailedToStartLabel.setValue(servicesFailedToStartMsg);
                        fields.add(servicesFailedToStartLabel);
                        this.inst_return_visual_code = INSTWRN;
                    }
                }
            }
            catch (ServiceException se) {
                ShowMessage.writeLogOutput("wrn", se.toString());
                this.inst_return_visual_code = INSTWRN;
            }
            UserInputField logLabel = new UserInputField();
            logLabel.setType(1);
            logLabel.setName("logFinalInstallationLabel");
            logLabel.setValue(this.getLogLocation());
            logLabel.setInsets("20,0,0,0");
            fields.add(logLabel);
            if (this.readMeFileExists()) {
                UserInputField postInstallTasks = new UserInputField();
                postInstallTasks.setType(1);
                postInstallTasks.setName("postInstallTasks");
                String postInstallMsg = ShowMessage.gi("Ins").resolve("InstallSummaryPanel.ViewPostInstallTask", null, null);
                postInstallTasks.setValue(postInstallMsg);
                fields.add(postInstallTasks);
            }
            UserInputField clickFinishLabel = new UserInputField();
            clickFinishLabel.setType(1);
            clickFinishLabel.setName("clickFinishLabel");
            clickFinishLabel.setValue(this.getFinishMsg());
            clickFinishLabel.setInsets("20,0,0,0");
            fields.add(clickFinishLabel);
        }
        if (this.inst_return_visual_code.equals(INSTWRN)) {
            String wrnMsg = ShowMessage.gi("Ins").resolve("InstallSummaryPanel.InstallationWithWRN", null, null);
            ShowMessage.writeLogOutput("INSTWRN: " + wrnMsg);
            productInstLabel.setValue(String.valueOf(wrnMsg) + "\n\n");
        } else {
            ShowMessage.writeLogOutput(String.valueOf(this.inst_return_visual_code) + ": " + reportedMsg);
        }
        UserInputField[] theFields = new UserInputField[fields.size()];
        theFields = fields.toArray(theFields);
        super.setFields(theFields);
        return true;
    }

    public boolean entered(WizardBeanEvent event) {
        SwingWizardUI swingUI;
        boolean ret = super.entered(event);
        ShowMessage.gi("Ins").setWizardTitle(this);
        String initialNextButtonLabel = (String)this.getWizard().getServices().getValue("InitialNextLabel");
        WizardUI ui = event.getUserInterface();
        if (ui != null && ui instanceof SwingWizardUI && (swingUI = (SwingWizardUI)ui) != null && swingUI.getNavigationController().next() instanceof JButton) {
            ((JButton)swingUI.getNavigationController().next()).setText(initialNextButtonLabel);
            ((JButton)swingUI.getNavigationController().back()).setEnabled(false);
        }
        this.setEntered(ret);
        return ret;
    }

    public void exited(WizardBeanEvent event) {
        if (this.status != FAILED && this.readMeFileExists()) {
            this.viewPostInstInstructions();
        }
        super.exited(event);
        ShowMessage.gi("Ins").setWizardTitle(null);
    }

    public void execute(WizardBeanEvent event) {
        String reportedMsg = this.getProductInstallationState();
        if (this.status != FAILED) {
            String wasServiceDisplayName = this.getServiceDisplayName(this.resolveString("$W(startWASServer.serviceName)"), "startWASServer");
            try {
                SystemUtilService sus = (SystemUtilService)ICAInstGlobals.getService("systemUtilService");
                if (sus.isRebootRequired()) {
                    ICAInstGlobals.setInt("WASServerState", -1);
                    Object[] args = new String[]{wasServiceDisplayName};
                    String rebootReqMsg = ShowMessage.gi("Ins").resolve("Install.RebootRequired.StartServers", args, null);
                    ShowMessage.writeLogOutput(rebootReqMsg);
                } else {
                    int wasServerState = this.getWASServerState();
                    String servicesStartedMsg = ShowMessage.gi("Ins").resolve("CimAgentSummaryPanel.ServicesStartedMsg", null, null);
                    String servicesFailedToStartMsg = ShowMessage.gi("Ins").resolve("CimAgentSummaryPanel.ServicesFailedToStartMsg", null, null);
                    int i = 0;
                    int ii = 0;
                    if (wasServerState == 0) {
                        servicesStartedMsg = String.valueOf(servicesStartedMsg) + "\n" + wasServiceDisplayName;
                        ++i;
                    } else {
                        servicesFailedToStartMsg = String.valueOf(servicesFailedToStartMsg) + "\n" + wasServiceDisplayName;
                        ++ii;
                    }
                    if (i > 0) {
                        ShowMessage.writeLogOutput(servicesStartedMsg);
                    }
                    if (ii > 0) {
                        ShowMessage.writeLogOutput("wrn", servicesFailedToStartMsg);
                        this.inst_return_visual_code = INSTWRN;
                    }
                }
            }
            catch (ServiceException se) {
                ShowMessage.writeLogOutput("wrn", se.toString());
                this.inst_return_visual_code = INSTWRN;
            }
        }
        if (this.inst_return_visual_code.equals(INSTWRN)) {
            String wrnMsg = ShowMessage.gi("Ins").resolve("InstallSummaryPanel.InstallationWithWRN", null, null);
            wrnMsg = String.valueOf(wrnMsg) + " ";
            wrnMsg = String.valueOf(wrnMsg) + ShowMessage.gi("Ins").resolve("ICAInstall.Wrn", new String[]{ICAStringUtils.goodSlashes(this.getWizard().getWizardLog().getLogOutput())}, null);
            ShowMessage.writeLogOutput("INSTWRN: " + wrnMsg);
        } else {
            ShowMessage.writeLogOutput(String.valueOf(this.inst_return_visual_code) + ": " + reportedMsg);
        }
        if (this.status == FAILED) {
            String consoleMsg = ShowMessage.gi("Ins").resolve("ICAInstall.Errors", new String[]{ICAStringUtils.goodSlashes(this.getWizard().getWizardLog().getLogOutput())}, null);
            this.getWizard().exit(2, consoleMsg);
        }
    }

    private String getProductInstallationState() {
        String retMsg = "";
        int finalInstStatus = ICAInstGlobals.getInt("WizardActionInstallationStatus", 0);
        boolean patch = new Boolean(this.resolveString("$P(patch)"));
        switch (finalInstStatus) {
            case 2: {
                retMsg = patch ? String.valueOf(ShowMessage.gi("Ins").resolve("InstallSummaryPanel.PatchFailedInstallation", null, null)) + "\n\n" + ShowMessage.gi("Ins").resolve("InstallSummaryPanel.LookAtTheLog", new String[]{this.getWizard().getWizardLog().getLogOutput()}, null) : String.valueOf(ShowMessage.gi("Ins").resolve("InstallSummaryPanel.FailedInstallation", null, null)) + "\n\n" + ShowMessage.gi("Ins").resolve("InstallSummaryPanel.LookAtTheLog", new String[]{this.getWizard().getWizardLog().getLogOutput()}, null);
                this.inst_return_visual_code = INSTFAILED;
                break;
            }
            case 1: {
                retMsg = patch ? ShowMessage.gi("Ins").resolve("InstallSummaryPanel.PatchCanceledInstallation", null, null) : ShowMessage.gi("Ins").resolve("InstallSummaryPanel.CanceledInstallation", null, null);
                this.inst_return_visual_code = INSTFAILED;
                break;
            }
            default: {
                if (ICASoftwareObjectUtils.successInstall()) {
                    this.status = INSTALLED;
                    retMsg = patch ? ShowMessage.gi("Ins").resolve("InstallSummaryPanel.PatchSuccessfulInstallation", null, null) : ShowMessage.gi("Ins").resolve("InstallSummaryPanel.SuccessfulInstallation", null, null);
                    int wrnStatus = ICAInstGlobals.getInt("WizardActionInstallationStatusWarnings", 0);
                    if (wrnStatus == 8) {
                        this.inst_return_visual_code = INSTWRN;
                        break;
                    }
                    this.inst_return_visual_code = INSTSUCC;
                    break;
                }
                this.status = FAILED;
                retMsg = this.getSummary();
                this.inst_return_visual_code = INSTFAILED;
            }
        }
        return retMsg;
    }

    private String getLogLocation() {
        String logLocation = ShowMessage.getLogNameForDisplay(this.getWizard().getWizardLog().getLogOutput());
        boolean patch = new Boolean(this.resolveString("$P(patch)"));
        String whereisthelog = patch ? ShowMessage.gi("Ins").resolve("InstallSummaryPanel.PatchInstallLogCanBeFound", new String[]{logLocation}, null) : ShowMessage.gi("Ins").resolve("InstallSummaryPanel.InstallLogCanBeFound", new String[]{logLocation}, null);
        return whereisthelog;
    }

    private String getFinishMsg() {
        String pushTheButton = null;
        pushTheButton = this.isLast() ? ShowMessage.gi("Ins").resolve("InstallSummaryPanel.ChooseFinishMessage", null, null) : ShowMessage.gi("Ins").resolve("InstallSummaryPanel.ClickNext", null, null);
        return pushTheButton;
    }

    private String getSummary() {
        try {
            ProductService service = (ProductService)this.getService("productService");
            Properties summary = service.getProductSummary("/product.xml", 2, "text");
            return summary.getProperty("summary.msg");
        }
        catch (ServiceException e) {
            this.logEvent(this, "err", e);
            return "errorOccured" + e.getMessage();
        }
    }

    private boolean isLast() {
        boolean flag = true;
        if (this.getWizard() != null && this.getWizard().getIterator() != null && this.getWizard().getCurrentBean() != null) {
            flag = this.getWizard().getIterator().getNext(this.getWizard().getCurrentBean()) == this.getWizard().getIterator().end();
        }
        return flag;
    }

    private String getViewer() {
        String osName = System.getProperty("os.name", "").toUpperCase();
        String rez = "cmd.exe /c start \"\" ";
        if (osName.startsWith("WINDOWS")) {
            rez = "cmd.exe /c start \"\" ";
        } else if (osName.startsWith("AIX")) {
            rez = "/usr/dt/bin/dtterm -e more ";
        } else if (osName.startsWith("LINUX")) {
            rez = new File("/usr/bin/X11/kterm").exists() ? "/usr/bin/X11/kterm -e /usr/bin/less " : "/usr/bin/X11/xterm -e /usr/bin/less ";
        }
        return rez;
    }

    void setReadMeFilePath(String readMePath) {
        this.readMePath = readMePath;
    }

    String getReadMeFilePath() {
        return this.readMePath;
    }

    boolean readMeFileExists() {
        ICAInstConst bundle;
        String postInstInstrFile;
        String fileToViewName;
        boolean fileExists = false;
        File fileToView = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.itcins.ica2.ICAInstConst");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((fileToViewName = ICAStringUtils.getLocalizedFileName(postInstInstrFile = (bundle = (ICAInstConst)Utilities.instantiate(clazz.getName())).getString("postInstallInstrunctionFile", "doc/postinstallation.txt"), Locale.getDefault())) != null && (fileToView = new File(fileToViewName)) != null && fileToView.exists()) {
            this.setReadMeFilePath(fileToView.getAbsolutePath());
            fileExists = true;
        }
        return fileExists;
    }

    public void viewPostInstInstructions() {
        File fileToView = new File(this.getReadMeFilePath());
        if (fileToView != null && fileToView.exists()) {
            ProcUtl proc = new ProcUtl();
            StringBuffer stdout = new StringBuffer();
            StringBuffer stderr = new StringBuffer();
            StringBuffer cmd = new StringBuffer();
            cmd.append(this.getViewer());
            cmd.append(Utilities.quote(fileToView.getAbsolutePath()));
            try {
                int rc = 0;
                rc = proc.system(cmd.toString(), false, null, stdout, stderr);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!proc.isProcessRunning() && (rc = proc.waitForProcess()) != 0) {
                    String mes = ShowMessage.gi("Ins").resolve("InstallSummaryPanel.ErrorOpenFile", new String[]{fileToView.getAbsolutePath(), stderr.toString()}, null);
                    ShowMessage.writeLogOutput(mes);
                }
            }
            catch (IOException ioException) {
                ShowMessage.writeLogOutput(ShowMessage.gi("Ins").resolve("Install.IOExceptionOccured", new String[]{ioException.toString()}, null));
            }
        }
    }

    private int getWASServerState() {
        String retMsg = "";
        int finalInstStatus = ICAInstGlobals.getInt("WizardActionInstallationStatus", 0);
        int slpAgentState = ICAInstGlobals.getInt("WASServerState", -1);
        block0 : switch (finalInstStatus) {
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                if (!ICASoftwareObjectUtils.successInstall()) break;
                String wasServiceName = this.getServiceDisplayName(this.resolveString("$W(startWASServer.serviceDisplayName)"), "startWASServer");
                switch (slpAgentState) {
                    case 2: {
                        String slpAgentFailedStartingMsg = ShowMessage.gi("Ins").resolve("Install.StartingServerFailed", new String[]{wasServiceName}, null);
                        String WRN = ShowMessage.gi("Ins").resolve("WARNING !", null, null);
                        retMsg = String.valueOf(WRN) + " " + slpAgentFailedStartingMsg;
                        break block0;
                    }
                    case 0: {
                        String slpAgentStartedMsg;
                        retMsg = slpAgentStartedMsg = ShowMessage.gi("Ins").resolve("Install.ServerStarted", new String[]{wasServiceName}, null);
                        break block0;
                    }
                    case 3: {
                        String slpAgentAlrdStartedMsg;
                        retMsg = slpAgentAlrdStartedMsg = ShowMessage.gi("Ins").resolve("Install.ServerAlreadyRunning", new String[]{wasServiceName}, null);
                        break block0;
                    }
                }
            }
        }
        return slpAgentState;
    }

    private String getServiceDisplayName(String serviceName, String beanId) {
        ProcessesUtl utl = ProcessesUtl.instantiate(this);
        String description = null;
        try {
            description = utl.getServiceDescription(serviceName);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return Utilities.isWindows() ? description : this.resolveString("(" + beanId + ".serviceDisplayName)");
    }
}

