/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.panels;

import com.ibm.itcins.ica2.CimomActions;
import com.ibm.itcins.ica2.ICAInstConst;
import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.PortUtils;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.Utilities;
import com.ibm.itcins.ica2.Utl;
import com.installshield.util.FileUtils;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardPanel;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.swing.SwingWizardUI;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;

public class CIMAgentWASPortsPanel
extends WizardPanel {
    private String initialNextButtonLabel = "";
    ICAInstConst bundle;
    private boolean readPortsVar;
    private int portSOAP;
    private int portRMI;
    private int portHTTP;
    private int portHTTPS;
    private int minimumPort;
    private int maximumPort;
    private String userSOAPPort;
    private String userRMIPort;
    private String userHTTPPort;
    private String userHTTPSPort;
    private final String defSOAPPort;
    private final String defRMIPort;
    private final String defHTTPPort;
    private final String defHTTPSPort;
    private String text0;
    private String text1;
    private String text2;
    private String text3;
    private String errorReadingConfig;
    public int preSOAPport;
    private static final String[] PORT_FIELD_NAMES = new String[]{"portSOAP", "portRMI", "portHTTP", "portHTTPS"};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CIMAgentWASPortsPanel() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.itcins.ica2.ICAInstConst");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.bundle = (ICAInstConst)Utilities.instantiate(clazz.getName());
        this.readPortsVar = false;
        this.minimumPort = Integer.parseInt(this.bundle.getString("minPortVal"));
        this.maximumPort = Integer.parseInt(this.bundle.getString("maxPortVal"));
        this.userSOAPPort = "";
        this.userRMIPort = "";
        this.userHTTPPort = "";
        this.userHTTPSPort = "";
        this.defSOAPPort = new String(this.bundle.getString("SOAPport"));
        this.defRMIPort = new String(this.bundle.getString("RMIport"));
        this.defHTTPPort = new String(this.bundle.getString("HTTPport"));
        this.defHTTPSPort = new String(this.bundle.getString("HTTPSport"));
        this.text0 = "";
        this.text1 = "";
        this.text2 = "";
        this.text3 = "";
        this.errorReadingConfig = null;
        this.preSOAPport = -1;
    }

    public void setPortSOAP(int port) {
        this.portSOAP = port;
        this.propertyChanged("portSOAP");
    }

    public int getPortSOAP() {
        return this.portSOAP;
    }

    public void setPortRMI(int port) {
        this.portRMI = port;
        this.propertyChanged("portRMI");
    }

    public int getPortRMI() {
        return this.portRMI;
    }

    public void setPortHTTP(int port) {
        this.portHTTP = port;
        this.propertyChanged("portHTTP");
    }

    public int getPortHTTP() {
        return this.portHTTP;
    }

    public void setPortHTTPS(int port) {
        this.portHTTPS = port;
        this.propertyChanged("portHTTPS");
    }

    public int getPortHTTPS() {
        return this.portHTTPS;
    }

    void setMaximumPort(int maximumPort) {
        this.maximumPort = maximumPort;
    }

    int getMaximumPort() {
        return this.maximumPort;
    }

    void setMinimumPort(int minimumPort) {
        this.minimumPort = minimumPort;
    }

    int getMinimumPort() {
        return this.minimumPort;
    }

    protected void setUserSOAPPort(String port) {
        this.userSOAPPort = port;
    }

    protected String getUserSOAPPort() {
        return this.userSOAPPort;
    }

    protected void setUserRMIPort(String port) {
        this.userRMIPort = port;
    }

    protected String getUserRMIPort() {
        return this.userRMIPort;
    }

    protected void setUserHTTPPort(String port) {
        this.userHTTPPort = port;
    }

    protected String getUserHTTPPort() {
        return this.userHTTPPort;
    }

    protected void setUserHTTPSPort(String port) {
        this.userHTTPSPort = port;
    }

    protected String getUserHTTPSPort() {
        return this.userHTTPSPort;
    }

    protected String getDefSOAPPort() {
        return this.defSOAPPort;
    }

    protected String getDefRMIPort() {
        return this.defRMIPort;
    }

    protected String getDefHTTPPort() {
        return this.defHTTPPort;
    }

    protected String getDefHTTPSPort() {
        return this.defHTTPSPort;
    }

    String getInitialNextButtonLabel() {
        return this.initialNextButtonLabel;
    }

    void setInitialNextButtonLabel(String initialNextButtonLabel) {
        this.initialNextButtonLabel = initialNextButtonLabel;
        this.propertyChanged("initialNextButtonLabel");
    }

    public boolean entered(WizardBeanEvent event) {
        SwingWizardUI swingUI;
        boolean ret = super.entered(event);
        ShowMessage.gi("ICAIns").setWizardTitle(this);
        String nextButtonLabel = (String)this.getWizard().getServices().getValue("InitialNextLabel");
        this.setInitialNextButtonLabel(nextButtonLabel);
        WizardUI ui = event.getUserInterface();
        if (ui != null && ui instanceof SwingWizardUI && (swingUI = (SwingWizardUI)ui) != null && swingUI.getNavigationController().next() instanceof JButton) {
            ((JButton)swingUI.getNavigationController().next()).setText(nextButtonLabel);
        }
        if (this.errorReadingConfig != null) {
            ShowMessage.gi("ICAIns").dispError0(this, "", this.errorReadingConfig);
        }
        this.setEntered(ret);
        return ret;
    }

    private boolean refreshPorts(String portArray, int ii) {
        String msg = null;
        if (ii == 0) {
            if (portArray == null) {
                this.setPortSOAP(Integer.parseInt(this.getDefSOAPPort()));
                msg = ShowMessage.gi("ICAIns").resolve("CIMAgentPortsPanelSwingImpl.readErr", new String[]{this.text0}, null);
                ShowMessage.writeLogOutput(msg);
            } else if (!this.validatePort(portArray, 0)) {
                msg = ShowMessage.gi("ICAIns").resolve("ICAInstall.ErrorsReadConfig", new String[]{this.text0}, null);
                ShowMessage.writeLogOutput(msg);
                return false;
            }
        }
        if (ii == 1) {
            if (portArray == null) {
                this.setPortRMI(Integer.parseInt(this.getDefRMIPort()));
                msg = ShowMessage.gi("ICAIns").resolve("CIMAgentPortsPanelSwingImpl.readErr", new String[]{this.text1}, null);
                ShowMessage.writeLogOutput(msg);
            } else if (!this.validatePort(portArray, 1)) {
                msg = ShowMessage.gi("ICAIns").resolve("ICAInstall.ErrorsReadConfig", new String[]{this.text1}, null);
                ShowMessage.writeLogOutput(msg);
                return false;
            }
        }
        if (ii == 2) {
            if (portArray == null) {
                this.setPortHTTP(Integer.parseInt(this.getDefHTTPPort()));
                msg = ShowMessage.gi("ICAIns").resolve("CIMAgentPortsPanelSwingImpl.readErr", new String[]{this.text2}, null);
                ShowMessage.writeLogOutput(msg);
            } else if (!this.validatePort(portArray, 2)) {
                msg = ShowMessage.gi("ICAIns").resolve("ICAInstall.ErrorsReadConfig", new String[]{this.text2}, null);
                ShowMessage.writeLogOutput(msg);
                return false;
            }
        }
        if (ii == 3) {
            if (portArray == null) {
                this.setPortHTTPS(Integer.parseInt(this.getDefHTTPSPort()));
                msg = ShowMessage.gi("ICAIns").resolve("CIMAgentPortsPanelSwingImpl.readErr", new String[]{this.text3}, null);
                ShowMessage.writeLogOutput(msg);
            } else if (!this.validatePort(portArray, 3)) {
                msg = ShowMessage.gi("ICAIns").resolve("ICAInstall.ErrorsReadConfig", new String[]{this.text3}, null);
                ShowMessage.writeLogOutput(msg);
                return false;
            }
        }
        return true;
    }

    public boolean queryEnter(WizardBeanEvent event) {
        this.setEntered(false);
        if (!super.queryEnter(event)) {
            return false;
        }
        this.errorReadingConfig = null;
        String servicesFile = "";
        String servicesPathWin = this.bundle.getString("servicesPathWin");
        servicesFile = ICAStringUtils.isWindows() ? String.valueOf(Utl.instantiate(this).getSystemDrive()) + servicesPathWin : this.bundle.getString("servicesFile");
        this.setDescription(ShowMessage.gi("ICAIns").resolve("CIMAgentPortsPanel.description", new String[]{servicesFile}, null));
        ICAInstGlobals.setBoolean("readPortsVar", this.readPortsVar);
        CimomActions actions = CimomActions.instantiate(this, 'I');
        int j = actions.getSaveConfigurationVar();
        this.text0 = ShowMessage.gi("ICAIns").resolve("CIMAgentPortsPanel.labelSOAP", null, null);
        this.text1 = ShowMessage.gi("ICAIns").resolve("CIMAgentPortsPanel.labelRMI", null, null);
        this.text2 = ShowMessage.gi("ICAIns").resolve("CIMAgentPortsPanel.labelHTTP", null, null);
        this.text3 = ShowMessage.gi("ICAIns").resolve("CIMAgentPortsPanel.labelHTTPS", null, null);
        String val = ICAInstGlobals.getString("saveConfiguration");
        if (val != null && val.equalsIgnoreCase("YES")) {
            try {
                String installedVersion = ICAInstGlobals.getString("installedVersion");
                if (!installedVersion.equals("")) {
                    this.setPortSOAP(new Integer(CIMAgentWASPortsPanel.readPorts(0)));
                    this.setPortRMI(new Integer(CIMAgentWASPortsPanel.readPorts(1)));
                    this.setPortHTTP(new Integer(CIMAgentWASPortsPanel.readPorts(2)));
                    this.setPortHTTPS(new Integer(CIMAgentWASPortsPanel.readPorts(3)));
                    return false;
                }
            }
            catch (Exception e) {
                return true;
            }
        }
        return true;
    }

    public boolean queryExit(WizardBeanEvent event) {
        if (!this.isEntered()) {
            return false;
        }
        if (this.errorReadingConfig != null) {
            ShowMessage.gi("ICAIns").dispError0(this, "", this.errorReadingConfig);
            return false;
        }
        String[] labelPort = new String[]{this.text0, this.text1, this.text2, this.text3};
        String[] portArray = new String[]{this.userSOAPPort, this.userRMIPort, this.userHTTPPort, this.userHTTPSPort};
        int ii = 0;
        while (ii < portArray.length) {
            if (!this.validatePort(portArray[ii], ii)) {
                String text = ShowMessage.gi("ICAIns").resolve("CIMAgentPortsPanel.validate", new String[]{"" + this.minimumPort, "" + this.maximumPort, portArray[ii], labelPort[ii]}, null);
                ShowMessage.gi("ICAIns").dispError0(this, "", text);
                return false;
            }
            ++ii;
        }
        if (!this.duplicatePorts()) {
            String text = ShowMessage.gi("ICAIns").resolve("CIMAgentPortsPanel.DuplicatePort", null, null);
            ShowMessage.gi("ICAIns").dispError0(this, "", text);
            return false;
        }
        PortUtils pu = new PortUtils();
        String portsInUseList = pu.getWasPortsInUse(new int[]{this.getPortSOAP(), this.getPortRMI(), this.getPortHTTP(), this.getPortHTTPS()});
        if (portsInUseList != null && portsInUseList.trim().length() > 0) {
            if (new Integer(this.getPortSOAP()).toString().equals(portsInUseList) && this.preSOAPport == this.getPortSOAP()) {
                String text = ShowMessage.gi("ICAIns").resolve("CIMAgentPortsPanel.SOAPPortsInUse", new String[]{portsInUseList}, null);
                ShowMessage.gi("ICAIns").dispError0(this, "", text);
            } else {
                String text = ShowMessage.gi("ICAIns").resolve("CIMAgentPortsPanel.PortsInUse", new String[]{portsInUseList}, null);
                ShowMessage.gi("ICAIns").dispError0(this, "", text);
            }
            return false;
        }
        ICAInstGlobals.setString("usrSOAPPort", this.resolveString("$W(ports.portSOAP)"));
        ICAInstGlobals.setString("usrRMIPort", this.resolveString("$W(ports.portRMI)"));
        ICAInstGlobals.setString("usrHTTPPort", this.resolveString("$W(ports.portHTTP)"));
        ICAInstGlobals.setString("usrHTTPSPort", this.resolveString("$W(ports.portHTTPS)"));
        return true;
    }

    public boolean duplicatePorts() {
        int[] portInt = new int[6];
        int cimHttpPort = 0;
        int cimHttpsPort = 0;
        try {
            cimHttpPort = Integer.parseInt(this.resolveString("$W(serverCommunicationConfig.httpPort)"));
        }
        catch (NumberFormatException ex) {
            cimHttpPort = 0;
        }
        try {
            cimHttpsPort = Integer.parseInt(this.resolveString("$W(serverCommunicationConfig.httpsPort)"));
        }
        catch (NumberFormatException ex) {
            cimHttpsPort = 0;
        }
        portInt = new int[]{cimHttpPort, cimHttpsPort, this.getPortSOAP(), this.getPortRMI(), this.getPortHTTP(), this.getPortHTTPS()};
        int k = 2;
        while (k < portInt.length) {
            int i = 0;
            while (i < k) {
                if (portInt[k] == portInt[i]) {
                    this.selectImplField(PORT_FIELD_NAMES[k - 2]);
                    return false;
                }
                ++i;
            }
            ++k;
        }
        return true;
    }

    private boolean validatePort(String port, int iii) {
        try {
            int portValue = Integer.parseInt(port);
            if (portValue >= this.minimumPort && portValue <= this.maximumPort) {
                if (iii == 0) {
                    this.setPortSOAP(portValue);
                }
                if (iii == 1) {
                    this.setPortRMI(portValue);
                }
                if (iii == 2) {
                    this.setPortHTTP(portValue);
                }
                if (iii == 3) {
                    this.setPortHTTPS(portValue);
                }
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.selectImplField(PORT_FIELD_NAMES[iii]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void exited(WizardBeanEvent event) {
        super.exited(event);
        ShowMessage.gi("ICAIns").setWizardTitle(null);
    }

    public static String readPorts(int portNr) {
        String fileName = null;
        String startTag = null;
        String userPort = null;
        String fs = File.separator;
        String instDest = ICAInstGlobals.getServices().resolveString("$P(absoluteInstallLocation)");
        instDest = String.valueOf(ICAStringUtils.removeLastSlash(instDest)) + fs;
        String keytarget = ICAInstGlobals.getString("backupKey");
        fileName = FileUtils.createFileName(keytarget, "serverindex.xml");
        startTag = "specialEndpoints";
        String[] portName = new String[]{"SOAP_CONNECTOR_ADDRESS", "BOOTSTRAP_ADDRESS", "WC_defaulthost", "WC_defaulthost_secure"};
        userPort = CIMAgentWASPortsPanel.findPort(fileName, portName[portNr], startTag);
        return userPort;
    }

    public static String findPort(String fileName, String portName, String startTag) {
        StringBuffer wholebuf = new StringBuffer("");
        String portVal = null;
        FileService sfs = null;
        startTag = "<" + startTag;
        StringBuffer stopT = new StringBuffer(startTag);
        stopT.insert(1, "/").insert(stopT.length(), ">");
        String stopTag = new String(stopT);
        String[] fileLine = null;
        try {
            sfs = (FileService)ICAInstGlobals.getServices().getService("fileService");
            if (sfs.fileExists(fileName)) {
                fileLine = sfs.readAsciiFile(fileName);
                int j = 0;
                while (j < fileLine.length) {
                    if (fileLine[j] != null) {
                        wholebuf.append(fileLine[j]).append(" ");
                    }
                    ++j;
                }
            }
            String wholef = new String(wholebuf);
            int pos2 = 0;
            boolean yet = false;
            while (!yet) {
                int pos1 = wholef.indexOf(startTag, pos2);
                if (pos1 < 0) {
                    yet = true;
                    continue;
                }
                pos2 = wholef.indexOf(stopTag, pos1);
                if (pos2 < 0) {
                    yet = true;
                    continue;
                }
                String elem = wholef.substring(pos1 + startTag.length(), pos2);
                int pos3 = elem.indexOf(portName);
                if (pos3 < 0) {
                    pos2 += stopTag.length();
                    continue;
                }
                int pos4 = elem.indexOf("port=\"", pos3);
                if (pos4 < 0) {
                    yet = true;
                    continue;
                }
                int pos5 = elem.indexOf("\"", pos4 + 6);
                if (pos5 < 0) {
                    yet = true;
                    continue;
                }
                portVal = elem.substring(pos4 + 6, pos5);
                yet = true;
            }
        }
        catch (ServiceException serviceException) {
            ShowMessage.gi("ICAIns").resolve("ICAInstall.ServiceExceptionOccured", new String[]{serviceException.toString()}, null);
        }
        catch (Exception ex) {
            String text = ShowMessage.gi("ICAIns").resolve("CIMAgentPortsPanel.parsingError", new String[]{ex.toString(), portName, fileName}, null);
            ShowMessage.writeLogOutput(text);
            portVal = null;
        }
        return portVal;
    }

    public void build(WizardBuilderSupport support) {
        super.build(support);
        support.putRequiredService("productService");
        support.putRequiredService("fileService");
        try {
            support.putResourceBundles("com.installshield.product.i18n.ProductResources");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("com.ibm.itcins.ica2.VersionComparator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            support.putClass(clazz.getName());
        }
        catch (IOException e) {
            support.logEvent(this, "err", e);
        }
    }
}

