/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.panels;

import com.ibm.itcins.ica2.ShowMessage;
import com.installshield.product.service.product.ProductService;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.swing.SwingWizardUI;
import com.installshield.wizardx.panels.TextDisplayPanel;
import java.io.File;
import java.util.Properties;
import javax.swing.JButton;

public class ICA2SpaceCheckPanel
extends TextDisplayPanel {
    private int requiredMB = 416;
    private String text = "";
    private boolean spaceAvailable = true;

    public void exited(WizardBeanEvent event) {
        super.exited(event);
        ShowMessage.gi("ICAIns").setWizardTitle(null);
    }

    private boolean checkSpaceAvailable() {
        String installFS;
        long needSpace;
        long availSpace;
        block8: {
            availSpace = -1L;
            needSpace = -1L;
            String tempSpace = "";
            int sindex = -1;
            int eindex = -1;
            installFS = null;
            String summaryMsg = this.getSummary();
            sindex = summaryMsg.indexOf("size:<blockquote> ");
            if (sindex != -1 && (eindex = summaryMsg.indexOf(" MB</blockquote>")) != -1) {
                tempSpace = summaryMsg.substring(sindex + 18, eindex);
                this.requiredMB = (eindex = tempSpace.indexOf(".")) != -1 ? Integer.valueOf(tempSpace.substring(0, eindex)).intValue() : Integer.valueOf(tempSpace).intValue();
            }
            ShowMessage.writeLogOutput(String.valueOf(this.requiredMB));
            FileService sfs = (FileService)this.getServices().getService("fileService");
            String dir = this.resolveString("$P(absoluteInstallLocation)");
            if (dir != null && dir.trim().length() > 0) {
                dir = new File(dir).getAbsolutePath();
                String[] partitions = sfs.getPartitionNames();
                installFS = sfs.getPartitionName(dir, partitions);
                availSpace = sfs.getPartitionFreeSpace(installFS);
            }
            if (availSpace >= 0L) break block8;
            this.text = ShowMessage.gi("ICAIns").resolve("ICAInstall.CannotFindOutAvailSpace", null, null);
            return false;
        }
        try {
            if (availSpace < (long)this.requiredMB * 0x100000L) {
                if (installFS.length() > 1 && (installFS.endsWith("/") || installFS.endsWith("\\"))) {
                    installFS = installFS.substring(0, installFS.length() - 1);
                }
                if (installFS.endsWith(":")) {
                    installFS = installFS.substring(0, installFS.length() - 1);
                    installFS = ShowMessage.gi("ICAIns").resolve("ICAInstall.drive", new String[]{installFS}, null);
                }
                needSpace = ((long)this.requiredMB * 0x100000L - availSpace) / 0x100000L + 1L;
                this.text = ShowMessage.gi("ICAIns").resolve("ICAInstall.NoEnoughAvailSpace", new String[]{installFS, String.valueOf(needSpace)}, null);
                return false;
            }
        }
        catch (ServiceException e) {
            ShowMessage.writeLogOutput("Space check failed");
            e.printStackTrace();
        }
        return true;
    }

    public boolean queryEnter(WizardBeanEvent wizardbeanevent) {
        this.setEntered(false);
        ShowMessage.gi("ICAIns").setWizardTitle(this);
        String s = this.resolveString(this.getBusyMessage());
        if (s != null && s.length() > 0) {
            wizardbeanevent.getUserInterface().setBusy(s);
        }
        this.spaceAvailable = this.checkSpaceAvailable();
        return super.queryEnter(wizardbeanevent);
    }

    public boolean queryExit(WizardBeanEvent wizardbeanevent) {
        if (!this.isEntered()) {
            return false;
        }
        return super.queryExit(wizardbeanevent);
    }

    public boolean entered(WizardBeanEvent event) {
        SwingWizardUI swingUI;
        boolean rez = super.entered(event);
        this.setEntered(rez);
        String initialNextButtonLabel = (String)this.getWizard().getServices().getValue("InitialNextLabel");
        WizardUI ui = event.getUserInterface();
        if (ui != null && ui instanceof SwingWizardUI && (swingUI = (SwingWizardUI)ui) != null && swingUI.getNavigationController().next() instanceof JButton) {
            ((JButton)swingUI.getNavigationController().next()).setText(initialNextButtonLabel);
            if (!this.spaceAvailable) {
                swingUI.setStopped(true);
                this.setText(this.text);
            } else {
                return false;
            }
        }
        return rez;
    }

    String getSummary() {
        try {
            ProductService productservice = (ProductService)this.getService("productService");
            Properties properties = productservice.getProductSummary("/product.xml", 1, "html");
            return properties.getProperty("summary.msg");
        }
        catch (ServiceException serviceexception) {
            this.logEvent(this, "err", serviceexception);
            return String.valueOf(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "errorOccured")) + serviceexception;
        }
    }
}

