/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.panels;

import com.ibm.itcins.ica2.ShowMessage;
import com.installshield.product.SoftwareObject;
import com.installshield.product.service.product.ProductService;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.awt.AWTWizardUI;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.swing.SwingWizardUI;
import com.installshield.wizardx.panels.TextDisplayPanel;
import java.awt.Button;
import java.util.Properties;
import javax.swing.JButton;

public class ICA2UninstallSummary
extends TextDisplayPanel {
    private String initialNextButtonLabel = "";
    private WizardUI ui;
    private AWTWizardUI awtUI;
    private SwingWizardUI swingUI;
    private StringBuffer text = new StringBuffer();

    public boolean entered(WizardBeanEvent event) {
        boolean rc = super.entered(event);
        ShowMessage.gi("ICAIns").setWizardTitle(this);
        this.initialNextButtonLabel = (String)this.getWizard().getServices().getValue("InitialNextLabel");
        this.ui = event.getUserInterface();
        if (this.ui != null) {
            if (this.ui instanceof SwingWizardUI) {
                this.swingUI = (SwingWizardUI)this.ui;
                if (this.swingUI != null && this.swingUI.getNavigationController().next() instanceof JButton) {
                    ((JButton)this.swingUI.getNavigationController().next()).setText(this.initialNextButtonLabel);
                }
            } else if (this.ui instanceof AWTWizardUI) {
                this.awtUI = (AWTWizardUI)this.ui;
                if (this.awtUI != null && this.awtUI.getNavigationController().next() instanceof Button) {
                    ((Button)this.awtUI.getNavigationController().next()).setLabel(this.initialNextButtonLabel);
                }
            }
        }
        this.text.append(this.getSummary());
        this.text.append("<br>");
        this.text.append(ShowMessage.gi("ICAIns").resolve("ICA2UninstallSummary.notice", null, null));
        this.setText(this.text.toString().trim());
        return rc;
    }

    public void exited(WizardBeanEvent event) {
        super.exited(event);
        ShowMessage.gi("ICAIns").setWizardTitle(null);
    }

    private boolean isProductUninstalled() {
        String PRODUCT_URL = "/product.xml";
        ProductService prodService = null;
        SoftwareObject softwareobject = null;
        try {
            prodService = (ProductService)this.getServices().getService("productService");
            softwareobject = (SoftwareObject)((Object)prodService.getSoftwareObjectTree(PRODUCT_URL).getRoot());
        }
        catch (ServiceException exception) {
            this.logEvent(this, "err", exception.toString());
        }
        return softwareobject.getInstallStatus() == 4;
    }

    public void execute(WizardBeanEvent event) {
        String par = this.getWizard().getWizardLog().getLogOutput();
        if (!this.isProductUninstalled()) {
            String string = ShowMessage.gi("ICAIns").resolve("ICAInstall.Errors", new String[]{par}, null);
        }
    }

    String getSummary() {
        try {
            ProductService productservice = (ProductService)this.getService("productService");
            Properties properties = productservice.getProductSummary("/product.xml", 4, "html");
            return properties.getProperty("summary.msg");
        }
        catch (ServiceException serviceexception) {
            this.logEvent(this, "err", serviceexception);
            return String.valueOf(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "errorOccured")) + serviceexception;
        }
    }
}

