/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.panels;

import com.ibm.itcins.ica2.ICASoftwareObjectUtils;
import com.ibm.itcins.ica2.ShowMessage;
import com.installshield.util.FileUtils;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.swing.SwingWizardUI;
import com.installshield.wizardx.panels.TextDisplayPanel;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JButton;

public class ICA2UserCheckPanel
extends TextDisplayPanel {
    private String text = "";
    private boolean userlimit = false;

    public void exited(WizardBeanEvent event) {
        super.exited(event);
        ShowMessage.gi("ICAIns").setWizardTitle(null);
    }

    public boolean queryEnter(WizardBeanEvent wizardbeanevent) {
        this.setEntered(false);
        ShowMessage.gi("ICAIns").setWizardTitle(this);
        String s = this.resolveString(this.getBusyMessage());
        String log = ShowMessage.gi("ICAIns").resolve("ICAInstall.CheckUserAccount", null, null);
        ShowMessage.writeLogOutput(log);
        this.userlimit = false;
        if (s != null && s.length() > 0) {
            wizardbeanevent.getUserInterface().setBusy(s);
        }
        String[] oldInstallDirs = ICASoftwareObjectUtils.getProductInstallLocations("ibmcimagentsvc");
        String oldInstallDir = "";
        if (oldInstallDirs != null && oldInstallDirs.length > 0) {
            oldInstallDir = oldInstallDirs[0];
        } else if (ICASoftwareObjectUtils.isProductInstalled()) {
            oldInstallDir = ICASoftwareObjectUtils.getInstallingProductLastInstallationPath();
        }
        if (oldInstallDir == null || oldInstallDir.trim().length() == 0) {
            return false;
        }
        try {
            String sourceUsers = FileUtils.createFileName(oldInstallDir, "cimom/pegasus/cimserver.passwd");
            FileService sfs = (FileService)this.getService("fileService");
            int line = 0;
            String sentence = "";
            if (sfs.fileExists(sourceUsers)) {
                FileReader in = new FileReader(sourceUsers);
                BufferedReader br = new BufferedReader(in);
                while ((sentence = br.readLine()) != null) {
                    if (sentence.startsWith("superuser:")) continue;
                    ++line;
                }
                in.close();
                br.close();
            }
            if (line > 128) {
                this.text = ShowMessage.gi("ICAIns").resolve("ICAInstall.UserAccountExceed", new String[]{String.valueOf(line)}, null);
                this.userlimit = true;
                ShowMessage.writeLogOutput(this.text);
            }
        }
        catch (ServiceException e) {
            ShowMessage.writeLogOutput("CIMOM user account files reading failed");
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            ShowMessage.writeLogOutput("CIMOM user account files not found");
            e.printStackTrace();
        }
        catch (IOException e) {
            ShowMessage.writeLogOutput("CIMOM user account files reading failed");
            e.printStackTrace();
        }
        return super.queryEnter(wizardbeanevent);
    }

    public boolean queryExit(WizardBeanEvent wizardbeanevent) {
        if (!this.isEntered()) {
            return false;
        }
        return super.queryExit(wizardbeanevent);
    }

    public boolean entered(WizardBeanEvent event) {
        SwingWizardUI swingUI;
        boolean rez = super.entered(event);
        this.setEntered(rez);
        String initialNextButtonLabel = (String)this.getWizard().getServices().getValue("InitialNextLabel");
        WizardUI ui = event.getUserInterface();
        if (ui != null && ui instanceof SwingWizardUI && (swingUI = (SwingWizardUI)ui) != null && swingUI.getNavigationController().next() instanceof JButton) {
            ((JButton)swingUI.getNavigationController().next()).setText(initialNextButtonLabel);
            if (this.userlimit) {
                swingUI.setStopped(true);
                this.setText(this.text);
            } else {
                return false;
            }
        }
        return rez;
    }
}

