/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.panels;

import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.VersionComparator;
import com.installshield.util.FileUtils;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.swing.SwingWizardUI;
import com.installshield.wizardx.panels.UserInputField;
import com.installshield.wizardx.panels.UserInputPanel;
import java.util.Vector;
import javax.swing.JButton;

public class SVCMigrateInfoPanel
extends UserInputPanel {
    private String busyMessage = "";
    private String[] returnClusters = new String[]{"unknown"};
    private String[] clusterID = new String[]{"unknown"};
    private String[] clusterPassword = new String[]{"unknown"};
    private UserInputField[] pwField = null;
    private int clusterNum = 0;

    public boolean queryEnter(WizardBeanEvent event) {
        this.setEntered(false);
        if (!super.queryEnter(event)) {
            return false;
        }
        ICAInstGlobals.setValue("returnClusters", this.returnClusters);
        ICAInstGlobals.setValue("clusterPassword", this.clusterPassword);
        ICAInstGlobals.setValue("clusterID", this.clusterID);
        ICAInstGlobals.setValue("clusterNum", new Integer(this.clusterNum));
        String val = ICAInstGlobals.getString("saveConfiguration");
        boolean preserveConfig = val != null && val.toUpperCase().startsWith("Y");
        String installedVRMF = ICAInstGlobals.getString("installedVersion");
        VersionComparator comparator = new VersionComparator();
        int result = comparator.compare(installedVRMF, "5.1.0");
        if (result < 0 && preserveConfig) {
            ICAInstGlobals.setValue("MigrateUnsuccessInfo", "false");
            ICAInstGlobals.setValue("MigrateSuccessInfo", "false");
            ICAInstGlobals.setValue("MigrateErrorCode", "false");
            ICAInstGlobals.setValue("MigrateNoAccu", "false");
            this.clusterNum = this.getClusterList();
            if (this.clusterNum == 0) {
                return false;
            }
            Vector<UserInputField> fields = new Vector<UserInputField>();
            this.clusterPassword = new String[this.clusterNum];
            this.pwField = new UserInputField[this.clusterNum + 1];
            this.pwField[0] = new UserInputField();
            String clusterip = ShowMessage.gi("ICAIns").resolve("SVCMigrateInfoPanel.ClusterIP", null, null);
            String adminpw = ShowMessage.gi("ICAIns").resolve("SVCMigrateInfoPanel.AdminPassword", null, null);
            this.pwField[0].setCaption(clusterip);
            this.pwField[0].setCaptionLocation(2);
            this.pwField[0].setType(1);
            this.pwField[0].setValue(adminpw);
            fields.add(this.pwField[0]);
            int i = 1;
            while (i < this.clusterNum + 1) {
                this.pwField[i] = new UserInputField();
                this.pwField[i].setCaption(String.valueOf(this.returnClusters[i - 1]) + ":");
                this.pwField[i].setCaptionLocation(2);
                this.pwField[i].setType(3);
                this.pwField[i].setValue("");
                fields.add(this.pwField[i]);
                ++i;
            }
            UserInputField[] theFields = new UserInputField[fields.size()];
            theFields = fields.toArray(theFields);
            super.setFields(theFields);
            return true;
        }
        return false;
    }

    public boolean entered(WizardBeanEvent event) {
        SwingWizardUI swingUI;
        boolean ret = super.entered(event);
        ShowMessage.gi("Ins").setWizardTitle(this);
        String nextButtonLabel = (String)this.getWizard().getServices().getValue("InitialNextLabel");
        WizardUI ui = event.getUserInterface();
        if (ui != null && ui instanceof SwingWizardUI && (swingUI = (SwingWizardUI)ui) != null && swingUI.getNavigationController().next() instanceof JButton) {
            ((JButton)swingUI.getNavigationController().next()).setText(nextButtonLabel);
            ((JButton)swingUI.getNavigationController().back()).setEnabled(false);
        }
        this.setEntered(ret);
        return ret;
    }

    public void execute(WizardBeanEvent event) {
        this.getWizard().getServices().setValue("isSilentMode", new Boolean(true));
    }

    public void exited(WizardBeanEvent event) {
        super.exited(event);
        ShowMessage.gi("Ins").setWizardTitle(null);
    }

    public boolean queryExit(WizardBeanEvent event) {
        if (!this.isEntered()) {
            return false;
        }
        int i = 0;
        while (i < this.clusterNum) {
            this.clusterPassword[i] = this.pwField[i + 1].getValue();
            if (this.clusterPassword[i].equals("")) {
                String text = ShowMessage.gi("ICAIns").resolve("SVCMigrateInfoPanel.PasswordInvalid", null, null);
                ShowMessage.gi("ICAIns").dispError0(this, "", text);
                return false;
            }
            ++i;
        }
        ICAInstGlobals.setValue("returnClusters", this.returnClusters);
        ICAInstGlobals.setValue("clusterPassword", this.clusterPassword);
        ICAInstGlobals.setValue("clusterID", this.clusterID);
        ICAInstGlobals.setValue("clusterNum", new Integer(this.clusterNum));
        return true;
    }

    public void setBusyMessage(String busyMessage) {
        this.busyMessage = busyMessage;
    }

    public String getBusyMessage() {
        return this.busyMessage;
    }

    private int getClusterList() {
        String backupDir = ICAInstGlobals.getString("backupKey");
        String sourceDevice = FileUtils.createFileName(backupDir, "devices.txt");
        String[] clusterlist = null;
        int startIndex = -1;
        int endIndex = -1;
        int idsIndex = -1;
        int ideIndex = -1;
        try {
            FileService sfs = (FileService)this.getService("fileService");
            if (sfs.fileExists(sourceDevice)) {
                clusterlist = sfs.readAsciiFile(sourceDevice);
                this.returnClusters = new String[clusterlist.length];
                this.clusterID = new String[clusterlist.length];
                int i = 0;
                while (i < clusterlist.length) {
                    startIndex = clusterlist[i].indexOf("ip=\"");
                    endIndex = clusterlist[i].indexOf("\" user=\"");
                    if (startIndex != -1 && endIndex != -1) {
                        this.returnClusters[this.clusterNum] = new String(clusterlist[i].substring(startIndex + 4, endIndex));
                        idsIndex = clusterlist[i].indexOf("\" id=\"");
                        ideIndex = clusterlist[i].indexOf("\" connect=\"");
                        this.clusterID[this.clusterNum] = idsIndex != -1 && ideIndex != -1 ? new String(clusterlist[i].substring(idsIndex + 6, ideIndex)) : new String("");
                        ++this.clusterNum;
                    }
                    ++i;
                }
            }
        }
        catch (ServiceException e) {
            ShowMessage.writeLogOutput("Device Read failed");
            e.printStackTrace();
        }
        return this.clusterNum;
    }
}

