/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.panels;

import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.VersionComparator;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.swing.SwingWizardUI;
import com.installshield.wizardx.panels.UserInputField;
import com.installshield.wizardx.panels.UserInputPanel;
import java.util.Vector;
import javax.swing.JButton;

public class SVCMigrateResultPanel
extends UserInputPanel {
    public boolean queryEnter(WizardBeanEvent event) {
        this.setEntered(false);
        if (!super.queryEnter(event)) {
            return false;
        }
        String val = ICAInstGlobals.getString("saveConfiguration");
        boolean preserveConfig = val != null && val.toUpperCase().startsWith("Y");
        VersionComparator comparator = new VersionComparator();
        String installedVRMF = ICAInstGlobals.getString("installedVersion");
        int result = comparator.compare(installedVRMF, "5.1.0");
        if (result < 0 && preserveConfig) {
            String reportedUnSucMsg;
            String[] returnClusters = (String[])ICAInstGlobals.getValue("returnClusters");
            if (returnClusters[0] == "unknown") {
                return false;
            }
            Vector<UserInputField> fields = new Vector<UserInputField>();
            UserInputField migrateDisplayLabel = new UserInputField();
            migrateDisplayLabel.setType(1);
            String reportedMsg = ShowMessage.gi("Ins").resolve("SVCMigrateResultPanel.description", null, null);
            migrateDisplayLabel.setValue(reportedMsg);
            fields.add(migrateDisplayLabel);
            String reportedSucMsg = this.getSuccMigrationState();
            if (!reportedSucMsg.equals("")) {
                UserInputField succDisplayLabel = new UserInputField();
                succDisplayLabel.setType(1);
                succDisplayLabel.setValue(reportedSucMsg);
                fields.add(succDisplayLabel);
            }
            if (!(reportedUnSucMsg = this.getUnSuccMigrationState()).equals("")) {
                UserInputField unsuccDisplayLabel = new UserInputField();
                unsuccDisplayLabel.setType(1);
                unsuccDisplayLabel.setValue(reportedUnSucMsg);
                fields.add(unsuccDisplayLabel);
            }
            if (ICAInstGlobals.getValue("MigrateNoAccu").equals("true")) {
                UserInputField noaccuDisplayLabel = new UserInputField();
                noaccuDisplayLabel.setType(1);
                String noaccuMsg = (String)ICAInstGlobals.getValue("MigrateNoAccounts");
                noaccuDisplayLabel.setValue(noaccuMsg);
                fields.add(noaccuDisplayLabel);
            }
            if (ICAInstGlobals.getValue("MigrateErrorCode").equals("true")) {
                UserInputField errorDisplayLabel = new UserInputField();
                errorDisplayLabel.setType(1);
                String msg = (String)ICAInstGlobals.getValue("MigrateErrorMessage");
                String errorMsg = ShowMessage.gi("Ins").resolve("SVCMigrateResultPanel.ErrorMigrate", new String[]{msg}, null);
                errorDisplayLabel.setValue(errorMsg);
                fields.add(errorDisplayLabel);
            }
            UserInputField nextDisplayLabel = new UserInputField();
            nextDisplayLabel.setType(1);
            reportedMsg = ShowMessage.gi("Ins").resolve("InstallSummaryPanel.ClickNext", null, null);
            nextDisplayLabel.setValue(String.valueOf(reportedMsg) + "\n");
            fields.add(nextDisplayLabel);
            UserInputField[] theFields = new UserInputField[fields.size()];
            theFields = fields.toArray(theFields);
            super.setFields(theFields);
            return true;
        }
        return false;
    }

    public boolean entered(WizardBeanEvent event) {
        SwingWizardUI swingUI;
        boolean ret = super.entered(event);
        ShowMessage.gi("Ins").setWizardTitle(this);
        String initialNextButtonLabel = (String)this.getWizard().getServices().getValue("InitialNextLabel");
        WizardUI ui = event.getUserInterface();
        if (ui != null && ui instanceof SwingWizardUI && (swingUI = (SwingWizardUI)ui) != null && swingUI.getNavigationController().next() instanceof JButton) {
            ((JButton)swingUI.getNavigationController().next()).setText(initialNextButtonLabel);
            ((JButton)swingUI.getNavigationController().back()).setEnabled(false);
        }
        this.setEntered(ret);
        return ret;
    }

    public void execute(WizardBeanEvent event) {
        super.execute(event);
    }

    public void exited(WizardBeanEvent event) {
        super.exited(event);
        ShowMessage.gi("Ins").setWizardTitle(null);
    }

    public boolean queryExit(WizardBeanEvent event) {
        return this.isEntered();
    }

    private String getSuccMigrationState() {
        String retMsg = "";
        String migrateSucInfo = (String)ICAInstGlobals.getValue("MigrateSuccessInfo");
        if (migrateSucInfo.equals("true")) {
            String migrateAcc = (String)ICAInstGlobals.getValue("MigrateAccounts");
            retMsg = ShowMessage.gi("Ins").resolve("SVCMigrateResultPanel.SuccessMigrate", new String[]{migrateAcc}, null);
        }
        return retMsg;
    }

    private String getUnSuccMigrationState() {
        String retMsg = "";
        String migrateSucInfo = (String)ICAInstGlobals.getValue("MigrateUnsuccessInfo");
        if (migrateSucInfo.equals("true")) {
            String migrateUnAcc = (String)ICAInstGlobals.getValue("MigrateUnAccounts");
            retMsg = ShowMessage.gi("Ins").resolve("SVCMigrateResultPanel.UnSuccessMigrate", new String[]{migrateUnAcc}, null);
        }
        return retMsg;
    }
}

