/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.product.actions;

import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ProcUtl;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.Utilities;
import com.ibm.itcins.ica2.Utl;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductException;
import com.installshield.util.FileUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class CreateWASProfile
extends ProductAction {
    private String wasProfileExePath;
    private String profileName;
    private String profilePath;
    private String profileTemplatePath;
    private String nodeName;
    private String hostName;
    private String cellName;
    private boolean isDefault = true;
    private String portsFileName;
    private String serverName;

    public void install(ProductActionSupport arg0) throws ProductException {
        String cmd = "";
        String wasProfilePath = this.resolveString(this.getWasProfileExePath());
        cmd = String.valueOf(cmd) + ICAStringUtils.quoteOrUnquote(wasProfilePath);
        cmd = String.valueOf(cmd) + " -create ";
        cmd = String.valueOf(cmd) + "-profileName ";
        cmd = String.valueOf(cmd) + this.resolveString(this.getProfileName());
        cmd = String.valueOf(cmd) + " -profilePath ";
        cmd = String.valueOf(cmd) + ICAStringUtils.quoteOrUnquote(this.resolveString(this.getProfilePath()));
        cmd = String.valueOf(cmd) + " -templatePath ";
        cmd = String.valueOf(cmd) + ICAStringUtils.quoteOrUnquote(this.resolveString(this.getProfileTemplatePath()));
        cmd = String.valueOf(cmd) + " -nodeName ";
        cmd = String.valueOf(cmd) + this.resolveString(this.getNodeName());
        cmd = String.valueOf(cmd) + " -hostName ";
        cmd = String.valueOf(cmd) + this.resolveString(this.getHostName());
        cmd = String.valueOf(cmd) + " -cellName ";
        cmd = String.valueOf(cmd) + this.resolveString(this.getCellName());
        if (this.isDefault()) {
            cmd = String.valueOf(cmd) + " -isDefault";
        }
        if (this.getPortsFileName() != null && this.getPortsFileName().length() > 0) {
            cmd = String.valueOf(cmd) + " -portsFile ";
            cmd = String.valueOf(cmd) + ICAStringUtils.quoteOrUnquote(this.resolveString(this.getPortsFileName()));
        }
        cmd = String.valueOf(cmd) + " -serverName ";
        cmd = String.valueOf(cmd) + this.getServerName();
        String tempFileName = null;
        try {
            Object utl;
            tempFileName = FileUtils.createTempFile();
            FileService fileService = (FileService)this.getService("fileService");
            if (Utilities.isWindows()) {
                fileService.copyFile(tempFileName, String.valueOf(tempFileName) + ".bat", true);
                FileUtils.deleteTempFile(tempFileName);
                tempFileName = String.valueOf(tempFileName) + ".bat";
            }
            FileWriter fos = new FileWriter(new File(tempFileName));
            fos.write(cmd);
            fos.close();
            if (Utilities.isUnix()) {
                utl = Utl.instantiate();
                ((Utl)utl).setExecutePermisions(tempFileName);
            }
            ShowMessage.writeLogOutput(ShowMessage.gi("Ins").resolve("CreateWASProfile.startProfileCreation", null, null));
            ShowMessage.writeLogOutput(ShowMessage.gi("Ins").resolve("ICAInstall.ExecCmd", new String[]{cmd}, null));
            utl = new ProcUtl();
            StringBuffer stdout = new StringBuffer();
            StringBuffer stderr = new StringBuffer();
            int rc = ((ProcUtl)utl).execcmd(ICAStringUtils.quoteOrUnquote(tempFileName), true, null, (Object)stdout, (Object)stderr);
            if (rc != 0) {
                String err = ShowMessage.gi("Ins").resolve("CreateWASProfile.profileCreationFailed", null, null);
                FileUtils.deleteTempFile(tempFileName);
                if (stderr.toString().trim().length() > 0) {
                    throw new ProductException(601, String.valueOf(err) + " " + stderr.toString());
                }
                if (stdout.toString().trim().length() > 0) {
                    throw new ProductException(601, String.valueOf(err) + " " + stdout.toString());
                }
                throw new ProductException(601, err);
            }
            ShowMessage.writeLogOutput(ShowMessage.gi("Ins").resolve("CreateWASProfile.profileCreationSuccedded", null, null));
            FileUtils.deleteTempFile(tempFileName);
        }
        catch (ServiceException se) {
            if (tempFileName != null) {
                FileUtils.deleteTempFile(tempFileName);
            }
            throw new ProductException(601, se.toString());
        }
        catch (IOException e) {
            if (tempFileName != null) {
                FileUtils.deleteTempFile(tempFileName);
            }
            throw new ProductException(601, e.toString());
        }
    }

    public void replace(ProductAction arg0, ProductActionSupport arg1) throws ProductException {
        this.install(arg1);
    }

    public String getCellName() {
        return this.cellName;
    }

    public void setCellName(String cellName) {
        this.cellName = cellName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getProfilePath() {
        return this.profilePath;
    }

    public void setProfilePath(String profilePath) {
        this.profilePath = profilePath;
    }

    public String getProfileTemplatePath() {
        return this.profileTemplatePath;
    }

    public void setProfileTemplatePath(String profileTemplatePath) {
        this.profileTemplatePath = profileTemplatePath;
    }

    public String getWasProfileExePath() {
        return this.wasProfileExePath;
    }

    public void setWasProfileExePath(String wasProfileExePath) {
        this.wasProfileExePath = wasProfileExePath;
    }

    public String getPortsFileName() {
        return this.portsFileName;
    }

    public void setPortsFileName(String portsFileName) {
        this.portsFileName = portsFileName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }
}

