/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.product.actions;

import com.installshield.product.Locatable;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.service.product.ProductService;
import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.service.file.FileService;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class DSCreateDirectoryStructure
extends ProductAction
implements Locatable {
    protected String installLocation = "";
    protected String[] directoryListRelativeToBeanInstallLocation = new String[]{"repository/root", "repository/root/classes", "repository/root/instances", "repository/root/qualifiers", "repository/root#PG_InterOp/instances", "repository/root#PG_Internal/instances", "repository/root#cimv2/instances", "repository/root#ibm/instances"};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public String getInstallLocation() {
        return this.installLocation;
    }

    public void setInstallLocation(String instLoc) {
        this.installLocation = instLoc.trim().length() == 0 ? null : instLoc;
    }

    public String[] getDirectoryListRelativeToBeanInstallLocation() {
        return this.directoryListRelativeToBeanInstallLocation;
    }

    public void setDirectoryListRelativeToBeanInstallLocation(String[] directoryListRelativeToBeanInstallLocation) {
        this.directoryListRelativeToBeanInstallLocation = directoryListRelativeToBeanInstallLocation;
    }

    public void build(ProductBuilderSupport support) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.itcins.ica2.ShowMessage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            support.putClass(clazz.getName());
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("com.ibm.itcins.ica2.Utilities");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            support.putClass(clazz2.getName());
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("com.installshield.wizard.service.ServiceException");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            support.putClass(clazz3.getName());
            support.putRequiredService("fileService");
            support.putRequiredService("productService");
        }
        catch (IOException ex) {
            support.logEvent(this, "err", ex);
        }
    }

    public void install(ProductActionSupport support) throws ProductException {
        block10: {
            try {
                FileService sfs = (FileService)this.getService("fileService");
                ProductService prodService = (ProductService)this.getService("productService");
                String absInstLoc = (String)prodService.getProductBeanProperty("/product.xml", this.getBeanId(), "absoluteInstallLocation");
                if (this.directoryListRelativeToBeanInstallLocation == null) break block10;
                int i = 0;
                while (i < this.directoryListRelativeToBeanInstallLocation.length) {
                    boolean mustGrantWritePermission = false;
                    String dir = this.directoryListRelativeToBeanInstallLocation[i].trim();
                    if (dir.startsWith("+")) {
                        dir = dir.substring(1);
                        mustGrantWritePermission = true;
                    }
                    dir = FileUtils.createFileName(absInstLoc, dir);
                    try {
                        String[] newDir = sfs.createDirectoryReturnNew(dir);
                        int j = 0;
                        while (j < (newDir != null ? newDir.length : 0)) {
                            if (mustGrantWritePermission && j == newDir.length - 1) {
                                this.grantAllDirPermissions(newDir[j]);
                            } else {
                                this.grantSomeDirPermissions(newDir[j]);
                            }
                            ++j;
                        }
                    }
                    catch (Exception ex) {
                        String message = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.couldNotCreateDir", new String[]{dir});
                        throw new ProductException(601, message);
                    }
                    ++i;
                }
            }
            catch (ProductException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProductException(601, e.toString());
            }
        }
    }

    protected Vector createDirList() {
        Vector<String> rez = new Vector<String>();
        if (this.directoryListRelativeToBeanInstallLocation != null) {
            Hashtable<String, String> hash = new Hashtable<String, String>();
            int i = 0;
            while (i < this.directoryListRelativeToBeanInstallLocation.length) {
                String leaf = this.directoryListRelativeToBeanInstallLocation[i].trim();
                if (leaf.startsWith("+")) {
                    leaf = leaf.substring(1);
                }
                leaf = FileUtils.canonizePath(leaf);
                String dir = "";
                StringTokenizer st = new StringTokenizer(leaf, File.separator, false);
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    if (item.length() <= 0 || hash.containsKey(dir = String.valueOf(dir) + (dir.length() > 0 ? String.valueOf(File.separator) + item : item))) continue;
                    hash.put(dir, "");
                    rez.add(dir);
                }
                ++i;
            }
        }
        return rez;
    }

    public boolean grantAllDirPermissions(String dirName) {
        int msk = 511;
        boolean retVal = false;
        try {
            FileService sfs = (FileService)this.getService("fileService");
            FileAttributes fileAttributes = sfs.getFileAttributes(dirName);
            int fileMsk = fileAttributes.getAttributes();
            fileAttributes.setAttributes(fileMsk | msk);
            sfs.setFileAttributes(dirName, fileAttributes);
            retVal = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public boolean grantSomeDirPermissions(String dirName) {
        int msk = 367;
        boolean retVal = false;
        try {
            FileService sfs = (FileService)this.getService("fileService");
            FileAttributes fileAttributes = sfs.getFileAttributes(dirName);
            int fileMsk = fileAttributes.getAttributes();
            fileAttributes.setAttributes(fileMsk | msk);
            sfs.setFileAttributes(dirName, fileAttributes);
            retVal = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public void replace(ProductAction oldAction, ProductActionSupport support) throws ProductException {
        this.install(support);
    }

    public void uninstall(ProductActionSupport support) throws ProductException {
        try {
            ProductService prodService = (ProductService)this.getService("productService");
            String absInstLoc = (String)prodService.getProductBeanProperty("/product.xml", this.getBeanId(), "absoluteInstallLocation");
            Vector vect = this.createDirList();
            int i = vect.size() - 1;
            while (i >= 0) {
                new File(FileUtils.createFileName(absInstLoc, (String)vect.elementAt(i))).delete();
                --i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

