/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.product.actions;

import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.PEGASUSActions;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.Utilities;
import com.ibm.itcins.ica2.exceptions.CmdException;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductException;
import java.io.IOException;
import java.util.StringTokenizer;

public class EnablePegasusAuthentication
extends ProductAction {
    private String cimConfigPath;
    private int estimatedTimeToInstall = 500;
    private String[] authenticationProperties = new String[0];
    private String[] environmentVars = new String[0];
    private boolean userExecutablesAsInternalResources = true;

    public void install(ProductActionSupport support) throws ProductException {
        support.getOperationState().setStatusDetail(ShowMessage.gi("Ins").resolve("EnablePegasusAuthentication.statusDetail", null, null));
        String[] propertiesToBeSet = this.getAuthenticationProperties();
        String script = this.resolveString(this.getCimConfigPath());
        script = ICAStringUtils.quoteOrUnquoteOnlyOnW32(script);
        if (this.isUserExecutablesAsInternalResources()) {
            try {
                String resourceName;
                String string = resourceName = Utilities.isWindows() ? "cimConfigScript" : "cimConfigUnixScript";
                script = Utilities.isUnix() ? Utilities.createTemporaryFile(resourceName) : Utilities.createTemporaryFile(resourceName, "cimconfig.bat");
            }
            catch (Exception resourceName) {
                // empty catch block
            }
        }
        PEGASUSActions pegasusActions = PEGASUSActions.instantiate();
        if (propertiesToBeSet.length > 0) {
            int i;
            String logMsg = ShowMessage.gi("Ins").resolve("EnablePegasusAuthentication.statusDetail", null, null);
            ShowMessage.writeLogOutput(logMsg);
            support.getOperationState().setStatusDetail(logMsg);
            if (this.getEnvironmentVars().length > 0) {
                i = 0;
                while (i < this.environmentVars.length) {
                    this.environmentVars[i] = this.resolveString(this.environmentVars[i]);
                    ++i;
                }
            }
            i = 0;
            while (i < propertiesToBeSet.length) {
                StringTokenizer tokenizer = new StringTokenizer(propertiesToBeSet[i], "=");
                String[] currentValues = new String[]{tokenizer.nextToken(), tokenizer.nextToken()};
                if (currentValues != null && currentValues.length >= 2) {
                    try {
                        pegasusActions.setProposedCimServerConfiguration(script, currentValues[0], currentValues[1], this.environmentVars);
                    }
                    catch (CmdException cmdEx) {
                        if (this.isUserExecutablesAsInternalResources()) {
                            Utilities.deleteAllYouCan(script);
                        }
                        throw new ProductException(601, cmdEx.getMessage());
                    }
                    catch (IOException ioEx) {
                        if (this.isUserExecutablesAsInternalResources()) {
                            Utilities.deleteAllYouCan(script);
                        }
                        throw new ProductException(601, ioEx.getMessage());
                    }
                }
                ++i;
            }
            if (this.isUserExecutablesAsInternalResources()) {
                Utilities.deleteAllYouCan(script);
            }
            logMsg = ShowMessage.gi("Ins").resolve("EnablePegasusAuthentication.setConfigDone", null, null);
            ShowMessage.writeLogOutput(logMsg);
            support.getOperationState().setStatusDetail("");
        }
    }

    public void replace(ProductAction oldAction, ProductActionSupport support) throws ProductException {
        this.install(support);
    }

    public String getCimConfigPath() {
        return this.cimConfigPath;
    }

    public void setCimConfigPath(String cimConfigPath) {
        this.cimConfigPath = cimConfigPath;
    }

    public int getEstimatedTimeToInstall() {
        return this.estimatedTimeToInstall;
    }

    public void setEstimatedTimeToInstall(int time) {
        this.estimatedTimeToInstall = time;
    }

    public boolean isUserExecutablesAsInternalResources() {
        return this.userExecutablesAsInternalResources;
    }

    public void setUserExecutablesAsInternalResources(boolean userExecutablesAsInternalResources) {
        this.userExecutablesAsInternalResources = userExecutablesAsInternalResources;
    }

    public String[] getAuthenticationProperties() {
        return this.authenticationProperties;
    }

    public void setAuthenticationProperties(String[] authenticationProperties) {
        this.authenticationProperties = authenticationProperties;
    }

    public String[] getEnvironmentVars() {
        return this.environmentVars;
    }

    public void setEnvironmentVars(String[] environmentVars) {
        this.environmentVars = environmentVars;
    }
}

