/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.product.actions;

import com.ibm.itcins.ica2.BldUtil;
import com.ibm.itcins.ica2.ProcessesUtl;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.Utilities;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.wizard.platform.win32.Win32Service;
import com.installshield.wizard.platform.win32.win32service.NTServiceConfig;
import com.installshield.wizard.platform.win32.win32service.Win2kSCAction;
import com.installshield.wizard.platform.win32.win32service.Win2kServiceFailureActions;
import com.installshield.wizard.service.ServiceException;
import java.io.IOException;

public class InstallNTService
extends ProductAction {
    private static final int FATAL_ERROR = 1;
    private static final int CONTINUE_WITH_WARNING = 2;
    private static final int CONTINUE = 3;
    private String exeAbsolutePath = null;
    private String serviceName = null;
    private String serviceDisplayName = null;
    private String servDescription = null;
    private String args = null;
    private int NTServiceStartupType = 1;
    private boolean replaceIfFound = false;
    private int verbose = 1;
    private int onFailure = 1;
    private int secForOneDay = 86400;
    private String previouscimAgentServiceName = "cimomsvcsrv";
    static /* synthetic */ Class class$0;

    public void build(ProductBuilderSupport support) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.itcins.ica2.ProcessesUtl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BldUtil.putClass(support, clazz.getName());
            super.build(support);
        }
        catch (Exception e) {
            support.logEvent(this, "err", e.toString());
        }
    }

    public void install(ProductActionSupport support) throws ProductException {
        if (!Utilities.isWindows()) {
            return;
        }
        ProcessesUtl procUtl = ProcessesUtl.instantiate(this);
        Win2kServiceFailureActions failactions = new Win2kServiceFailureActions();
        Win2kSCAction firstAction = new Win2kSCAction();
        firstAction.setActionType(1);
        Win2kSCAction secondAction = new Win2kSCAction();
        secondAction.setActionType(1);
        Win2kSCAction subsequentAction = new Win2kSCAction();
        subsequentAction.setActionType(0);
        Win2kSCAction[] actions = new Win2kSCAction[]{firstAction, secondAction, subsequentAction};
        failactions.setActions(actions);
        failactions.setResetPeriod(this.secForOneDay);
        try {
            if (procUtl.isServiceInstalled(this.previouscimAgentServiceName)) {
                boolean stopped = procUtl.stopService(this.previouscimAgentServiceName);
                if (!stopped) {
                    ShowMessage.writeLogOutput("Detect previous CIMOM service, while can not stop it successfully");
                    return;
                }
                int i = procUtl.uninstallService(this.getServices(), this.resolveString(this.serviceName), false);
                if (i != 0) {
                    ShowMessage.writeLogOutput("Detect previous CIMOM service, while can not uninstall it successfully");
                    return;
                }
            }
        }
        catch (ServiceException e) {
            ShowMessage.writeLogOutput("Detect previous CIMOM service, exception happened during cleaning previous CIMOM");
            e.printStackTrace();
        }
        try {
            String serviceDescription = procUtl.getServiceDescription(this.resolveString(this.serviceName));
            if (procUtl.isServiceInstalled(this.resolveString(this.serviceName))) {
                String txt = ShowMessage.gi(null).resolve("Install.ServiceAlrdInstalled", new String[]{serviceDescription}, null);
                ShowMessage.writeLogOutput(txt);
                if (this.isReplaceIfFound()) {
                    if (procUtl.isServiceRunning(this.resolveString(this.serviceName))) {
                        txt = ShowMessage.gi(null).resolve("Install.StoppingService", new String[]{serviceDescription}, null);
                        ShowMessage.writeLogOutput(txt);
                        boolean stopped = procUtl.stopService(this.resolveString(this.serviceName));
                        if (!stopped) {
                            txt = ShowMessage.gi(null).resolve("Install.StoppingServiceFailed", new String[]{serviceDescription}, null);
                            throw new ProductException(601, txt);
                        }
                        txt = ShowMessage.gi(null).resolve("Install.ServiceStopped", new String[]{serviceDescription}, null);
                        ShowMessage.writeLogOutput(txt);
                    }
                    txt = ShowMessage.gi(null).resolve("Install.RemovingService", new String[]{serviceDescription}, null);
                    ShowMessage.writeLogOutput(txt);
                    int i = procUtl.uninstallService(this.getServices(), this.resolveString(this.serviceName), false);
                    if (i != 0) {
                        txt = ShowMessage.gi(null).resolve("Install.RemovingServiceFailed", new String[]{serviceDescription}, null);
                        throw new ProductException(601, txt);
                    }
                    txt = ShowMessage.gi(null).resolve("Install.ServiceRemoved", new String[]{serviceDescription}, null);
                    ShowMessage.writeLogOutput(txt);
                } else {
                    String dispName = this.resolveString(this.getServiceDisplayName());
                    if (dispName != null && dispName.length() > 0) {
                        dispName = this.resolveString(dispName);
                        Win32Service win32Service = (Win32Service)this.getService("win32Service");
                        if (win32Service.serviceExists(this.resolveString(this.serviceName))) {
                            win32Service.changeWin2kServiceDescription(this.resolveString(this.serviceName), this.resolveString(this.getServDescription()));
                            NTServiceConfig config = win32Service.queryNTServiceConfig(this.resolveString(this.serviceName));
                            if (config != null) {
                                config.setDisplayName(dispName);
                                win32Service.changeNTServiceConfig(this.resolveString(this.serviceName), config);
                                win32Service.changeWin2kServiceFailureActions(this.resolveString(this.serviceName), failactions);
                            }
                        }
                    }
                    return;
                }
            }
            serviceDescription = this.resolveString(this.getServiceDisplayName());
            String txt = ShowMessage.gi(null).resolve("Install.InstallingService", new String[]{serviceDescription}, null);
            ShowMessage.writeLogOutput(txt);
            String exepath = this.resolveString(this.getExeAbsolutePath());
            int rc = procUtl.installService(exepath, this.resolveString(this.getServiceName()), this.getArgs(), this.getVerbose());
            if (rc != 0) {
                txt = ShowMessage.gi(null).resolve("Install.InstalledServiceFailed", new String[]{serviceDescription}, null);
                switch (this.onFailure) {
                    case 2: 
                    case 3: {
                        String wrnMsg = txt;
                        ShowMessage.writeLogOutput("wrn", wrnMsg);
                        return;
                    }
                }
                throw new ProductException(601, txt);
            }
            String dispName = this.resolveString(this.getServiceDisplayName());
            if (dispName != null && dispName.length() > 0) {
                dispName = this.resolveString(dispName);
                Win32Service win32Service = (Win32Service)this.getService("win32Service");
                if (win32Service.serviceExists(this.resolveString(this.serviceName))) {
                    win32Service.changeWin2kServiceDescription(this.resolveString(this.serviceName), this.resolveString(this.getServDescription()));
                    NTServiceConfig config = win32Service.queryNTServiceConfig(this.resolveString(this.serviceName));
                    if (config != null) {
                        config.setDisplayName(dispName);
                        win32Service.changeNTServiceConfig(this.resolveString(this.serviceName), config);
                        win32Service.changeWin2kServiceFailureActions(this.resolveString(this.serviceName), failactions);
                    }
                }
            }
            this.changeNTServiceStartupType(this.getNTServiceStartupType());
            txt = ShowMessage.gi(null).resolve("Install.ServiceInstalled", new String[]{serviceDescription}, null);
            ShowMessage.writeLogOutput(txt);
        }
        catch (IOException ioException) {
            String txt = ShowMessage.gi(null).resolve("Install.IOExceptionOccured", new String[]{ioException.toString()}, null);
            switch (this.onFailure) {
                case 2: 
                case 3: {
                    String wrnMsg = txt;
                    ShowMessage.writeLogOutput("wrn", wrnMsg);
                    return;
                }
            }
            ShowMessage.writeLogOutput("err", txt);
            throw new ProductException(601, ioException.toString());
        }
        catch (ServiceException exception) {
            String txt = ShowMessage.gi(null).resolve("Install.ServiceExceptionOccured", new String[]{exception.toString()}, null);
            switch (this.onFailure) {
                case 2: 
                case 3: {
                    String wrnMsg = txt;
                    ShowMessage.writeLogOutput("wrn", wrnMsg);
                    return;
                }
            }
            ShowMessage.writeLogOutput("err", txt);
            throw new ProductException(601, exception.toString());
        }
    }

    public void replace(ProductAction oldAction, ProductActionSupport support) throws ProductException {
        this.install(support);
    }

    public void uninstall(ProductActionSupport support) throws ProductException {
        if (!Utilities.isWindows()) {
            return;
        }
        ProcessesUtl procUtl = ProcessesUtl.instantiate(this);
        try {
            String serviceDescription = procUtl.getServiceDescription(this.resolveString(this.serviceName));
            if (procUtl.isServiceInstalled(this.resolveString(this.serviceName))) {
                String txt;
                if (procUtl.isServiceRunning(this.resolveString(this.serviceName))) {
                    txt = ShowMessage.gi(null).resolve("Install.StoppingService", new String[]{serviceDescription}, null);
                    ShowMessage.writeLogOutput(txt);
                    boolean stopped = procUtl.stopService(this.resolveString(this.serviceName));
                    if (!stopped) {
                        txt = ShowMessage.gi(null).resolve("Install.StoppingServiceFailed", new String[]{serviceDescription}, null);
                    }
                    txt = ShowMessage.gi(null).resolve("Install.ServiceStopped", new String[]{serviceDescription}, null);
                    ShowMessage.writeLogOutput(txt);
                }
                txt = ShowMessage.gi(null).resolve("Install.RemovingService", new String[]{serviceDescription}, null);
                ShowMessage.writeLogOutput(txt);
                int i = procUtl.uninstallService(this.getServices(), this.resolveString(this.serviceName), true);
                if (i != 0) {
                    txt = ShowMessage.gi(null).resolve("Install.RemovingServiceFailed", new String[]{serviceDescription}, null);
                }
                txt = ShowMessage.gi(null).resolve("Install.ServiceRemoved", new String[]{serviceDescription}, null);
                ShowMessage.writeLogOutput(txt);
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    private void changeNTServiceStartupType(int type) {
        ProcessesUtl processesUtl = ProcessesUtl.instantiate(this);
        try {
            int starttype = -123456;
            switch (type) {
                case 0: {
                    starttype = 3;
                    break;
                }
                case 1: {
                    starttype = 2;
                    break;
                }
                case 2: {
                    starttype = 4;
                    break;
                }
                default: {
                    return;
                }
            }
            processesUtl.changeNTSrvStartType(this.resolveString(this.serviceName), starttype);
        }
        catch (ServiceException se) {
            ShowMessage.writeLogOutput("err", ShowMessage.gi("Ins").resolve("ICAInstall.ServiceExceptionOccured", new String[]{se.toString()}, null));
        }
    }

    public String getArgs() {
        return this.args;
    }

    public String getExeAbsolutePath() {
        return this.exeAbsolutePath;
    }

    public int getNTServiceStartupType() {
        return this.NTServiceStartupType;
    }

    public int getOnFailure() {
        return this.onFailure;
    }

    public boolean isReplaceIfFound() {
        return this.replaceIfFound;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public int getVerbose() {
        return this.verbose;
    }

    public void setArgs(String string) {
        this.args = string;
    }

    public void setExeAbsolutePath(String string) {
        this.exeAbsolutePath = string;
    }

    public void setNTServiceStartupType(int i) {
        this.NTServiceStartupType = i;
    }

    public void setOnFailure(int i) {
        this.onFailure = i;
    }

    public void setReplaceIfFound(boolean b) {
        this.replaceIfFound = b;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public void setVerbose(int i) {
        this.verbose = i;
    }

    public String getServiceDisplayName() {
        return this.serviceDisplayName;
    }

    public void setServiceDisplayName(String string) {
        this.serviceDisplayName = string;
    }

    public String getServDescription() {
        return this.servDescription;
    }

    public void setServDescription(String string) {
        this.servDescription = string;
    }
}

