/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.product.actions;

import com.ibm.itcins.ica2.BldUtil;
import com.ibm.itcins.ica2.ProcessesUtl;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.Utilities;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.wizard.platform.win32.Win32Service;
import com.installshield.wizard.platform.win32.win32service.NTServiceConfig;
import com.installshield.wizard.service.ServiceException;
import java.io.IOException;

public class InstallWAS6Service
extends ProductAction {
    public static final String STARTUP_TYPE_AUTOMATIC = "automatic";
    public static final String STARTUP_TYPE_MANUAL = "manual";
    public static final String STARTUP_TYPE_DISABLED = "disabled";
    private String wasServicePath;
    private String wasServiceName;
    private String displayName;
    private String profilePath;
    private String wasHome;
    private String configRoot;
    private String startArgs;
    private String stopArgs;
    private String logFile;
    private String logRoot;
    private String startupType;
    private String serviceName;
    private String serverName;
    private String userName;
    private String password;
    private String NTServiceStartupType = "automatic";
    private boolean replaceIfFound = false;
    private boolean restart = false;
    private boolean preserveStartupType = false;
    private int verbose = 1;
    private static final int FATAL_ERROR = 1;
    private static final int CONTINUE_WITH_WARNING = 2;
    private static final int CONTINUE = 3;
    private int onFailure = 1;
    private boolean DEBUG = false;
    static /* synthetic */ Class class$0;

    public void build(ProductBuilderSupport support) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.itcins.ica2.ProcessesUtl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BldUtil.putClass(support, clazz.getName());
            super.build(support);
        }
        catch (Exception e) {
            support.logEvent(this, "err", e.toString());
        }
    }

    public void install(ProductActionSupport support) throws ProductException {
        if (!Utilities.isWindows()) {
            return;
        }
        ProcessesUtl procUtl = ProcessesUtl.instantiate(this);
        try {
            String txt;
            String srvname = this.getWASSuffixedName();
            if (procUtl.isServiceInstalled(srvname)) {
                txt = ShowMessage.gi(null).resolve("Install.ServiceAlrdInstalled", new String[]{srvname}, null);
                ShowMessage.writeLogOutput(txt);
                if (this.isReplaceIfFound()) {
                    if (this.isPreserveStartupType()) {
                        int ntServiceStartupType = procUtl.getNTSrvStartType(srvname);
                        String tempStartupType = STARTUP_TYPE_AUTOMATIC;
                        switch (ntServiceStartupType) {
                            case 3: {
                                tempStartupType = STARTUP_TYPE_MANUAL;
                                break;
                            }
                            case 4: {
                                tempStartupType = STARTUP_TYPE_DISABLED;
                            }
                        }
                        this.setNTServiceStartupType(tempStartupType);
                    }
                    if (procUtl.isServiceRunning(srvname)) {
                        txt = ShowMessage.gi(null).resolve("Install.StoppingService", new String[]{srvname}, null);
                        ShowMessage.writeLogOutput(txt);
                        boolean stopped = procUtl.stopService(srvname);
                        if (!stopped) {
                            txt = ShowMessage.gi(null).resolve("Install.StoppingServiceFailed", new String[]{srvname}, null);
                            throw new ProductException(601, txt);
                        }
                        txt = ShowMessage.gi(null).resolve("Install.ServiceStopped", new String[]{srvname}, null);
                        ShowMessage.writeLogOutput(txt);
                    }
                    txt = ShowMessage.gi(null).resolve("Install.RemovingService", new String[]{srvname}, null);
                    ShowMessage.writeLogOutput(txt);
                    int i = procUtl.uninstallService(this.getServices(), srvname, false);
                    if (i != 0) {
                        txt = ShowMessage.gi(null).resolve("Install.RemovingServiceFailed", new String[]{srvname}, null);
                        throw new ProductException(601, txt);
                    }
                    txt = ShowMessage.gi(null).resolve("Install.ServiceRemoved", new String[]{srvname}, null);
                    ShowMessage.writeLogOutput(txt);
                } else {
                    String dispName = this.getDisplayName();
                    if (dispName != null && dispName.length() > 0) {
                        NTServiceConfig config;
                        dispName = this.resolveString(dispName);
                        Win32Service win32Service = (Win32Service)this.getService("win32Service");
                        if (win32Service.serviceExists(srvname) && (config = win32Service.queryNTServiceConfig(srvname)) != null) {
                            config.setDisplayName(dispName);
                            win32Service.changeNTServiceConfig(srvname, config);
                        }
                    }
                    return;
                }
            }
            txt = ShowMessage.gi(null).resolve("Install.InstallingService", new String[]{this.getWASSuffixedName()}, null);
            ShowMessage.writeLogOutput(txt);
            int rc = procUtl.installWAS6Service(this.resolveString(this.getWasServicePath()), this.resolveString(this.getServiceName()), this.resolveString(this.getServerName()), this.resolveString(this.getProfilePath()), this.resolveString(this.getWasHome()), this.resolveString(this.getConfigRoot()), this.resolveString(this.getStartArgs()), this.resolveString(this.getStopArgs()), this.resolveString(this.getUserName()), this.resolveString(this.getPassword()), this.resolveString(this.getLogFile()), this.resolveString(this.getLogRoot()), this.isRestart(), this.resolveString(this.getStartupType()), this.getVerbose());
            if (rc != 0) {
                txt = ShowMessage.gi(null).resolve("Install.InstalledServiceFailed", new String[]{this.getWASSuffixedName()}, null);
                switch (this.onFailure) {
                    case 2: 
                    case 3: {
                        String wrnMsg = txt;
                        ShowMessage.writeLogOutput("wrn", wrnMsg);
                        return;
                    }
                }
                throw new ProductException(601, txt);
            }
            String dispName = this.getDisplayName();
            if (dispName != null && dispName.length() > 0) {
                NTServiceConfig config;
                dispName = this.resolveString(dispName);
                Win32Service win32Service = (Win32Service)this.getService("win32Service");
                if (win32Service.serviceExists(srvname) && (config = win32Service.queryNTServiceConfig(srvname)) != null) {
                    config.setDisplayName(dispName);
                    win32Service.changeNTServiceConfig(srvname, config);
                }
            }
            this.changeNTServiceStartupType(this.getNTServiceStartupType());
            txt = ShowMessage.gi(null).resolve("Install.ServiceInstalled", new String[]{this.getWASSuffixedName()}, null);
            ShowMessage.writeLogOutput(txt);
        }
        catch (IOException ioException) {
            String txt = ShowMessage.gi(null).resolve("Install.IOExceptionOccured", new String[]{ioException.toString()}, null);
            switch (this.onFailure) {
                case 2: 
                case 3: {
                    String wrnMsg = txt;
                    ShowMessage.writeLogOutput("wrn", wrnMsg);
                    return;
                }
            }
            ShowMessage.writeLogOutput("err", txt);
            throw new ProductException(601, ioException.toString());
        }
        catch (ServiceException exception) {
            String txt = ShowMessage.gi(null).resolve("Install.ServiceExceptionOccured", new String[]{exception.toString()}, null);
            switch (this.onFailure) {
                case 2: 
                case 3: {
                    String wrnMsg = txt;
                    ShowMessage.writeLogOutput("wrn", wrnMsg);
                    return;
                }
            }
            ShowMessage.writeLogOutput("err", txt);
            throw new ProductException(601, exception.toString());
        }
    }

    public void replace(ProductAction oldAction, ProductActionSupport support) throws ProductException {
        this.install(support);
    }

    public void uninstall(ProductActionSupport support) throws ProductException {
        if (!Utilities.isWindows()) {
            return;
        }
        ProcessesUtl procUtl = ProcessesUtl.instantiate(this);
        String srvname = this.getWASSuffixedName();
        try {
            String txt;
            if (procUtl.isServiceRunning(srvname)) {
                txt = ShowMessage.gi(null).resolve("Install.StoppingService", new String[]{srvname}, null);
                ShowMessage.writeLogOutput(txt);
                boolean stopped = procUtl.stopService(srvname);
                if (!stopped) {
                    txt = ShowMessage.gi(null).resolve("Install.StoppingServiceFailed", new String[]{srvname}, null);
                }
                txt = ShowMessage.gi(null).resolve("Install.ServiceStopped", new String[]{srvname}, null);
                ShowMessage.writeLogOutput(txt);
            }
            txt = ShowMessage.gi(null).resolve("Install.RemovingService", new String[]{srvname}, null);
            ShowMessage.writeLogOutput(txt);
            int i = procUtl.uninstallService(this.getServices(), srvname, true);
            if (i != 0) {
                txt = ShowMessage.gi(null).resolve("Install.RemovingServiceFailed", new String[]{srvname}, null);
            }
            txt = ShowMessage.gi(null).resolve("Install.ServiceRemoved", new String[]{srvname}, null);
            ShowMessage.writeLogOutput(txt);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    private String getWASSuffixedName() {
        return String.valueOf(this.resolveString(this.getWasServiceName())) + " - " + this.resolveString(this.getServiceName());
    }

    private void changeNTServiceStartupType(String type) {
        ProcessesUtl processesUtl = ProcessesUtl.instantiate(this);
        try {
            int starttype = -123456;
            if (type.equals(STARTUP_TYPE_MANUAL)) {
                starttype = 3;
            } else if (type.equals(STARTUP_TYPE_AUTOMATIC)) {
                starttype = 2;
            } else if (type.endsWith(STARTUP_TYPE_DISABLED)) {
                starttype = 4;
            } else {
                return;
            }
            processesUtl.changeNTSrvStartType(this.getWASSuffixedName(), starttype);
        }
        catch (ServiceException se) {
            ShowMessage.writeLogOutput("err", ShowMessage.gi("Ins").resolve("Install.ServiceExceptionOccured", new String[]{se.toString()}, null));
        }
    }

    public boolean isDEBUG() {
        return this.DEBUG;
    }

    public int getOnFailure() {
        return this.onFailure;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isReplaceIfFound() {
        return this.replaceIfFound;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getWasServiceName() {
        return this.wasServiceName;
    }

    public void setDEBUG(boolean b) {
        this.DEBUG = b;
    }

    public void setOnFailure(int onFailure) {
        this.onFailure = onFailure;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setReplaceIfFound(boolean b) {
        this.replaceIfFound = b;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public void setWasServiceName(String string) {
        this.wasServiceName = string;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public boolean isRestart() {
        return this.restart;
    }

    public void setLogFile(String string) {
        this.logFile = string;
    }

    public void setRestart(boolean b) {
        this.restart = b;
    }

    public int getVerbose() {
        return this.verbose;
    }

    public void setVerbose(int i) {
        this.verbose = i;
    }

    public String getNTServiceStartupType() {
        return this.NTServiceStartupType;
    }

    public void setNTServiceStartupType(String serviceStartupType) {
        this.NTServiceStartupType = serviceStartupType;
    }

    public String getConfigRoot() {
        return this.configRoot;
    }

    public void setConfigRoot(String configRoot) {
        this.configRoot = configRoot;
    }

    public String getLogRoot() {
        return this.logRoot;
    }

    public void setLogRoot(String logRoot) {
        this.logRoot = logRoot;
    }

    public String getProfilePath() {
        return this.profilePath;
    }

    public void setProfilePath(String profilePath) {
        this.profilePath = profilePath;
    }

    public String getStartArgs() {
        return this.startArgs;
    }

    public void setStartArgs(String startArgs) {
        this.startArgs = startArgs;
    }

    public String getStartupType() {
        return this.startupType;
    }

    public void setStartupType(String startupType) {
        this.startupType = startupType;
    }

    public String getStopArgs() {
        return this.stopArgs;
    }

    public void setStopArgs(String stopArgs) {
        this.stopArgs = stopArgs;
    }

    public String getWasHome() {
        return this.wasHome;
    }

    public void setWasHome(String wasHome) {
        this.wasHome = wasHome;
    }

    public boolean isPreserveStartupType() {
        return this.preserveStartupType;
    }

    public void setPreserveStartupType(boolean b) {
        this.preserveStartupType = b;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getWasServicePath() {
        return this.wasServicePath;
    }

    public void setWasServicePath(String wasServicePath) {
        this.wasServicePath = wasServicePath;
    }
}

