/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.product.actions;

import com.ibm.itcins.ica2.ShowMessage;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductException;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

public class SVCCimUsers
extends ProductAction {
    private String[] userPasswordPairs = new String[0];
    private String passwdFileName;

    public void install(ProductActionSupport arg0) throws ProductException {
        if (this.getUserPasswordPairs() != null && this.getUserPasswordPairs().length > 0) {
            String passwdFileName = this.resolveString(this.getPasswdFileName());
            File passwdFile = new File(passwdFileName);
            FileService fs = null;
            try {
                fs = (FileService)this.getService("fileService");
            }
            catch (ServiceException e) {
                throw new ProductException(601, e.getMessage());
            }
            String[] users = null;
            if (passwdFile.exists()) {
                try {
                    users = fs.readAsciiFile(passwdFileName);
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
            Vector<String> newUsers = new Vector<String>();
            boolean mustAddUsers = false;
            int i = 0;
            while (i < this.getUserPasswordPairs().length) {
                String currentPair = this.getUserPasswordPairs()[i];
                String userName = (String)new StringTokenizer(currentPair, ":").nextElement();
                int position = this.userExists(userName, users);
                if (position >= 0) {
                    newUsers.add(users[i]);
                } else {
                    newUsers.add(currentPair);
                    mustAddUsers = true;
                }
                ++i;
            }
            if (mustAddUsers && newUsers.size() > 0) {
                try {
                    if (fs.fileExists(passwdFileName)) {
                        fs.deleteFile(passwdFileName);
                    }
                    String msg = ShowMessage.gi("Ins").resolve("CreateCIMUsers.createPasswdFile", new String[]{passwdFileName}, null);
                    ShowMessage.writeLogOutput(msg);
                    String[] list = new String[newUsers.size()];
                    list = newUsers.toArray(list);
                    fs.createAsciiFile(passwdFileName, list);
                }
                catch (ServiceException e) {
                    throw new ProductException(601, e.getMessage());
                }
            }
        }
    }

    private int userExists(String userName, String[] existingUsers) {
        int position = -1;
        if (existingUsers != null && existingUsers.length > 0) {
            int i = 0;
            while (i < existingUsers.length) {
                if (existingUsers[i] != null && existingUsers[i].startsWith(userName)) {
                    position = i;
                }
                ++i;
            }
        }
        return position;
    }

    public String getPasswdFileName() {
        return this.passwdFileName;
    }

    public void setPasswdFileName(String passwdFileName) {
        this.passwdFileName = passwdFileName;
    }

    public String[] getUserPasswordPairs() {
        return this.userPasswordPairs;
    }

    public void setUserPasswordPairs(String[] userPasswordPairs) {
        this.userPasswordPairs = userPasswordPairs;
    }

    public void replace(ProductAction oldAction, ProductActionSupport support) throws ProductException {
        FileService fss = null;
        String passwdFileName = this.resolveString(this.getPasswdFileName());
        try {
            fss = (FileService)this.getService("fileService");
        }
        catch (ServiceException e) {
            throw new ProductException(601, e.getMessage());
        }
        try {
            if (fss.fileExists(passwdFileName)) {
                fss.deleteFile(passwdFileName);
            }
        }
        catch (ServiceException e) {
            throw new ProductException(601, e.getMessage());
        }
        this.install(support);
    }
}

