/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.product.actions;

import com.ibm.itcins.ica2.BldUtil;
import com.ibm.itcins.ica2.ICAInstConst;
import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICAProfileParser;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.PEGASUSActions;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.Utilities;
import com.ibm.itcins.ica2.exceptions.CmdException;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductException;
import com.installshield.util.FileUtils;
import java.io.File;
import java.io.IOException;

public class SVCPortsConfigAction
extends ProductAction {
    private String cimConfigPath;
    private int estimatedTimeToInstall = 500;
    private boolean userExecutablesAsInternalResources = true;
    private String[] environmentVars = new String[0];
    static /* synthetic */ Class class$0;

    public String[] getEnvironmentVars() {
        return this.environmentVars;
    }

    public void setEnvironmentVars(String[] environmentVars) {
        this.environmentVars = environmentVars;
    }

    public void install(ProductActionSupport support) throws ProductException {
        String[] stringArray;
        String[] stringArray2;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.itcins.ica2.ICAInstConst");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICAInstConst bundle = (ICAInstConst)BldUtil.instantiate(clazz.getName());
        support.getOperationState().setStatusDetail(ShowMessage.gi("Ins").resolve("DSPortsConfigAction.statusDetail", null, null));
        String httpsPort = null;
        String httpPort = null;
        String selectedProtocolValue = null;
        String backupVar = ICAInstGlobals.getString("portsBackup");
        String val = (String)this.getServices().getValue("saveConfiguration");
        boolean preserveConfig = val != null && val.toUpperCase().startsWith("Y");
        selectedProtocolValue = ICAInstGlobals.getString("PegasusProtocol", null);
        if (selectedProtocolValue == null) {
            selectedProtocolValue = this.resolveString("$W(serverCommunicationConfig.communicationProtocol)");
        }
        if ((httpsPort = ICAInstGlobals.getString("PegasusHTTPSPort", null)) == null) {
            httpsPort = this.resolveString("$W(serverCommunicationConfig.httpsPort)");
        }
        if ((httpPort = ICAInstGlobals.getString("PegasusHTTPPort", null)) == null) {
            httpPort = this.resolveString("$W(serverCommunicationConfig.httpPort)");
        }
        boolean enableHttpConnection = false;
        boolean enableHttpsConnection = false;
        String installerDirectory = this.resolveString("$P(absoluteInstallLocation)");
        if (backupVar != "" && preserveConfig) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("com.ibm.itcins.ica2.ICAInstConst");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            bundle = (ICAInstConst)BldUtil.instantiate(clazz2.getName());
            String confFile = FileUtils.createFileName(backupVar, "cimserver_planned.conf");
            ICAProfileParser parser = new ICAProfileParser();
            if (new File(confFile).exists()) {
                try {
                    httpsPort = parser.getProfileString(confFile, null, "httpsPort", null);
                    httpPort = parser.getProfileString(confFile, null, "httpPort", null);
                    String enableHttps = parser.getProfileString(confFile, null, "enableHttpsConnection", null);
                    String enableHttp = parser.getProfileString(confFile, null, "enableHttpConnection", null);
                    boolean isHttps = new Boolean(enableHttpsConnection);
                    boolean isHttp = new Boolean(enableHttpConnection);
                    if (isHttps && isHttp) {
                        selectedProtocolValue = "both";
                    } else if (isHttps && isHttp) {
                        selectedProtocolValue = "https";
                    } else if (isHttp && isHttps) {
                        selectedProtocolValue = "http";
                    }
                }
                catch (IOException ioex) {
                    ShowMessage.gi("Ins").fatalError1(this, "", "ICAInstall.IOExceptionOccured", ioex.toString());
                }
            }
        }
        if (backupVar != "" && !preserveConfig) {
            httpsPort = bundle.getString("svcHTTPSPortDefaultValue");
            httpPort = bundle.getString("svcHTTPPortDefaultValue");
            selectedProtocolValue = bundle.getString("svcProtocolDefaultValue");
        }
        if (selectedProtocolValue.equalsIgnoreCase("both")) {
            enableHttpConnection = true;
            enableHttpsConnection = true;
        } else if (selectedProtocolValue.equalsIgnoreCase("https")) {
            enableHttpsConnection = true;
        } else if (selectedProtocolValue.equalsIgnoreCase("http")) {
            enableHttpConnection = true;
        }
        String[][] stringArrayArray = new String[4][];
        stringArrayArray[0] = new String[]{"enableHttpConnection", String.valueOf(enableHttpConnection)};
        stringArrayArray[1] = new String[]{"enableHttpsConnection", String.valueOf(enableHttpsConnection)};
        if (httpPort != null) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "httpPort";
            stringArray2 = stringArray3;
            stringArray3[1] = httpPort;
        } else {
            stringArray2 = stringArrayArray[2] = null;
        }
        if (httpsPort != null) {
            String[] stringArray4 = new String[2];
            stringArray4[0] = "httpsPort";
            stringArray = stringArray4;
            stringArray4[1] = httpsPort;
        } else {
            stringArray = null;
        }
        stringArrayArray[3] = stringArray;
        String[][] propertiesToBeSet = stringArrayArray;
        String script = this.resolveString(this.getCimConfigPath());
        script = ICAStringUtils.quoteOrUnquoteOnlyOnW32(script);
        if (this.isUserExecutablesAsInternalResources()) {
            try {
                String resourceName;
                String string = resourceName = Utilities.isWindows() ? "cimConfigScript" : "cimConfigUnixScript";
                script = Utilities.isUnix() ? Utilities.createTemporaryFile(resourceName) : Utilities.createTemporaryFile(resourceName, "cimconfig.bat");
            }
            catch (Exception resourceName) {
                // empty catch block
            }
        }
        PEGASUSActions pegasusActions = PEGASUSActions.instantiate();
        if (propertiesToBeSet.length > 0) {
            int i;
            String logMsg = ShowMessage.gi("Ins").resolve("DSPortsConfigAction.setConfig", null, null);
            ShowMessage.writeLogOutput(logMsg);
            support.getOperationState().setStatusDetail(logMsg);
            if (this.getEnvironmentVars().length > 0) {
                i = 0;
                while (i < this.environmentVars.length) {
                    this.environmentVars[i] = this.resolveString(this.environmentVars[i]);
                    ++i;
                }
            }
            i = 0;
            while (i < propertiesToBeSet.length) {
                String[] currentValues = propertiesToBeSet[i];
                if (currentValues != null) {
                    try {
                        pegasusActions.setProposedCimServerConfiguration(script, currentValues[0], currentValues[1], this.environmentVars);
                    }
                    catch (CmdException cmdEx) {
                        if (this.isUserExecutablesAsInternalResources()) {
                            Utilities.deleteAllYouCan(script);
                        }
                        throw new ProductException(601, cmdEx.getMessage());
                    }
                    catch (IOException ioEx) {
                        if (this.isUserExecutablesAsInternalResources()) {
                            Utilities.deleteAllYouCan(script);
                        }
                        throw new ProductException(601, ioEx.getMessage());
                    }
                }
                ++i;
            }
            if (this.isUserExecutablesAsInternalResources()) {
                Utilities.deleteAllYouCan(script);
            }
            logMsg = ShowMessage.gi("Ins").resolve("DSPortsConfigAction.setConfigDone", null, null);
            ShowMessage.writeLogOutput(logMsg);
            support.getOperationState().setStatusDetail("");
        }
    }

    public void replace(ProductAction oldAction, ProductActionSupport support) throws ProductException {
        this.install(support);
    }

    public String getCimConfigPath() {
        return this.cimConfigPath;
    }

    public void setCimConfigPath(String cimConfigPath) {
        this.cimConfigPath = cimConfigPath;
    }

    public int getEstimatedTimeToInstall() {
        return this.estimatedTimeToInstall;
    }

    public void setEstimatedTimeToInstall(int time) {
        this.estimatedTimeToInstall = time;
    }

    public boolean isUserExecutablesAsInternalResources() {
        return this.userExecutablesAsInternalResources;
    }

    public void setUserExecutablesAsInternalResources(boolean userExecutablesAsInternalResources) {
        this.userExecutablesAsInternalResources = userExecutablesAsInternalResources;
    }
}

