/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.product.actions;

import com.ibm.itcins.ica2.CimomActions;
import com.ibm.itcins.ica2.ICAInstConst;
import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICAProfileParser;
import com.ibm.itcins.ica2.ICASoftwareObjectUtils;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.Utilities;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductException;
import com.installshield.product.service.product.ProductService;
import com.installshield.util.FileUtils;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.service.ServiceException;
import java.io.IOException;

public class W32ICA2LdsConsoleRegistryUpdate
extends ProductAction {
    private ICAInstConst bundle;
    private CimomActions actions;
    private ProductService prodService;
    protected String ldsEarFilesInstallLocation;
    static /* synthetic */ Class class$0;

    public String getLdsEarFilesInstallLocation() {
        return this.ldsEarFilesInstallLocation;
    }

    public void setLdsEarFilesInstallLocation(String ldsEarFilesInstallLocation) {
        this.ldsEarFilesInstallLocation = ldsEarFilesInstallLocation;
    }

    public void install(ProductActionSupport support) throws ProductException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.itcins.ica2.ICAInstConst");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.bundle = (ICAInstConst)Utilities.instantiate(clazz.getName());
        this.actions = CimomActions.instantiate(this);
        String rootKey = null;
        String ibmKey = null;
        String rootIBMKey = null;
        String productKey = null;
        Object[] productVRMF = null;
        String productInstallLocation = null;
        String componentParentKey = null;
        String lodestoneKey = null;
        String[] lodestoneVRMF = null;
        String lodestoneInstallLocation = null;
        try {
            this.prodService = (ProductService)this.getService("productService");
            rootKey = this.bundle.getString("rootKey");
            ibmKey = this.bundle.getString("ibmKey");
            this.actions.createW2KIBMRootRegistryKey(rootKey, ibmKey);
            rootIBMKey = String.valueOf(rootKey) + "\\" + ibmKey;
            ICAProfileParser parser = new ICAProfileParser();
            String namesFile = ICAStringUtils.getSearchedFilePath("names.properties");
            try {
                String companyShortName = parser.getProfileString(namesFile, null, "companyShortName", "IBM");
                String brand = parser.getProfileString(namesFile, null, "brand", "");
                String productLongName = parser.getProfileString(namesFile, null, "productLongName", "");
                productKey = String.valueOf(companyShortName) + " " + brand + " " + productLongName;
            }
            catch (IOException e) {
                throw new ProductException(601, e.getMessage());
            }
            productVRMF = (String[])this.getServices().getValue("productVRMF");
            if (productVRMF == null) {
                throw new ProductException(601, ShowMessage.gi("ICAIns").resolve("NullGlobalVariable", new String[]{"productVRMF"}, null));
            }
            productInstallLocation = this.resolveString("$P(absoluteInstallLocation)");
            if (productInstallLocation == null) {
                throw new ProductException(601, ShowMessage.gi("ICAIns").resolve("NullGlobalVariable", new String[]{"InstallLocation"}, null));
            }
            this.actions.createW2KRegistryKey(rootIBMKey, productKey, (String[])productVRMF, productInstallLocation, false);
            componentParentKey = String.valueOf(rootIBMKey) + "\\" + productKey;
            lodestoneKey = this.resolveString("$P(lodestoneConsoleFeature.localizedDisplayName)");
            lodestoneVRMF = (String[])this.getServices().getValue("lodestoneGuiVRMF");
            if (lodestoneVRMF == null) {
                throw new ProductException(601, ShowMessage.gi("ICAIns").resolve("NullGlobalVariable", new String[]{"lodestoneGuiVRMF"}, null));
            }
            String ldsEarFlsLoc = this.getLdsEarFilesInstallLocation();
            if (ldsEarFlsLoc == null || ldsEarFlsLoc.length() == 0) {
                ldsEarFlsLoc = ICAInstGlobals.getString("LodestoneInstallableApps");
            }
            if ((lodestoneInstallLocation = FileUtils.createFileName(productInstallLocation, ldsEarFlsLoc)) == null) {
                throw new ProductException(601, ShowMessage.gi("ICAIns").resolve("NullGlobalVariable", new String[]{"LodestoneEarFiles.installLocation"}, null));
            }
            this.actions.createW2KRegistryKey(componentParentKey, lodestoneKey, lodestoneVRMF, lodestoneInstallLocation.replace('/', '\\'), true);
            this.prodService.setProductBeanProperty("/product.xml", "product", "localizedDisplayName", String.valueOf(productKey) + " " + ICAStringUtils.arrayToString(productVRMF, "."));
        }
        catch (ServiceException serviceException) {
            throw new ProductException(601, serviceException.toString());
        }
    }

    public void uninstall(ProductActionSupport support) {
        this.actions = CimomActions.instantiate(this, 'I');
        this.actions.unregister();
    }

    public void replace(ProductAction oldAction, ProductActionSupport support) throws ProductException {
        Win32RegistryService winService = null;
        ICAInstConst bundle = null;
        String productKey = null;
        String winUninstaller = null;
        String cimAgentUninstallerKey = null;
        String productName = null;
        Object[] currentVersionToBeSet = null;
        this.install(support);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.itcins.ica2.ICAInstConst");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        bundle = (ICAInstConst)Utilities.instantiate(clazz.getName());
        try {
            productKey = ICASoftwareObjectUtils.getInstallingProductUID();
            winUninstaller = bundle.getString("svcUninstallerRegistryKey");
            productName = ShowMessage.gi("ICAIns").resolve("ICAInstall.folder", null, null);
            currentVersionToBeSet = (String[])this.getServices().getValue("productVRMF");
            cimAgentUninstallerKey = String.valueOf(winUninstaller) + productKey;
            winService = (Win32RegistryService)this.getService("win32RegistryService");
            if (winService.keyExists(4, cimAgentUninstallerKey)) {
                winService.setStringValue(4, cimAgentUninstallerKey, "DisplayName", false, String.valueOf(productName) + " " + ICAStringUtils.arrayToString(currentVersionToBeSet, "."));
            }
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("ICAInstall.ServiceExceptionOccured", new String[]{serviceException.getMessage()}, null));
        }
    }
}

