/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.product.actions;

import com.ibm.itcins.ica2.CimomActions;
import com.ibm.itcins.ica2.ICAInstConst;
import com.ibm.itcins.ica2.ICAProfileParser;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.Utilities;
import com.ibm.itcins.ica2.W32RegistryUtils;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.service.product.ProductService;
import com.installshield.wizard.service.ServiceException;
import java.io.IOException;

public class W32ICA2RegistryUpdate
extends ProductAction {
    private ICAInstConst bundle;
    private CimomActions actions;
    private ProductService prodService;
    private String oldProductName = "";
    protected String slpFilesInstallLocation;
    protected String cimomFilesInstallLocation;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public String getSlpFilesInstallLocation() {
        return this.slpFilesInstallLocation;
    }

    public void setSlpFilesInstallLocation(String slpFilesInstallLocation) {
        this.slpFilesInstallLocation = slpFilesInstallLocation;
    }

    public String getCimomFilesInstallLocation() {
        return this.cimomFilesInstallLocation;
    }

    public void setCimomFilesInstallLocation(String cimomFilesInstallLocation) {
        this.cimomFilesInstallLocation = cimomFilesInstallLocation;
    }

    public void build(ProductBuilderSupport support) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.itcins.ica2.W32ICAInstConst");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            support.putClass(clazz.getName());
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("com.ibm.itcins.ica2.W32RegistryUtils");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            support.putClass(clazz2.getName());
        }
        catch (IOException ioException) {
            this.logEvent(this, "err", ioException);
        }
        support.putRequiredService("win32RegistryService");
    }

    public void install(ProductActionSupport support) throws ProductException {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("com.ibm.itcins.ica2.ICAInstConst");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.bundle = (ICAInstConst)Utilities.instantiate(clazz.getName());
        this.actions = CimomActions.instantiate(this);
        String rootKey = null;
        String ibmKey = null;
        String rootIBMKey = null;
        String productKey = null;
        Object[] productVRMF = null;
        String productInstallLocation = null;
        try {
            this.prodService = (ProductService)this.getService("productService");
            rootKey = this.bundle.getString("rootKey");
            ibmKey = this.bundle.getString("ibmKey");
            this.actions.createW2KIBMRootRegistryKey(rootKey, ibmKey);
            rootIBMKey = String.valueOf(rootKey) + "\\" + ibmKey;
            ICAProfileParser parser = new ICAProfileParser();
            String namesFile = ICAStringUtils.getSearchedFilePath("names.properties");
            try {
                String companyShortName = parser.getProfileString(namesFile, null, "companyShortName", "IBM");
                String brand = parser.getProfileString(namesFile, null, "brand", "");
                String productLongName = parser.getProfileString(namesFile, null, "productLongName", "");
                productKey = String.valueOf(companyShortName) + " " + brand + " " + productLongName;
            }
            catch (IOException e) {
                throw new ProductException(601, e.getMessage());
            }
            productVRMF = (String[])this.getServices().getValue("productVRMF");
            if (productVRMF == null) {
                throw new ProductException(601, ShowMessage.gi("ICAIns").resolve("NullGlobalVariable", new String[]{"productVRMF"}, null));
            }
            productInstallLocation = this.resolveString("$P(absoluteInstallLocation)");
            if (productInstallLocation == null) {
                throw new ProductException(601, ShowMessage.gi("ICAIns").resolve("NullGlobalVariable", new String[]{"InstallLocation"}, null));
            }
            this.actions.createW2KRegistryKey(rootIBMKey, productKey, (String[])productVRMF, productInstallLocation, true);
            this.setOldProductName(productKey);
            this.prodService.setProductBeanProperty("/product.xml", "product", "localizedDisplayName", String.valueOf(productKey) + " " + ICAStringUtils.arrayToString(productVRMF, "."));
        }
        catch (ServiceException serviceException) {
            throw new ProductException(601, serviceException.toString());
        }
    }

    public void uninstall(ProductActionSupport support) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("com.ibm.itcins.ica2.ICAInstConst");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.bundle = (ICAInstConst)Utilities.instantiate(clazz.getName());
        String parentKey = String.valueOf(this.bundle.getString("rootKey")) + "\\" + this.bundle.getString("ibmKey");
        if (this.getOldProductName() != null) {
            W32RegistryUtils.deleteRegistryKey(parentKey, this.getOldProductName());
        }
    }

    public void replace(ProductAction oldAction, ProductActionSupport support) throws ProductException {
        oldAction.uninstall(support);
        this.install(support);
        ((W32ICA2RegistryUpdate)oldAction).setOldProductName(this.resolveString("$GLOBAL(Product_ShortDisplayName)"));
    }

    public String getOldProductName() {
        return this.oldProductName;
    }

    public void setOldProductName(String string) {
        this.oldProductName = string;
    }
}

