/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.product.actions.externalfiles;

import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.Utilities;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductException;
import com.installshield.product.RequiredBytesTable;
import com.installshield.product.actions.ExternalFiles;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.service.file.FileService;
import java.lang.reflect.Method;

public class ICAExternalFilesUninstBeforeReplace
extends ExternalFiles {
    private boolean uninstallBeforeReplace = true;
    private String displayMessage = "";

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public void setDisplayMessage(String displayMessage) {
        this.displayMessage = displayMessage;
    }

    public boolean isUninstallBeforeReplace() {
        return this.uninstallBeforeReplace;
    }

    public void setUninstallBeforeReplace(boolean uninstallBeforeReplace) {
        this.uninstallBeforeReplace = uninstallBeforeReplace;
    }

    public void install(ProductActionSupport support) throws ProductException {
        String message;
        if (this.uninstallBeforeReplace) {
            String doc_dir = "";
            doc_dir = (String)Utilities.getServices(this).getValue("doc_dir");
            try {
                FileService fileService = (FileService)this.getService("fileService");
                if (fileService.fileExists(doc_dir)) {
                    Utilities.deleteAllYouCan(doc_dir);
                    String mess = ShowMessage.gi("ICAIns").resolve("Install.deleteOldFiles", new String[]{doc_dir}, null);
                    ShowMessage.writeLogOutput(mess);
                }
            }
            catch (Exception fileService) {
                // empty catch block
            }
        }
        if ((message = this.resolveString(this.getDisplayMessage())) != null && message.length() > 0) {
            support.getOperationState().setStatusDetail(message);
            ShowMessage.writeLogOutput(message);
        }
        int nrerrsBefore = this.getNrOfErrors();
        super.install(support);
        int nrerrsAfter = this.getNrOfErrors();
        if (nrerrsAfter > nrerrsBefore) {
            support.getOperationState().setStatusDetail("");
            String errorText = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.installError", new String[]{this.getBeanId()});
            throw new ProductException(601, errorText);
        }
        support.getOperationState().setStatusDetail("");
    }

    public void replace(ProductAction oldAction, ProductActionSupport support) throws ProductException {
        if (this.isUninstallBeforeReplace()) {
            oldAction.uninstall(support);
        }
        this.install(support);
    }

    public RequiredBytesTable getRequiredBytesForReplace() throws ProductException {
        return this.getRequiredBytes();
    }

    public int getEstimatedTimeToReplace() {
        return this.getEstimatedTimeToInstall();
    }

    protected int getNrOfErrors() {
        int nrerrs = 0;
        String PRODUCT_URL = "/product.xml";
        String psk = "productService.logSummary(2, " + PRODUCT_URL;
        Object logSummary = this.getServices().getValue(psk);
        if (logSummary != null) {
            Class<?> cls = logSummary.getClass();
            Method meth = null;
            try {
                meth = cls.getDeclaredMethod("errorCount", null);
                if (meth != null) {
                    nrerrs = (Integer)meth.invoke(logSummary, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nrerrs;
    }
}

