/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.product.actions.externalfiles;

import com.ibm.itcins.ica2.BackupFile;
import com.ibm.itcins.ica2.CimomActions;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.Utilities;
import com.ibm.itcins.ica2.product.actions.externalfiles.ICA2ExternalFiles;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductException;
import com.installshield.product.RequiredBytesTable;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;

public class SLPExternalFiles
extends ICA2ExternalFiles {
    public void install(ProductActionSupport support) throws ProductException {
        String mess = ShowMessage.gi("ICAIns").resolve("ICAInstall.SLPFiles", null, null);
        int filesToBeCopied = this.getFilesCount();
        if (filesToBeCopied != 0) {
            support.getOperationState().setStatusDetail(mess);
            ShowMessage.writeLogOutput(mess);
        }
        super.install(support);
    }

    public void replace(ProductAction oldAction, ProductActionSupport support) throws ProductException {
        String source = null;
        String dest = null;
        FileService sfs = null;
        CimomActions actions = CimomActions.instantiate(this);
        if (actions.mustSave()) {
            source = Utilities.concatenateDirFile(this.getInstallLocation(), "slp.conf");
            dest = Utilities.concatenateDirFile(this.getInstallLocation(), "slp.conf.sav");
            try {
                sfs = (FileService)this.getService("fileService");
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            try {
                if (sfs.fileExists(source)) {
                    sfs.copyFile(source, dest, true);
                }
            }
            catch (ServiceException e) {
                String text = ShowMessage.gi("ICAIns").resolve("ICAInstall.CantCopyFile", new String[]{source, dest}, null);
                throw new ProductException(601, text);
            }
        }
        this.install(support);
        if (actions.mustSave()) {
            String backupFile = null;
            try {
                backupFile = BackupFile.makeABackup(source, null, 2);
            }
            catch (Exception text) {
                // empty catch block
            }
            try {
                if (sfs.fileExists(dest)) {
                    sfs.copyFile(dest, source, true);
                }
            }
            catch (ServiceException e) {
                String text = ShowMessage.gi("ICAIns").resolve("ICAInstall.CantRestoreFile", new String[]{dest, source}, null);
                ShowMessage.writeLogOutput(text);
            }
        }
    }

    public RequiredBytesTable getRequiredBytesForReplace() throws ProductException {
        return this.getRequiredBytes();
    }

    public int getEstimatedTimeToReplace() {
        return this.getEstimatedTimeToInstall();
    }
}

