/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.wizardbeans;

import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.Utilities;
import com.installshield.product.service.product.ProductService;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.service.ServiceException;
import java.util.Properties;

public class DeleteFileOrDirectory
extends WizardAction {
    private boolean executeAfterInstall = true;
    private String fileName = null;

    public void execute(WizardBeanEvent event) {
        String filename = this.resolveString(this.getFileName());
        if (filename == null || filename.length() == 0) {
            return;
        }
        if (this.isExecuteAfterInstall()) {
            if (this.successInstall()) {
                Utilities.deleteAllYouCan(filename);
            }
        } else {
            Utilities.deleteAllYouCan(filename);
        }
    }

    public boolean isExecuteAfterInstall() {
        return this.executeAfterInstall;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setExecuteAfterInstall(boolean executeAfterInstall) {
        this.executeAfterInstall = executeAfterInstall;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private boolean successInstall() {
        String PRODUCT_URL = "/product.xml";
        boolean success = false;
        try {
            int nrerrs = -1;
            ProductService prodService = (ProductService)this.getService("productService");
            Properties props = prodService.getProductSummary("/product.xml", 2, "text");
            String nrerrsString = props.getProperty("summary.error.count");
            if (nrerrsString != null) {
                try {
                    nrerrs = Integer.parseInt(nrerrsString.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (nrerrs >= 0) {
                success = nrerrs == 0;
            } else {
                String translatedMsg;
                String message = props.getProperty("summary.msg");
                if (message != null && (translatedMsg = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "installationError")) != null && translatedMsg.trim().length() > 0) {
                    success = !(message = message.trim()).startsWith(translatedMsg = translatedMsg.trim());
                }
            }
        }
        catch (ServiceException exception) {
            ShowMessage.writeLogOutput("err", exception.toString());
        }
        return success;
    }
}

