/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.wizardbeans;

import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ProcUtl;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.WizardActionTimeBasedPercentEstimator;
import com.installshield.util.FileUtils;
import com.installshield.wizard.CancelableWizardAction;
import com.installshield.wizard.RunnableWizardBeanState;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizardx.progress.StandardProgressRenderer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class MigrateUserAction
extends CancelableWizardAction {
    static final int TIME_FOR_EACH_CLUSTER = 50;
    static final String Cluster_XML_Header = "<?xml version=\"1.0\" ?><clusters>";
    static final String Cluster_XML_Footer = "</clusters>";
    static final String Cluster_XML_Element = "<cluster id=\"{0}\" name=\"{1}\" ip=\"{2}\" port=\"5989\" protocol=\"https\" namespace=\"root/ibm\"  version=\"{3}\"/>";
    private String[] returnClusters = null;
    private String[] clusterID = null;
    private String[] clusterPassword = null;
    private int clusterNum = 0;

    public MigrateUserAction() {
        this.setCancelable(false);
        this.setProgressRenderer(new StandardProgressRenderer());
    }

    public void execute(WizardBeanEvent event) {
        this.returnClusters = (String[])ICAInstGlobals.getValue("returnClusters");
        this.clusterID = (String[])ICAInstGlobals.getValue("clusterID");
        this.clusterPassword = (String[])ICAInstGlobals.getValue("clusterPassword");
        this.clusterNum = (Integer)ICAInstGlobals.getValue("clusterNum");
        if (this.returnClusters[0] == "unknown" || this.clusterID[0] == "unknown" || this.clusterPassword[0] == "unknown") {
            return;
        }
        FileWriter fw = null;
        BufferedWriter buf = null;
        String backupDir = ICAInstGlobals.getString("backupKey");
        String sourceUsers = FileUtils.createFileName(backupDir, "cimserver.passwd");
        String userRoles = FileUtils.createFileName(backupDir, "roles.txt");
        String clusterVersion = "";
        String clusterName = "";
        String instDest = this.resolveString("$P(absoluteInstallLocation)");
        String targetClusterICAPath = FileUtils.createFileName(instDest, "console/embeddedWAS/profiles/SVCProfile/installedApps/SVCCell/ICAConsole.ear/ICAConsole.war/WEB-INF/clusters.xml");
        String support = FileUtils.createFileName(instDest, "support/pmigrate.bat");
        String javahome = FileUtils.createFileName(instDest, "console/embeddedWAS/java");
        String errormsg = "";
        String noaccmsg = "";
        Object[] cmd = new String[6];
        cmd[0] = ICAStringUtils.quote(support);
        cmd[1] = "PasswordFile=" + sourceUsers;
        cmd[2] = "RoleFile=" + userRoles;
        cmd[3] = "CimomUser=superuser";
        String[] env = new String[]{"JAVA_HOME=" + javahome, "SystemRoot=" + ICAInstGlobals.getServices().resolveString("$E(SystemRoot)")};
        int sindex = -1;
        int eindex = -1;
        String migrateAcct = "";
        String migrateUnAcct = "";
        boolean notReturnInfo = false;
        ShowMessage.gi("Ins").setWizardTitle(this);
        RunnableWizardBeanState state = this.getState();
        state.setStatusDescription("");
        WizardActionTimeBasedPercentEstimator estimator = new WizardActionTimeBasedPercentEstimator(state, 50 * this.clusterNum);
        try {
            fw = new FileWriter(new File(targetClusterICAPath));
            buf = new BufferedWriter(fw);
            buf.write(Cluster_XML_Header);
            if (new File(support).exists()) {
                int i = 0;
                while (i < this.clusterNum) {
                    clusterName = "";
                    clusterVersion = "";
                    notReturnInfo = true;
                    cmd[4] = "CimomIPAddress=" + this.returnClusters[i];
                    cmd[5] = "CimomPassword=********";
                    ProcUtl proc = new ProcUtl();
                    StringBuffer stdout = new StringBuffer();
                    StringBuffer stderr = new StringBuffer();
                    String cmdExec = ShowMessage.gi("Ins").resolve("Install.CmdToBeExecuted", new String[]{ICAStringUtils.arrayToString(cmd, " ")}, null);
                    ShowMessage.writeLogOutput(cmdExec);
                    cmd[5] = "CimomPassword=" + this.clusterPassword[i];
                    int rc = 0;
                    try {
                        rc = proc.execcmd((String[])cmd, env, false, null, (Object)stdout, (Object)stderr);
                        String infoMsg = ShowMessage.gi("Ins").resolve("SVCMigrateInfoPanel.Description", new String[]{this.returnClusters[i]}, null);
                        state.setStatusDetail(infoMsg);
                        if (estimator != null) {
                            while (proc.isProcessRunning()) {
                                estimator.updateOperationState();
                                estimator.sleep();
                            }
                            estimator.updateOperationState();
                        }
                        proc.waitForProcess();
                        String retCode = ShowMessage.gi("Ins").resolve("Install.CmdReturnCode", new String[]{new Integer(rc).toString()}, null);
                        ShowMessage.writeLogOutput(retCode);
                        String returnmsg = stdout.toString().trim();
                        ShowMessage.writeLogOutput(returnmsg);
                        String[] msgsent = returnmsg.split("\n");
                        int k = 0;
                        while (k < msgsent.length) {
                            Object[] args;
                            if (msgsent[k].indexOf("CIM_AGENT_INFORMATION") != -1) {
                                sindex = msgsent[k].toLowerCase().indexOf("cluster <");
                                eindex = msgsent[k].toLowerCase().indexOf("> at software version <");
                                clusterName = msgsent[k].substring(sindex + 9, eindex);
                                clusterVersion = "";
                            } else if (msgsent[k].indexOf("ADD_USER_SUCCESS") != -1) {
                                ICAInstGlobals.setValue("MigrateSuccessInfo", "true");
                                sindex = msgsent[k].toLowerCase().indexOf("user <");
                                eindex = msgsent[k].toLowerCase().indexOf("> with role");
                                args = new String[]{this.returnClusters[i], msgsent[k].substring(sindex + 6, eindex)};
                                migrateAcct = String.valueOf(migrateAcct) + ShowMessage.gi("ICAIns").resolve("MigrateUserAction.ADD_USER_SUCCESS", args, null);
                                notReturnInfo = false;
                            } else if (msgsent[k].indexOf("ADD_USER_ERROR") != -1) {
                                ICAInstGlobals.setValue("MigrateUnsuccessInfo", "true");
                                sindex = msgsent[k].toLowerCase().indexOf("user <");
                                eindex = msgsent[k].toLowerCase().indexOf("> already");
                                args = new String[]{this.returnClusters[i], msgsent[k].substring(sindex + 6, eindex)};
                                migrateUnAcct = String.valueOf(migrateUnAcct) + ShowMessage.gi("ICAIns").resolve("MigrateUserAction.ADD_USER_ERROR", args, null);
                                notReturnInfo = false;
                            }
                            ++k;
                        }
                    }
                    catch (Exception e) {
                        ShowMessage.writeLogOutput("Catch excpetion in migrating cluster " + this.returnClusters[i]);
                    }
                    String err = stderr.toString().trim();
                    if (err.length() > 0) {
                        err = ShowMessage.gi("Ins").resolve("Install.CmdReturnErrMsg", new String[]{err}, null);
                        ShowMessage.writeLogOutput(err);
                    }
                    if (notReturnInfo && rc != 0 || notReturnInfo && rc == 0 && err.length() > 0) {
                        ICAInstGlobals.setValue("MigrateErrorCode", "true");
                        errormsg = String.valueOf(errormsg) + ShowMessage.gi("ICAIns").resolve("SVCMigrateResultPanel.OutputMsgError", new String[]{this.returnClusters[i]}, null);
                    } else if (notReturnInfo && rc == 0 && err.length() == 0) {
                        ICAInstGlobals.setValue("MigrateNoAccu", "true");
                        noaccmsg = String.valueOf(noaccmsg) + ShowMessage.gi("ICAIns").resolve("SVCMigrateResultPanel.UnDoneMigrate", new String[]{this.returnClusters[i]}, null);
                    }
                    String[] args = new String[]{this.clusterID[i], clusterName, this.returnClusters[i], clusterVersion};
                    String temp_xml_format = Cluster_XML_Element;
                    int index = -1;
                    int j = 0;
                    while (j < args.length) {
                        index = temp_xml_format.indexOf("{" + String.valueOf(j) + "}");
                        if (index != -1) {
                            temp_xml_format = String.valueOf(temp_xml_format.substring(0, index)) + args[j] + temp_xml_format.substring(index + 3, temp_xml_format.length());
                        }
                        ++j;
                    }
                    buf.write(temp_xml_format);
                    ++i;
                }
            } else {
                ICAInstGlobals.setValue("MigrateErrorCode", "true");
                errormsg = ShowMessage.gi("ICAIns").resolve("SVCMigrateResultPanel.NoPMigrateScript", null, null);
                ICAInstGlobals.setValue("MigrateErrorMessage", errormsg);
            }
            ICAInstGlobals.setValue("MigrateAccounts", migrateAcct);
            ICAInstGlobals.setValue("MigrateUnAccounts", migrateUnAcct);
            ICAInstGlobals.setValue("MigrateErrorMessage", errormsg);
            ICAInstGlobals.setValue("MigrateNoAccounts", noaccmsg);
            ShowMessage.writeLogOutput(migrateAcct);
            ShowMessage.writeLogOutput(migrateUnAcct);
            ShowMessage.writeLogOutput(errormsg);
            ShowMessage.writeLogOutput(noaccmsg);
            buf.write(Cluster_XML_Footer);
            buf.close();
            fw.close();
        }
        catch (IOException e) {
            if (buf != null) {
                try {
                    buf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ShowMessage.writeLogOutput("clusters.xml failed in creation");
            e.printStackTrace();
        }
        catch (Exception e) {
            ShowMessage.writeLogOutput("clusters.xml failed in creation");
            e.printStackTrace();
        }
        if (estimator != null) {
            estimator.completeOperationState();
        }
    }
}

