/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.wizardbeans;

import com.ibm.itcins.ica2.BackupFile;
import com.ibm.itcins.ica2.BldUtil;
import com.ibm.itcins.ica2.ICAInstConst;
import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICASoftwareObjectUtils;
import com.ibm.itcins.ica2.ShowMessage;
import com.installshield.util.FileUtils;
import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SVCBackupFiles
extends WizardAction {
    static final String Cluster_XML_Header = "<?xml version=\"1.0\" ?><clusters>";
    static final String Cluster_XML_Footer = "</clusters>";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void build(WizardBuilderSupport support) {
        try {
            new BldUtil();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.itcins.ica2.BackupFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BldUtil.putClass(support, clazz.getName());
        }
        catch (Exception ioException) {
            support.logEvent(this, "err", ioException.toString());
        }
    }

    public void execute(WizardBeanEvent event) {
        if (ICAInstGlobals.getInt("WizardActionInstallationStatus", 0) != 0) {
            return;
        }
        FileWriter fw = null;
        BufferedWriter bufWriter = null;
        String val = ICAInstGlobals.getString("saveConfiguration");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.ibm.itcins.ica2.ICAInstConst");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICAInstConst bundle = (ICAInstConst)BldUtil.instantiate(clazz.getName());
        String keytarget = null;
        String oldInstallDir = null;
        FileService sfs = null;
        String backupDir = bundle.getString("backupLocation");
        String instDest = this.resolveString("$P(absoluteInstallLocation)");
        String text = null;
        String installedVRMF = ICAInstGlobals.getString("installedVersion");
        boolean preserveConfig = val != null && val.toUpperCase().startsWith("Y");
        ShowMessage.gi("Ins").setWizardTitle(this);
        if (installedVRMF.equals("") && !preserveConfig) {
            ShowMessage.gi("Ins").setWizardTitle(null);
            return;
        }
        try {
            keytarget = BackupFile.createABackupDir(backupDir, instDest);
            ICAInstGlobals.setString("backupKey", keytarget);
        }
        catch (IOException ex) {
            text = ShowMessage.gi("Ins").resolve("BackupFiles.cantCreateBackupDir", new String[]{keytarget}, null);
            ShowMessage.writeLogOutput("err", text);
        }
        String[] oldInstallDirs = ICASoftwareObjectUtils.getProductInstallLocations("ibmcimagentsvc");
        if (oldInstallDirs != null && oldInstallDirs.length > 0) {
            oldInstallDir = oldInstallDirs[0];
        } else if (ICASoftwareObjectUtils.isProductInstalled()) {
            oldInstallDir = ICASoftwareObjectUtils.getInstallingProductLastInstallationPath();
        }
        if (oldInstallDir == null || oldInstallDir.trim().length() == 0) {
            return;
        }
        String fileNameWAS6 = null;
        try {
            sfs = (FileService)this.getService("fileService");
            fileNameWAS6 = FileUtils.createFileName(oldInstallDir, "console/embeddedWAS/profiles/SVCProfile/config/cells");
            fileNameWAS6 = FileUtils.createFileName(fileNameWAS6, ICAInstGlobals.getServices().resolveString("$P(createWASProfile.cellName)"));
            fileNameWAS6 = FileUtils.createFileName(fileNameWAS6, "nodes");
            fileNameWAS6 = FileUtils.createFileName(fileNameWAS6, ICAInstGlobals.getServices().resolveString("$P(createWASProfile.nodeName)"));
            fileNameWAS6 = FileUtils.createFileName(fileNameWAS6, "serverindex.xml");
            String was6_config_src = FileUtils.createFileName(fileNameWAS6, null);
            String was6_config_tgt = FileUtils.createFileName(keytarget, "serverindex.xml");
            if (sfs.fileExists(was6_config_src)) {
                sfs.copyFile(was6_config_src.replace('/', '\\'), was6_config_tgt, true);
            }
            String sourceDevice = FileUtils.createFileName(oldInstallDir, "cimom/config/devices.txt");
            String targetDevice = FileUtils.createFileName(keytarget, "devices.txt");
            String sourceUsers = FileUtils.createFileName(oldInstallDir, "cimom/pegasus/cimserver.passwd");
            String targetUsers = FileUtils.createFileName(keytarget, "cimserver.passwd");
            String sourceRoles = FileUtils.createFileName(oldInstallDir, "cimom/roles.txt");
            String targetRoles = FileUtils.createFileName(keytarget, "roles.txt");
            String ppksource = FileUtils.createFileName(String.valueOf(oldInstallDir) + "/cimom", "icat.ppk");
            String ppktarget = FileUtils.createFileName(keytarget, "icat.ppk");
            if (new File(ppksource).exists()) {
                sfs.copyFile(ppksource, ppktarget, true);
                ShowMessage.writeLogOutput("backup icat.ppk sucessfully");
            }
            if (sfs.fileExists(sourceDevice)) {
                sfs.copyFile(sourceDevice.replace('/', '\\'), targetDevice, true);
            }
            if (sfs.fileExists(sourceUsers)) {
                int len;
                FileInputStream in = new FileInputStream(new File(sourceUsers));
                FileOutputStream out = new FileOutputStream(new File(targetUsers));
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            if (sfs.fileExists(sourceRoles)) {
                sfs.copyFile(sourceRoles.replace('/', '\\'), targetRoles, true);
            } else {
                File file = new File(targetRoles);
                file.createNewFile();
            }
            ShowMessage.writeLogOutput("CIMOM config files back up succeeded");
        }
        catch (ServiceException e) {
            ShowMessage.writeLogOutput("CIMOM config files back up failed");
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            ShowMessage.writeLogOutput("CIMOM config files back up failed");
            e.printStackTrace();
        }
        catch (IOException e) {
            ShowMessage.writeLogOutput("CIMOM config files back up failed");
            e.printStackTrace();
        }
        String clusterICAPath = FileUtils.createFileName(oldInstallDir, "console/embeddedWAS/profiles/SVCProfile/installedApps/SVCCell/ICAConsole.ear/ICAConsole.war/WEB-INF/clusters.xml");
        String targetClusterICAPath = FileUtils.createFileName(keytarget, "clusters.xml");
        try {
            if (sfs.fileExists(clusterICAPath)) {
                sfs.copyFile(clusterICAPath.replace('/', '\\'), targetClusterICAPath, true);
            } else {
                try {
                    fw = new FileWriter(new File(targetClusterICAPath));
                    bufWriter = new BufferedWriter(fw);
                    bufWriter.write(Cluster_XML_Header);
                    bufWriter.write(Cluster_XML_Footer);
                    bufWriter.close();
                    fw.close();
                }
                catch (IOException e) {
                    if (bufWriter != null) {
                        try {
                            bufWriter.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (fw != null) {
                        try {
                            fw.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    ShowMessage.writeLogOutput("clusters.xml failed in creation");
                    e.printStackTrace();
                }
                catch (Exception e) {
                    ShowMessage.writeLogOutput("clusters.xml failed in creation");
                    e.printStackTrace();
                }
            }
            ShowMessage.writeLogOutput("Embedded CIMOM user and cluster files back up succeeded");
        }
        catch (ServiceException e) {
            ShowMessage.writeLogOutput("Embedded CIMOM user and cluster files back up failed");
            e.printStackTrace();
        }
        ShowMessage.gi("Ins").setWizardTitle(null);
    }
}

