/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.wizardbeans;

import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICASoftwareObjectUtils;
import com.ibm.itcins.ica2.ShowMessage;
import com.installshield.util.FileUtils;
import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import java.io.File;

public class SVCRestoreFiles
extends WizardAction {
    public void execute(WizardBeanEvent event) {
        String backupDir;
        boolean preserveConfig;
        if (!ICASoftwareObjectUtils.successInstall()) {
            return;
        }
        ShowMessage.gi("Ins").setWizardTitle(this);
        String val = ICAInstGlobals.getString("saveConfiguration");
        boolean bl = preserveConfig = val != null && val.toUpperCase().startsWith("Y");
        if (preserveConfig && (backupDir = ICAInstGlobals.getString("backupKey")) != null) {
            try {
                FileService sfs = (FileService)this.getService("fileService");
                String instDest = this.resolveString("$P(absoluteInstallLocation)");
                String clusterICAPath = FileUtils.createFileName(backupDir, "clusters.xml");
                String targetClusterICAPath = FileUtils.createFileName(instDest, "console/embeddedWAS/profiles/SVCProfile/installedApps/SVCCell/ICAConsole.ear/ICAConsole.war/WEB-INF/clusters.xml");
                File icatBackupDir = new File(instDest, "cimom");
                if (!icatBackupDir.exists()) {
                    icatBackupDir.mkdir();
                }
                String sourceKey = FileUtils.createFileName(backupDir, "icat.ppk");
                String targetKey = FileUtils.createFileName(icatBackupDir.getPath(), "icat.ppk");
                if (sfs.fileExists(clusterICAPath)) {
                    sfs.copyFile(clusterICAPath.replace('/', '\\'), targetClusterICAPath, true);
                    ShowMessage.writeLogOutput("Embedded CIMOM user and cluster files restore succeeded");
                }
                ShowMessage.writeLogOutput("source key:" + sourceKey);
                ShowMessage.writeLogOutput("target key:" + targetKey);
                if (sfs.fileExists(sourceKey)) {
                    sfs.copyFile(sourceKey, targetKey, true);
                    ShowMessage.writeLogOutput("restore icat.ppk sucessfully");
                }
            }
            catch (ServiceException e) {
                ShowMessage.writeLogOutput("Embedded CIMOM user and cluster files restore failed");
                e.printStackTrace();
            }
        }
        ShowMessage.gi("Ins").setWizardTitle(null);
    }
}

