/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.wizardbeans;

import com.ibm.itcins.ica2.BldUtil;
import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICASoftwareObjectUtils;
import com.ibm.itcins.ica2.ProcessesUtl;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.WizardActionTimeBasedPercentEstimator;
import com.ibm.itcins.ica2.exceptions.CmdException;
import com.installshield.wizard.CancelableWizardAction;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.SystemUtilService;
import com.installshield.wizardx.progress.StandardProgressRenderer;
import java.io.IOException;

public class SVCStartWASServer
extends CancelableWizardAction {
    private String serviceName;
    private String serviceDisplayName;
    private String processIdentifier;
    private String startCommand;
    private boolean useActionTimeBaseEstimator = false;
    private int estimtedTimeToStart = 0;
    private int verbose;
    private String[] environmentVars = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SVCStartWASServer() {
        this.setProgressRenderer(new StandardProgressRenderer());
        this.setCancelable(false);
        this.verbose = 1;
        this.environmentVars = new String[0];
    }

    public void build(WizardBuilderSupport support) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.itcins.ica2.ProcessesUtl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BldUtil.putClass(support, clazz.getName());
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("com.ibm.itcins.ica2.WizardActionTimeBasedPercentEstimator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            support.putClass(clazz2.getName());
            super.build(support);
        }
        catch (Exception e) {
            support.logEvent(this, "err", e.toString());
        }
    }

    public void execute(WizardBeanEvent event) {
        block21: {
            boolean isRebootRequired = false;
            try {
                SystemUtilService sus = (SystemUtilService)this.getService("systemUtilService");
                isRebootRequired = sus.isRebootRequired();
            }
            catch (ServiceException sus) {
                // empty catch block
            }
            if (ICAInstGlobals.getInt("WizardActionInstallationStatus", 0) != 0 || !ICASoftwareObjectUtils.successInstall() || isRebootRequired) {
                return;
            }
            this.setBeanId("startWASServer");
            ICAInstGlobals.setInt("WASServerState", -1);
            ShowMessage.gi("Ins").setWizardTitle(this);
            try {
                String serviceDescription;
                ProcessesUtl utl = ProcessesUtl.instantiate(this);
                if (this.getEnvironmentVars().length > 0) {
                    int i = 0;
                    while (i < this.environmentVars.length) {
                        this.environmentVars[i] = this.resolveString(this.environmentVars[i]);
                        ++i;
                    }
                }
                if (!utl.isServiceInstalled(this.resolveString(this.getServiceName()))) {
                    ShowMessage.writeLogOutput("Starting SVC WAS service error: service is not installed");
                    break block21;
                }
                WizardActionTimeBasedPercentEstimator estimator = null;
                if (this.useActionTimeBaseEstimator) {
                    estimator = new WizardActionTimeBasedPercentEstimator(this.getState(), this.getEstimtedTimeToStart());
                }
                if ((serviceDescription = utl.getServiceDescription(this.resolveString(this.getServiceName()))) == null || serviceDescription.equals("")) {
                    serviceDescription = this.resolveString(this.getServiceDisplayName());
                }
                String processId = this.resolveString(this.getServiceName());
                boolean isServiceRunning = false;
                isServiceRunning = utl.isServiceRunning(processId);
                if (!isServiceRunning) {
                    String txt = ShowMessage.gi(null).resolve("Install.StartingService", new String[]{serviceDescription}, null);
                    ShowMessage.writeLogOutput(txt);
                    this.getState().setStatusDescription(txt);
                    int rc = utl.startService(this.resolveString(this.getServiceName()), this.resolveString(this.getStartCommand()), this.getVerbose(), estimator);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (estimator != null) {
                        estimator.completeOperationState();
                    }
                    isServiceRunning = utl.isServiceRunning(processId);
                    if (rc != 0 || !isServiceRunning) {
                        txt = ShowMessage.gi(null).resolve("Install.StartingServiceFailed", new String[]{serviceDescription}, null);
                        ShowMessage.writeLogOutput(txt);
                        if (estimator != null) {
                            estimator.completeOperationState();
                        }
                        ICAInstGlobals.setInt("WASServerState", 2);
                    } else {
                        txt = ShowMessage.gi(null).resolve("Install.ServiceStarted", new String[]{serviceDescription}, null);
                        ShowMessage.writeLogOutput(txt);
                        if (estimator != null) {
                            estimator.completeOperationState();
                        }
                        ICAInstGlobals.setInt("WASServerState", 0);
                    }
                    break block21;
                }
                String txt = ShowMessage.gi(null).resolve("Install.ServiceAlreadyRunning", new String[]{serviceDescription}, null);
                ShowMessage.writeLogOutput(txt);
                if (estimator != null) {
                    estimator.completeOperationState();
                }
                ICAInstGlobals.setInt("WASServerState", 3);
            }
            catch (CmdException cmdException) {
                String txt = ShowMessage.gi(null).resolve("Install.ExceptionOccured", new String[]{cmdException.getMessage()}, null);
                ShowMessage.writeLogOutput("wrn", txt);
                ICAInstGlobals.setInt("WASServerState", 2);
            }
            catch (IOException ioEx) {
                String txt = ShowMessage.gi(null).resolve("Install.IOExceptionOccured", new String[]{ioEx.toString()}, null);
                ShowMessage.writeLogOutput(txt);
                ICAInstGlobals.setInt("WASServerState", 2);
            }
            catch (ServiceException serviceexception) {
                String txt = ShowMessage.gi(null).resolve("Install.ServiceExceptionOccured", new String[]{serviceexception.toString()}, null);
                ShowMessage.writeLogOutput(txt);
                ICAInstGlobals.setInt("WASServerState", 2);
            }
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isUseActionTimeBaseEstimator() {
        return this.useActionTimeBaseEstimator;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public void setUseActionTimeBaseEstimator(boolean b) {
        this.useActionTimeBaseEstimator = b;
    }

    public int getEstimtedTimeToStart() {
        return this.estimtedTimeToStart;
    }

    public int getVerbose() {
        return this.verbose;
    }

    public void setEstimtedTimeToStart(int i) {
        this.estimtedTimeToStart = i;
    }

    public void setVerbose(int i) {
        this.verbose = i;
    }

    public String getServiceDisplayName() {
        return this.serviceDisplayName;
    }

    public void setServiceDisplayName(String serviceDisplayName) {
        this.serviceDisplayName = serviceDisplayName;
    }

    public String getStartCommand() {
        return this.startCommand;
    }

    public void setStartCommand(String startCommand) {
        this.startCommand = startCommand;
    }

    public String getProcessIdentifier() {
        return this.processIdentifier;
    }

    public void setProcessIdentifier(String processIdentifier) {
        this.processIdentifier = processIdentifier;
    }

    public String[] getEnvironmentVars() {
        return this.environmentVars;
    }

    public void setEnvironmentVars(String[] environmentVars) {
        this.environmentVars = environmentVars;
    }
}

