/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.wizardbeans;

import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ProcUtl;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.Utilities;
import com.ibm.itcins.ica2.Utl;
import com.installshield.util.FileUtils;
import com.installshield.wizard.CancelableWizardAction;
import com.installshield.wizard.RunnableWizardBeanState;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.service.file.FileService;
import java.io.File;
import java.net.URL;

public class ShutDownEclipse
extends CancelableWizardAction {
    private static final String ECLIPSE_INFOCENTER_CLASS = "org.eclipse.help.standalone.Infocenter";
    private String wasInstallLocation;
    private String javaPath;
    private String eclipseLocation;
    private String eclipseJarPath;

    public void execute(WizardBeanEvent event) {
        String eclipseJar = this.resolveString(this.getEclipseJarPath());
        File eclipse = new File(eclipseJar);
        if (eclipse.exists()) {
            RunnableWizardBeanState state = this.getState();
            String infoMsg = ShowMessage.gi("Ins").resolve("Install.StoppingService", new String[]{"eclipse"}, null);
            state.setStatusDescription(infoMsg);
            String logMsg = ShowMessage.gi("Ins").resolve("StoppingEclipse", null, null);
            ShowMessage.writeLogOutput(logMsg);
            this.shutdownEclipse();
        }
    }

    private void shutdownEclipse() {
        StringBuffer cmd = new StringBuffer(255);
        cmd.append(ICAStringUtils.quoteOrUnquote(this.resolveString(this.getJavaPath()))).append(" -classpath ").append(ICAStringUtils.quoteOrUnquote(this.resolveString(this.getEclipseJarPath()))).append(" ").append(ECLIPSE_INFOCENTER_CLASS).append(" -command shutdown ").append(" -eclipsehome ").append(ICAStringUtils.quoteOrUnquote(this.resolveString(this.getEclipseLocation())));
        String tempBatFile = null;
        try {
            String string = tempBatFile = ICAStringUtils.isWindows() ? FileUtils.createTempFile(new URL("file:///NUL"), "ShutdownEclipse.bat") : FileUtils.createTempFile();
            if (Utilities.isUnix()) {
                Utl utl = Utl.instantiate();
                utl.setExecutePermisions(tempBatFile);
            }
            FileService sfs = (FileService)this.getService("fileService");
            sfs.appendToAsciiFile(tempBatFile, new String[]{cmd.toString()});
        }
        catch (Throwable t) {
            ShowMessage.writeLogOutput("Shut down eclipse failed");
        }
        int exitProc = -1;
        ProcUtl proc = new ProcUtl();
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        try {
            exitProc = proc.execcmd(ICAStringUtils.quoteOrUnquote(ICAStringUtils.goodSlashes(tempBatFile)), false, null, (Object)stdout, (Object)stderr);
            String Msg = ShowMessage.gi("Ins").resolve("EclipseStopped", null, null);
            ShowMessage.writeLogOutput(Msg);
            if (exitProc != 0) {
                ShowMessage.writeLogOutput("Shut down eclipse failed");
                ShowMessage.writeLogOutput(stderr.toString());
            } else {
                ShowMessage.writeLogOutput("Shut down eclipse successfully");
                String returnmsg = stdout.toString().trim();
                ShowMessage.writeLogOutput(returnmsg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ShowMessage.writeLogOutput(stderr.toString());
        }
        exitProc = proc.waitForProcess();
        if (tempBatFile != null) {
            FileUtils.deleteTempFile(tempBatFile);
        }
    }

    public String getEclipseJarPath() {
        return this.eclipseJarPath;
    }

    public void setEclipseJarPath(String eclipseJarPath) {
        this.eclipseJarPath = eclipseJarPath;
    }

    public String getEclipseLocation() {
        return this.eclipseLocation;
    }

    public void setEclipseLocation(String eclipseLocation) {
        this.eclipseLocation = eclipseLocation;
    }

    public String getJavaPath() {
        return this.javaPath;
    }

    public void setJavaPath(String javaPath) {
        this.javaPath = javaPath;
    }

    public String getWasInstallLocation() {
        return this.wasInstallLocation;
    }

    public void setWasInstallLocation(String wasInstallLocation) {
        this.wasInstallLocation = wasInstallLocation;
    }
}

