/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.wizardbeans;

import com.ibm.itcins.ica2.ICAInstConst;
import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICASoftwareObjectUtils;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.Utilities;
import com.installshield.util.FileUtils;
import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.service.file.FileService;

public class W32UpdateUninstallerIcon
extends WizardAction {
    static /* synthetic */ Class class$0;

    public void build(WizardBuilderSupport support) {
        super.build(support);
        try {
            support.putResource(this.getClass().getResource("icon.ico"), "uninstallerBrandIcon");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void execute(WizardBeanEvent event) {
        FileService fileService = null;
        Win32RegistryService winService = null;
        ICAInstConst bundle = null;
        String productKey = null;
        String winUninstaller = null;
        String cimAgentUninstallerKey = null;
        String iconFileName = "icon.ico";
        String iconSourceFilePath = null;
        String iconDestFilePath = null;
        String tempFilePath = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.itcins.ica2.ICAInstConst");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        bundle = (ICAInstConst)Utilities.instantiate(clazz.getName());
        try {
            productKey = ICASoftwareObjectUtils.getInstallingProductUID();
            winUninstaller = bundle.getString("svcUninstallerRegistryKey");
            cimAgentUninstallerKey = String.valueOf(winUninstaller) + productKey;
            tempFilePath = null;
            fileService = (FileService)this.getService("fileService");
            winService = (Win32RegistryService)this.getService("win32RegistryService");
            iconSourceFilePath = ICAStringUtils.getSearchedFilePath(iconFileName);
            if (winService.keyExists(4, cimAgentUninstallerKey) && winService.valueExists(4, cimAgentUninstallerKey, "UninstallString")) {
                if (iconSourceFilePath == null || !fileService.fileExists(iconSourceFilePath)) {
                    iconSourceFilePath = null;
                    iconSourceFilePath = tempFilePath = FileUtils.createTempFile(this.getResource("uninstallerBrandIcon"));
                }
                if (iconSourceFilePath != null && fileService.fileExists(iconSourceFilePath)) {
                    iconDestFilePath = winService.getStringValue(4, cimAgentUninstallerKey, "UninstallString", false);
                    iconDestFilePath = ICAStringUtils.unquote(iconDestFilePath);
                    iconDestFilePath = fileService.createFileName(fileService.getParent(iconDestFilePath), iconFileName);
                    fileService.copyFile(iconSourceFilePath, iconDestFilePath, true);
                    winService.setStringValue(4, cimAgentUninstallerKey, "DisplayIcon", false, iconDestFilePath);
                }
            }
            String installer = ICAInstGlobals.getString("InstallerDirectory");
            String noticeFd = fileService.createFileName(installer, "notices.txt");
            String instDest = this.resolveString("$P(absoluteInstallLocation)");
            String noticeDest = fileService.createFileName(instDest, "notices.txt");
            if (fileService.fileExists(noticeDest)) {
                fileService.deleteFile(noticeDest);
            }
            fileService.copyFile(noticeFd, noticeDest, true);
            String vpdfile = FileUtils.createFileName(ICAInstGlobals.getServices().resolveString("$D(os_main)"), "vpd.properties");
            FileService sfs = (FileService)this.getService("fileService");
            int index = -1;
            String temp = "";
            boolean needModify = false;
            if (sfs.fileExists(vpdfile)) {
                String[] vpdcontents = sfs.readAsciiFile(vpdfile);
                int i = 0;
                while (i < vpdcontents.length) {
                    if (vpdcontents[i].startsWith("ibmpegasussvc") && (index = vpdcontents[i].indexOf("uninstaller.dat")) != -1) {
                        temp = vpdcontents[i].substring(0, index);
                        vpdcontents[i] = temp = String.valueOf(temp) + "uninstall.dat" + vpdcontents[i].substring(index + 13, vpdcontents[i].length());
                        needModify = true;
                    }
                    ++i;
                }
                if (needModify) {
                    sfs.deleteFile(vpdfile);
                    sfs.createAsciiFile(vpdfile, vpdcontents);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tempFilePath != null) {
            try {
                FileUtils.deleteTempFile(tempFilePath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

