/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2.wizardbeans.conditions;

import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICASoftwareObjectUtils;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.VersionComparator;
import com.installshield.wizard.WizardBeanCondition;
import com.installshield.wizard.service.ServiceException;

public class ICA2InstallSpaceCheckCondition
extends WizardBeanCondition {
    public String defaultName() {
        return "ICA2 Install Space Check Condition";
    }

    public String describe() {
        return "Evaluate ICA2 Install Space Check Condition";
    }

    protected boolean evaluateTrueCondition() {
        VersionComparator comparator;
        int result;
        boolean preserveConfig;
        String installedVersion = ICAInstGlobals.getString("installedVersion");
        String val = ICAInstGlobals.getString("saveConfiguration");
        boolean bl = preserveConfig = val != null && val.toUpperCase().startsWith("Y");
        if (preserveConfig) {
            return false;
        }
        if (!installedVersion.equals("") && (result = (comparator = new VersionComparator()).compare(installedVersion, "4.3.1.0")) >= 0) {
            try {
                String productKey = ICASoftwareObjectUtils.getInstallingProductUID();
                String productPath = ICASoftwareObjectUtils.getLastInstallPath(productKey);
                String destDir = ICAInstGlobals.getString("installationDiretory");
                if (productPath.equals(destDir)) {
                    return false;
                }
            }
            catch (ServiceException serviceException) {
                ShowMessage.writeLogOutput(serviceException.toString());
            }
        }
        return true;
    }
}

