/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.AbstractArchiveWriterOutputStream;
import com.installshield.archive.ArchiveWriterEntry;
import com.installshield.archive.index.ArchiveIndexWriter;
import com.installshield.archive.index.DeflaterOutputStreamWrapper;
import com.installshield.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.DeflaterOutputStream;

public class ArchiveWriterDirOutputStream
extends AbstractArchiveWriterOutputStream {
    private String currentArchiveName = "";
    private OutputStream out = null;

    public ArchiveWriterDirOutputStream(String string, String string2, String string3, String string4, ArchiveIndexWriter archiveIndexWriter) {
        super(string, string2, string3, string4, archiveIndexWriter);
    }

    private void closeArchiveEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        this.closeArchiveStream();
        Date date = null;
        File file = new File(this.getCurrentArchiveName());
        if (file.isFile()) {
            date = new Date(file.lastModified());
        }
        archiveWriterEntry.setDate(date);
    }

    private void closeArchiveStream() throws IOException {
        block2: {
            try {
                if (this.out == null) break block2;
                this.out.close();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.out = null;
                this.resetDeflater();
                throw throwable;
            }
        }
        Object var2_1 = null;
        this.out = null;
        this.resetDeflater();
    }

    void closeInternalArchive() throws IOException {
        try {
            this.closeArchiveStream();
            this.setCurrentArchiveName("");
            this.fireApplicationArchiveFinished();
        }
        catch (IOException iOException) {
            throw new IOException("Could not close OutputStream: " + this.getCurrentArchiveName());
        }
    }

    void closeInternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        int n = archiveWriterEntry.getEntryType();
        if (n != 1 && n != 2 && n != 3) {
            throw new IOException("Unknown archive entry type: " + archiveWriterEntry.getId());
        }
        this.closeArchiveEntry(archiveWriterEntry);
    }

    private String createEntryName(String string, String string2) {
        String string3 = FileUtils.appendSeparator(FileUtils.normalizeFileName(string, File.separatorChar), File.separator);
        String string4 = FileUtils.normalizeFileName(string2, File.separatorChar);
        string3 = string4.startsWith(File.separator) ? String.valueOf(string3) + string4.substring(1) : String.valueOf(string3) + string4;
        return string3;
    }

    void flushInternalArchive() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public String getApplicationArchiveName() {
        return this.createArchiveFileName(this.getArchiveName(), 1);
    }

    public long getApplicationArchiveSize() throws IOException {
        return 0L;
    }

    private OutputStream getArchiveStream() {
        return this.out;
    }

    private String getCurrentArchiveName() {
        return this.currentArchiveName;
    }

    private void initArchiveStream(String string, boolean bl) throws IOException {
        if (this.out != null) {
            throw new IOException("Initialization Error:  Previous archive has not been closed.");
        }
        String string2 = this.createEntryName(this.getArchiveName(), string);
        String string3 = this.createArchiveFileName(string2, 1);
        if (string2.endsWith(File.separator)) {
            this.createDirs(string3);
            this.out = new ByteArrayOutputStream();
        } else {
            this.createDirsForArchive(string3);
            OutputStream outputStream = new FileOutputStream(string3);
            if (bl) {
                this.resetDeflater();
                outputStream = new DeflaterOutputStreamWrapper(new DeflaterOutputStream(outputStream, this.getDeflater()));
            }
            this.out = outputStream;
        }
        this.createMediaInf(1);
        this.setCurrentArchiveName(string3);
    }

    protected void putNextArchiveEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        this.putNextArchiveEntry(archiveWriterEntry, false);
    }

    void putNextArchiveEntry(ArchiveWriterEntry archiveWriterEntry, boolean bl) throws IOException {
        this.initArchiveStream(archiveWriterEntry.getId(), bl);
    }

    void putNextInternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        int n = archiveWriterEntry.getEntryType();
        if (n == 1 || n == 2) {
            this.putNextArchiveEntry(archiveWriterEntry, false);
        } else if (n == 3) {
            this.putNextArchiveEntry(archiveWriterEntry, true);
        } else {
            throw new IOException("Unknown archive entry type: " + archiveWriterEntry.getId());
        }
    }

    private void setCurrentArchiveName(String string) {
        this.currentArchiveName = string;
    }

    void writeToInternalArchive(ArchiveWriterEntry archiveWriterEntry, byte[] byArray, int n, int n2) throws IOException {
        OutputStream outputStream = this.getArchiveStream();
        outputStream.write(byArray, n, n2);
    }
}

