/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive.index;

import com.installshield.archive.index.ArchiveIndexEntry;
import com.installshield.archive.index.ArchiveIndexWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;

class ArchiveIndexEntryWriter {
    private Vector compressed;
    private Vector currentEntries;
    private int nextToken;
    private int packetSize;
    private ArchiveIndexWriter writer;

    ArchiveIndexEntryWriter(int n, ArchiveIndexWriter archiveIndexWriter) {
        this.writer = archiveIndexWriter;
        this.packetSize = n;
        this.compressed = new Vector(20000 / n);
        this.currentEntries = new Vector(n);
        this.nextToken = 1;
    }

    ArchiveIndexEntryWriter(ArchiveIndexWriter archiveIndexWriter) {
        this(1000, archiveIndexWriter);
    }

    synchronized void addEntry(ArchiveIndexEntry archiveIndexEntry) throws IOException {
        this.currentEntries.addElement(archiveIndexEntry);
        if (this.currentEntries.size() == this.currentEntries.capacity()) {
            this.compressCurrent();
        }
    }

    private void compressCurrent() throws IOException {
        if (this.currentEntries.size() > 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(200 * this.currentEntries.size());
            this.writer.resetDeflater();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, this.writer.getDeflater());
            DataOutputStream dataOutputStream = new DataOutputStream(deflaterOutputStream);
            int n = this.currentEntries.size();
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                ArchiveIndexEntry archiveIndexEntry = (ArchiveIndexEntry)this.currentEntries.elementAt(n2);
                dataOutputStream.writeInt(archiveIndexEntry.entryNumber);
                dataOutputStream.write(archiveIndexEntry.digest);
                dataOutputStream.writeUTF(archiveIndexEntry.fileName);
                dataOutputStream.writeInt(archiveIndexEntry.type);
                dataOutputStream.writeLong(archiveIndexEntry.size);
                dataOutputStream.writeInt(archiveIndexEntry.startMediaNumber);
                dataOutputStream.writeInt(archiveIndexEntry.endMediaNumber);
                dataOutputStream.writeBoolean(archiveIndexEntry.duplicateResource);
                dataOutputStream.writeBoolean(archiveIndexEntry.attributes != null);
                if (archiveIndexEntry.attributes != null) {
                    archiveIndexEntry.attributes.write(dataOutputStream);
                }
                dataOutputStream.writeLong(archiveIndexEntry.lastModified);
                dataOutputStream.writeByte(archiveIndexEntry.resourceType);
                dataOutputStream.writeUTF(archiveIndexEntry.source);
                dataOutputStream.writeInt(archiveIndexEntry.extra.length);
                dataOutputStream.write(archiveIndexEntry.extra);
                ++n2;
            }
            dataOutputStream.flush();
            deflaterOutputStream.finish();
            this.compressed.addElement(byteArrayOutputStream.toByteArray());
            this.currentEntries.removeAllElements();
        }
    }

    void write(OutputStream outputStream) throws IOException {
        this.compressCurrent();
        if (this.currentEntries.capacity() != this.packetSize) {
            throw new Error();
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(this.packetSize);
        dataOutputStream.writeInt(this.compressed.size());
        int n = 0;
        while (n < this.compressed.size()) {
            byte[] byArray = (byte[])this.compressed.elementAt(n);
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
            ++n;
        }
        dataOutputStream.flush();
    }
}

