/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.RequiredBytesTable;
import com.installshield.product.actions.DesktopIconExtra;
import com.installshield.product.service.desktop.DesktopService;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.StringResolverUtil;
import com.installshield.util.URLUtils;
import com.installshield.util.rex.Rex;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;

public class DesktopIcon
extends ProductAction {
    private String folder = "";
    private String name = "My Icon";
    private String args = "";
    private String workingDirectory = "";
    private String target = "";
    private String itemOwner = "";
    private String itemGroup = "";
    private String folderOwner = "";
    private String folderGroup = "";
    private boolean relativeTarget = true;
    private boolean workingDirectoryRelative = true;
    private String installedIconFile = "";
    private String installedFolder = "";
    private String installedFolderName = "";
    private String installedFolderContext = "";
    private String installedName = "";
    private String scriptFile = "";
    static final String TARGET_ABSOLUTE_INSTALL_LOCATION = "\\$P([^)]*absoluteInstallLocation)";
    static final String TARGET_ABSOLUTE_LAUNCHER_LOCATION = "\\$P([^)]*installedFileName)";
    static /* synthetic */ Class class$com$installshield$product$actions$DesktopIconBeanInfo;
    static /* synthetic */ Class class$com$installshield$product$actions$DesktopIconExtra;

    public void build(ProductBuilderSupport productBuilderSupport) {
        try {
            productBuilderSupport.putClass((class$com$installshield$product$actions$DesktopIconBeanInfo != null ? class$com$installshield$product$actions$DesktopIconBeanInfo : (class$com$installshield$product$actions$DesktopIconBeanInfo = DesktopIcon.class$("com.installshield.product.actions.DesktopIconBeanInfo"))).getName());
            productBuilderSupport.putClass((class$com$installshield$product$actions$DesktopIconExtra != null ? class$com$installshield$product$actions$DesktopIconExtra : (class$com$installshield$product$actions$DesktopIconExtra = DesktopIcon.class$("com.installshield.product.actions.DesktopIconExtra"))).getName());
            productBuilderSupport.putRequiredService("desktopService");
            productBuilderSupport.putRequiredService("fileService");
            Enumeration enumeration = this.getExtras();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                DesktopIconExtra desktopIconExtra = (DesktopIconExtra)enumeration.nextElement();
                if (desktopIconExtra.getIconFile() != null && desktopIconExtra.getIconFile().length() > 0 && desktopIconExtra.getIconFileType() == 2) {
                    String string = StringResolverUtil.resolveString(desktopIconExtra.getIconFile(), "iconFile", productBuilderSupport, desktopIconExtra, this.getServices());
                    if (!new File(string).exists()) {
                        productBuilderSupport.logEvent(this, "err", "Icon File: " + string + " does not exist.  " + "Unable to build " + this.getClass().getName());
                        return;
                    }
                    desktopIconExtra.setIconFile(string);
                    String string2 = FileUtils.getName(desktopIconExtra.getIconFile());
                    String string3 = String.valueOf(this.getBeanId()) + "/" + desktopIconExtra.getPlatformId() + "/" + string2;
                    productBuilderSupport.getWriter().putResource(desktopIconExtra.getIconFile(), string3);
                }
                bl = true;
            }
            if (this.isActive() && !bl) {
                productBuilderSupport.logEvent(this, "wrn", "No platform specific desktop icon properties included -- " + this.resolveString(this.getName()) + " will not be created at runtime");
            }
            try {
                if (this.isRelativeTarget() && (Rex.matches(this.getTarget(), TARGET_ABSOLUTE_INSTALL_LOCATION) || Rex.matches(this.getTarget(), TARGET_ABSOLUTE_LAUNCHER_LOCATION))) {
                    productBuilderSupport.logEvent(this, "wrn", "The Relative Target property should be false if the Target resolves to an absolute path.");
                }
            }
            catch (Exception exception) {}
        }
        catch (IOException iOException) {
            this.logEvent(this, "err", iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private String createFileName(String string, String string2) {
        return new File(string, string2).getAbsolutePath().replace('\\', File.separatorChar).replace('/', File.separatorChar);
    }

    private String createFileNameRelativeToDestination(String string) {
        return new File(this.getProductTree().getInstallLocation(this), string).getAbsolutePath();
    }

    public String getArgs() {
        return this.args;
    }

    private DesktopIconExtra getExtra(String string) {
        DesktopIconExtra desktopIconExtra = null;
        Dictionary dictionary = this.getExtendedProperties();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements() && desktopIconExtra == null) {
                Object k = enumeration.nextElement();
                Object v = dictionary.get(k);
                if (v == null || !(v instanceof DesktopIconExtra) || !string.equals(((DesktopIconExtra)v).getPlatformId())) continue;
                desktopIconExtra = (DesktopIconExtra)v;
            }
        }
        return desktopIconExtra;
    }

    private Enumeration getExtras() {
        Vector<DesktopIconExtra> vector = new Vector<DesktopIconExtra>();
        Dictionary dictionary = this.getExtendedProperties();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!(dictionary.get(string) instanceof DesktopIconExtra)) continue;
            vector.addElement((DesktopIconExtra)dictionary.get(string));
        }
        return vector.elements();
    }

    public String getFolder() {
        return this.folder;
    }

    public String getFolderGroup() {
        return this.folderGroup;
    }

    public String getFolderOwner() {
        return this.folderOwner;
    }

    public String getInstalledFolder() {
        return this.installedFolder;
    }

    public String getInstalledFolderContext() {
        return this.installedFolderContext;
    }

    public String getInstalledFolderName() {
        return this.installedFolderName;
    }

    public String getInstalledIconFile() {
        return this.installedIconFile;
    }

    public String getInstalledName() {
        return this.installedName;
    }

    public String getItemGroup() {
        return this.itemGroup;
    }

    public String getItemOwner() {
        return this.itemOwner;
    }

    public String getName() {
        return this.name;
    }

    public RequiredBytesTable getRequiredBytes() throws ProductException {
        try {
            RequiredBytesTable requiredBytesTable = new RequiredBytesTable();
            DesktopService desktopService = (DesktopService)this.getService("desktopService");
            DesktopIconExtra desktopIconExtra = this.getExtra(desktopService.getPlatformId());
            if (desktopIconExtra != null) {
                String string = desktopIconExtra.getIconFile();
                int n = desktopIconExtra.getIconFileType();
                if (string != null && string.trim().length() > 0 && n == 2) {
                    FileService fileService = (FileService)this.getService("fileService");
                    String[] stringArray = fileService.getPartitionNames();
                    String string2 = FileUtils.getName(string);
                    URL uRL = this.getResource(String.valueOf(this.getBeanId()) + "/" + desktopIconExtra.getPlatformId() + "/" + string2);
                    if (uRL != null) {
                        File file = new File(this.getProductTree().getInstallLocation(this), string2);
                        if (uRL.getProtocol().equals("file")) {
                            requiredBytesTable.addBytes(fileService.getPartitionName(file.getAbsolutePath(), stringArray), new File(uRL.getFile()).length());
                        } else if (uRL.getProtocol().equals("ismpfile")) {
                            requiredBytesTable.addBytes(fileService.getPartitionName(file.getAbsolutePath(), stringArray), new File(URLUtils.decode(uRL.getFile())).length());
                        }
                    } else {
                        throw new IOException(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DesktopIcon.iconResourceNotFound", new String[]{String.valueOf(this.getBeanId()) + "/" + string2}));
                    }
                }
            }
            return requiredBytesTable;
        }
        catch (Exception exception) {
            throw new ProductException(exception);
        }
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public String getTarget() {
        return this.target;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void install(ProductActionSupport productActionSupport) throws ProductException {
        try {
            DesktopService desktopService = (DesktopService)this.getService("desktopService");
            FileService fileService = (FileService)this.getService("fileService");
            DesktopIconExtra desktopIconExtra = this.getExtra(desktopService.getPlatformId());
            if (desktopIconExtra != null) {
                File file = new File(this.getProductTree().getInstallLocation(this));
                String string = this.getTarget();
                String string2 = null;
                boolean bl = this.isRelativeTarget();
                String string3 = desktopIconExtra.getPlatformSpecificTarget();
                if (string3 != null && string3.trim().length() > 0) {
                    string = string3;
                    bl = desktopIconExtra.isRelativePlatformSpecificTarget();
                }
                string2 = this.installIconFile(desktopIconExtra.getPlatformId(), desktopIconExtra.getIconFile(), desktopIconExtra.getIconFileType(), fileService);
                this.installedFolderContext = desktopIconExtra.getFolderContext();
                String string4 = bl ? this.createFileName(file.getAbsolutePath(), this.resolveString(string)) : FileUtils.normalizeFileName(this.resolveString(string));
                this.installedFolderName = this.resolveString(this.folder);
                String string5 = "";
                string5 = this.isWorkingDirectoryRelative() ? FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.resolveString(this.getWorkingDirectory())) : FileUtils.normalizeFileName(this.resolveString(this.getWorkingDirectory()));
                this.installedName = this.resolveString(this.name);
                this.scriptFile = desktopIconExtra.createScriptFile(string5, string4, this.resolveString(this.args));
                if (this.scriptFile != null && this.scriptFile.length() != 0) {
                    string4 = this.scriptFile;
                    this.args = "";
                    ((FileService)this.getServices().getService("fileService")).setFileExecutable(string4);
                }
                desktopService.createDesktopItem(this.installedFolderContext, this.installedFolderName, this.installedName, string4, this.resolveString(this.args), string2, string5, desktopIconExtra.extraProperties());
                if (desktopService.isContextOwnershipSupported(this.installedFolderContext)) {
                    String string6 = null;
                    if (this.itemGroup != null) {
                        string6 = this.resolveString(this.itemGroup);
                    }
                    if (string6 != null && string6.length() > 0) {
                        desktopService.setDesktopItemOwnerGroup(this.installedFolderContext, this.installedFolderName, this.name, string6);
                    }
                    String string7 = null;
                    if (this.itemOwner != null) {
                        string7 = this.resolveString(this.itemOwner);
                    }
                    if (string7 != null && string7.length() > 0) {
                        desktopService.setDesktopItemOwner(this.installedFolderContext, this.installedFolderName, this.name, string7);
                    }
                    if (this.folder != null && this.folder.length() > 0) {
                        String string8 = null;
                        if (this.folderGroup != null) {
                            string8 = this.resolveString(this.folderGroup);
                        }
                        if (string8 != null && string8.length() > 0) {
                            desktopService.setDesktopFolderOwnerGroup(this.installedFolderContext, this.installedFolderName, string8);
                        }
                        String string9 = null;
                        if (this.folderOwner != null) {
                            string9 = this.resolveString(this.folderOwner);
                        }
                        if (string9 != null && string9.length() > 0) {
                            desktopService.setDesktopFolderOwner(this.installedFolderContext, this.installedFolderName, string9);
                        }
                    }
                }
            } else {
                this.logEvent(this, "msg1", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DesktopIcon.extraNotFound", new String[]{this.resolveString(this.name)}));
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            productActionSupport.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DesktopIcon.couldNotCreate", new String[]{this.resolveString(this.name)}));
        }
    }

    private String installIconFile(String string, String string2, int n, FileService fileService) {
        try {
            if (string2 != null && string2.trim().length() > 0) {
                if (n == 2) {
                    String string3 = FileUtils.getName(string2);
                    URL uRL = this.getResource(String.valueOf(this.getBeanId()) + "/" + string + "/" + string3);
                    if (uRL != null) {
                        File file = new File(this.getProductTree().getInstallLocation(this), string3);
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        FileUtils.copy(uRL.openStream(), fileOutputStream);
                        fileOutputStream.close();
                        this.installedIconFile = file.getAbsolutePath();
                        return this.installedIconFile;
                    }
                    throw new IOException(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DesktopIcon.iconResourceNotFound", new String[]{String.valueOf(this.getBeanId()) + "/" + string3}));
                }
                String string4 = this.resolveString(string2);
                if (fileService.isAbsolute(string4)) {
                    return fileService.normalizeFileName(string4);
                }
                return this.createFileNameRelativeToDestination(string4);
            }
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
        return null;
    }

    public boolean isRelativeTarget() {
        return this.relativeTarget;
    }

    public boolean isWorkingDirectoryRelative() {
        return this.workingDirectoryRelative;
    }

    public void setArgs(String string) {
        if (string == null) {
            throw new IllegalArgumentException("args can not be null. ");
        }
        this.args = string;
    }

    public void setFolder(String string) {
        if (string == null) {
            throw new IllegalArgumentException("folderName cannot be null");
        }
        this.folder = string;
    }

    public void setFolderGroup(String string) {
        this.folderGroup = string;
    }

    public void setFolderOwner(String string) {
        this.folderOwner = string;
    }

    public void setInstalledFolder(String string) {
        this.installedFolder = string;
    }

    public void setInstalledFolderContext(String string) {
        this.installedFolderContext = string;
    }

    public void setInstalledFolderName(String string) {
        this.installedFolderName = string;
    }

    public void setInstalledIconFile(String string) {
        this.installedIconFile = string;
    }

    public void setInstalledName(String string) {
        this.installedName = string;
    }

    public void setItemGroup(String string) {
        this.itemGroup = string;
    }

    public void setItemOwner(String string) {
        this.itemOwner = string;
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = string;
    }

    public void setRelativeTarget(boolean bl) {
        this.relativeTarget = bl;
    }

    public void setScriptFile(String string) {
        this.scriptFile = string;
    }

    public void setTarget(String string) {
        if (string == null) {
            throw new IllegalArgumentException("action cannot be null");
        }
        this.target = string;
    }

    public void setWorkingDirectory(String string) {
        if (string == null) {
            throw new IllegalArgumentException("workingDirectory can not be null. ");
        }
        this.workingDirectory = string;
    }

    public void setWorkingDirectoryRelative(boolean bl) {
        this.workingDirectoryRelative = bl;
    }

    public void uninstall(ProductActionSupport productActionSupport) {
        try {
            FileService fileService;
            DesktopService desktopService = (DesktopService)this.getService("desktopService");
            if (this.installedIconFile != null && this.installedIconFile.trim().length() > 0 && (fileService = (FileService)this.getService("fileService")).fileExists(this.installedIconFile)) {
                fileService.deleteFile(this.installedIconFile);
            }
            if (this.installedName != null && this.installedName.length() > 0) {
                if (this.installedFolder != null && this.installedFolder.trim().length() != 0) {
                    desktopService.removeDesktopItem(this.installedFolder, this.installedName);
                } else {
                    desktopService.removeDesktopItem(this.installedFolderContext, this.installedFolderName, this.installedName);
                }
            }
            if (this.scriptFile != null && this.scriptFile.length() != 0 && (fileService = (FileService)this.getService("fileService")).fileExists(this.scriptFile)) {
                fileService.deleteFile(this.scriptFile);
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            productActionSupport.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DesktopIcon.couldNotRemove", new String[]{this.name}));
        }
    }
}

