/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.actions.EnvironmentVariableUpdateExtra;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;

public class EnvironmentVariableUpdate
extends ProductAction {
    public static final int PREPEND = 1;
    public static final int APPEND = 2;
    public static final int REPLACE = 3;
    public static final int DELETE = 4;
    public static final int UNPREPEND = 5;
    public static final int UNAPPEND = 6;
    private String variableName = "";
    private String variableValue = "";
    private int operation = 2;
    private boolean includePathSeparator = true;
    private String variableValueBeforeInstall = null;
    private boolean isRebootRequired = false;
    private boolean normalizePath = false;
    private String installedVariableName = "";
    private String installedVariableValue = "";
    static /* synthetic */ Class class$com$installshield$product$actions$EnvironmentVariableUpdateBeanInfo;
    static /* synthetic */ Class class$com$installshield$product$actions$EnvironmentVariableUpdateExtra;

    public void build(ProductBuilderSupport productBuilderSupport) {
        try {
            productBuilderSupport.putClass((class$com$installshield$product$actions$EnvironmentVariableUpdateBeanInfo != null ? class$com$installshield$product$actions$EnvironmentVariableUpdateBeanInfo : (class$com$installshield$product$actions$EnvironmentVariableUpdateBeanInfo = EnvironmentVariableUpdate.class$("com.installshield.product.actions.EnvironmentVariableUpdateBeanInfo"))).getName());
            productBuilderSupport.putClass((class$com$installshield$product$actions$EnvironmentVariableUpdateExtra != null ? class$com$installshield$product$actions$EnvironmentVariableUpdateExtra : (class$com$installshield$product$actions$EnvironmentVariableUpdateExtra = EnvironmentVariableUpdate.class$("com.installshield.product.actions.EnvironmentVariableUpdateExtra"))).getName());
            productBuilderSupport.putRequiredService("systemUtilService");
            if (this.isActive() && this.getExtendedProperties().size() <= 0) {
                productBuilderSupport.logEvent(this, "wrn", "No platform specific environment variable update properties included -- " + this.resolveString(this.getVariableName()) + " will not be updated at runtime");
            }
        }
        catch (IOException iOException) {
            productBuilderSupport.logEvent(this, "err", iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private boolean equalsWithNull(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    private EnvironmentVariableUpdateExtra getExtra(String string) {
        EnvironmentVariableUpdateExtra environmentVariableUpdateExtra = null;
        Dictionary dictionary = this.getExtendedProperties();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements() && environmentVariableUpdateExtra == null) {
                Object k = enumeration.nextElement();
                Object v = dictionary.get(k);
                if (v == null || !(v instanceof EnvironmentVariableUpdateExtra) || !string.equals(((EnvironmentVariableUpdateExtra)v).getPlatformId())) continue;
                environmentVariableUpdateExtra = (EnvironmentVariableUpdateExtra)v;
            }
        }
        return environmentVariableUpdateExtra;
    }

    public boolean getIncludePathSeparator() {
        return this.includePathSeparator;
    }

    public String getInstalledVariableName() {
        return this.installedVariableName;
    }

    public String getInstalledVariableValue() {
        return this.installedVariableValue;
    }

    public boolean getNormalizePath() {
        return this.normalizePath;
    }

    public int getOperation() {
        return this.operation;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableValue() {
        return this.variableValue;
    }

    public String getVariableValueBeforeInstall() {
        return this.variableValueBeforeInstall;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void install(ProductActionSupport productActionSupport) throws ProductException {
        try {
            SystemUtilService systemUtilService = (SystemUtilService)this.getService("systemUtilService");
            EnvironmentVariableUpdateExtra environmentVariableUpdateExtra = this.getExtra(systemUtilService.getPlatformId());
            if (environmentVariableUpdateExtra != null) {
                String string = this.resolveString(this.getVariableName());
                if (string != null) {
                    this.installedVariableName = string;
                    this.setVariableValueBeforeInstall(systemUtilService.getRawEnvironmentVariable(this.installedVariableName, environmentVariableUpdateExtra == null ? 2 : environmentVariableUpdateExtra.getLevel()));
                }
                if ((string = this.resolveString(this.getVariableValue())) != null) {
                    this.installedVariableValue = this.normalizePath ? FileUtils.normalizeFileName(string) : string;
                }
                String string2 = "";
                if (this.getIncludePathSeparator()) {
                    string2 = File.pathSeparator;
                }
                switch (this.getOperation()) {
                    case 2: {
                        systemUtilService.appendEnvironmentVariable(this.installedVariableName, this.installedVariableValue, string2, environmentVariableUpdateExtra == null ? 2 : environmentVariableUpdateExtra.getLevel());
                        return;
                    }
                    case 1: {
                        systemUtilService.prependEnvironmentVariable(this.installedVariableName, this.installedVariableValue, string2, environmentVariableUpdateExtra == null ? 2 : environmentVariableUpdateExtra.getLevel());
                        return;
                    }
                    case 3: {
                        systemUtilService.setEnvironmentVariable(this.installedVariableName, this.installedVariableValue, environmentVariableUpdateExtra == null ? 2 : environmentVariableUpdateExtra.getLevel());
                        return;
                    }
                    case 4: {
                        systemUtilService.deleteEnvironmentVariable(this.installedVariableName, environmentVariableUpdateExtra == null ? 2 : environmentVariableUpdateExtra.getLevel());
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            this.logEvent(this, "msg1", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "EnvironmentVariableUpdate.extraNotFound", new String[]{this.resolveString(this.resolveString(this.getVariableName()))}));
            return;
        }
        catch (Exception exception) {
            throw new ProductException(exception);
        }
    }

    public boolean isRebootRequired() {
        return this.isRebootRequired;
    }

    private String removeValue(String string, String string2, boolean bl) {
        String string3 = null;
        if (string != null) {
            if (string.equals(string2)) {
                string3 = "";
            } else {
                int n = bl ? string.indexOf(string2) : string.lastIndexOf(string2);
                if (n == 0) {
                    string3 = string.substring(string2.length());
                } else if (n > 0) {
                    int n2 = n + string2.length();
                    string3 = string.substring(0, n);
                    if (n2 < string.length()) {
                        string3 = String.valueOf(string3) + string.substring(n2);
                    }
                }
            }
        }
        return string3;
    }

    public void setIncludePathSeparator(boolean bl) {
        this.includePathSeparator = bl;
    }

    public void setInstalledVariableName(String string) {
        this.installedVariableName = string;
    }

    public void setInstalledVariableValue(String string) {
        this.installedVariableValue = string;
    }

    public void setNormalizePath(boolean bl) {
        this.normalizePath = bl;
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    public void setRebootRequired(boolean bl) {
        this.isRebootRequired = bl;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public void setVariableValue(String string) {
        this.variableValue = string;
    }

    public void setVariableValueBeforeInstall(String string) {
        this.variableValueBeforeInstall = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void uninstall(ProductActionSupport productActionSupport) throws ProductException {
        try {
            SystemUtilService systemUtilService = (SystemUtilService)this.getService("systemUtilService");
            EnvironmentVariableUpdateExtra environmentVariableUpdateExtra = this.getExtra(systemUtilService.getPlatformId());
            if (environmentVariableUpdateExtra == null) return;
            String string = "";
            String string2 = null;
            string2 = systemUtilService.getRawEnvironmentVariable(this.installedVariableName, environmentVariableUpdateExtra == null ? 2 : environmentVariableUpdateExtra.getLevel());
            if (this.getIncludePathSeparator()) {
                string = File.pathSeparator;
            }
            switch (this.getOperation()) {
                case 2: {
                    systemUtilService.unAppendEnvironmentVariable(this.installedVariableName, this.installedVariableValue, string, environmentVariableUpdateExtra == null ? 2 : environmentVariableUpdateExtra.getLevel());
                    return;
                }
                case 1: {
                    systemUtilService.unPrependEnvironmentVariable(this.installedVariableName, this.installedVariableValue, string, environmentVariableUpdateExtra == null ? 2 : environmentVariableUpdateExtra.getLevel());
                    return;
                }
                case 3: {
                    String string3 = this.getVariableValueBeforeInstall();
                    if (this.equalsWithNull(string2, string3) || !this.equalsWithNull(string2, this.installedVariableValue)) return;
                    if (string3 == null) {
                        systemUtilService.deleteEnvironmentVariable(this.installedVariableName, environmentVariableUpdateExtra == null ? 2 : environmentVariableUpdateExtra.getLevel());
                        return;
                    } else {
                        systemUtilService.setEnvironmentVariable(this.installedVariableName, string3, environmentVariableUpdateExtra == null ? 2 : environmentVariableUpdateExtra.getLevel());
                    }
                    return;
                }
                case 4: {
                    if (string2 != null && !string2.equals("") || this.getVariableValueBeforeInstall() == null) return;
                    systemUtilService.setEnvironmentVariable(this.installedVariableName, this.getVariableValueBeforeInstall(), environmentVariableUpdateExtra == null ? 2 : environmentVariableUpdateExtra.getLevel());
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            throw new ProductException(exception);
        }
    }
}

