/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.product.Locatable;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionEvent;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.RequiredBytesTable;
import com.installshield.product.actions.SourceFile;
import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.URLUtils;
import com.installshield.util.rex.RegExprSyntaxException;
import com.installshield.util.rex.Rex;
import com.installshield.wizard.service.MutableOperationState;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardLog;
import com.installshield.wizard.service.file.FileService;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;

public class ExternalFiles
extends ProductAction
implements Locatable {
    public static final String CREATE_FILE = "createFile";
    public static final String DELETE_FILE = "deleteFile";
    private static final String CANT_SET_ATTRIBUTES_FLAG = "cantSetAttributes";
    private static final String CANT_SET_FILE_TIMES_FLAG = "cantSetFileTimes";
    private static final String REPLACE_EXISTING = "replaceExistingResponse";
    private static final String REPLACE_NEWER = "replaceNewerResponse";
    private static final String REMOVE_EXISTING = "removeExistingResponse";
    private static final String REMOVE_MODIFIED = "removeModifiedResponse";
    private static final String YES = "$L(com.installshield.wizard.i18n.WizardResources, yesWithMn)";
    private static final String YES_TO_ALL = "$L(com.installshield.wizard.i18n.WizardResources, yesToAllWithMn)";
    private static final String NO = "$L(com.installshield.wizard.i18n.WizardResources, noWithMn)";
    private static final String NO_TO_ALL = "$L(com.installshield.wizard.i18n.WizardResources, noToAllWithMn)";
    private static final String CANCEL = "$L(com.installshield.wizard.i18n.WizardResources, cancelWithMn)";
    private String owner = "";
    private String group = "";
    private String installLocation = null;
    private Vector files = new Vector();
    private boolean building = false;
    private InstalledFiles installed = null;
    private byte[] buf = new byte[10240];
    private Vector fileLists = null;
    private long totalBytes = -1L;
    private int fileCount = -1;
    private int timeToInstall = 0;
    private boolean nativeServicesAvailable = true;
    static /* synthetic */ Class class$com$installshield$product$actions$SourceFile;
    static /* synthetic */ Class class$com$installshield$product$actions$ExternalFilesBeanInfo;

    public void addFile(SourceFile sourceFile) {
        this.files.addElement(sourceFile);
    }

    private void addFileList(SourceFileList sourceFileList) {
        this.fileLists.addElement(sourceFileList);
    }

    public void build(ProductBuilderSupport productBuilderSupport) {
        this.building = true;
        try {
            productBuilderSupport.putClass((class$com$installshield$product$actions$SourceFile != null ? class$com$installshield$product$actions$SourceFile : (class$com$installshield$product$actions$SourceFile = ExternalFiles.class$("com.installshield.product.actions.SourceFile"))).getName());
            productBuilderSupport.putClass((class$com$installshield$product$actions$ExternalFilesBeanInfo != null ? class$com$installshield$product$actions$ExternalFilesBeanInfo : (class$com$installshield$product$actions$ExternalFilesBeanInfo = ExternalFiles.class$("com.installshield.product.actions.ExternalFilesBeanInfo"))).getName());
            productBuilderSupport.putClass("com.installshield.product.actions.ExternalFiles$InstalledFile");
            productBuilderSupport.putClass("com.installshield.product.actions.ExternalFiles$InstalledFiles");
            productBuilderSupport.putClass("com.installshield.product.actions.ExternalFiles$SourceFileList");
            productBuilderSupport.putClass("com.installshield.product.actions.ExternalFiles$FileInfo");
            productBuilderSupport.putRequiredService("fileService");
        }
        catch (IOException iOException) {
            productBuilderSupport.logEvent(this, "err", iOException);
        }
        this.building = false;
    }

    private int calculateTimeToInstall(int n, long l) {
        return Math.round(n) + Math.round((float)l * 1.0E-6f);
    }

    private boolean canCopyFile(File file, int n, long l, ProductActionSupport productActionSupport) throws ServiceException {
        if (this.getValue(REPLACE_EXISTING) == null) {
            this.setValue(REPLACE_EXISTING, "unspecified");
        }
        if (this.getValue(REPLACE_NEWER) == null) {
            this.setValue(REPLACE_NEWER, "unspecified");
        }
        if (!file.exists()) {
            return true;
        }
        if (n == 1) {
            return true;
        }
        if (n == 2) {
            return false;
        }
        if (n == 3) {
            return this.compareDates(l, file.lastModified()) > 0;
        }
        if (n == 4) {
            if (this.compareDates(l, file.lastModified()) < 0) {
                this.refreshReplaceNewerResponse(file);
                String string = (String)this.getValue(REPLACE_NEWER);
                return string.equals(this.resolveString(YES)) || string.equals(this.resolveString(YES_TO_ALL));
            }
            return true;
        }
        if (n == 5) {
            if (this.compareDates(l, file.lastModified()) < 0) {
                this.refreshReplaceNewerResponse(file);
                String string = (String)this.getValue(REPLACE_NEWER);
                return string.equals(this.resolveString(YES)) || string.equals(this.resolveString(YES_TO_ALL));
            }
            this.refreshReplaceExistingResponse(file, this.compareDates(l, file.lastModified()) > 0);
            String string = (String)this.getValue(REPLACE_EXISTING);
            return string.equals(this.resolveString(YES)) || string.equals(this.resolveString(YES_TO_ALL));
        }
        productActionSupport.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.illegalReplaceOption", new String[]{String.valueOf(n)}));
        return false;
    }

    private boolean canRemoveFile(File file, int n, long l, ProductActionSupport productActionSupport) throws ServiceException {
        if (this.getValue(REMOVE_EXISTING) == null) {
            this.setValue(REMOVE_EXISTING, "unspecified");
        }
        if (this.getValue(REMOVE_MODIFIED) == null) {
            this.setValue(REMOVE_MODIFIED, "unspecified");
        }
        if (!file.exists()) {
            return false;
        }
        if (n == 1) {
            return true;
        }
        if (n == 2) {
            return false;
        }
        if (n == 3) {
            return this.compareDates(l, file.lastModified()) == 0;
        }
        if (n == 4) {
            long l2 = file.lastModified();
            String string = file.getAbsolutePath();
            this.logDebugEvent(String.valueOf(string) + "internal last modified = " + l);
            this.logDebugEvent(String.valueOf(string) + " last modified = " + l2);
            if (this.compareDates(l, l2) != 0) {
                this.refreshRemoveModifiedResponse(file);
                String string2 = (String)this.getValue(REMOVE_MODIFIED);
                return string2.equals(this.resolveString(YES)) || string2.equals(this.resolveString(YES_TO_ALL));
            }
            return true;
        }
        if (n == 5) {
            if (this.compareDates(l, file.lastModified()) != 0) {
                this.refreshRemoveModifiedResponse(file);
                String string = (String)this.getValue(REMOVE_MODIFIED);
                return string.equals(this.resolveString(YES)) || string.equals(this.resolveString(YES_TO_ALL));
            }
            this.refreshRemoveExistingResponse(file);
            String string = (String)this.getValue(REMOVE_EXISTING);
            return string.equals(this.resolveString(YES)) || string.equals(this.resolveString(YES_TO_ALL));
        }
        productActionSupport.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.illegalRemoveOption", new String[]{String.valueOf(n)}));
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected int compareDates(long l, long l2) {
        long l3 = l - l2;
        if (Math.abs(l - l2) <= 2000L) {
            return 0;
        }
        return l3 > 0L ? 1 : -1;
    }

    private int copy(FileInfo fileInfo, File file, MutableOperationState mutableOperationState, FileService fileService, ProductActionSupport productActionSupport) throws ServiceException {
        int n = 0;
        if (this.checkOperationState(mutableOperationState)) {
            fileService.copyFile(new File(fileInfo.fileLocation).getAbsolutePath(), file.getAbsolutePath(), true);
            n = fileInfo.bytes;
            mutableOperationState.updatePercentComplete(this.timeToInstall, n, this.getTotalBytes());
        }
        return n;
    }

    private String[] createDirs(File file) throws IOException {
        Object object;
        Stack<File> stack = new Stack<File>();
        File file2 = file;
        while (file2 != null && !file2.exists()) {
            stack.push(file2);
            object = file2.getParent();
            File file3 = file2 = object != null ? new File((String)object) : null;
        }
        object = new Vector();
        while (!stack.isEmpty()) {
            file2 = (File)stack.pop();
            if (file2.exists()) continue;
            if (!file2.mkdir()) {
                throw new IOException(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.couldNotCreateDir", new String[]{file2.getAbsolutePath()}));
            }
            ((Vector)object).addElement(file2.getAbsolutePath());
        }
        Object[] objectArray = new String[((Vector)object).size()];
        ((Vector)object).copyInto(objectArray);
        return objectArray;
    }

    private boolean deleteDirWithFileService(File file) {
        boolean bl = false;
        try {
            FileService fileService = (FileService)this.getService("fileService");
            if (fileService != null) {
                bl = fileService.deleteDirectory(file.getAbsolutePath()) == 0;
            }
        }
        catch (Throwable throwable) {}
        return bl;
    }

    private boolean deleteFileWithFileService(File file) {
        boolean bl = false;
        try {
            FileService fileService = (FileService)this.getService("fileService");
            if (fileService != null) {
                fileService.deleteFile(file.getAbsolutePath());
                bl = true;
            }
        }
        catch (Throwable throwable) {
            this.logEvent(this, "wrn", throwable);
        }
        return bl;
    }

    public int getEstimatedTimeToInstall() {
        return this.calculateTimeToInstall(this.getFileCount(), this.getTotalBytes());
    }

    public SourceFile getFile(int n) {
        return (SourceFile)this.files.elementAt(n);
    }

    private int getFileCount() {
        if (this.fileCount == -1) {
            this.fileCount = 0;
            SourceFileList[] sourceFileListArray = this.getFileLists();
            int n = 0;
            while (n < sourceFileListArray.length) {
                this.fileCount += sourceFileListArray[n].getFileCount();
                ++n;
            }
        }
        return this.fileCount;
    }

    private SourceFileList[] getFileLists() {
        if (this.fileLists == null) {
            this.initializeFileLists();
        }
        Object[] objectArray = new SourceFileList[this.fileLists.size()];
        this.fileLists.copyInto(objectArray);
        return objectArray;
    }

    private String getFileLocation(SourceFile sourceFile) {
        String string = new String(sourceFile.getFileName());
        if (sourceFile.getResolveRuntimeFileName()) {
            string = this.resolveString(string);
        }
        String string2 = FileUtils.getParent(this.getServices().getHome());
        string = FileUtils.createFileName(string2, string);
        return string;
    }

    public SourceFile[] getFiles() {
        if (this.building) {
            return null;
        }
        Object[] objectArray = new SourceFile[this.files.size()];
        this.files.copyInto(objectArray);
        return objectArray;
    }

    public int getFilesCount() {
        return this.files.size();
    }

    public String getGroup() {
        return this.group;
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    public String getOwner() {
        return this.owner;
    }

    public RequiredBytesTable getRequiredBytes() {
        RequiredBytesTable requiredBytesTable = new RequiredBytesTable();
        String string = this.getProductTree().getInstallLocation(this);
        requiredBytesTable.addBytes(string, this.getTotalBytes());
        return requiredBytesTable;
    }

    private FileAttributes getSourceFileAttributes(SourceFile sourceFile) throws IOException {
        FileAttributes fileAttributes;
        block3: {
            fileAttributes = sourceFile.getAttributes();
            if (this.nativeServicesAvailable && fileAttributes == null) {
                try {
                    FileService fileService = (FileService)this.getService("fileService");
                    fileAttributes = fileService.getFileAttributes(this.getFileLocation(sourceFile));
                }
                catch (ServiceException serviceException) {
                    this.nativeServicesAvailable = false;
                    if (serviceException.getErrorCode() == 305) break block3;
                    throw new IOException(serviceException.getMessage());
                }
            }
        }
        return fileAttributes;
    }

    private int getSourceFileSize(SourceFile sourceFile) throws IOException {
        int n = 0;
        try {
            FileService fileService = (FileService)this.getService("fileService");
            n = fileService.getFileSize(this.getFileLocation(sourceFile));
        }
        catch (ServiceException serviceException) {
            throw new IOException(serviceException.getMessage());
        }
        return n;
    }

    private long getTotalBytes() {
        if (this.totalBytes == -1L) {
            this.totalBytes = 0L;
            SourceFileList[] sourceFileListArray = this.getFileLists();
            int n = 0;
            while (n < sourceFileListArray.length) {
                this.totalBytes += sourceFileListArray[n].getTotalBytes();
                ++n;
            }
        }
        return this.totalBytes;
    }

    private Object getValue(String string) {
        return this.getServices().getValue(string);
    }

    private void initializeFileLists() {
        this.fileLists = new Vector();
        int n = 0;
        while (n < this.files.size()) {
            SourceFile sourceFile = (SourceFile)this.files.elementAt(n);
            SourceFileList sourceFileList = new SourceFileList();
            this.initializeSourceFileList(sourceFile, null, sourceFileList);
            this.addFileList(sourceFileList);
            ++n;
        }
    }

    private void initializeSourceFileList(SourceFile sourceFile, String string, SourceFileList sourceFileList) {
        String string2 = this.getFileLocation(sourceFile);
        File file = new File(string2);
        if (sourceFileList.filename == null) {
            sourceFileList.filename = new String(string2);
        }
        String string3 = sourceFile.getPattern();
        if (file.isFile()) {
            try {
                String string4 = file.getName();
                String string5 = string3;
                boolean bl = false;
                if (string3 != null && string3.trim().length() != 0) {
                    bl = true;
                    if (!sourceFile.isUsingGNUPattern()) {
                        string5 = this.translateToGNUPattern(string3);
                    }
                }
                if (!bl || Rex.matches(string4, string5)) {
                    FileAttributes fileAttributes = this.getSourceFileAttributes(sourceFile);
                    int n = this.getSourceFileSize(sourceFile);
                    String string6 = string != null ? string2.substring(string.length()) : string4;
                    FileInfo fileInfo = new FileInfo(string6, string2, n, fileAttributes);
                    sourceFileList.addFile(fileInfo);
                }
            }
            catch (RegExprSyntaxException regExprSyntaxException) {
                this.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.invalidRegExpression", new String[]{regExprSyntaxException.getMessage()}));
            }
            catch (IOException iOException) {
                this.logEvent(this, "err", iOException);
            }
        } else if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                SourceFile sourceFile2 = new SourceFile(file2.getAbsolutePath(), sourceFile.getPattern(), 0);
                sourceFile2.setIncludeSubdirs(true);
                sourceFile2.setAttributes(sourceFile.getAttributes());
                sourceFile2.setUsingGNUPattern(sourceFile.isUsingGNUPattern());
                sourceFile2.setResolveRuntimeFileName(false);
                if (!file2.isFile() && string == null) {
                    string = FileUtils.appendSeparator(file.getAbsolutePath());
                }
                this.initializeSourceFileList(sourceFile2, string, sourceFileList);
                ++n;
            }
        } else {
            sourceFileList.exists = false;
            this.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.fileNotExist", new String[]{file.getAbsolutePath()}));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void install(ProductActionSupport productActionSupport) throws ProductException {
        boolean bl;
        block23: {
            String string = this.getProductTree().getInstallLocation(this);
            bl = false;
            MutableOperationState mutableOperationState = productActionSupport.getOperationState();
            this.timeToInstall = this.getEstimatedTimeToInstall();
            try {
                try {
                    int n = this.getProductTree().getReplaceOption(this);
                    FileService fileService = (FileService)this.getService("fileService");
                    this.installed = new InstalledFiles();
                    String string2 = String.valueOf(this.getBeanId()) + "/installed";
                    productActionSupport.putUninstallerResource(this.installed.getIndexFileName(), string2);
                    productActionSupport.removeUninstallerResourceExclusion(string2);
                    SourceFileList[] sourceFileListArray = this.getFileLists();
                    int n2 = 0;
                    block11: while (n2 < sourceFileListArray.length) {
                        SourceFileList sourceFileList = sourceFileListArray[n2];
                        if (!sourceFileList.exists) {
                            throw new ProductException(601, "External file " + sourceFileList.filename + " does not exist.");
                        }
                        FileInfo[] fileInfoArray = sourceFileList.getFileList();
                        if (fileInfoArray.length == 0) {
                            productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "ExternalFiles.emptyDirectory", new String[]{sourceFileList.filename}));
                        }
                        int n3 = 0;
                        while (true) {
                            File file;
                            if (n3 >= fileInfoArray.length) {
                                ++n2;
                                continue block11;
                            }
                            FileInfo fileInfo = fileInfoArray[n3];
                            String string3 = FileUtils.normalizeFileName(fileInfo.fileName);
                            File file2 = new File(string, string3);
                            if (this.canCopyFile(file2, n, (file = new File(fileInfo.fileLocation)).lastModified(), productActionSupport)) {
                                File file3 = new File(file2.getParent());
                                if (!file3.exists()) {
                                    String[] stringArray = this.createDirs(file3);
                                    int n4 = 0;
                                    while (n4 < stringArray.length) {
                                        this.installed.add(stringArray[n4], -1L);
                                        ++n4;
                                    }
                                }
                                try {
                                    this.copy(fileInfo, file2, mutableOperationState, fileService, productActionSupport);
                                    if (!mutableOperationState.isCanceled()) {
                                        this.setAttributes(file2.getAbsolutePath(), fileInfo, fileService, productActionSupport);
                                        this.setFileTimes(file2.getAbsolutePath(), fileInfo, fileService, productActionSupport);
                                    }
                                    if (this.group != null && this.group.length() > 0) {
                                        fileService.setFileOwnerGroup(file2.getAbsolutePath(), this.group);
                                    }
                                    if (this.owner != null && this.owner.length() > 0) {
                                        fileService.setFileOwner(file2.getAbsolutePath(), this.owner);
                                    }
                                    this.fireProductActionEvent(new ProductActionEvent(this, this.getParentComponent(), CREATE_FILE, file2));
                                }
                                finally {
                                    Object var21_22 = null;
                                    File file4 = new File(file2.getAbsolutePath());
                                    this.installed.add(file2.getAbsolutePath(), file4.lastModified());
                                }
                            } else {
                                mutableOperationState.updatePercentComplete(this.timeToInstall, fileInfo.bytes, this.totalBytes);
                            }
                            ++n3;
                        }
                    }
                }
                catch (IOException iOException) {
                    this.logEvent(this, "err", iOException);
                    bl = true;
                }
                catch (ServiceException serviceException) {
                    this.logEvent(this, "err", serviceException);
                    bl = true;
                }
                Object var6_26 = null;
                if (this.installed == null) break block23;
            }
            catch (Throwable throwable) {
                Object var6_27 = null;
                if (this.installed == null) throw throwable;
                try {
                    this.installed.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            this.installed.close();
        }
        if (!bl) return;
        productActionSupport.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.installError", new String[]{this.getBeanId()}));
    }

    public boolean isBuilding() {
        return this.building;
    }

    private void logDebugEvent(String string) {
        this.logEvent(this, WizardLog.subclassEvent("dbg", "externalFiles"), string);
    }

    private void refreshRemoveExistingResponse(File file) throws ServiceException {
        String string = (String)this.getValue(REMOVE_EXISTING);
        if (!string.equals(this.resolveString(YES_TO_ALL)) && !string.equals(this.resolveString(NO_TO_ALL))) {
            string = (String)this.getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.removeExistingFile"), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.fileExisting", new String[]{FileUtils.normalizeFileName(file.getAbsolutePath())}), new Object[]{this.resolveString(YES), this.resolveString(YES_TO_ALL), this.resolveString(NO), this.resolveString(NO_TO_ALL)}, this.resolveString(YES));
            this.setValue(REMOVE_EXISTING, string);
        }
    }

    private void refreshRemoveModifiedResponse(File file) throws ServiceException {
        String string = (String)this.getValue(REMOVE_MODIFIED);
        if (!string.equals(this.resolveString(YES_TO_ALL)) && !string.equals(this.resolveString(NO_TO_ALL))) {
            string = (String)this.getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.removeExistingFile"), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.fileModified", new String[]{FileUtils.normalizeFileName(file.getAbsolutePath())}), new Object[]{this.resolveString(YES), this.resolveString(YES_TO_ALL), this.resolveString(NO), this.resolveString(NO_TO_ALL)}, this.resolveString(NO));
            this.setValue(REMOVE_MODIFIED, string);
        }
    }

    private void refreshReplaceExistingResponse(File file, boolean bl) throws ServiceException {
        String string = (String)this.getValue(REPLACE_EXISTING);
        if (!string.equals(this.resolveString(YES_TO_ALL)) && !string.equals(this.resolveString(NO_TO_ALL))) {
            String string2 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.alreadyExist", new String[]{file.getAbsolutePath()});
            if (bl) {
                string2 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.olderVersionExists", new String[]{file.getAbsolutePath()});
            }
            string = (String)this.getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.replaceFile"), string2, new Object[]{this.resolveString(YES), this.resolveString(YES_TO_ALL), this.resolveString(NO), this.resolveString(NO_TO_ALL)}, this.resolveString(YES));
            this.setValue(REPLACE_EXISTING, string);
        }
    }

    private void refreshReplaceNewerResponse(File file) throws ServiceException {
        String string = (String)this.getValue(REPLACE_NEWER);
        if (!string.equals(this.resolveString(YES_TO_ALL)) && !string.equals(this.resolveString(NO_TO_ALL))) {
            string = (String)this.getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.replaceExistingFile"), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.newerVersionExist", new String[]{FileUtils.normalizeFileName(file.getAbsolutePath())}), new Object[]{this.resolveString(YES), this.resolveString(YES_TO_ALL), this.resolveString(NO), this.resolveString(NO_TO_ALL)}, this.resolveString(NO));
            this.setValue(REPLACE_NEWER, string);
        }
    }

    public void removeFile(int n) {
        this.files.removeElementAt(n);
    }

    public void removeFile(SourceFile sourceFile) {
        this.files.removeElement(sourceFile);
    }

    private void setAttributes(String string, FileInfo fileInfo, FileService fileService, ProductActionSupport productActionSupport) throws IOException {
        block3: {
            FileAttributes fileAttributes;
            if (this.getValue(CANT_SET_ATTRIBUTES_FLAG) != null || (fileAttributes = fileInfo.attributes) == null) break block3;
            try {
                fileService.setFileAttributes(string, fileAttributes);
            }
            catch (ServiceException serviceException) {
                if (serviceException.getErrorCode() == 305) {
                    this.logEvent(this, "wrn", "Cannot set file attributes: operation is not supported by the current file service implementation.");
                    productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.fileAttributeError"));
                    this.setValue(CANT_SET_ATTRIBUTES_FLAG, "1");
                    break block3;
                }
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    private void setFileTimes(String string, FileInfo fileInfo, FileService fileService, ProductActionSupport productActionSupport) throws IOException {
        block3: {
            File file;
            long l;
            if (this.getValue(CANT_SET_FILE_TIMES_FLAG) != null || (l = (file = new File(fileInfo.fileLocation)).lastModified()) <= 0L) break block3;
            try {
                fileService.setFileModified(string, l);
            }
            catch (ServiceException serviceException) {
                if (serviceException.getErrorCode() == 305) {
                    this.logEvent(this, "wrn", "Cannot set file times: operation is not supported by the current file service implementation.");
                    productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.fileTimesError"));
                    this.setValue(CANT_SET_FILE_TIMES_FLAG, "1");
                    break block3;
                }
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    public void setFiles(SourceFile[] sourceFileArray) {
        this.files.removeAllElements();
        if (sourceFileArray != null) {
            int n = 0;
            while (n < sourceFileArray.length) {
                this.files.addElement(sourceFileArray[n]);
                ++n;
            }
        }
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public void setInstallLocation(String string) {
        this.installLocation = string.trim().length() == 0 ? null : string;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    private void setValue(String string, Object object) {
        this.getServices().setValue(string, object);
    }

    private String translateToGNUPattern(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != '*' && string.charAt(n) != '?' && string.charAt(n) != '\\') {
                stringBuffer.append('\"');
                stringBuffer.append(string.charAt(n));
                stringBuffer.append('\"');
            } else if (string.charAt(n) == '\\') {
                stringBuffer.append('\\');
                stringBuffer.append('\\');
            } else if (string.charAt(n) == '*') {
                stringBuffer.append('.');
                stringBuffer.append('*');
            } else if (string.charAt(n) == '?') {
                stringBuffer.append('.');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public void uninstall(ProductActionSupport var1_1) throws ProductException {
        var2_2 = false;
        var3_3 = false;
        var4_4 = new Vector<File>();
        try {
            try {
                var7_5 = this.getProductTree().getRemoveOption(this);
                if (this.installed != null) {
                    this.installed = new InstalledFiles(new URL("ismpfile", "", -1, URLUtils.encode(this.installed.getIndexFileName())));
                } else if (this.installed == null) {
                    this.installed = new InstalledFiles(this.getResource(String.valueOf(this.getBeanId()) + "/installed"));
                }
                var8_9 = this.installed.read();
                while (var8_9 != null) {
                    block34: {
                        var9_10 = new File(var8_9.fileName);
                        if (var9_10.isDirectory()) {
                            var4_4.addElement(var9_10);
                        } else {
                            try {
                                if (!this.canRemoveFile(var9_10, var7_5, var8_9.lastModified, var1_1)) break block34;
                                var10_12 = false;
                                try {
                                    if (var9_10.delete()) {
                                        var10_12 = true;
                                    }
                                }
                                catch (Throwable v0) {}
                                if (!var10_12) {
                                    if (!this.deleteFileWithFileService(var9_10)) {
                                        this.logEvent(this, "wrn", "Could not delete file " + var9_10.getAbsolutePath());
                                        var1_1.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.couldNotDeleteFile", new String[]{var9_10.getAbsolutePath()}));
                                        var3_3 = true;
                                    } else {
                                        var10_12 = true;
                                    }
                                }
                                if (var10_12) {
                                    this.fireProductActionEvent(new ProductActionEvent(this, this.getParentComponent(), "deleteFile", var8_9.fileName));
                                }
                            }
                            catch (ServiceException var10_13) {
                                this.logEvent(this, "err", var10_13);
                            }
                        }
                    }
                    var8_9 = this.installed.read();
                }
                var9_11 = -1;
                while (var9_11 != 0) {
                    var9_11 = 0;
                    var10_14 = 0;
                    while (var10_14 < var4_4.size()) {
                        var11_16 = (File)var4_4.elementAt(var10_14);
                        if (var11_16 != null && var11_16.delete()) {
                            var4_4.setElementAt(null, var10_14);
                            ++var9_11;
                        }
                        ++var10_14;
                    }
                }
                do {
                    var10_15 = false;
                    var11_17 = 0;
                    while (var11_17 < var4_4.size()) {
                        var12_18 = (File)var4_4.elementAt(var11_17);
                        if (var12_18 != null && this.deleteDirWithFileService(var12_18)) {
                            var10_15 = true;
                            var4_4.setElementAt(null, var11_17);
                        }
                        ++var11_17;
                    }
                } while (var10_15);
                var11_17 = 0;
                while (var11_17 < var4_4.size()) {
                    var12_18 = (File)var4_4.elementAt(var11_17);
                    if (var12_18 != null) {
                        var1_1.putInstalledDirectory(var12_18.getAbsolutePath());
                    }
                    ++var11_17;
                }
            }
            catch (IOException var7_6) {
                this.logEvent(this, "err", var7_6);
                var2_2 = true;
            }
            var6_19 = null;
            ** if (this.installed == null) goto lbl-1000
        }
        catch (Throwable var5_21) {
            var6_20 = null;
            if (this.installed != null) {
                try {
                    this.installed.close();
                    var7_8 = String.valueOf(this.getBeanId()) + "/installed";
                    var1_1.putUninstallerResourceExclusion(var7_8);
                }
                catch (IOException v2) {}
            }
            throw var5_21;
        }
lbl-1000:
        // 1 sources

        {
            try {
                this.installed.close();
                var7_7 = String.valueOf(this.getBeanId()) + "/installed";
                var1_1.putUninstallerResourceExclusion(var7_7);
            }
            catch (IOException v1) {}
        }
lbl-1000:
        // 2 sources

        {
        }
        if (var2_2) {
            var1_1.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.uninstallError", new String[]{this.getBeanId()}));
        }
        if (var3_3) {
            var1_1.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.couldNotUninstallFiles", new String[]{this.getBeanId()}));
        }
    }

    class InstalledFiles {
        private final int READ = 1;
        private final int WRITE = 2;
        private final byte EOF = (byte)-128;
        private int mode;
        private String indexFileName;
        private DataOutputStream out;
        private DataInputStream in;

        InstalledFiles() throws IOException {
            this.mode = 2;
            this.indexFileName = FileUtils.createTempFile();
            FileOutputStream fileOutputStream = new FileOutputStream(this.indexFileName);
            this.out = new DataOutputStream(fileOutputStream);
        }

        InstalledFiles(URL uRL) throws IOException {
            this.mode = 1;
            this.in = new DataInputStream(uRL.openStream());
        }

        void add(String string, long l) throws IOException {
            if (this.mode != 2) {
                throw new Error();
            }
            this.out.writeByte(0);
            this.out.writeUTF(string);
            this.out.writeLong(l);
        }

        void close() throws IOException {
            if (this.mode == 2) {
                this.out.writeByte(-128);
                this.out.flush();
                this.out.close();
            } else if (this.mode == 1) {
                this.in.close();
            } else {
                throw new Error();
            }
        }

        String getIndexFileName() {
            return this.indexFileName;
        }

        InstalledFile read() throws IOException {
            if (this.mode != 1) {
                throw new Error();
            }
            if (this.in.readByte() == -128) {
                return null;
            }
            String string = this.in.readUTF();
            long l = this.in.readLong();
            return new InstalledFile(string, l);
        }
    }

    class InstalledFile {
        final String fileName;
        final long lastModified;

        InstalledFile(String string, long l) {
            this.fileName = string;
            this.lastModified = l;
        }
    }

    class SourceFileList {
        Vector fileList = new Vector();
        boolean exists = true;
        String filename = null;

        SourceFileList() {
        }

        void addFile(FileInfo fileInfo) {
            this.fileList.addElement(fileInfo);
        }

        int getFileCount() {
            return this.fileList.size();
        }

        FileInfo[] getFileList() {
            Object[] objectArray = new FileInfo[this.fileList.size()];
            this.fileList.copyInto(objectArray);
            return objectArray;
        }

        long getTotalBytes() {
            long l = 0L;
            int n = 0;
            while (n < this.fileList.size()) {
                l += (long)((FileInfo)this.fileList.elementAt((int)n)).bytes;
                ++n;
            }
            return l;
        }
    }

    class FileInfo {
        String fileName;
        String fileLocation;
        int bytes;
        FileAttributes attributes;

        FileInfo(String string, String string2, int n, FileAttributes fileAttributes) {
            this.fileName = string;
            this.fileLocation = string2;
            this.bytes = n;
            this.attributes = fileAttributes;
        }
    }
}

