/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.wizardbeans.DestinationPanel;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.MnemonicString;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.Spacing;
import com.installshield.wizard.service.ServiceFactory;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.swing.DefaultSwingWizardPanelImpl;
import com.installshield.wizard.swing.SwingWizardUI;
import com.installshield.wizardx.ui.DirectoryBrowser;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class DestinationPanelSwingImpl
extends DefaultSwingWizardPanelImpl
implements ActionListener,
DocumentListener {
    private JPanel captionPane = null;
    private JLabel caption = null;
    private JTextField destination = null;
    private JButton browse = null;
    private boolean isRemote = false;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser$IconBase11;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser$IconListBox11;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser$DirTextDisplay;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser$FileStructure;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser$Comparator;

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isRemote) {
            Container container = this.getParent();
            while (container != null && !(container instanceof Frame)) {
                container = container.getParent();
            }
            try {
                DirectoryBrowser directoryBrowser = new DirectoryBrowser((Frame)container, LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryInputComponent.selectDirectory"), null, (FileService)this.getPanel().getServices().getService("fileService"), LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryBrowser.Folder"));
                directoryBrowser.setSelectionType(1);
                directoryBrowser.setInitialDirectory(this.destination.getText());
                directoryBrowser.run();
                if (directoryBrowser.dirName() != null) {
                    this.destination.setText(directoryBrowser.dirName());
                }
            }
            catch (Exception exception) {
                this.getPanel().logEvent(this, "err", exception);
            }
        } else {
            SwingWizardUI swingWizardUI = (SwingWizardUI)this.getPanel().getWizard().getUI();
            if (swingWizardUI != null) {
                swingWizardUI.restoreDefaultColors();
            }
            JFileChooser jFileChooser = new JFileChooser(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }

                public void setCurrentDirectory(File file) {
                    super.setCurrentDirectory(file);
                    FileChooserUI fileChooserUI = this.getUI();
                    if (fileChooserUI instanceof BasicFileChooserUI) {
                        ((BasicFileChooserUI)fileChooserUI).setFileName("");
                    }
                }
            };
            jFileChooser.setDialogTitle(LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryInputComponent.selectDirectory"));
            jFileChooser.setFileSelectionMode(2);
            Dimension dimension = jFileChooser.getPreferredSize();
            jFileChooser.setSelectedFile(new File(this.destination.getText()));
            jFileChooser.setPreferredSize(dimension);
            if (jFileChooser.showOpenDialog(this) == 0) {
                try {
                    this.destination.setText(jFileChooser.getSelectedFile().getCanonicalPath());
                }
                catch (IOException iOException) {
                    this.destination.setText(jFileChooser.getSelectedFile().getPath());
                }
                this.destination.requestFocus();
                this.destination.selectAll();
            }
            if (swingWizardUI != null) {
                swingWizardUI.setWizardColors();
            }
        }
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        try {
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser != null ? class$com$installshield$wizardx$ui$DirectoryBrowser : (class$com$installshield$wizardx$ui$DirectoryBrowser = DestinationPanelSwingImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser"))).getName());
            wizardBuilderSupport.putClass("com.installshield.wizardx.ui.DirectoryBrowser$1");
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser$IconBase11 != null ? class$com$installshield$wizardx$ui$DirectoryBrowser$IconBase11 : (class$com$installshield$wizardx$ui$DirectoryBrowser$IconBase11 = DestinationPanelSwingImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser$IconBase11"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser$IconListBox11 != null ? class$com$installshield$wizardx$ui$DirectoryBrowser$IconListBox11 : (class$com$installshield$wizardx$ui$DirectoryBrowser$IconListBox11 = DestinationPanelSwingImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser$IconListBox11"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser$DirTextDisplay != null ? class$com$installshield$wizardx$ui$DirectoryBrowser$DirTextDisplay : (class$com$installshield$wizardx$ui$DirectoryBrowser$DirTextDisplay = DestinationPanelSwingImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser$DirTextDisplay"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser$FileStructure != null ? class$com$installshield$wizardx$ui$DirectoryBrowser$FileStructure : (class$com$installshield$wizardx$ui$DirectoryBrowser$FileStructure = DestinationPanelSwingImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser$FileStructure"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser$Comparator != null ? class$com$installshield$wizardx$ui$DirectoryBrowser$Comparator : (class$com$installshield$wizardx$ui$DirectoryBrowser$Comparator = DestinationPanelSwingImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser$Comparator"))).getName());
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.getDP().setDestination(this.destination.getText());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void entering(WizardBeanEvent wizardBeanEvent) {
        this.refreshDestination();
    }

    private DestinationPanel getDP() {
        return (DestinationPanel)this.getPanel();
    }

    public void initialize(WizardBeanEvent wizardBeanEvent) {
        super.initialize(wizardBeanEvent);
        try {
            Class<?> clazz = Class.forName("com.ibm.wizard.platform.as400.IBMAS400PpkUtils");
            Method method = clazz.getMethod("getSystemCompatibility", new Class[0]);
            int n = clazz.getDeclaredField("REMOTEINSTALL").getInt(clazz);
            boolean bl = (Integer)method.invoke(null, new Object[0]) == n;
            FileService fileService = (FileService)this.getPanel().getServices().getService("fileService");
            boolean bl2 = ServiceFactory.getCurrentImplementorType(fileService).endsWith("IBMAS400FileServiceImpl");
            this.isRemote = bl && bl2;
        }
        catch (Exception exception) {
            this.isRemote = false;
        }
        this.getContentPane().add(Spacing.createVerticalSpacing(6));
        this.getContentPane().setLayout(new ColumnLayout());
        this.destination = new JTextField();
        this.captionPane = new JPanel();
        this.getContentPane().add((Component)this.captionPane, ColumnConstraints.createHorizontalFill());
        this.captionPane.setLayout(new ColumnLayout());
        this.caption = new JLabel();
        this.refreshDestinationCaption();
        this.getContentPane().add((Component)this.destination, ColumnConstraints.createHorizontalFill());
        this.destination.getDocument().addDocumentListener(this);
        this.destination.getAccessibleContext().setAccessibleName(this.resolveString(this.getDP().getDescription()));
        this.refreshDestination();
        this.getContentPane().add(Spacing.createVerticalSpacing(4));
        this.browse = new JButton();
        this.getContentPane().add((Component)this.browse, ColumnConstraints.createRightAlign());
        this.browse.addActionListener(this);
        this.browse.getAccessibleContext().setAccessibleName(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DestinationPanelSwingImpl.browse"));
        this.refreshBrowseCaption();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.getDP().setDestination(this.destination.getText());
    }

    public void propertyChanged(String string) {
        super.propertyChanged(string);
        if (string.equals("destinationCaption")) {
            this.refreshDestinationCaption();
        } else if (string.equals("browseCaption")) {
            this.refreshBrowseCaption();
        }
    }

    private void refreshBrowseCaption() {
        MnemonicString mnemonicString = new MnemonicString(this.resolveString(this.getDP().getBrowseCaption()));
        this.browse.setText("  " + mnemonicString.toString() + "  ");
        if (mnemonicString.isMnemonicSpecified()) {
            this.browse.setMnemonic(mnemonicString.getMnemonicChar());
        } else {
            this.browse.setMnemonic(0);
        }
    }

    private void refreshDestination() {
        this.destination.setText(this.resolveString(this.getDP().getDestination()));
    }

    private void refreshDestinationCaption() {
        this.captionPane.removeAll();
        MnemonicString mnemonicString = new MnemonicString(this.resolveString(this.getDP().getDestinationCaption()));
        String string = mnemonicString.toString();
        this.caption.setText(string);
        if (mnemonicString.isMnemonicSpecified()) {
            this.caption.setDisplayedMnemonic(mnemonicString.getMnemonicChar());
            this.caption.setLabelFor(this.destination);
        } else {
            this.caption.setDisplayedMnemonic(0);
            this.caption.setLabelFor(null);
        }
        this.captionPane.add((Component)this.caption, ColumnConstraints.createHorizontalFill());
        this.captionPane.add(Spacing.createVerticalSpacing(4));
        this.caption.validate();
        this.caption.repaint();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.getDP().setDestination(this.destination.getText());
    }
}

