/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassLocator {
    private Hashtable classPaths = new Hashtable();
    private Stack recentPaths = new Stack();
    private Hashtable archiveContents = new Hashtable();

    public ClassLocator() {
    }

    public ClassLocator(String string) {
        this.putClassPath(string);
    }

    public void clearClassPath() {
        this.classPaths.clear();
    }

    public String findClass(String string) {
        return this.findClassResource(String.valueOf(string.replace('.', '/')) + ".class");
    }

    public String findClassResource(String string) {
        Object object;
        String string2 = null;
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        while (string2 == null && !this.recentPaths.isEmpty()) {
            object = (String)this.recentPaths.pop();
            string2 = this.findClassResource(string, (String)object);
            if (string2 != null) {
                this.recentPaths.push(object);
                continue;
            }
            hashtable.put(object, "");
        }
        object = this.classPaths.keys();
        while (object.hasMoreElements() && string2 == null) {
            String string3 = (String)object.nextElement();
            if (hashtable.containsKey(string3) || (string2 = this.findClassResource(string, string3)) == null) continue;
            this.recentPaths.push(string3);
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String findClassResource(String string, String string2) {
        String string3 = null;
        try {
            File file = new File(string2);
            if (file.isDirectory()) {
                File file2 = new File(file, string);
                if (!file2.isFile()) return string3;
                return file2.getAbsolutePath();
            }
            if (!file.isFile()) return string3;
            ZipFile zipFile = null;
            try {
                try {
                    zipFile = new ZipFile(file);
                    String string4 = string;
                    ZipEntry zipEntry = zipFile.getEntry(string4);
                    if (zipEntry != null) {
                        string3 = String.valueOf(file.getAbsolutePath()) + "!/" + zipEntry.getName();
                    }
                }
                catch (Exception exception) {
                }
                Object var7_9 = null;
                if (zipFile == null) return string3;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (zipFile == null) throw throwable;
                try {
                    zipFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                zipFile.close();
                return string3;
            }
            catch (IOException iOException) {}
            return string3;
        }
        catch (Exception exception) {}
        return string3;
    }

    public Enumeration findPackageResources(String string, boolean bl) throws IOException {
        string = string.replace('.', '/');
        Vector vector = new Vector();
        Enumeration enumeration = this.classPaths.keys();
        while (enumeration.hasMoreElements()) {
            this.readResourcesInPackage(string, bl, (String)enumeration.nextElement(), vector);
        }
        if (vector.size() == 0) {
            throw new IOException("invalid package: " + string);
        }
        return vector.elements();
    }

    public String getClassPath() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.classPaths.keys();
        while (enumeration.hasMoreElements()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append((String)enumeration.nextElement());
        }
        return stringBuffer.toString();
    }

    public static InputStream operResourceStream(String string) throws IOException {
        int n = string.indexOf("!/");
        if (n != -1) {
            ZipFile zipFile = new ZipFile(string.substring(0, n));
            ZipEntry zipEntry = zipFile.getEntry(string.substring(n + 2));
            return zipFile.getInputStream(zipEntry);
        }
        return new FileInputStream(string);
    }

    public void putClassPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            this.classPaths.put(stringTokenizer.nextToken(), "");
        }
    }

    private void readResourcesInDirectory(String string, boolean bl, File file, Vector vector) {
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                File file2 = new File(file, string2);
                if (file2.isFile()) {
                    vector.addElement(String.valueOf(string) + "/" + string2);
                } else if (bl && file2.isDirectory()) {
                    this.readResourcesInDirectory(String.valueOf(string) + "/" + string2, bl, file2, vector);
                }
                ++n;
            }
        }
    }

    private void readResourcesInPackage(String string, boolean bl, String string2, Vector vector) throws IOException {
        File file = new File(string2);
        if (file.isDirectory()) {
            File file2 = new File(string2, string);
            if (file2.isDirectory()) {
                this.readResourcesInDirectory(string, bl, file2, vector);
            }
        } else if (file.isFile()) {
            ZipFile zipFile = new ZipFile(file);
            String string3 = String.valueOf(string) + '/';
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string4 = zipEntry.getName();
                if (!string4.startsWith(string3)) continue;
                String string5 = string4.substring(string3.length());
                if (!bl && string5.indexOf(47) != -1) continue;
                vector.addElement(string4);
            }
            zipFile.close();
        }
    }

    public void removeClassPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            this.classPaths.remove(stringTokenizer.nextToken());
        }
    }
}

