/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util.rex;

import com.installshield.util.rex.Anchor;
import com.installshield.util.rex.Atom;
import com.installshield.util.rex.AtomBackRef;
import com.installshield.util.rex.AtomSet;
import com.installshield.util.rex.AtomString;
import com.installshield.util.rex.Expr;
import com.installshield.util.rex.IntPtr;
import com.installshield.util.rex.Range;
import com.installshield.util.rex.RexResult;
import com.installshield.util.rex.State;
import com.installshield.util.rex.State1;
import com.installshield.util.rex.StateAnchor;
import com.installshield.util.rex.StateBackRef;
import com.installshield.util.rex.StateCntrl;
import com.installshield.util.rex.StateNSet;
import com.installshield.util.rex.StateRepeater;
import com.installshield.util.rex.StateSet;

class StateMachine {
    static final int DEF_POSSBL = 32;
    static final int DEF_CLOSUR = 48;
    static final int MAX_ALTNVS = 32;
    static final int MAXSUBLEN = 512;
    static final char EOL_CHAR = '\n';
    static StateAnchor anchorStart = new StateAnchor('^');
    static StateAnchor anchorEnd = new StateAnchor('$');
    static State auxAccept = new StateCntrl();
    short[] possible;
    int pCount;
    short[] closure;
    int cCount;
    short[] realPossible;
    short[] shadowPossible;
    int savedPCount;
    short[] realClosure;
    short[] shadowClosure;
    int savedCCount;
    private int[] poffset;
    private int[] coffset;
    State acceptingState;
    State[] tabState;
    int tabCount;
    short startState;
    int farthestState;
    char[] input;
    int start;
    RexResult result = new RexResult();
    int[] subEnd;
    int[] subStart;
    int[] subRepeat;
    int resCount;
    int[] backRefState;
    int backRefCount;
    boolean ignoreSubs = false;
    private int tmp;
    boolean augmentIt = false;
    private boolean specBol = false;
    private boolean pastEol = false;

    static {
        auxAccept.setAccept();
    }

    private StateMachine(int n, boolean bl) {
        int n2 = this.result.maxResults();
        this.realPossible = new short[32];
        this.realClosure = new short[48];
        this.possible = this.realPossible;
        this.closure = this.realClosure;
        if (bl) {
            this.shadowPossible = new short[32];
            this.shadowClosure = new short[48];
            this.poffset = new int[32];
            this.coffset = new int[48];
            this.backRefState = new int[n2];
        }
        this.tabState = new State[n];
        this.startState = (short)-1;
        this.subRepeat = new int[n2];
        this.subStart = new int[n2];
        this.subEnd = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            if (this.backRefState != null) {
                this.backRefState[n3] = -1;
            }
            this.subEnd[n3] = -1;
            this.subStart[n3] = -1;
            ++n3;
        }
        this.resCount = 0;
        this.backRefCount = 0;
    }

    private int acceptingState() {
        int n = 0;
        while (n < this.cCount) {
            if (this.tabState[this.closure[n]].canAccept()) {
                return this.closure[n];
            }
            ++n;
        }
        return -1;
    }

    private int addState(State state) {
        this.tabState[this.tabCount++] = state;
        return this.tabCount - 1;
    }

    private int adoptAlternative(Atom atom, int n, int[] nArray, int n2) {
        if (atom.cpr() != null) {
            int n3 = this.addState(new StateCntrl());
            ((StateCntrl)this.tabState[n]).setNext0(n3);
            nArray[n2] = n3 = this.adoptAtom$(atom, n3);
            int n4 = this.addState(new StateCntrl());
            ((StateCntrl)this.tabState[n]).setNext1(n4);
            return this.adoptAlternative(atom.cpr(), n4, nArray, n2 + 1);
        }
        int n5 = this.adoptAtom$(atom, n);
        nArray[n2] = n5;
        return n2;
    }

    private int adoptAlternatives(Atom atom, int n) {
        int[] nArray = new int[32];
        int n2 = this.adoptAlternative(atom, n, nArray, 0);
        while (--n2 >= 0) {
            ((StateCntrl)this.tabState[nArray[n2]]).setNext0(this.tabCount - 1);
        }
        return this.tabCount - 1;
    }

    private int adoptAnchor(Anchor anchor, int n) {
        StateAnchor stateAnchor;
        switch (anchor.anchorType) {
            case 1: {
                stateAnchor = anchorEnd;
                break;
            }
            case 2: {
                stateAnchor = anchorStart;
                break;
            }
            default: {
                return n;
            }
        }
        this.tabState[n] = stateAnchor;
        this.addState(new StateCntrl());
        return this.tabCount - 1;
    }

    private int adoptAtom$(Atom atom, int n) {
        if (atom instanceof Expr) {
            return this.adoptExprSimple((Expr)atom, n);
        }
        this.adoptAtom(atom, n);
        return this.tabCount - 1;
    }

    private int adoptAtom(Atom atom, int n) {
        int n2 = n;
        StateCntrl stateCntrl = (StateCntrl)this.tabState[n];
        Range range = (Range)atom;
        if (range.min == 1 && range.max == range.min) {
            return this.adoptAtomOnce(atom, n);
        }
        if (range.max >= 256 && (range.min == 1 || range.min == 0)) {
            this.adoptClosure(range, n2, stateCntrl);
            return n2;
        }
        if (range.min <= range.max) {
            stateCntrl.setNext0(this.tabCount);
            this.adoptAtomOnce(atom, this.tabCount++);
            if (range.min == 0) {
                if (range.max > 1) {
                    this.tabState[this.tabCount - 1] = new StateRepeater(n2 + 1, this.tabCount, 0, range.max);
                    ((StateCntrl)this.tabState[n2]).setNext1(this.tabCount);
                    this.addState(new StateCntrl());
                } else {
                    ((StateCntrl)this.tabState[n2]).setNext1(this.tabCount - 1);
                }
            } else {
                this.tabState[this.tabCount - 1] = new StateRepeater(n2 + 1, this.tabCount, range.min, range.max);
                this.addState(new StateCntrl());
            }
        }
        return n2;
    }

    final int adoptAtomOnce(Atom atom, int n) {
        return atom instanceof AtomSet ? this.adoptSet((AtomSet)atom, n) : (atom instanceof AtomString ? this.adoptString((AtomString)atom, n) : -1);
    }

    private int adoptAtomOpt(Atom atom, int n, IntPtr intPtr) {
        int n2 = n;
        if (intPtr.value == -1) {
            n2 = this.adoptAtom(atom, n);
            ((StateCntrl)this.tabState[this.tabCount - (this.tabState[this.tabCount - 2] instanceof StateCntrl ? 2 : 1)]).setNext1(this.tabCount);
            intPtr.value = this.tabCount - 1;
            this.addState(new StateCntrl());
            ((StateCntrl)this.tabState[n2]).setNext1(intPtr.value);
            return n2;
        }
        if (((Range)atom).max == 1) {
            ((StateCntrl)this.tabState[intPtr.value]).setNext1(this.tabCount);
            this.addState(new StateCntrl());
            ((StateCntrl)this.tabState[intPtr.value]).setNext0(this.tabCount);
            intPtr.value = this.tabCount - 1;
            n2 = this.adoptAtom(atom, n);
        } else {
            this.adoptAtom(atom, intPtr.value);
            ((StateCntrl)this.tabState[intPtr.value]).setNext1(this.tabCount - 1);
            intPtr.value = this.tabCount - 1;
            int n3 = this.tabCount - 2;
            n2 = this.adoptAtom(atom, n);
            ((StateCntrl)this.tabState[n3]).setNext1(this.tabCount - 1);
        }
        return n2;
    }

    private int adoptBackRef(AtomBackRef atomBackRef, int n) {
        this.tabState[n] = new StateBackRef(atomBackRef.refNo);
        this.addState(new StateCntrl());
        this.backRefState[this.backRefCount++] = n;
        return this.tabCount - 1;
    }

    private void adoptClosure(Range range, int n, StateCntrl stateCntrl) {
        stateCntrl.setNext0(this.tabCount);
        this.adoptAtomOnce(range, this.tabCount++);
        ((StateCntrl)this.tabState[this.tabCount - 1]).setNext0(this.tabCount - 2);
        ((StateCntrl)this.tabState[this.tabCount - 1]).setNext1(this.tabCount);
        if (range.min == 0) {
            stateCntrl.setNext1(this.tabCount);
        }
        this.addState(new StateCntrl());
    }

    private int adoptExpr(Expr expr, int n) {
        return expr.cpr() == null ? this.adoptExprSimple(expr, n) : this.adoptAlternatives(expr, n);
    }

    private int adoptExprSimple(Expr expr, int n) {
        int n2 = this.resCount;
        if (this.resCount < this.subStart.length) {
            this.subRepeat[this.resCount] = expr.max;
            this.subStart[this.resCount++] = n;
        }
        if (expr.min == 1 && expr.max == expr.min) {
            this.adoptSubExpr(expr, n);
            if (n2 < this.subEnd.length && this.subEnd[n2] < 0) {
                this.subEnd[n2] = this.tabCount - 1;
            }
            return this.tabCount - 1;
        }
        int n3 = expr.min;
        if (n3 > 0) {
            while (n3-- > 0) {
                this.adoptSubExpr(expr, n);
                n = this.tabCount - 1;
                if (n2 >= this.subEnd.length || this.subEnd[n2] >= 0) continue;
                this.subEnd[n2] = n;
            }
        } else if (expr.max == 1) {
            ((StateCntrl)this.tabState[n]).setNext0(this.tabCount);
            this.addState(new StateCntrl());
            this.adoptSubExpr(expr, this.tabCount - 1);
            ((StateCntrl)this.tabState[n]).setNext1(this.tabCount - 1);
            if (n2 < this.subEnd.length && this.subEnd[n2] < 0) {
                this.subEnd[n2] = this.tabCount - 1;
            }
            return this.tabCount - 1;
        }
        if (expr.max >= 256 && StateMachine.allCanonical(expr)) {
            ((StateCntrl)this.tabState[n]).setNext0(this.tabCount);
            this.addState(new StateCntrl());
            n3 = this.tabCount - 1;
            this.adoptSubExpr(expr, n3, StateMachine.allOptional(expr));
            if (this.tabState[n3].getNext1() == this.tabCount - 1) {
                ((StateCntrl)this.tabState[n3]).setNext1(-1);
            }
            ((StateCntrl)this.tabState[this.tabCount - 1]).setNext1(n3);
            ((StateCntrl)this.tabState[this.tabCount - 1]).setNext0(this.tabCount);
            if (n2 < this.subEnd.length && this.subEnd[n2] < 0) {
                this.subEnd[n2] = this.tabCount - 1;
            }
            this.addState(new StateCntrl());
            ((StateCntrl)this.tabState[n]).setNext1(this.tabCount - 1);
            n = this.tabCount - 1;
            return n;
        }
        n3 = expr.max - expr.min;
        if (n3 > 0) {
            int n4 = this.addState(new StateCntrl());
            while (n3-- > 0) {
                this.adoptOptionalSubExpr(expr, n, n4);
                n = this.tabCount - 1;
            }
            ((StateCntrl)this.tabState[n4]).setNext0(this.tabCount - 1);
        }
        if (n2 < this.subEnd.length && this.subEnd[n2] < 0) {
            this.subEnd[n2] = n;
        }
        return n;
    }

    private int adoptOptionalSubExpr(Expr expr, int n, int n2) {
        ((StateCntrl)this.tabState[n]).setNext0(this.tabCount);
        this.addState(new StateCntrl());
        this.adoptSubExpr(expr, this.tabCount - 1, false);
        ((StateCntrl)this.tabState[n]).setNext1(n2);
        return this.tabCount - 1;
    }

    private int adoptSet(AtomSet atomSet, int n) {
        this.tabState[n] = atomSet.neg ? new StateNSet(atomSet.set) : (atomSet.set.length() > 1 ? new StateSet(atomSet.set) : new State1(atomSet.set.charAt(0)));
        this.addState(new StateCntrl());
        return this.tabCount - 1;
    }

    private int adoptString(AtomString atomString, int n) {
        this.tabState[n] = new State1(atomString.string[0]);
        int n2 = 1;
        while (n2 < atomString.string.length) {
            this.addState(new State1(atomString.string[n2]));
            ++n2;
        }
        this.addState(new StateCntrl());
        return this.tabCount - (atomString.string.length + 1);
    }

    private int adoptSubExpr(Expr expr, int n) {
        return this.adoptSubExpr(expr, n, false);
    }

    private int adoptSubExpr(Expr expr, int n, boolean bl) {
        int n2 = n;
        int n3 = -1;
        IntPtr intPtr = new IntPtr(-1);
        Atom atom = expr.getHead();
        while (atom != null) {
            if (atom.cpr() != null) {
                n2 = this.adoptAlternatives(atom, n2);
            } else if (atom instanceof Expr) {
                n2 = this.adoptExpr((Expr)atom, n2);
            } else if (atom instanceof AtomBackRef) {
                n2 = this.adoptBackRef((AtomBackRef)atom, n2);
            } else {
                n = atom instanceof Anchor ? this.adoptAnchor((Anchor)atom, n2) : (bl ? this.adoptAtomOpt(atom, n2, intPtr) : this.adoptAtom(atom, n2));
                n2 = this.tabCount - 1;
            }
            if (n3 == -1) {
                n3 = n;
            }
            atom = atom.cdr();
        }
        return n3;
    }

    private static boolean allCanonical(Expr expr) {
        Atom atom = expr.getHead();
        while (atom != null) {
            if (atom instanceof Range && (((Range)atom).min > 1 || ((Range)atom).max < 256 && ((Range)atom).max != 1) || atom instanceof Expr && !StateMachine.allCanonical((Expr)atom)) break;
            atom = atom.cdr();
        }
        return atom == null;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean allOptional(Expr var0) {
        var1_1 = var0.getHead();
        if (var1_1.cdr() != null) ** GOTO lbl6
        return false;
        while (!(var1_1 instanceof Range && ((Range)var1_1).min > 0 || var1_1 instanceof Expr && !StateMachine.allOptional((Expr)var1_1))) {
            var1_1 = var1_1.cdr();
lbl6:
            // 2 sources

            if (var1_1 != null) continue;
        }
        return var1_1 == null;
    }

    private boolean appendSet(short[] sArray, int n, short s) {
        int n2 = 0;
        while (n2 < n && sArray[n2] != s) {
            ++n2;
        }
        if (n2 >= n) {
            sArray[n++] = s;
            return true;
        }
        return false;
    }

    static StateMachine buildMachine(Expr expr) {
        StateMachine stateMachine = new StateMachine(StateMachine.expectStatesTotal(expr), true);
        stateMachine.addState(new StateCntrl());
        stateMachine.startState = 0;
        stateMachine.adoptExpr(expr, 0);
        stateMachine.acceptingState = stateMachine.tabState[stateMachine.tabCount - 1];
        stateMachine.acceptingState.setAccept();
        stateMachine.farthestState = stateMachine.tabCount - 1;
        stateMachine.result.subRes = stateMachine.resCount - 1;
        return stateMachine;
    }

    private static int expectStates(Atom atom) {
        if (atom instanceof Expr) {
            return StateMachine.expectStates((Expr)atom) + 1;
        }
        if (atom instanceof AtomBackRef) {
            return 2;
        }
        if (atom instanceof Range) {
            return 4 + (atom instanceof AtomString ? ((AtomString)atom).string.length : 0);
        }
        return 1;
    }

    private static int expectStates(Expr expr) {
        int n = 0;
        Atom atom = expr.getHead();
        while (atom != null) {
            if (atom.cpr() == null) {
                n += StateMachine.expectStates(atom);
            } else {
                Atom atom2 = atom;
                while (atom2 != null) {
                    n += 3 + StateMachine.expectStates(atom2);
                    atom2 = atom2.cpr();
                }
            }
            atom = atom.cdr();
        }
        if (expr.max >= 256 && StateMachine.allCanonical(expr)) {
            return (n << 1) + expr.min * n;
        }
        return (n *= expr.max) + 1;
    }

    private static int expectStatesTotal(Expr expr) {
        return StateMachine.expectStates(expr);
    }

    private boolean isBol(int n) {
        return n == 0 || this.input[n - 1] == '\n';
    }

    private boolean isEol(int n, int n2) {
        this.pastEol = n + 1 >= n2 || this.input[n] == '\n';
        return this.pastEol;
    }

    private int match(int n, int n2, short s) {
        int n3 = -1;
        int n4 = -1;
        char c = '\u0000';
        this.reset();
        this.specBol = false;
        this.pastEol = false;
        if (this.appendSet(this.closure, this.cCount, s)) {
            ++this.cCount;
        }
        this.moveOnEmpty(s);
        while (n < n2) {
            c = this.input[n];
            n3 = 0;
            this.pCount = 0;
            while (n3 < this.cCount) {
                if (this.farthestState < this.closure[n3]) {
                    this.farthestState = this.closure[n3];
                }
                if (this.tabState[this.closure[n3]].canAccept()) {
                    n4 = n;
                } else {
                    this.moveOn(this.closure[n3], c, n, n2);
                }
                ++n3;
            }
            if (this.pCount == 0) break;
            n3 = 0;
            this.cCount = 0;
            while (n3 < this.pCount) {
                this.tabState[this.possible[n3]].incPass();
                if (this.farthestState < this.possible[n3]) {
                    this.farthestState = this.possible[n3];
                }
                if (this.appendSet(this.closure, this.cCount, this.possible[n3])) {
                    ++this.cCount;
                }
                this.moveOnEmpty(this.possible[n3]);
                ++n3;
            }
            ++n;
        }
        if (this.pastEol || this.specBol) {
            --n4;
            --n;
        }
        if (n4 >= 0) {
            this.augmentIt = n >= n2;
            return n4;
        }
        return this.acceptingState() < 0 ? -1 : n;
    }

    /*
     * Unable to fully structure code
     */
    private int matchBR(int var1_1, int var2_2, short var3_3) {
        var4_4 = -1;
        var5_5 = -1;
        this.reset();
        if (this.appendSet(this.closure, this.cCount, var3_3)) {
            ++this.cCount;
        }
        this.moveOnEmpty(var3_3, var1_1);
        block0: while (true) {
            var4_4 = 0;
            this.pCount = 0;
            while (var4_4 < this.cCount) {
                if (this.farthestState < this.closure[var4_4]) {
                    this.farthestState = this.closure[var4_4];
                }
                if (this.tabState[this.closure[var4_4]].canAccept()) {
                    var5_5 = this.coffset[var4_4];
                } else {
                    if (this.coffset[var4_4] >= var2_2) break;
                    this.moveOn(this.closure[var4_4], this.coffset[var4_4], var2_2);
                }
                ++var4_4;
            }
            if (this.pCount == 0) break;
            var4_4 = 0;
            this.cCount = 0;
            while (true) {
                if (var4_4 >= this.pCount) continue block0;
                this.tabState[this.possible[var4_4]].incPass();
                if (this.farthestState < this.possible[var4_4]) {
                    this.farthestState = this.possible[var4_4];
                }
                if (this.poffset[var4_4] < var2_2) ** break;
                continue block0;
                if (this.appendSet(this.closure, this.cCount, this.possible[var4_4])) {
                    this.coffset[this.cCount++] = this.poffset[var4_4];
                }
                this.moveOnEmpty(this.possible[var4_4], this.poffset[var4_4]);
                ++var4_4;
            }
            break;
        }
        return var5_5 < 0 ? (this.acceptingState() < 0 ? -1 : var1_1) : var5_5;
    }

    private int matchBackRef(int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4 && this.input[n] == this.input[n3]) {
            ++n;
            ++n3;
        }
        return n3 >= n4 ? n : -1;
    }

    private int matchBackRef(StateBackRef stateBackRef, int n, int n2) {
        byte by = stateBackRef.backRef;
        int n3 = n;
        int n4 = -1;
        stateBackRef.setAccept();
        this.acceptingState.resetAccept();
        this.saveTables();
        n3 = this.match(this.start, n, this.startState);
        while (n3 >= 0 && n >= this.start) {
            if (this.matchSubs(this.start, n3, this.result, 1) < 0) break;
            if (this.matchBackRef(n3, n2, this.result.start[by] + this.start, this.result.start[by] + this.result.leng[by] + this.start) >= 0) {
                n4 = n3 + this.result.leng[by] - 1;
                break;
            }
            n3 = this.match(this.start, --n, this.startState);
        }
        this.restoreTables();
        this.acceptingState.setAccept();
        stateBackRef.resetAccept();
        return n4;
    }

    private int matchSubExpr(int n, int n2, int n3, RexResult rexResult) {
        int n4;
        int n5 = this.subStart[n];
        int n6 = this.subEnd[n];
        State state = this.tabState[n6];
        int n7 = n4 = n2;
        int n8 = this.subRepeat[n];
        while (n8-- > 0) {
            int n9;
            if (this.tabState[n6].canAccept()) {
                n9 = this.match(n2, n3, (short)n5);
            } else {
                this.acceptingState.resetAccept();
                this.tabState[n6] = auxAccept;
                n9 = this.match(n2, n3, (short)n5);
                this.tabState[n6] = state;
                this.acceptingState.setAccept();
            }
            if (n9 < 0 || !this.tabState[n6].canAccept() && this.match(n9, n3, (short)n6) < 0 || n9 == n2) break;
            n4 = n2;
            n2 = n7 = n9;
        }
        rexResult.start[n] = n4;
        rexResult.leng[n] = n7;
        return n7;
    }

    private int matchSubs(int n, int n2, RexResult rexResult, int n3) {
        int n4 = n;
        int n5 = 0;
        int n6 = this.startState;
        int n7 = n3;
        while (n7 < this.resCount) {
            n5 = this.matchSubExpr(n7, n4 = this.skipMatch(n6, n7, n4, n2), n2, rexResult);
            if (n5 >= 0) {
                n4 = n5;
            }
            if (rexResult.start[n7] >= 0) {
                int n8 = n7;
                rexResult.leng[n8] = rexResult.leng[n8] - rexResult.start[n7];
                int n9 = n7;
                rexResult.start[n9] = rexResult.start[n9] - n;
            } else {
                rexResult.start[n7] = -1;
            }
            n6 = this.subEnd[n7++];
        }
        return n4;
    }

    private int moveOn(int n, char c, int n2, int n3) {
        if (this.tabState[n] instanceof StateCntrl) {
            State state = this.tabState[n];
            if (state.getNext0() != -1) {
                this.moveOn(state.getNext0(), c, n2, n3);
            }
            if (state.getNext1() != -1) {
                this.moveOn(state.getNext1(), c, n2, n3);
            }
        } else {
            if (this.tabState[n] instanceof StateAnchor) {
                if (this.tabState[n] == anchorStart) {
                    if (!this.isBol(n2)) {
                        return 0;
                    }
                    if (this.tabState[++n] instanceof StateCntrl) {
                        if (this.tabState[n].canAccept()) {
                            this.specBol = true;
                            this.appendSet(this.possible, this.pCount++, (short)n);
                        } else {
                            this.moveOn(n, c, n2, n3);
                        }
                        return 0;
                    }
                } else if (this.tabState[n] == anchorEnd) {
                    if (this.isEol(n2, n3) && this.appendSet(this.possible, this.pCount, (short)(n + 1))) {
                        ++this.pCount;
                    }
                    return 0;
                }
            }
            if (this.tabState[n].hasTransitionOn(c) && this.appendSet(this.possible, this.pCount, (short)(n + 1))) {
                ++this.pCount;
            }
        }
        return 0;
    }

    private int moveOn(int n, int n2, int n3) {
        if (this.tabState[n] instanceof StateCntrl) {
            State state = this.tabState[n];
            if (state.getNext0() != -1) {
                this.moveOn(state.getNext0(), n2, n3);
            }
            if (state.getNext1() != -1) {
                this.moveOn(state.getNext1(), n2, n3);
            }
        } else {
            if (this.tabState[n] instanceof StateAnchor) {
                if (this.tabState[n] == anchorStart) {
                    if (!this.isBol(n2)) {
                        return n2;
                    }
                    if (this.tabState[++n] instanceof StateCntrl) {
                        this.moveOn(n, this.input[n2], n2, n3);
                        return n2;
                    }
                } else if (this.tabState[n] == anchorEnd) {
                    if (this.isEol(n2, n3) && this.appendSet(this.possible, this.pCount, (short)(n + 1))) {
                        this.poffset[this.pCount++] = n2;
                    }
                    return n2;
                }
            }
            if (this.tabState[n] instanceof StateBackRef) {
                int n4;
                if (this.tabState[n].canAccept()) {
                    return n2;
                }
                if (this.appendSet(this.possible, this.pCount, (short)(n + 1)) && (n4 = this.matchBackRef((StateBackRef)this.tabState[n], n2, n3)) >= 0) {
                    n2 = n4;
                    this.poffset[this.pCount++] = n2 + 1;
                }
            } else if (this.tabState[n].hasTransitionOn(this.input[n2]) && this.appendSet(this.possible, this.pCount, (short)(n + 1))) {
                this.poffset[this.pCount++] = n2 + 1;
            }
        }
        return n2;
    }

    private void moveOnEmpty(int n) {
        if (this.tabState[n] instanceof StateCntrl) {
            State state = this.tabState[n];
            if (state.getNext0() != -1 && this.appendSet(this.closure, this.cCount, state.getNext0())) {
                this.moveOnEmpty(this.closure[this.cCount++]);
            }
            if (state.getNext1() != -1 && this.appendSet(this.closure, this.cCount, state.getNext1())) {
                this.moveOnEmpty(this.closure[this.cCount++]);
            }
        }
    }

    private void moveOnEmpty(int n, int n2) {
        if (this.tabState[n] instanceof StateCntrl) {
            State state = this.tabState[n];
            if (state.getNext0() != -1 && this.appendSet(this.closure, this.cCount, state.getNext0())) {
                this.coffset[this.cCount] = n2;
                this.moveOnEmpty(this.closure[this.cCount++], n2);
            }
            if (state.getNext1() != -1 && this.appendSet(this.closure, this.cCount, state.getNext1())) {
                this.coffset[this.cCount] = n2;
                this.moveOnEmpty(this.closure[this.cCount++], n2);
            }
        }
    }

    void printStates() {
        System.out.println("State Transition Table\nstart=" + this.startState);
        int n = 0;
        while (n < this.tabState.length && this.tabState[n] != null) {
            System.out.println(String.valueOf(n) + " " + this.tabState[n].stateToString());
            ++n;
        }
    }

    private void reset() {
        int n = this.farthestState;
        while (n >= 0) {
            if (this.tabState[n] instanceof StateRepeater) {
                this.tabState[n].reset();
            }
            --n;
        }
        this.cCount = 0;
        this.farthestState = 0;
    }

    private void restoreTables() {
        this.cCount = this.savedCCount;
        this.pCount = this.savedPCount;
        this.possible = this.realPossible;
        this.closure = this.realClosure;
    }

    private void saveTables() {
        this.savedCCount = this.cCount;
        this.savedPCount = this.pCount;
        this.possible = this.shadowPossible;
        this.closure = this.shadowClosure;
    }

    final synchronized RexResult search(char[] cArray, int n, int n2) {
        this.input = cArray;
        this.start = n;
        int n3 = this.result.leng[0] = this.backRefCount > 0 ? this.matchBR(n, n2, this.startState) : this.match(n, n2, this.startState);
        if (this.result.leng[0] >= 0) {
            this.result.start[0] = n;
            if (!this.ignoreSubs && this.resCount > 0) {
                this.matchSubs(n, this.result.leng[0], this.result, this.backRefCount > 0 ? this.backRefCount : 1);
                if (this.augmentIt) {
                    int n4 = this.resCount - 1;
                    this.result.leng[n4] = this.result.leng[n4] + 1;
                }
            }
            this.result.leng[0] = this.result.leng[0] - n;
            if (this.augmentIt && this.resCount > 1) {
                this.result.leng[0] = this.result.leng[0] + 1;
            }
            return this.result;
        }
        return null;
    }

    private int skipMatch(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        if (this.subStart[n2] != n) {
            State state = this.tabState[this.subStart[n2]];
            int n7 = 0;
            while (n7 < n4) {
                this.tabState[this.subStart[n2]] = auxAccept;
                n5 = this.match(n3, n4 - n7, (short)n);
                this.tabState[this.subStart[n2]] = state;
                if (n5 < 0) break;
                if (this.match(n5, n4, (short)this.subStart[n2]) >= 0) {
                    n6 = n5;
                }
                ++n7;
            }
            return n6;
        }
        return n3;
    }
}

