/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard;

import com.installshield.wizard.CommandLineBean;
import com.installshield.wizard.CommandLineOption;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.console.ConsoleWizardUI;

public class AccessibilityMode
extends CommandLineBean {
    public boolean execute(Wizard wizard, String[] stringArray) {
        if (stringArray.length > 0) {
            wizard.setExitCode(1001);
            System.err.println("Invalid command line option: accessibility does not take arguments");
            return false;
        }
        WizardUI[] wizardUIArray = wizard.getInterfaces();
        int n = 0;
        while (n < wizardUIArray.length) {
            if (wizardUIArray[n] instanceof ConsoleWizardUI) {
                wizard.setInterfaceName(wizardUIArray[n].getName());
                ((ConsoleWizardUI)wizardUIArray[n]).setAccessibilityEnabled(true);
                break;
            }
            ++n;
        }
        return true;
    }

    public boolean getEarlyExecution() {
        return true;
    }

    public String[] getIllegalOptions() {
        return new String[]{"silent", "gui", "awt"};
    }

    public CommandLineOption getOption() {
        return new CommandLineOption("accessibility");
    }
}

